/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0003\u001aB\u0010\u0017\u001a\u00020\u0001*\u00020\u001826\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00010\u001a\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\t*\u00020 2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006!"}, d2={"assertIsTrue", "", "condition", "", "getBitmapFromAsset", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "filename", "", "getStringForTime", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "formatter", "Ljava/util/Formatter;", "timeMs", "", "visibility", "", "show", "visibilityOpacity", "", "contextSafe", "Landroidx/fragment/app/Fragment;", "funCall", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "Landroidx/fragment/app/FragmentActivity;", "activity", "getName", "Landroid/net/Uri;", "room-kit_release"})
public final class UtilsKt {
    public static final void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    public static final int visibility(boolean show) {
        return show ? 0 : 8;
    }

    public static final float visibilityOpacity(boolean show) {
        return show ? 1.0f : 0.0f;
    }

    @Nullable
    public static final Bitmap getBitmapFromAsset(@NotNull Context context, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        AssetManager assetManager = context.getAssets();
        InputStream istr = null;
        Bitmap bitmap = null;
        try {
            InputStream inputStream = assetManager.open(filename);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(filename)");
            istr = inputStream;
            bitmap = BitmapFactory.decodeStream((InputStream)istr);
        }
        catch (IOException e) {
            HMSLogger.e((String)"videoPlugin", (String)(e.getMessage() + "error reading virtual background image"));
        }
        return bitmap;
    }

    @Nullable
    public static final String getName(@NotNull Uri $this$getName, @NotNull Context context) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Cursor returnCursor;
            Cursor cursor = returnCursor = context.getContentResolver().query($this$getName, null, null, null, null);
            Intrinsics.checkNotNull((Object)cursor);
            int nameIndex = cursor.getColumnIndex("_display_name");
            returnCursor.moveToFirst();
            String fileName = returnCursor.getString(nameIndex);
            returnCursor.close();
            string2 = fileName;
        }
        catch (Exception e) {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public static final String getStringForTime(@NotNull StringBuilder builder, @NotNull Formatter formatter, long timeMs) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        long timeMs2 = timeMs;
        if (timeMs2 == -9223372036854775807L) {
            timeMs2 = 0L;
        }
        String prefix = timeMs2 < 0L ? "-" : "";
        timeMs2 = Math.abs(timeMs2);
        long totalSeconds = (timeMs2 + (long)500) / (long)1000;
        long seconds = totalSeconds % (long)60;
        long minutes = totalSeconds / (long)60 % (long)60;
        long hours = totalSeconds / (long)3600;
        builder.setLength(0);
        if (hours > 0L) {
            Object[] objectArray = new Object[]{prefix, hours, minutes, seconds};
            String string3 = formatter.format("%s%d:%02d:%02d", objectArray).toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"formatter.format(\"%s%d:%\u2026 seconds)\n    .toString()");
        } else {
            Object[] objectArray = new Object[]{prefix, minutes, seconds};
            String string4 = formatter.format("%s%02d:%02d", objectArray).toString();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"formatter.format(\"%s%02d\u2026utes, seconds).toString()");
        }
        return string2;
    }

    public static final void contextSafe(@NotNull Fragment $this$contextSafe, @NotNull Function2<? super Context, ? super FragmentActivity, Unit> funCall) {
        Intrinsics.checkNotNullParameter((Object)$this$contextSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter(funCall, (String)"funCall");
        if ($this$contextSafe.getContext() != null && $this$contextSafe.getActivity() != null) {
            FragmentActivity fragmentActivity = $this$contextSafe.getActivity();
            boolean bl = fragmentActivity != null ? !fragmentActivity.isFinishing() : false;
            if (bl && $this$contextSafe.isAdded()) {
                Context context = $this$contextSafe.getContext();
                Intrinsics.checkNotNull((Object)context);
                FragmentActivity fragmentActivity2 = $this$contextSafe.getActivity();
                Intrinsics.checkNotNull((Object)fragmentActivity2);
                funCall.invoke((Object)context, (Object)fragmentActivity2);
            }
        }
    }
}

