/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.polls.leaderboard;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a%\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"millisToText", "", "milliseconds", "", "hyphenateEmptyValues", "", "secondsText", "(Ljava/lang/Long;ZLjava/lang/String;)Ljava/lang/String;", "millisecondsToDisplayTime", "room-kit_release"})
public final class TimeConversionUtilitiesKt {
    @NotNull
    public static final String millisecondsToDisplayTime(long milliseconds) {
        Object object;
        long minutes = milliseconds / (long)1000 / (long)60;
        long seconds = milliseconds / (long)1000 % (long)60;
        String secondsStr = String.valueOf(seconds);
        if (secondsStr.length() >= 2) {
            String string2 = secondsStr.substring(0, 2);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            object = "0" + secondsStr;
        }
        String secs = object;
        return minutes + ":" + secs;
    }

    @NotNull
    public static final String millisToText(@Nullable Long milliseconds, boolean hyphenateEmptyValues, @NotNull String secondsText) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)secondsText, (String)"secondsText");
        Long l = milliseconds;
        long l2 = 0L;
        if (l != null && l == l2 || milliseconds == null) {
            object = hyphenateEmptyValues ? "-" : "";
        } else {
            boolean hasHours = milliseconds > 3600000L;
            boolean hasMinutes = milliseconds > 60000L;
            long hours = milliseconds / (long)1000 / (long)3600;
            long minutes = milliseconds / (long)1000 / (long)60 % (long)60;
            float seconds = (float)(milliseconds % (long)60000) / 1000.0f;
            Object prefix = hasHours ? hours + "h " + minutes + "m" : (hasMinutes ? minutes + "m" : "");
            String suffix = hasHours || hasMinutes ? "" : " " + new BigDecimal(String.valueOf(seconds)).setScale(2, RoundingMode.FLOOR).doubleValue() + " seconds";
            object = (String)prefix + suffix;
        }
        return object;
    }
}

