/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.notification;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import live.hms.roomkit.ui.notification.CardStackLayoutManager;
import live.hms.roomkit.ui.notification.CardStackSetting;
import live.hms.roomkit.ui.notification.CardStackSmoothScroller;
import live.hms.roomkit.ui.notification.CardStackState;
import live.hms.roomkit.ui.notification.Duration;
import live.hms.roomkit.ui.notification.SwipeAnimationSetting;

public class CardStackSnapHelper
extends SnapHelper {
    private int velocityX = 0;
    private int velocityY = 0;

    @Nullable
    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        CardStackLayoutManager manager;
        if (layoutManager instanceof CardStackLayoutManager && (manager = (CardStackLayoutManager)layoutManager).findViewByPosition(manager.getTopPosition()) != null) {
            int x = (int)targetView.getTranslationX();
            int y = (int)targetView.getTranslationY();
            if (x != 0 || y != 0) {
                CardStackSetting setting = manager.getCardStackSetting();
                float horizontal = (float)Math.abs(x) / (float)targetView.getWidth();
                float vertical = (float)Math.abs(y) / (float)targetView.getHeight();
                Duration duration = Duration.fromVelocity(this.velocityY < this.velocityX ? this.velocityX : this.velocityY);
                if (duration == Duration.Fast || setting.swipeThreshold < horizontal || setting.swipeThreshold < vertical) {
                    CardStackState state = manager.getCardStackState();
                    if (setting.directions.contains((Object)state.getDirection())) {
                        state.targetPosition = state.topPosition + 1;
                        SwipeAnimationSetting swipeAnimationSetting = new SwipeAnimationSetting.Builder().setDirection(setting.swipeAnimationSetting.getDirection()).setDuration(duration.duration).setInterpolator(setting.swipeAnimationSetting.getInterpolator()).build();
                        manager.setSwipeAnimationSetting(swipeAnimationSetting);
                        this.velocityX = 0;
                        this.velocityY = 0;
                        CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.ManualSwipe, manager);
                        scroller.setTargetPosition(manager.getTopPosition());
                        manager.startSmoothScroll(scroller);
                    } else {
                        CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.ManualCancel, manager);
                        scroller.setTargetPosition(manager.getTopPosition());
                        manager.startSmoothScroll(scroller);
                    }
                } else {
                    CardStackSmoothScroller scroller = new CardStackSmoothScroller(CardStackSmoothScroller.ScrollType.ManualCancel, manager);
                    scroller.setTargetPosition(manager.getTopPosition());
                    manager.startSmoothScroll(scroller);
                }
            }
        }
        return new int[2];
    }

    @Nullable
    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        CardStackLayoutManager manager;
        View view;
        if (layoutManager instanceof CardStackLayoutManager && (view = (manager = (CardStackLayoutManager)layoutManager).findViewByPosition(manager.getTopPosition())) != null) {
            int x = (int)view.getTranslationX();
            int y = (int)view.getTranslationY();
            if (x == 0 && y == 0) {
                return null;
            }
            return view;
        }
        return null;
    }

    public int findTargetSnapPosition(RecyclerView.LayoutManager layoutManager, int velocityX, int velocityY) {
        this.velocityX = Math.abs(velocityX);
        this.velocityY = Math.abs(velocityY);
        if (layoutManager instanceof CardStackLayoutManager) {
            CardStackLayoutManager manager = (CardStackLayoutManager)layoutManager;
            return manager.getTopPosition();
        }
        return -1;
    }
}

