/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.participants;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B1\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J(\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Llive/hms/roomkit/ui/meeting/participants/HeaderItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "background", "", "sidePaddingPixels", "roundedBorderPixels", "", "expandedGroupSpacing", "headerViewType", "(IIFFI)V", "corners", "", "paint", "Landroid/graphics/Paint;", "drawRoundedBorder", "", "top", "bottom", "left", "right", "canvas", "Landroid/graphics/Canvas;", "mPaint", "getItemOffsets", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "isHeader", "", "child", "onDraw", "c", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class HeaderItemDecoration
extends RecyclerView.ItemDecoration {
    private final int sidePaddingPixels;
    private final float roundedBorderPixels;
    private final float expandedGroupSpacing;
    private final int headerViewType;
    @NotNull
    private final Paint paint;
    @NotNull
    private final float[] corners;
    public static final int $stable = 8;

    public HeaderItemDecoration(@ColorInt int background, int sidePaddingPixels, float roundedBorderPixels, float expandedGroupSpacing, @LayoutRes int headerViewType) {
        this.sidePaddingPixels = sidePaddingPixels;
        this.roundedBorderPixels = roundedBorderPixels;
        this.expandedGroupSpacing = expandedGroupSpacing;
        this.headerViewType = headerViewType;
        float[] fArray = new float[]{this.roundedBorderPixels, this.roundedBorderPixels, this.roundedBorderPixels, this.roundedBorderPixels, this.roundedBorderPixels, this.roundedBorderPixels, this.roundedBorderPixels, this.roundedBorderPixels};
        this.corners = fArray;
        this.paint = new Paint();
        this.paint.setColor(background);
        this.paint.setStrokeWidth(0.0f);
        this.paint.setStyle(Paint.Style.STROKE);
    }

    public final boolean isHeader(@Nullable View child, @NotNull RecyclerView parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager);
        View view = child;
        Intrinsics.checkNotNull((Object)view);
        int viewType = layoutManager.getItemViewType(view);
        return viewType == this.headerViewType;
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.isHeader(view, parent)) {
            return;
        }
        outRect.left = this.sidePaddingPixels;
        outRect.right = this.sidePaddingPixels;
    }

    public void onDraw(@NotNull Canvas c, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RecyclerView.LayoutManager lm = parent.getLayoutManager();
        float top = 0.0f;
        float bottom = 0.0f;
        float left = 0.0f;
        float right = 0.0f;
        if (parent.getChildCount() == 0) {
            return;
        }
        boolean foundHeader = false;
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            View child = parent.getChildAt(i);
            boolean isHeader = this.isHeader(child, parent);
            if (foundHeader && isHeader) {
                View child2 = parent.getChildAt(i - 1);
                RecyclerView.LayoutManager layoutManager = lm;
                Intrinsics.checkNotNull((Object)layoutManager);
                bottom = (float)layoutManager.getDecoratedBottom(child2) + child2.getTranslationY();
                foundHeader = false;
                this.drawRoundedBorder(top, bottom, left, right, c, this.paint);
            }
            if (!isHeader) continue;
            foundHeader = true;
            RecyclerView.LayoutManager layoutManager = lm;
            Intrinsics.checkNotNull((Object)layoutManager);
            top = (float)layoutManager.getDecoratedTop(child) + child.getTranslationY();
            right = (float)lm.getDecoratedRight(child) + child.getTranslationX();
            left = (float)lm.getDecoratedLeft(child) + child.getTranslationX();
        }
        View child = parent.getChildAt(parent.getChildCount() - 1);
        RecyclerView.LayoutManager layoutManager = lm;
        Intrinsics.checkNotNull((Object)layoutManager);
        bottom = (float)layoutManager.getDecoratedBottom(child) + child.getTranslationY();
        this.drawRoundedBorder(top, bottom, left, right, c, this.paint);
    }

    private final void drawRoundedBorder(float top, float bottom, float left, float right, Canvas canvas, Paint mPaint) {
        Path path = new Path();
        path.addRoundRect(new RectF(left, top, right, bottom - this.expandedGroupSpacing), this.corners, Path.Direction.CW);
        canvas.drawPath(path, mPaint);
    }
}

