/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.chat.combined;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class LinePagerIndicatorDecoration
extends RecyclerView.ItemDecoration {
    private int colorActive = -1;
    private int colorInactive = 0x66FFFFFF;
    private static final float DP = Resources.getSystem().getDisplayMetrics().density;
    private final int mIndicatorHeight = (int)(DP * 16.0f);
    private final float mIndicatorStrokeWidth = DP * 2.0f;
    private final float mIndicatorItemLength = DP * 8.0f;
    private final float mIndicatorItemPadding = DP * 4.0f;
    private final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private final Paint mPaint = new Paint();

    public LinePagerIndicatorDecoration(int colorActive, int colorInactive) {
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth(this.mIndicatorStrokeWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.colorActive = colorActive;
        this.colorInactive = colorInactive;
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
        int itemCount = parent.getAdapter().getItemCount();
        if (itemCount <= 1) {
            return;
        }
        float totalLength = this.mIndicatorItemLength * (float)itemCount;
        float paddingBetweenItems = (float)Math.max(0, itemCount - 1) * this.mIndicatorItemPadding;
        float indicatorTotalHeight = totalLength + paddingBetweenItems;
        float indicatorStartY = ((float)parent.getHeight() - indicatorTotalHeight) / 2.0f;
        float indicatorPosX = (float)this.mIndicatorHeight / 2.0f;
        this.drawInactiveIndicators(c, indicatorPosX, indicatorStartY, itemCount);
        LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
        int activePosition = layoutManager.findFirstVisibleItemPosition();
        if (activePosition == -1) {
            return;
        }
        View activeChild = layoutManager.findViewByPosition(activePosition);
        int left = activeChild.getLeft();
        int width = activeChild.getWidth();
        float progress = this.mInterpolator.getInterpolation((float)(left * -1) / (float)width);
        this.drawHighlights(c, indicatorPosX, indicatorStartY, activePosition, progress, itemCount);
    }

    private void drawInactiveIndicators(Canvas c, float indicatorStartX, float indicatorPosY, int itemCount) {
        this.mPaint.setColor(this.colorInactive);
        float itemHeight = this.mIndicatorItemLength + this.mIndicatorItemPadding;
        float start = indicatorPosY;
        for (int i = 0; i < itemCount; ++i) {
            c.drawLine(indicatorStartX, start, indicatorStartX, start + this.mIndicatorItemLength, this.mPaint);
            start += itemHeight;
        }
    }

    private void drawHighlights(Canvas c, float indicatorStartX, float indicatorPosY, int highlightPosition, float progress, int itemCount) {
        this.mPaint.setColor(this.colorActive);
        float itemHeight = this.mIndicatorItemLength + this.mIndicatorItemPadding;
        if (progress == 0.0f) {
            float highlightStart = indicatorPosY + itemHeight * (float)highlightPosition;
            c.drawLine(indicatorStartX, highlightStart, indicatorStartX, highlightStart + this.mIndicatorItemLength, this.mPaint);
        } else {
            float highlightStart = indicatorPosY + itemHeight * (float)highlightPosition;
            float partialLength = this.mIndicatorItemLength * progress;
            c.drawLine(indicatorStartX, highlightStart + partialLength, indicatorStartX, highlightStart + this.mIndicatorItemLength, this.mPaint);
        }
    }
}

