/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.audiomode;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.prebuilt_themes.ViewExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J0\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0014J\u0015\u0010&\u001a\u00020\u001d2\b\u0010\u001b\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010'J\u001c\u0010(\u001a\u00020\u001d*\u00020\u001f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Llive/hms/roomkit/ui/meeting/audiomode/AudioLevelView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "barPadding", "", "barPaint", "Landroid/graphics/Paint;", "barRadius", "barRect", "Landroid/graphics/RectF;", "barWidth", "", "lastAudioLevel", "Ljava/lang/Integer;", "middleBarAnimation", "Landroid/animation/ValueAnimator;", "showAudioLevel", "", "sideBarAnimation", "createAnimation", "current", "finalHeight", "mapAudioLevelToScale", "level", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "left", "top", "right", "bottom", "update", "(Ljava/lang/Integer;)V", "drawVerticalBar", "xOffset", "size", "Companion", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class AudioLevelView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint barPaint;
    @NotNull
    private final RectF barRect;
    private final float barWidth;
    private final int barRadius;
    private final int barPadding;
    @Nullable
    private ValueAnimator middleBarAnimation;
    @Nullable
    private ValueAnimator sideBarAnimation;
    private boolean showAudioLevel;
    @Nullable
    private Integer lastAudioLevel;
    public static final int $stable = 8;
    private static final float SIDE_BAR_SHRINK_FACTOR = 0.75f;

    /*
     * WARNING - void declaration
     */
    public AudioLevelView(@NotNull Context context, @NotNull AttributeSet attrs) {
        void $this$barPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        Paint paint2 = paint = new Paint(1);
        AudioLevelView audioLevelView = this;
        boolean bl = false;
        $this$barPaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$barPaint_u24lambda_u240.setColor(-1);
        audioLevelView.barPaint = paint;
        this.barRect = new RectF();
        this.barWidth = ViewExtKt.dp((float)4.0f);
        this.barRadius = ViewExtKt.dp((int)32);
        this.barPadding = ViewExtKt.dp((int)4);
        this.setWillNotDraw(false);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.update(0);
    }

    private final float mapAudioLevelToScale(int level) {
        float f;
        block1: {
            block5: {
                block4: {
                    block3: {
                        block2: {
                            block0: {
                                if (level < 90) break block0;
                                f = 1.0f;
                                break block1;
                            }
                            if (level <= 80) break block2;
                            f = 0.85f;
                            break block1;
                        }
                        if (level < 70) break block3;
                        f = 0.75f;
                        break block1;
                    }
                    boolean bl = 50 <= level ? level < 70 : false;
                    if (!bl) break block4;
                    f = 0.65f;
                    break block1;
                }
                boolean bl = 40 <= level ? level < 50 : false;
                if (!bl) break block5;
                f = 0.55f;
                break block1;
            }
            f = (30 <= level ? level < 40 : false) ? 0.45f : ((10 <= level ? level < 30 : false) ? 0.35f : 0.15f);
        }
        return f;
    }

    public final void update(@Nullable Integer level) {
        boolean wasShowingAudioLevel = this.showAudioLevel;
        boolean bl = this.showAudioLevel = level != null;
        if (this.showAudioLevel) {
            Integer n = level;
            Intrinsics.checkNotNull((Object)n);
            float scaleFactor = this.mapAudioLevelToScale(n);
            ValueAnimator valueAnimator = this.middleBarAnimation;
            if (valueAnimator != null) {
                valueAnimator.end();
            }
            ValueAnimator valueAnimator2 = this.middleBarAnimation = this.createAnimation(this.middleBarAnimation, (float)this.getHeight() * scaleFactor);
            if (valueAnimator2 != null) {
                valueAnimator2.start();
            }
            ValueAnimator valueAnimator3 = this.sideBarAnimation;
            if (valueAnimator3 != null) {
                valueAnimator3.end();
            }
            float finalHeight = (float)this.getHeight() * scaleFactor;
            if (level > 10) {
                finalHeight *= 0.75f;
            }
            ValueAnimator valueAnimator4 = this.sideBarAnimation = this.createAnimation(this.sideBarAnimation, finalHeight);
            if (valueAnimator4 != null) {
                valueAnimator4.start();
            }
        }
        if (this.showAudioLevel != wasShowingAudioLevel || !Intrinsics.areEqual((Object)level, (Object)this.lastAudioLevel)) {
            this.invalidate();
        }
        this.lastAudioLevel = level;
    }

    private final ValueAnimator createAnimation(ValueAnimator current, float finalHeight) {
        ValueAnimator valueAnimator = current;
        Object object = valueAnimator != null ? valueAnimator.getAnimatedValue() : null;
        Float f = object instanceof Float ? (Float)object : null;
        float currentHeight = f != null ? f.floatValue() : 0.0f;
        object = new float[2];
        object[0] = currentHeight;
        object[1] = finalHeight;
        Object $this$createAnimation_u24lambda_u241 = object = ValueAnimator.ofFloat((float[])object);
        boolean bl = false;
        $this$createAnimation_u24lambda_u241.setDuration(200L);
        $this$createAnimation_u24lambda_u241.setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator());
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ofFloat(currentHeight, f\u2026nInterpolator()\n        }");
        return object2;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        block3: {
            block4: {
                Float sideBarHeight;
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                super.onDraw(canvas);
                ValueAnimator valueAnimator = this.middleBarAnimation;
                Object object = valueAnimator != null ? valueAnimator.getAnimatedValue() : null;
                Float middleBarHeight = object instanceof Float ? (Float)object : null;
                ValueAnimator valueAnimator2 = this.sideBarAnimation;
                Object object2 = valueAnimator2 != null ? valueAnimator2.getAnimatedValue() : null;
                Float f = sideBarHeight = object2 instanceof Float ? (Float)object2 : null;
                if (!this.showAudioLevel || middleBarHeight == null || sideBarHeight == null) break block3;
                float audioLevelWidth = (float)3 * this.barWidth + (float)(2 * this.barPadding);
                float xOffsetBase = ((float)this.getWidth() - audioLevelWidth) / (float)2;
                this.drawVerticalBar(canvas, xOffsetBase, sideBarHeight.floatValue());
                this.drawVerticalBar(canvas, (float)this.barPadding + this.barWidth + xOffsetBase, middleBarHeight.floatValue());
                this.drawVerticalBar(canvas, (float)2 * ((float)this.barPadding + this.barWidth) + xOffsetBase, sideBarHeight.floatValue());
                ValueAnimator valueAnimator3 = this.middleBarAnimation;
                if (valueAnimator3 != null ? valueAnimator3.isRunning() : false) break block4;
                ValueAnimator valueAnimator4 = this.sideBarAnimation;
                boolean bl = valueAnimator4 != null ? valueAnimator4.isRunning() : false;
                if (!bl) break block3;
            }
            this.invalidate();
        }
    }

    private final void drawVerticalBar(Canvas $this$drawVerticalBar, float xOffset, float size) {
        float yOffset = ((float)$this$drawVerticalBar.getHeight() - size) / (float)2;
        this.barRect.set(xOffset, yOffset, xOffset + this.barWidth, (float)$this$drawVerticalBar.getHeight() - yOffset);
        $this$drawVerticalBar.drawRoundRect(this.barRect, (float)this.barRadius, (float)this.barRadius, this.barPaint);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/roomkit/ui/meeting/audiomode/AudioLevelView$Companion;", "", "()V", "SIDE_BAR_SHRINK_FACTOR", "", "room-kit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

