/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting.audiomode;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.MainThread;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.roomkit.R;
import live.hms.roomkit.databinding.ListItemAudioCollectionBinding;
import live.hms.roomkit.ui.meeting.audiomode.AudioCollection;
import live.hms.roomkit.ui.meeting.audiomode.AudioCollectionDiffUtil;
import live.hms.roomkit.ui.meeting.audiomode.AudioItem;
import live.hms.roomkit.ui.meeting.audiomode.AudioItemsAdapter;
import live.hms.roomkit.util.UtilsKt;
import live.hms.video.media.tracks.HMSAudioTrack;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSSpeaker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u00020\t2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\t2\n\u0010\u0015\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\u00020\t2\n\u0010\u0015\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u001c\u0010\u001a\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0016\u0010\u001e\u001a\u00020\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0007R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Llive/hms/roomkit/ui/meeting/audiomode/AudioCollectionAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Llive/hms/roomkit/ui/meeting/audiomode/AudioCollectionAdapter$AudioViewHolder;", "()V", "collections", "Ljava/util/ArrayList;", "Llive/hms/roomkit/ui/meeting/audiomode/AudioCollection;", "Lkotlin/collections/ArrayList;", "applySpeakerUpdates", "", "speakers", "", "Llive/hms/video/sdk/models/HMSSpeaker;", "([Llive/hms/video/sdk/models/HMSSpeaker;)V", "dispatchUpdates", "newCollections", "isSpeakerUpdate", "", "getItemCount", "", "onBindViewHolder", "holder", "position", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setItems", "newItems", "", "Llive/hms/video/sdk/models/HMSPeer;", "AudioViewHolder", "room-kit_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAudioCollectionAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioCollectionAdapter.kt\nlive/hms/roomkit/ui/meeting/audiomode/AudioCollectionAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,140:1\n1485#2:141\n1510#2,3:142\n1513#2,3:152\n1053#2:155\n1557#2:156\n1628#2,3:157\n1010#2,2:160\n381#3,7:145\n*S KotlinDebug\n*F\n+ 1 AudioCollectionAdapter.kt\nlive/hms/roomkit/ui/meeting/audiomode/AudioCollectionAdapter\n*L\n40#1:141\n40#1:142,3\n40#1:152,3\n45#1:155\n46#1:156\n46#1:157,3\n75#1:160,2\n40#1:145,7\n*E\n"})
public final class AudioCollectionAdapter
extends RecyclerView.Adapter<AudioViewHolder> {
    @NotNull
    private ArrayList<AudioCollection> collections = new ArrayList();
    public static final int $stable = 8;

    private final void dispatchUpdates(ArrayList<AudioCollection> newCollections, boolean isSpeakerUpdate) {
        AudioCollectionDiffUtil callback = new AudioCollectionDiffUtil(this.collections, newCollections);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)callback);
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"calculateDiff(callback)");
        DiffUtil.DiffResult diff = diffResult;
        if (!isSpeakerUpdate) {
            this.collections.clear();
            this.collections.addAll((Collection<AudioCollection>)newCollections);
        }
        diff.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    static /* synthetic */ void dispatchUpdates$default(AudioCollectionAdapter audioCollectionAdapter, ArrayList arrayList, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        audioCollectionAdapter.dispatchUpdates(arrayList, bl);
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    public final synchronized void setItems(@NotNull List<? extends HMSPeer> newItems) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(newItems, (String)"newItems");
        Iterable $this$groupBy$iv = newItems;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            HMSPeer it = (HMSPeer)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getHmsRole().getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map itemsMap = destination$iv$iv;
        ArrayList<AudioCollection> newCollections = new ArrayList<AudioCollection>();
        for (Map.Entry item : itemsMap.entrySet()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedBy$iv;
            Object element$iv$iv;
            Iterable $i$f$groupByTo2 = (Iterable)item.getValue();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    HMSPeer it = (HMSPeer)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (HMSPeer)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            boolean $i$f$map = false;
            element$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HMSPeer $i$f$getOrPut = (HMSPeer)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                HMSAudioTrack hMSAudioTrack = it.getAudioTrack();
                collection.add(new AudioItem(it.getPeerID(), it.getName(), hMSAudioTrack != null ? hMSAudioTrack.isMute() : true, 0, 8, null));
            }
            List audioItems = (List)destination$iv$iv2;
            newCollections.add(new AudioCollection((String)item.getKey(), new ArrayList<AudioItem>(audioItems)));
        }
        AudioCollectionAdapter.dispatchUpdates$default(this, newCollections, false, 2, null);
    }

    @MainThread
    public final synchronized void applySpeakerUpdates(@NotNull HMSSpeaker[] speakers) {
        Intrinsics.checkNotNullParameter((Object)speakers, (String)"speakers");
        boolean requiresUpdate = false;
        for (AudioCollection collection : this.collections) {
            ArrayList<AudioItem> toRemove = new ArrayList<AudioItem>();
            ArrayList<AudioItem> toAdd = new ArrayList<AudioItem>();
            for (AudioItem item : collection.getItems()) {
                int level;
                HMSSpeaker hMSSpeaker;
                block4: {
                    HMSSpeaker[] hMSSpeakerArray = speakers;
                    int n = hMSSpeakerArray.length;
                    for (int i = 0; i < n; ++i) {
                        HMSSpeaker hMSSpeaker2;
                        HMSSpeaker it = hMSSpeaker2 = hMSSpeakerArray[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getPeerId(), (Object)item.getPeerId())) continue;
                        hMSSpeaker = hMSSpeaker2;
                        break block4;
                    }
                    hMSSpeaker = null;
                }
                HMSSpeaker hMSSpeaker3 = hMSSpeaker;
                int n = level = hMSSpeaker3 != null ? hMSSpeaker3.getLevel() : 0;
                if (item.getAudioLevel() == level) continue;
                requiresUpdate = true;
                toRemove.add(item);
                toAdd.add(new AudioItem(item.getPeerId(), item.getName(), item.isTrackMute(), level));
            }
            collection.getItems().removeAll((Collection)toRemove);
            collection.getItems().addAll((Collection<AudioItem>)toAdd);
            List $this$sortBy$iv = collection.getItems();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AudioItem it = (AudioItem)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (AudioItem)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        }
        if (requiresUpdate) {
            this.dispatchUpdates(this.collections, true);
        }
    }

    @NotNull
    public AudioViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ListItemAudioCollectionBinding listItemAudioCollectionBinding = ListItemAudioCollectionBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)listItemAudioCollectionBinding, (String)"inflate(\n      LayoutInf\u2026parent,\n      false\n    )");
        ListItemAudioCollectionBinding binding = listItemAudioCollectionBinding;
        return new AudioViewHolder(binding);
    }

    public void onBindViewHolder(@NotNull AudioViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        AudioCollection audioCollection = this.collections.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)audioCollection, (String)"collections[position]");
        holder.bind(audioCollection);
    }

    public void onBindViewHolder(@NotNull AudioViewHolder holder, int position, @NotNull List<Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        if (payloads.contains((Object)AudioCollectionDiffUtil.PayloadKey.ITEMS)) {
            AudioCollection audioCollection = this.collections.get(position);
            Intrinsics.checkNotNullExpressionValue((Object)audioCollection, (String)"collections[position]");
            holder.updateWithCollection(audioCollection);
            return;
        }
        super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
    }

    public int getItemCount() {
        return this.collections.size();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Llive/hms/roomkit/ui/meeting/audiomode/AudioCollectionAdapter$AudioViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Llive/hms/roomkit/databinding/ListItemAudioCollectionBinding;", "(Llive/hms/roomkit/ui/meeting/audiomode/AudioCollectionAdapter;Llive/hms/roomkit/databinding/ListItemAudioCollectionBinding;)V", "bind", "collection", "Llive/hms/roomkit/ui/meeting/audiomode/AudioCollection;", "updateWithCollection", "", "room-kit_release"})
    @SourceDebugExtension(value={"SMAP\nAudioCollectionAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioCollectionAdapter.kt\nlive/hms/roomkit/ui/meeting/audiomode/AudioCollectionAdapter$AudioViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
    public final class AudioViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ListItemAudioCollectionBinding binding;

        public AudioViewHolder(ListItemAudioCollectionBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ListItemAudioCollectionBinding bind(@NotNull AudioCollection collection) {
            void $this$bind_u24lambda_u243_u24lambda_u241_u24lambda_u240;
            AudioItemsAdapter audioItemsAdapter;
            RecyclerView recyclerView;
            ListItemAudioCollectionBinding listItemAudioCollectionBinding;
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            ListItemAudioCollectionBinding $this$bind_u24lambda_u243 = listItemAudioCollectionBinding = this.binding;
            boolean bl = false;
            $this$bind_u24lambda_u243.title.setText((CharSequence)collection.getTitle());
            RecyclerView $this$bind_u24lambda_u243_u24lambda_u241 = recyclerView = $this$bind_u24lambda_u243.audioCollection;
            boolean bl2 = false;
            $this$bind_u24lambda_u243_u24lambda_u241.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager($this$bind_u24lambda_u243_u24lambda_u241.getContext(), 3));
            AudioItemsAdapter audioItemsAdapter2 = audioItemsAdapter = new AudioItemsAdapter();
            RecyclerView recyclerView2 = $this$bind_u24lambda_u243_u24lambda_u241;
            boolean bl3 = false;
            $this$bind_u24lambda_u243_u24lambda_u241_u24lambda_u240.setItems((List<AudioItem>)collection.getItems());
            recyclerView2.setAdapter((RecyclerView.Adapter)audioItemsAdapter);
            $this$bind_u24lambda_u243.buttonToggleVisibility.setOnClickListener(arg_0 -> AudioViewHolder.bind$lambda$3$lambda$2($this$bind_u24lambda_u243, arg_0));
            return listItemAudioCollectionBinding;
        }

        public final void updateWithCollection(@NotNull AudioCollection collection) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            RecyclerView.Adapter adapter2 = this.binding.audioCollection.getAdapter();
            Intrinsics.checkNotNull((Object)adapter2, (String)"null cannot be cast to non-null type live.hms.roomkit.ui.meeting.audiomode.AudioItemsAdapter");
            AudioItemsAdapter adapter3 = (AudioItemsAdapter)adapter2;
            adapter3.setItems((List<AudioItem>)collection.getItems());
        }

        private static final void bind$lambda$3$lambda$2(ListItemAudioCollectionBinding $this_apply, View it) {
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            boolean show = $this_apply.audioCollection.getVisibility() == 8;
            $this_apply.audioCollection.setVisibility(UtilsKt.visibility(show));
            if (show) {
                $this_apply.buttonToggleVisibility.setIconResource(R.drawable.ic_keyboard_arrow_up_24);
            } else {
                $this_apply.buttonToggleVisibility.setIconResource(R.drawable.ic_keyboard_arrow_down_24);
            }
        }
    }
}

