/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.MutableLiveData;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.roomkit.ui.meeting.SessionMetadataUseCase;
import live.hms.roomkit.ui.meeting.chat.ChatMessage;
import live.hms.video.error.HMSException;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sessionstore.HMSKeyChangeListener;
import live.hms.video.sessionstore.HmsSessionStore;
import live.hms.video.utils.GsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003*\u0001\b\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0006J\u0010\u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010 \u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Llive/hms/roomkit/ui/meeting/SessionMetadataUseCase;", "Ljava/io/Closeable;", "()V", "MAX_PINNED_MESSAGES", "", "hmsSessionStore", "Llive/hms/video/sessionstore/HmsSessionStore;", "keyListener", "live/hms/roomkit/ui/meeting/SessionMetadataUseCase$keyListener$1", "Llive/hms/roomkit/ui/meeting/SessionMetadataUseCase$keyListener$1;", "localPeerName", "", "pinnedMessages", "Landroidx/lifecycle/MutableLiveData;", "", "Llive/hms/roomkit/ui/meeting/SessionMetadataUseCase$PinnedMessage;", "getPinnedMessages", "()Landroidx/lifecycle/MutableLiveData;", "addToPinnedMessages", "", "data", "Llive/hms/roomkit/ui/meeting/chat/ChatMessage;", "hmsActionResultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "close", "removeFromPinnedMessages", "chatMessage", "setPinnedMessageUpdateListener", "setSessionStore", "sessionStore", "updatePeerName", "peerName", "updatePinnedMessage", "", "userBlocked", "PinnedMessage", "room-kit_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSessionMetadataUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionMetadataUseCase.kt\nlive/hms/roomkit/ui/meeting/SessionMetadataUseCase\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n26#2:113\n3829#3:114\n4344#3,2:115\n1#4:117\n*S KotlinDebug\n*F\n+ 1 SessionMetadataUseCase.kt\nlive/hms/roomkit/ui/meeting/SessionMetadataUseCase\n*L\n65#1:113\n66#1:114\n66#1:115,2\n*E\n"})
public final class SessionMetadataUseCase
implements Closeable {
    private final int MAX_PINNED_MESSAGES;
    private HmsSessionStore hmsSessionStore;
    @Nullable
    private String localPeerName;
    @NotNull
    private final keyListener.1 keyListener = new HMSKeyChangeListener(this){
        final /* synthetic */ SessionMetadataUseCase this$0;
        {
            this.this$0 = $receiver;
        }

        public void onKeyChanged(@NotNull String key, @Nullable JsonElement value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (Intrinsics.areEqual((Object)key, (Object)"pinnedMessages")) {
                PinnedMessage[] pinnedMessageArray;
                if (value == null) {
                    boolean $i$f$emptyArray = false;
                    pinnedMessageArray = new PinnedMessage[]{};
                } else {
                    pinnedMessageArray = (PinnedMessage[])GsonUtils.INSTANCE.getGson().fromJson((JsonElement)value.getAsJsonArray(), PinnedMessage[].class);
                }
                PinnedMessage[] message = pinnedMessageArray;
                this.this$0.getPinnedMessages().postValue((Object)message);
            }
        }
    };
    @NotNull
    private final MutableLiveData<PinnedMessage[]> pinnedMessages = new MutableLiveData((Object)new PinnedMessage[0]);
    public static final int $stable = 8;

    public SessionMetadataUseCase() {
        this.MAX_PINNED_MESSAGES = 3;
    }

    @NotNull
    public final MutableLiveData<PinnedMessage[]> getPinnedMessages() {
        return this.pinnedMessages;
    }

    public final void updatePeerName(@Nullable String peerName) {
        this.localPeerName = peerName;
    }

    @Override
    public void close() {
        if (this.hmsSessionStore == null) {
            return;
        }
        HmsSessionStore hmsSessionStore = this.hmsSessionStore;
        if (hmsSessionStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
            hmsSessionStore = null;
        }
        hmsSessionStore.removeKeyChangeListener((HMSKeyChangeListener)this.keyListener, new HMSActionResultListener(){

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
            }

            public void onSuccess() {
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void removeFromPinnedMessages(@NotNull PinnedMessage chatMessage, @NotNull HMSActionResultListener hmsActionResultListener) {
        void $this$filterTo$iv$iv;
        PinnedMessage[] currentMessages;
        PinnedMessage[] pinnedMessageArray;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)hmsActionResultListener, (String)"hmsActionResultListener");
        PinnedMessage[] pinnedMessageArray2 = (PinnedMessage[])this.pinnedMessages.getValue();
        if (pinnedMessageArray2 == null) {
            boolean $i$f$emptyArray = false;
            pinnedMessageArray = new PinnedMessage[]{};
        } else {
            pinnedMessageArray = pinnedMessageArray2;
        }
        PinnedMessage[] $this$filter$iv = currentMessages = pinnedMessageArray;
        boolean $i$f$filter = false;
        PinnedMessage[] pinnedMessageArray3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)chatMessage))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List result = (List)destination$iv$iv;
        this.updatePinnedMessage(result, hmsActionResultListener);
    }

    public final void addToPinnedMessages(@NotNull ChatMessage data, @NotNull HMSActionResultListener hmsActionResultListener) {
        String string2;
        String string3;
        PinnedMessage pinnedMessage;
        Object[] existingPinnedMessages;
        block6: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)hmsActionResultListener, (String)"hmsActionResultListener");
            Object[] objectArray = (PinnedMessage[])this.pinnedMessages.getValue();
            if (objectArray == null) {
                objectArray = new PinnedMessage[]{};
            }
            Object[] objectArray2 = existingPinnedMessages = objectArray;
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                PinnedMessage pinnedMessage2;
                PinnedMessage it = pinnedMessage2 = objectArray2[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)data.getMessageId())) continue;
                pinnedMessage = pinnedMessage2;
                break block6;
            }
            pinnedMessage = null;
        }
        if (pinnedMessage != null) {
            return;
        }
        String string4 = data.getLocalSenderRealNameForPinMessage() + ": " + data.getMessage();
        String string5 = data.getMessageId();
        if (string5 == null) {
            string5 = "";
        }
        if ((string3 = this.localPeerName) == null) {
            string3 = "Participant";
        }
        if ((string2 = data.getUserIdForBlockList()) == null) {
            string2 = "";
        }
        PinnedMessage newPinnedMessage = new PinnedMessage(string4, string5, string3, string2);
        List newMessages = existingPinnedMessages.length < this.MAX_PINNED_MESSAGES ? ArraysKt.toList((Object[])ArraysKt.plus((Object[])existingPinnedMessages, (Object)newPinnedMessage)) : CollectionsKt.plus((Collection)ArraysKt.drop((Object[])existingPinnedMessages, (int)1), (Object)newPinnedMessage);
        this.updatePinnedMessage(newMessages, hmsActionResultListener);
    }

    private final void updatePinnedMessage(List<PinnedMessage> data, HMSActionResultListener hmsActionResultListener) {
        HmsSessionStore hmsSessionStore = this.hmsSessionStore;
        if (hmsSessionStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
            hmsSessionStore = null;
        }
        hmsSessionStore.set(data, "pinnedMessages", hmsActionResultListener);
    }

    public final void setPinnedMessageUpdateListener(@NotNull HMSActionResultListener hmsActionResultListener) {
        Intrinsics.checkNotNullParameter((Object)hmsActionResultListener, (String)"hmsActionResultListener");
        HmsSessionStore hmsSessionStore = this.hmsSessionStore;
        if (hmsSessionStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
            hmsSessionStore = null;
        }
        hmsSessionStore.addKeyChangeListener(CollectionsKt.listOf((Object)"pinnedMessages"), (HMSKeyChangeListener)this.keyListener, hmsActionResultListener);
    }

    public final void setSessionStore(@NotNull HmsSessionStore sessionStore) {
        Intrinsics.checkNotNullParameter((Object)sessionStore, (String)"sessionStore");
        this.hmsSessionStore = sessionStore;
    }

    public final void userBlocked(@NotNull ChatMessage chatMessage) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J7\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Llive/hms/roomkit/ui/meeting/SessionMetadataUseCase$PinnedMessage;", "", "text", "", "id", "pinnedBy", "authorId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAuthorId", "()Ljava/lang/String;", "getId", "getPinnedBy", "getText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "room-kit_release"})
    @StabilityInferred(parameters=0)
    public static final class PinnedMessage {
        @SerializedName(value="text")
        @Nullable
        private final String text;
        @SerializedName(value="id")
        @NotNull
        private final String id;
        @SerializedName(value="pinnedBy")
        @Nullable
        private final String pinnedBy;
        @SerializedName(value="authorId")
        @Nullable
        private final String authorId;
        public static final int $stable;

        public PinnedMessage(@Nullable String text, @NotNull String id2, @Nullable String pinnedBy, @Nullable String authorId) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            this.text = text;
            this.id = id2;
            this.pinnedBy = pinnedBy;
            this.authorId = authorId;
        }

        @Nullable
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getPinnedBy() {
            return this.pinnedBy;
        }

        @Nullable
        public final String getAuthorId() {
            return this.authorId;
        }

        @Nullable
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.id;
        }

        @Nullable
        public final String component3() {
            return this.pinnedBy;
        }

        @Nullable
        public final String component4() {
            return this.authorId;
        }

        @NotNull
        public final PinnedMessage copy(@Nullable String text, @NotNull String id2, @Nullable String pinnedBy, @Nullable String authorId) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return new PinnedMessage(text, id2, pinnedBy, authorId);
        }

        public static /* synthetic */ PinnedMessage copy$default(PinnedMessage pinnedMessage, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = pinnedMessage.text;
            }
            if ((n & 2) != 0) {
                string3 = pinnedMessage.id;
            }
            if ((n & 4) != 0) {
                string4 = pinnedMessage.pinnedBy;
            }
            if ((n & 8) != 0) {
                string5 = pinnedMessage.authorId;
            }
            return pinnedMessage.copy(string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "PinnedMessage(text=" + this.text + ", id=" + this.id + ", pinnedBy=" + this.pinnedBy + ", authorId=" + this.authorId + ")";
        }

        public int hashCode() {
            int result = this.text == null ? 0 : this.text.hashCode();
            result = result * 31 + this.id.hashCode();
            result = result * 31 + (this.pinnedBy == null ? 0 : this.pinnedBy.hashCode());
            result = result * 31 + (this.authorId == null ? 0 : this.authorId.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PinnedMessage)) {
                return false;
            }
            PinnedMessage pinnedMessage = (PinnedMessage)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)pinnedMessage.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)pinnedMessage.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pinnedBy, (Object)pinnedMessage.pinnedBy)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.authorId, (Object)pinnedMessage.authorId);
        }
    }
}

