/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.MutableLiveData;
import com.google.gson.JsonElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import live.hms.roomkit.ui.meeting.ChatPauseState;
import live.hms.roomkit.ui.meeting.PauseChatUseCase;
import live.hms.video.error.HMSException;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sessionstore.HMSKeyChangeListener;
import live.hms.video.sessionstore.HmsSessionStore;
import live.hms.video.utils.GsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u0010\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\nJ\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u0018"}, d2={"Llive/hms/roomkit/ui/meeting/PauseChatUseCase;", "Ljava/lang/AutoCloseable;", "()V", "PAUSE_CHAT_KEY", "", "TAG", "getTAG", "()Ljava/lang/String;", "currentChatPauseState", "Landroidx/lifecycle/MutableLiveData;", "Llive/hms/roomkit/ui/meeting/ChatPauseState;", "getCurrentChatPauseState", "()Landroidx/lifecycle/MutableLiveData;", "hmsSessionStore", "Llive/hms/video/sessionstore/HmsSessionStore;", "keyChangeListener", "live/hms/roomkit/ui/meeting/PauseChatUseCase$keyChangeListener$1", "Llive/hms/roomkit/ui/meeting/PauseChatUseCase$keyChangeListener$1;", "addKeyChangeListener", "", "changeChatState", "state", "close", "setSessionStore", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class PauseChatUseCase
implements AutoCloseable {
    private HmsSessionStore hmsSessionStore;
    @NotNull
    private final String TAG;
    @NotNull
    private final String PAUSE_CHAT_KEY;
    @NotNull
    private final MutableLiveData<ChatPauseState> currentChatPauseState = new MutableLiveData((Object)new ChatPauseState(false, null, 0L, 7, null));
    @NotNull
    private final keyChangeListener.1 keyChangeListener = new HMSKeyChangeListener(this){
        final /* synthetic */ PauseChatUseCase this$0;
        {
            this.this$0 = $receiver;
        }

        public void onKeyChanged(@NotNull String key, @Nullable JsonElement value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (Intrinsics.areEqual((Object)key, (Object)PauseChatUseCase.access$getPAUSE_CHAT_KEY$p(this.this$0))) {
                ChatPauseState chatPauseState;
                if (value == null) {
                    chatPauseState = new ChatPauseState(false, null, 0L, 7, null);
                } else {
                    Object object = GsonUtils.INSTANCE.getGson().fromJson(value, ChatPauseState.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    Gs\u2026s.java)\n                }");
                    chatPauseState = (ChatPauseState)object;
                }
                ChatPauseState newState = chatPauseState;
                this.this$0.getCurrentChatPauseState().postValue((Object)newState);
            }
        }
    };
    public static final int $stable = 8;

    public PauseChatUseCase() {
        this.TAG = "BlockUserUseCase";
        this.PAUSE_CHAT_KEY = "chatState";
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final MutableLiveData<ChatPauseState> getCurrentChatPauseState() {
        return this.currentChatPauseState;
    }

    public final void setSessionStore(@NotNull HmsSessionStore hmsSessionStore) {
        Intrinsics.checkNotNullParameter((Object)hmsSessionStore, (String)"hmsSessionStore");
        this.hmsSessionStore = hmsSessionStore;
    }

    public final void changeChatState(@NotNull ChatPauseState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.hmsSessionStore == null) {
            Log.e((String)this.TAG, (String)"Tried to block user without session store inited");
            return;
        }
        HmsSessionStore hmsSessionStore = this.hmsSessionStore;
        if (hmsSessionStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
            hmsSessionStore = null;
        }
        hmsSessionStore.set((Object)state, this.PAUSE_CHAT_KEY, new HMSActionResultListener(this){
            final /* synthetic */ PauseChatUseCase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                Log.e((String)this.this$0.getTAG(), (String)("Updating chat state failed with " + error));
            }

            public void onSuccess() {
                Log.d((String)this.this$0.getTAG(), (String)"Updating chat state successful");
            }
        });
    }

    public final void addKeyChangeListener() {
        HmsSessionStore hmsSessionStore = this.hmsSessionStore;
        if (hmsSessionStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
            hmsSessionStore = null;
        }
        hmsSessionStore.addKeyChangeListener(CollectionsKt.listOf((Object)this.PAUSE_CHAT_KEY), (HMSKeyChangeListener)this.keyChangeListener, new HMSActionResultListener(this){
            final /* synthetic */ PauseChatUseCase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                Log.e((String)this.this$0.getTAG(), (String)("Error " + error));
            }

            public void onSuccess() {
                Log.d((String)this.this$0.getTAG(), (String)"Added block peer key");
            }
        });
    }

    @Override
    public void close() {
        if (this.hmsSessionStore == null) {
            return;
        }
        HmsSessionStore hmsSessionStore = this.hmsSessionStore;
        if (hmsSessionStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
            hmsSessionStore = null;
        }
        hmsSessionStore.removeKeyChangeListener((HMSKeyChangeListener)this.keyChangeListener, new HMSActionResultListener(){

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
            }

            public void onSuccess() {
            }
        });
    }

    public static final /* synthetic */ String access$getPAUSE_CHAT_KEY$p(PauseChatUseCase $this) {
        return $this.PAUSE_CHAT_KEY;
    }
}

