/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.meeting;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.MutableLiveData;
import com.google.gson.JsonElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import live.hms.roomkit.ui.meeting.BlockUserUseCase;
import live.hms.roomkit.ui.meeting.chat.ChatMessage;
import live.hms.video.error.HMSException;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sessionstore.HMSKeyChangeListener;
import live.hms.video.sessionstore.HmsSessionStore;
import live.hms.video.utils.GsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0010\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001b"}, d2={"Llive/hms/roomkit/ui/meeting/BlockUserUseCase;", "Ljava/lang/AutoCloseable;", "()V", "BLOCK_PEER_KEY", "", "TAG", "getTAG", "()Ljava/lang/String;", "currentBlockList", "Landroidx/lifecycle/MutableLiveData;", "", "getCurrentBlockList", "()Landroidx/lifecycle/MutableLiveData;", "hmsSessionStore", "Llive/hms/video/sessionstore/HmsSessionStore;", "keyChangeListener", "live/hms/roomkit/ui/meeting/BlockUserUseCase$keyChangeListener$1", "Llive/hms/roomkit/ui/meeting/BlockUserUseCase$keyChangeListener$1;", "addKeyChangeListener", "", "blockUser", "chatMessage", "Llive/hms/roomkit/ui/meeting/chat/ChatMessage;", "hmsActionResultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "close", "setSessionStore", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class BlockUserUseCase
implements AutoCloseable {
    private HmsSessionStore hmsSessionStore;
    @NotNull
    private final String TAG;
    @NotNull
    private final String BLOCK_PEER_KEY;
    @NotNull
    private final MutableLiveData<Set<String>> currentBlockList = new MutableLiveData((Object)SetsKt.emptySet());
    @NotNull
    private final keyChangeListener.1 keyChangeListener = new HMSKeyChangeListener(this){
        final /* synthetic */ BlockUserUseCase this$0;
        {
            this.this$0 = $receiver;
        }

        public void onKeyChanged(@NotNull String key, @Nullable JsonElement value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (Intrinsics.areEqual((Object)key, (Object)BlockUserUseCase.access$getBLOCK_PEER_KEY$p(this.this$0))) {
                Set set;
                if (value == null) {
                    set = SetsKt.emptySet();
                } else {
                    Object object = GsonUtils.INSTANCE.getGson().fromJson((JsonElement)value.getAsJsonArray(), String[].class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(value.asJs\u2026rray<String>::class.java)");
                    set = ArraysKt.toSet((Object[])((Object[])object));
                }
                Set newList = set;
                this.this$0.getCurrentBlockList().postValue((Object)newList);
            }
        }
    };
    public static final int $stable = 8;

    public BlockUserUseCase() {
        this.TAG = "BlockUserUseCase";
        this.BLOCK_PEER_KEY = "chatPeerBlacklist";
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final MutableLiveData<Set<String>> getCurrentBlockList() {
        return this.currentBlockList;
    }

    public final void setSessionStore(@NotNull HmsSessionStore hmsSessionStore) {
        Intrinsics.checkNotNullParameter((Object)hmsSessionStore, (String)"hmsSessionStore");
        this.hmsSessionStore = hmsSessionStore;
    }

    public final void blockUser(@NotNull ChatMessage chatMessage, @NotNull HMSActionResultListener hmsActionResultListener) {
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter((Object)hmsActionResultListener, (String)"hmsActionResultListener");
        if (this.hmsSessionStore == null) {
            Log.e((String)this.TAG, (String)"Tried to block user without session store inited");
            return;
        }
        if (chatMessage.getUserIdForBlockList() != null) {
            Set set;
            Set set2 = (Set)this.currentBlockList.getValue();
            Set newValue = set2 != null && (set = SetsKt.plus((Set)set2, (Object)chatMessage.getUserIdForBlockList())) != null ? set : SetsKt.setOf((Object)chatMessage.getUserIdForBlockList());
            HmsSessionStore hmsSessionStore = this.hmsSessionStore;
            if (hmsSessionStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
                hmsSessionStore = null;
            }
            hmsSessionStore.set((Object)newValue, this.BLOCK_PEER_KEY, hmsActionResultListener);
        }
    }

    public final void addKeyChangeListener() {
        HmsSessionStore hmsSessionStore = this.hmsSessionStore;
        if (hmsSessionStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
            hmsSessionStore = null;
        }
        hmsSessionStore.addKeyChangeListener(CollectionsKt.listOf((Object)this.BLOCK_PEER_KEY), (HMSKeyChangeListener)this.keyChangeListener, new HMSActionResultListener(this){
            final /* synthetic */ BlockUserUseCase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Log.e((String)this.this$0.getTAG(), (String)("Error " + error));
            }

            public void onSuccess() {
                Log.d((String)this.this$0.getTAG(), (String)"Added block peer key");
            }
        });
    }

    @Override
    public void close() {
        if (this.hmsSessionStore == null) {
            return;
        }
        HmsSessionStore hmsSessionStore = this.hmsSessionStore;
        if (hmsSessionStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hmsSessionStore");
            hmsSessionStore = null;
        }
        hmsSessionStore.removeKeyChangeListener((HMSKeyChangeListener)this.keyChangeListener, new HMSActionResultListener(){

            public void onError(@NotNull HMSException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }

            public void onSuccess() {
            }
        });
    }

    public static final /* synthetic */ String access$getBLOCK_PEER_KEY$p(BlockUserUseCase $this) {
        return $this.BLOCK_PEER_KEY;
    }
}

