/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.ui.diagnostic;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.diagnostics.HMSDiagnostics;
import live.hms.video.sdk.HMSSDK;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0002J\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Llive/hms/roomkit/ui/diagnostic/DiagnosticProvider;", "", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "consistentUserId", "", "hms", "Lkotlin/Pair;", "Llive/hms/video/sdk/HMSSDK;", "Llive/hms/video/diagnostics/HMSDiagnostics;", "createInstance", "disposeOfDiagnostic", "", "getConsistentUserIdOverSessions", "getDiagnosticSdk", "getSdk", "room-kit_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiagnosticProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticProvider.kt\nlive/hms/roomkit/ui/diagnostic/DiagnosticProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,39:1\n1#2:40\n39#3,12:41\n*S KotlinDebug\n*F\n+ 1 DiagnosticProvider.kt\nlive/hms/roomkit/ui/diagnostic/DiagnosticProvider\n*L\n30#1:41,12\n*E\n"})
public final class DiagnosticProvider {
    @NotNull
    private final Application application;
    @Nullable
    private Pair<HMSSDK, HMSDiagnostics> hms;
    @NotNull
    private final String consistentUserId;
    public static final int $stable = 8;

    public DiagnosticProvider(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.application = application;
        this.consistentUserId = this.getConsistentUserIdOverSessions();
    }

    public final void disposeOfDiagnostic() {
        HMSDiagnostics hMSDiagnostics = this.hms;
        if (hMSDiagnostics != null && (hMSDiagnostics = (HMSDiagnostics)hMSDiagnostics.getSecond()) != null) {
            hMSDiagnostics.stopConnectivityCheck();
        }
        this.hms = null;
    }

    @NotNull
    public final HMSSDK getSdk() {
        HMSSDK hMSSDK = this.hms;
        if (hMSSDK == null || (hMSSDK = (HMSSDK)hMSSDK.getFirst()) == null) {
            hMSSDK = (HMSSDK)this.createInstance(this.application).getFirst();
        }
        return hMSSDK;
    }

    @NotNull
    public final HMSDiagnostics getDiagnosticSdk() {
        HMSDiagnostics hMSDiagnostics = this.hms;
        if (hMSDiagnostics == null || (hMSDiagnostics = (HMSDiagnostics)hMSDiagnostics.getSecond()) == null) {
            hMSDiagnostics = (HMSDiagnostics)this.createInstance(this.application).getSecond();
        }
        return hMSDiagnostics;
    }

    private final Pair<HMSSDK, HMSDiagnostics> createInstance(Application application) {
        Pair pair;
        HMSSDK hmsSDK = new HMSSDK.Builder((Context)application).build();
        HMSDiagnostics diag = hmsSDK.getDiagnosticsSDK(this.consistentUserId);
        Pair $this$createInstance_u24lambda_u240 = pair = new Pair((Object)hmsSDK, (Object)diag);
        boolean bl = false;
        this.hms = $this$createInstance_u24lambda_u240;
        return pair;
    }

    private final String getConsistentUserIdOverSessions() {
        String string;
        SharedPreferences sharedPreferences = this.application.getSharedPreferences("your-activity-preference", 0);
        if (sharedPreferences.getString("saved_user_id_blocklist", null) == null) {
            SharedPreferences.Editor editor$iv;
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"sharedPreferences");
            SharedPreferences $this$edit_u24default$iv = sharedPreferences;
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor $this$getConsistentUserIdOverSessions_u24lambda_u241 = editor$iv = $this$edit_u24default$iv.edit();
            boolean bl = false;
            $this$getConsistentUserIdOverSessions_u24lambda_u241.putString("saved_user_id_blocklist", UUID.randomUUID().toString());
            editor$iv.apply();
        }
        if ((string = sharedPreferences.getString("saved_user_id_blocklist", null)) == null) {
            string = "";
        }
        return string;
    }
}

