/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.animation;

import android.os.CancellationSignal;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsAnimationControlListenerCompat;
import androidx.core.view.WindowInsetsAnimationControllerCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import live.hms.roomkit.animation.SimpleImeAnimationController;
import live.hms.roomkit.animation.SimpleImeAnimationControllerKt;
import live.hms.roomkit.animation.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000e2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00132\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0013J\u0006\u0010\u001c\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020\u000eJ\u0006\u0010#\u001a\u00020\u000eJ\u0006\u0010$\u001a\u00020\u000eJ\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\fH\u0002J\b\u0010'\u001a\u00020\u0013H\u0002J\u0016\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010+\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*2\u0016\b\u0002\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Llive/hms/roomkit/animation/SimpleImeAnimationController;", "", "()V", "animationControlListener", "live/hms/roomkit/animation/SimpleImeAnimationController$animationControlListener$2$1", "getAnimationControlListener", "()Llive/hms/roomkit/animation/SimpleImeAnimationController$animationControlListener$2$1;", "animationControlListener$delegate", "Lkotlin/Lazy;", "currentSpringAnimation", "Landroidx/dynamicanimation/animation/SpringAnimation;", "insetsAnimationController", "Landroidx/core/view/WindowInsetsAnimationControllerCompat;", "isImeShownAtStart", "", "pendingRequestCancellationSignal", "Landroid/os/CancellationSignal;", "pendingRequestOnReady", "Lkotlin/Function1;", "", "animateImeToVisibility", "visible", "velocityY", "", "(ZLjava/lang/Float;)V", "animateToFinish", "(Ljava/lang/Float;)V", "cancel", "finish", "insetBy", "", "dy", "insetTo", "inset", "isInsetAnimationFinishing", "isInsetAnimationInProgress", "isInsetAnimationRequestPending", "onRequestReady", "controller", "reset", "startAndFling", "view", "Landroid/view/View;", "startControlRequest", "room-kit_release"})
@SourceDebugExtension(value={"SMAP\nSimpleImeAnimationController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleImeAnimationController.kt\nlive/hms/roomkit/animation/SimpleImeAnimationController\n+ 2 utils.kt\nlive/hms/roomkit/animation/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,388:1\n108#2,5:389\n1#3:394\n*S KotlinDebug\n*F\n+ 1 SimpleImeAnimationController.kt\nlive/hms/roomkit/animation/SimpleImeAnimationController\n*L\n356#1:389,5\n*E\n"})
public final class SimpleImeAnimationController {
    @Nullable
    private WindowInsetsAnimationControllerCompat insetsAnimationController;
    @Nullable
    private CancellationSignal pendingRequestCancellationSignal;
    @Nullable
    private Function1<? super WindowInsetsAnimationControllerCompat, Unit> pendingRequestOnReady;
    @NotNull
    private final Lazy animationControlListener$delegate = LazyKt.lazy((Function0)((Function0)new Function0<animationControlListener.1>(this){
        final /* synthetic */ SimpleImeAnimationController this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final animationControlListener.1 invoke() {
            return new WindowInsetsAnimationControlListenerCompat(this.this$0){
                final /* synthetic */ SimpleImeAnimationController this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onReady(@NotNull WindowInsetsAnimationControllerCompat controller, int types) {
                    Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                    SimpleImeAnimationController.access$onRequestReady(this.this$0, controller);
                }

                public void onFinished(@NotNull WindowInsetsAnimationControllerCompat controller) {
                    Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                    SimpleImeAnimationController.access$reset(this.this$0);
                }

                public void onCancelled(@Nullable WindowInsetsAnimationControllerCompat controller) {
                    SimpleImeAnimationController.access$reset(this.this$0);
                }
            };
        }
    }));
    private boolean isImeShownAtStart;
    @Nullable
    private SpringAnimation currentSpringAnimation;

    private final animationControlListener.1 getAnimationControlListener() {
        Lazy lazy = this.animationControlListener$delegate;
        return lazy.getValue();
    }

    public final void startControlRequest(@NotNull View view, @Nullable Function1<? super WindowInsetsAnimationControllerCompat, Unit> onRequestReady) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            if (!(!this.isInsetAnimationInProgress())) {
                boolean bl = false;
                String string = "Animation in progress. Can not start a new request to controlWindowInsetsAnimation()";
                throw new IllegalStateException(string.toString());
            }
            WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)view);
            this.isImeShownAtStart = windowInsetsCompat != null ? windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime()) : false;
            this.pendingRequestCancellationSignal = new CancellationSignal();
            this.pendingRequestOnReady = onRequestReady;
            WindowInsetsControllerCompat windowInsetsControllerCompat = ViewCompat.getWindowInsetsController((View)view);
            if (windowInsetsControllerCompat == null) break block1;
            windowInsetsControllerCompat.controlWindowInsetsAnimation(WindowInsetsCompat.Type.ime(), -1L, (Interpolator)SimpleImeAnimationControllerKt.access$getLinearInterpolator$p(), this.pendingRequestCancellationSignal, (WindowInsetsAnimationControlListenerCompat)this.getAnimationControlListener());
        }
    }

    public static /* synthetic */ void startControlRequest$default(SimpleImeAnimationController simpleImeAnimationController, View view, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        simpleImeAnimationController.startControlRequest(view, (Function1<? super WindowInsetsAnimationControllerCompat, Unit>)function1);
    }

    public final void startAndFling(@NotNull View view, float velocityY) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.startControlRequest(view, (Function1<? super WindowInsetsAnimationControllerCompat, Unit>)((Function1)new Function1<WindowInsetsAnimationControllerCompat, Unit>(this, velocityY){
            final /* synthetic */ SimpleImeAnimationController this$0;
            final /* synthetic */ float $velocityY;
            {
                this.this$0 = $receiver;
                this.$velocityY = $velocityY;
                super(1);
            }

            public final void invoke(@NotNull WindowInsetsAnimationControllerCompat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.animateToFinish(Float.valueOf(this.$velocityY));
            }
        }));
    }

    public final int insetBy(int dy) {
        WindowInsetsAnimationControllerCompat windowInsetsAnimationControllerCompat = this.insetsAnimationController;
        if (windowInsetsAnimationControllerCompat == null) {
            throw new IllegalStateException("Current WindowInsetsAnimationController is null.This should only be called if isAnimationInProgress() returns true");
        }
        WindowInsetsAnimationControllerCompat controller = windowInsetsAnimationControllerCompat;
        return this.insetTo(controller.getCurrentInsets().bottom - dy);
    }

    public final int insetTo(int inset) {
        WindowInsetsAnimationControllerCompat windowInsetsAnimationControllerCompat = this.insetsAnimationController;
        if (windowInsetsAnimationControllerCompat == null) {
            throw new IllegalStateException("Current WindowInsetsAnimationController is null.This should only be called if isAnimationInProgress() returns true");
        }
        WindowInsetsAnimationControllerCompat controller = windowInsetsAnimationControllerCompat;
        int hiddenBottom = controller.getHiddenStateInsets().bottom;
        int shownBottom = controller.getShownStateInsets().bottom;
        int startBottom = this.isImeShownAtStart ? shownBottom : hiddenBottom;
        int endBottom = this.isImeShownAtStart ? hiddenBottom : shownBottom;
        int coercedBottom = RangesKt.coerceIn((int)inset, (int)hiddenBottom, (int)shownBottom);
        int consumedDy = controller.getCurrentInsets().bottom - coercedBottom;
        controller.setInsetsAndAlpha(Insets.of((int)0, (int)0, (int)0, (int)coercedBottom), 1.0f, (float)(coercedBottom - startBottom) / (float)(endBottom - startBottom));
        return consumedDy;
    }

    public final boolean isInsetAnimationInProgress() {
        return this.insetsAnimationController != null;
    }

    public final boolean isInsetAnimationFinishing() {
        return this.currentSpringAnimation != null;
    }

    public final boolean isInsetAnimationRequestPending() {
        return this.pendingRequestCancellationSignal != null;
    }

    public final void cancel() {
        WindowInsetsAnimationControllerCompat windowInsetsAnimationControllerCompat = this.insetsAnimationController;
        if (windowInsetsAnimationControllerCompat != null) {
            windowInsetsAnimationControllerCompat.finish(this.isImeShownAtStart);
        }
        CancellationSignal cancellationSignal = this.pendingRequestCancellationSignal;
        if (cancellationSignal != null) {
            cancellationSignal.cancel();
        }
        SpringAnimation springAnimation = this.currentSpringAnimation;
        if (springAnimation != null) {
            springAnimation.cancel();
        }
        this.reset();
    }

    public final void finish() {
        WindowInsetsAnimationControllerCompat controller = this.insetsAnimationController;
        if (controller == null) {
            CancellationSignal cancellationSignal = this.pendingRequestCancellationSignal;
            if (cancellationSignal != null) {
                cancellationSignal.cancel();
            }
            return;
        }
        int current = controller.getCurrentInsets().bottom;
        int shown = controller.getShownStateInsets().bottom;
        int hidden = controller.getHiddenStateInsets().bottom;
        int n = current;
        if (n == shown) {
            controller.finish(true);
        } else if (n == hidden) {
            controller.finish(false);
        } else if (controller.getCurrentFraction() >= 0.15f) {
            controller.finish(!this.isImeShownAtStart);
        } else {
            controller.finish(this.isImeShownAtStart);
        }
    }

    public final void animateToFinish(@Nullable Float velocityY) {
        WindowInsetsAnimationControllerCompat controller = this.insetsAnimationController;
        if (controller == null) {
            CancellationSignal cancellationSignal = this.pendingRequestCancellationSignal;
            if (cancellationSignal != null) {
                cancellationSignal.cancel();
            }
            return;
        }
        int current = controller.getCurrentInsets().bottom;
        int shown = controller.getShownStateInsets().bottom;
        int hidden = controller.getHiddenStateInsets().bottom;
        if (velocityY != null) {
            this.animateImeToVisibility(velocityY.floatValue() > 0.0f, velocityY);
        } else if (current == shown) {
            controller.finish(true);
        } else if (current == hidden) {
            controller.finish(false);
        } else if (controller.getCurrentFraction() >= 0.15f) {
            SimpleImeAnimationController.animateImeToVisibility$default(this, !this.isImeShownAtStart, null, 2, null);
        } else {
            SimpleImeAnimationController.animateImeToVisibility$default(this, this.isImeShownAtStart, null, 2, null);
        }
    }

    public static /* synthetic */ void animateToFinish$default(SimpleImeAnimationController simpleImeAnimationController, Float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = null;
        }
        simpleImeAnimationController.animateToFinish(f);
    }

    private final void onRequestReady(WindowInsetsAnimationControllerCompat controller) {
        this.pendingRequestCancellationSignal = null;
        this.insetsAnimationController = controller;
        Function1<? super WindowInsetsAnimationControllerCompat, Unit> function1 = this.pendingRequestOnReady;
        if (function1 != null) {
            function1.invoke((Object)controller);
        }
        this.pendingRequestOnReady = null;
    }

    private final void reset() {
        this.insetsAnimationController = null;
        this.pendingRequestCancellationSignal = null;
        this.isImeShownAtStart = false;
        SpringAnimation springAnimation = this.currentSpringAnimation;
        if (springAnimation != null) {
            springAnimation.cancel();
        }
        this.currentSpringAnimation = null;
        this.pendingRequestOnReady = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void animateImeToVisibility(boolean visible, Float velocityY) {
        void it;
        SpringAnimation $this$animateImeToVisibility_u24lambda_u243;
        void $this$animateImeToVisibility_u24lambda_u241;
        void $this$withSpringForceProperties$iv;
        WindowInsetsAnimationControllerCompat windowInsetsAnimationControllerCompat = this.insetsAnimationController;
        if (windowInsetsAnimationControllerCompat == null) {
            throw new IllegalStateException("Controller should not be null");
        }
        WindowInsetsAnimationControllerCompat controller = windowInsetsAnimationControllerCompat;
        SpringAnimation springAnimation = UtilsKt.springAnimationOf((Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this){
            final /* synthetic */ SimpleImeAnimationController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(float it) {
                this.this$0.insetTo(MathKt.roundToInt((float)it));
            }
        }), (Function0<Float>)((Function0)new Function0<Float>(controller){
            final /* synthetic */ WindowInsetsAnimationControllerCompat $controller;
            {
                this.$controller = $controller;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                return Float.valueOf(this.$controller.getCurrentInsets().bottom);
            }
        }), visible ? (float)controller.getShownStateInsets().bottom : (float)controller.getHiddenStateInsets().bottom);
        boolean $i$f$withSpringForceProperties22 = false;
        if ($this$withSpringForceProperties$iv.getSpring() == null) {
            $this$withSpringForceProperties$iv.setSpring(new SpringForce());
        }
        SpringForce springForce = $this$withSpringForceProperties$iv.getSpring();
        Intrinsics.checkNotNullExpressionValue((Object)springForce, (String)"spring");
        SpringForce springForce2 = springForce;
        SimpleImeAnimationController simpleImeAnimationController = this;
        boolean bl = false;
        $this$animateImeToVisibility_u24lambda_u241.setDampingRatio(1.0f);
        $this$animateImeToVisibility_u24lambda_u241.setStiffness(1500.0f);
        SpringAnimation $i$f$withSpringForceProperties22 = springAnimation = $this$withSpringForceProperties$iv;
        boolean bl2 = false;
        if (velocityY != null) {
            $this$animateImeToVisibility_u24lambda_u243.setStartVelocity(velocityY.floatValue());
        }
        $this$animateImeToVisibility_u24lambda_u243.addEndListener((arg_0, arg_1, arg_2, arg_3) -> SimpleImeAnimationController.animateImeToVisibility$lambda$3$lambda$2(this, arg_0, arg_1, arg_2, arg_3));
        $this$animateImeToVisibility_u24lambda_u243 = springAnimation;
        boolean bl3 = false;
        it.start();
        simpleImeAnimationController.currentSpringAnimation = springAnimation;
    }

    static /* synthetic */ void animateImeToVisibility$default(SimpleImeAnimationController simpleImeAnimationController, boolean bl, Float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        simpleImeAnimationController.animateImeToVisibility(bl, f);
    }

    private static final void animateImeToVisibility$lambda$3$lambda$2(SimpleImeAnimationController this$0, DynamicAnimation anim, boolean bl, float f, float f2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Intrinsics.areEqual((Object)anim, (Object)this$0.currentSpringAnimation)) {
            this$0.currentSpringAnimation = null;
        }
        this$0.finish();
    }

    public static final /* synthetic */ void access$onRequestReady(SimpleImeAnimationController $this, WindowInsetsAnimationControllerCompat controller) {
        $this.onRequestReady(controller);
    }

    public static final /* synthetic */ void access$reset(SimpleImeAnimationController $this) {
        $this.reset();
    }
}

