/*
 * Decompiled with CFR 0.152.
 */
package live.hms.roomkit.animation;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import live.hms.roomkit.animation.SimpleImeAnimationController;
import live.hms.roomkit.animation.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Llive/hms/roomkit/animation/InsetsAnimationTouchListener;", "Landroid/view/View$OnTouchListener;", "scrollImeOffScreenWhenVisible", "", "scrollImeOnScreenWhenNotVisible", "(ZZ)V", "bounds", "Landroid/graphics/Rect;", "isHandling", "lastTouchX", "", "lastTouchY", "lastWindowY", "", "simpleController", "Llive/hms/roomkit/animation/SimpleImeAnimationController;", "velocityTracker", "Landroid/view/VelocityTracker;", "onTouch", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "reset", "", "shouldStartRequest", "dy", "imeVisible", "room-kit_release"})
@StabilityInferred(parameters=0)
public final class InsetsAnimationTouchListener
implements View.OnTouchListener {
    private final boolean scrollImeOffScreenWhenVisible;
    private final boolean scrollImeOnScreenWhenNotVisible;
    private boolean isHandling;
    private float lastTouchX;
    private float lastTouchY;
    private int lastWindowY;
    @NotNull
    private final Rect bounds;
    @NotNull
    private final SimpleImeAnimationController simpleController;
    @Nullable
    private VelocityTracker velocityTracker;
    public static final int $stable = 8;

    public InsetsAnimationTouchListener(boolean scrollImeOffScreenWhenVisible, boolean scrollImeOnScreenWhenNotVisible) {
        this.scrollImeOffScreenWhenVisible = scrollImeOffScreenWhenVisible;
        this.scrollImeOnScreenWhenNotVisible = scrollImeOnScreenWhenNotVisible;
        this.bounds = new Rect();
        this.simpleController = new SimpleImeAnimationController();
    }

    public /* synthetic */ InsetsAnimationTouchListener(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        this(bl, bl2);
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        switch (event.getAction()) {
            case 0: {
                VelocityTracker velocityTracker = this.velocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.addMovement(event);
                }
                this.lastTouchX = event.getX();
                this.lastTouchY = event.getY();
                UtilsKt.copyBoundsInWindow(v, this.bounds);
                this.lastWindowY = this.bounds.top;
                break;
            }
            case 2: {
                UtilsKt.copyBoundsInWindow(v, this.bounds);
                int windowOffsetY = this.bounds.top - this.lastWindowY;
                MotionEvent vtev = MotionEvent.obtain((MotionEvent)event);
                vtev.offsetLocation(0.0f, (float)windowOffsetY);
                VelocityTracker velocityTracker = this.velocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.addMovement(vtev);
                }
                float dx = vtev.getX() - this.lastTouchX;
                float dy = vtev.getY() - this.lastTouchY;
                if (!this.isHandling) {
                    boolean bl = this.isHandling = Math.abs(dy) > Math.abs(dx) && Math.abs(dy) >= (float)ViewConfiguration.get((Context)v.getContext()).getScaledTouchSlop();
                }
                if (!this.isHandling) break;
                if (this.simpleController.isInsetAnimationInProgress()) {
                    this.simpleController.insetBy(MathKt.roundToInt((float)dy));
                } else if (!this.simpleController.isInsetAnimationRequestPending()) {
                    WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)v);
                    boolean bl = windowInsetsCompat != null ? windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime()) : false;
                    if (this.shouldStartRequest(dy, bl)) {
                        SimpleImeAnimationController.startControlRequest$default(this.simpleController, v, null, 2, null);
                    }
                }
                this.lastTouchY = event.getY();
                this.lastTouchX = event.getX();
                this.lastWindowY = this.bounds.top;
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.velocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.addMovement(event);
                }
                VelocityTracker velocityTracker2 = this.velocityTracker;
                if (velocityTracker2 != null) {
                    velocityTracker2.computeCurrentVelocity(1000);
                }
                VelocityTracker velocityTracker3 = this.velocityTracker;
                Float velocityY = velocityTracker3 != null ? Float.valueOf(velocityTracker3.getYVelocity()) : null;
                this.simpleController.animateToFinish(velocityY);
                this.reset();
                break;
            }
            case 3: {
                this.simpleController.cancel();
                this.reset();
            }
        }
        return false;
    }

    private final void reset() {
        this.isHandling = false;
        this.lastTouchX = 0.0f;
        this.lastTouchY = 0.0f;
        this.lastWindowY = 0;
        this.bounds.setEmpty();
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
        }
        this.velocityTracker = null;
    }

    private final boolean shouldStartRequest(float dy, boolean imeVisible) {
        return dy < 0.0f ? !imeVisible && this.scrollImeOnScreenWhenNotVisible : (dy > 0.0f ? imeVisible && this.scrollImeOffScreenWhenVisible : false);
    }

    public InsetsAnimationTouchListener() {
        this(false, false, 3, null);
    }
}

