/*
 * Decompiled with CFR 0.152.
 */
package live.hms.hls_player;

import android.content.Context;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.Player;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionOverride;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.hls.HlsMediaSource;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.util.EventLogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.hls_player.HlsMetadataHandler;
import live.hms.hls_player.HmsHlsCue;
import live.hms.hls_player.HmsHlsException;
import live.hms.hls_player.HmsHlsLayer;
import live.hms.hls_player.HmsHlsPlaybackEvents;
import live.hms.hls_player.HmsHlsPlaybackState;
import live.hms.hls_player.HmsHlsPlayerInterface;
import live.hms.stats.PlayerEventsCollector;
import live.hms.stats.PlayerStatsListener;
import live.hms.video.media.settings.HMSVideoResolution;
import live.hms.video.sdk.HMSSDK;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010)\u001a\u00020(2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0006\u0010*\u001a\u00020+J\"\u0010,\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u000e2\b\b\u0002\u0010.\u001a\u00020+H\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u001bH\u0002J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020305H\u0016J\n\u00106\u001a\u0004\u0018\u00010\u0018H\u0016J\u0006\u00107\u001a\u00020\u001bJ\u000e\u00108\u001a\u00020(2\u0006\u00108\u001a\u00020+J\b\u00109\u001a\u00020(H\u0016J\u0010\u0010:\u001a\u00020(2\u0006\u0010-\u001a\u00020\u000eH\u0016J\b\u0010;\u001a\u00020(H\u0002J\b\u0010<\u001a\u00020(H\u0016J\u0018\u0010=\u001a\u00020(2\u0006\u0010 \u001a\u00020\b2\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020(2\u0006\u0010 \u001a\u00020\b2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010A\u001a\u00020(H\u0016J\u000e\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020\u0018J\u0012\u0010D\u001a\u00020(2\b\u0010E\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010F\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010G\u001a\u00020(2\u0006\u0010H\u001a\u000203H\u0016J\u0012\u0010I\u001a\u00020(2\b\u0010J\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010K\u001a\u00020(H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\"\u001a\u00020!2\b\b\u0001\u0010 \u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006L"}, d2={"Llive/hms/hls_player/HmsHlsPlayer;", "Llive/hms/hls_player/HmsHlsPlayerInterface;", "context", "Landroid/content/Context;", "hmssdk", "Llive/hms/video/sdk/HMSSDK;", "(Landroid/content/Context;Llive/hms/video/sdk/HMSSDK;)V", "MILLISECONDS_BEHIND_LIVE_IS_PAUSED", "", "getMILLISECONDS_BEHIND_LIVE_IS_PAUSED", "()J", "setMILLISECONDS_BEHIND_LIVE_IS_PAUSED", "(J)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "dataSourceFactory", "Landroidx/media3/datasource/DataSource$Factory;", "events", "Llive/hms/hls_player/HmsHlsPlaybackEvents;", "hlsMetadataHandler", "Llive/hms/hls_player/HlsMetadataHandler;", "hmsLastError", "Llive/hms/hls_player/HmsHlsException;", "playbackPosition", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "playerStatsCollector", "Llive/hms/stats/PlayerEventsCollector;", "playerStatsListener", "Llive/hms/stats/PlayerStatsListener;", "value", "", "volume", "getVolume", "()I", "setVolume", "(I)V", "addHlsMetadataListener", "", "addPlayerEventListener", "areClosedCaptionsSupported", "", "createPlayer", "url", "playWhenready", "createPlayerIfRequired", "gatherPlayerStatsForClients", "exoPlayer", "getCurrentHmsHlsLayer", "Llive/hms/hls_player/HmsHlsLayer;", "getHmsHlsLayers", "", "getLastError", "getNativePlayer", "mute", "pause", "play", "releasePlayer", "resume", "seekBackward", "unit", "Ljava/util/concurrent/TimeUnit;", "seekForward", "seekToLivePosition", "sendError", "hmsError", "setAnalytics", "analytics", "setEventsListeners", "setHmsHlsLayer", "layer", "setStatsMonitor", "statsListener", "stop", "hls-player_release"})
@SourceDebugExtension(value={"SMAP\nHmsHlsPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HmsHlsPlayer.kt\nlive/hms/hls_player/HmsHlsPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,381:1\n1#2:382\n1774#3,4:383\n*S KotlinDebug\n*F\n+ 1 HmsHlsPlayer.kt\nlive/hms/hls_player/HmsHlsPlayer\n*L\n372#1:383,4\n*E\n"})
public final class HmsHlsPlayer
implements HmsHlsPlayerInterface {
    @NotNull
    private final Context context;
    @Nullable
    private final HMSSDK hmssdk;
    private long MILLISECONDS_BEHIND_LIVE_IS_PAUSED;
    @Nullable
    private PlayerEventsCollector playerStatsCollector;
    @Nullable
    private PlayerStatsListener playerStatsListener;
    @Nullable
    private HlsMetadataHandler hlsMetadataHandler;
    @NotNull
    private final String TAG;
    @Nullable
    private HmsHlsException hmsLastError;
    @Nullable
    private HmsHlsPlaybackEvents events;
    @NotNull
    private final DataSource.Factory dataSourceFactory;
    private long playbackPosition;
    @Nullable
    private ExoPlayer player;

    public HmsHlsPlayer(@NotNull Context context, @Nullable HMSSDK hmssdk) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.hmssdk = hmssdk;
        this.MILLISECONDS_BEHIND_LIVE_IS_PAUSED = 10000L;
        this.TAG = "HMSHLSPLAYER";
        this.dataSourceFactory = (DataSource.Factory)new DefaultHttpDataSource.Factory();
    }

    public /* synthetic */ HmsHlsPlayer(Context context, HMSSDK hMSSDK, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            hMSSDK = null;
        }
        this(context, hMSSDK);
    }

    public final long getMILLISECONDS_BEHIND_LIVE_IS_PAUSED() {
        return this.MILLISECONDS_BEHIND_LIVE_IS_PAUSED;
    }

    public final void setMILLISECONDS_BEHIND_LIVE_IS_PAUSED(long l) {
        this.MILLISECONDS_BEHIND_LIVE_IS_PAUSED = l;
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final ExoPlayer getNativePlayer() {
        this.createPlayerIfRequired(this.context);
        ExoPlayer exoPlayer = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer);
        return exoPlayer;
    }

    @Override
    public void setAnalytics(@Nullable HMSSDK analytics) {
        PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
        if (playerEventsCollector != null) {
            playerEventsCollector.setHmsSdk(analytics);
        }
    }

    @Override
    public void setStatsMonitor(@Nullable PlayerStatsListener statsListener) {
        block1: {
            block0: {
                if (statsListener == null) break block0;
                this.playerStatsListener = statsListener;
                PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
                if (playerEventsCollector == null) break block1;
                playerEventsCollector.addStatsListener(statsListener);
                break block1;
            }
            PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
            if (playerEventsCollector == null) break block1;
            playerEventsCollector.removeStatsListener();
        }
    }

    @Override
    @Nullable
    public HmsHlsException getLastError() {
        return this.hmsLastError;
    }

    @Override
    public void addPlayerEventListener(@Nullable HmsHlsPlaybackEvents events) {
        this.events = events;
    }

    /*
     * WARNING - void declaration
     */
    private final void createPlayerIfRequired(Context context) {
        Log.d((String)this.TAG, (String)("Is going to create player? " + (this.player == null)));
        if (this.player == null) {
            void $this$createPlayerIfRequired_u24lambda_u240;
            ExoPlayer exoPlayer;
            ExoPlayer exoPlayer2 = exoPlayer = new ExoPlayer.Builder(context).build();
            HmsHlsPlayer hmsHlsPlayer = this;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$createPlayerIfRequired_u24lambda_u240, (String)"this");
            this.setEventsListeners((ExoPlayer)$this$createPlayerIfRequired_u24lambda_u240);
            this.gatherPlayerStatsForClients((ExoPlayer)$this$createPlayerIfRequired_u24lambda_u240);
            hmsHlsPlayer.player = exoPlayer;
        }
    }

    private final void gatherPlayerStatsForClients(ExoPlayer exoPlayer) {
        block2: {
            PlayerEventsCollector playerEventsCollector = this.playerStatsCollector = new PlayerEventsCollector(this.hmssdk, null, 2, null);
            if (playerEventsCollector != null) {
                playerEventsCollector.setExoPlayer(exoPlayer);
            }
            PlayerStatsListener reporterNullChecked = this.playerStatsListener;
            if (reporterNullChecked == null) break block2;
            PlayerEventsCollector playerEventsCollector2 = this.playerStatsCollector;
            if (playerEventsCollector2 != null) {
                playerEventsCollector2.addStatsListener(reporterNullChecked);
            }
        }
    }

    private final void setEventsListeners(ExoPlayer player) {
        player.addListener(new Player.Listener(this){
            final /* synthetic */ HmsHlsPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPlaybackStateChanged(int playbackState) {
                super.onPlaybackStateChanged(playbackState);
                switch (playbackState) {
                    case 2: {
                        HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                        if (hmsHlsPlaybackEvents != null) {
                            hmsHlsPlaybackEvents.onPlaybackStateChanged(HmsHlsPlaybackState.buffering);
                        }
                        break;
                    }
                    case 4: {
                        HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                        if (hmsHlsPlaybackEvents == null) break;
                        hmsHlsPlaybackEvents.onPlaybackStateChanged(HmsHlsPlaybackState.stopped);
                        break;
                    }
                }
            }

            public void onIsPlayingChanged(boolean isPlaying) {
                block1: {
                    super.onIsPlayingChanged(isPlaying);
                    if (!isPlaying) break block1;
                    HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                    if (hmsHlsPlaybackEvents != null) {
                        hmsHlsPlaybackEvents.onPlaybackStateChanged(HmsHlsPlaybackState.playing);
                    }
                }
            }

            public void onPlayerError(@NotNull PlaybackException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super.onPlayerError(error);
                if (error.errorCode != 1002) {
                    HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                    if (hmsHlsPlaybackEvents != null) {
                        hmsHlsPlaybackEvents.onPlaybackStateChanged(HmsHlsPlaybackState.failed);
                    }
                    this.this$0.sendError(new HmsHlsException(error));
                }
            }
        });
    }

    @Override
    public void pause() {
        block0: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.pause();
        }
    }

    @Override
    public void resume() {
        block0: {
            Log.d((String)this.TAG, (String)"Resuming");
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.play();
        }
    }

    @Override
    public int getVolume() {
        int n;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            ExoPlayer it = exoPlayer;
            boolean bl = false;
            n = (int)(it.getVolume() * (float)10);
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public void setVolume(@IntRange(from=0L, to=10L) int value) {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.setVolume((float)value / 10.0f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<HmsHlsLayer> getHmsHlsLayers() {
        Object object;
        ImmutableList immutableList;
        Tracks tracks;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null && (tracks = exoPlayer.getCurrentTracks()) != null && (immutableList = tracks.getGroups()) != null) {
            Object v0;
            Object object2;
            block6: {
                Iterable iterable = (Iterable)immutableList;
                object2 = iterable.iterator();
                while (object2.hasNext()) {
                    Object t = object2.next();
                    Tracks.Group it = (Tracks.Group)t;
                    boolean bl = false;
                    if (!(it.getType() == 2)) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            Tracks.Group group = v0;
            if (group != null) {
                Tracks.Group trackGroupInfo = group;
                boolean bl = false;
                List layers = new ArrayList();
                int index = 0;
                int n = trackGroupInfo.getMediaTrackGroup().length;
                while (true) {
                    if (index >= n) {
                        Object $this$getHmsHlsLayers_u24lambda_u244 = object2 = layers;
                        boolean bl2 = false;
                        $this$getHmsHlsLayers_u24lambda_u244.add(HmsHlsLayer.AUTO.INSTANCE);
                        object = object2;
                        return object;
                    }
                    if (trackGroupInfo.getType() == 2) {
                        Format format;
                        Intrinsics.checkNotNullExpressionValue((Object)trackGroupInfo.getTrackFormat(index), (String)"trackGroupInfo.getTrackFormat(index)");
                        HMSVideoResolution hMSVideoResolution = new HMSVideoResolution(format.width, format.height);
                        int n2 = format.bitrate;
                        TrackGroup trackGroup = trackGroupInfo.getMediaTrackGroup();
                        Intrinsics.checkNotNullExpressionValue((Object)trackGroup, (String)"trackGroupInfo.mediaTrackGroup");
                        layers.add(new HmsHlsLayer.LayerInfo(hMSVideoResolution, n2, trackGroup, index));
                    }
                    ++index;
                }
            }
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setHmsHlsLayer(@NotNull HmsHlsLayer layer) {
        TrackSelectionParameters trackSelectionParameters;
        TrackSelectionParameters.Builder builder;
        TrackSelectionParameters.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        HmsHlsLayer hmsHlsLayer = layer;
        if (hmsHlsLayer instanceof HmsHlsLayer.AUTO) {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) return;
            TrackSelectionParameters trackSelectionParameters2 = exoPlayer.getTrackSelectionParameters();
            if (trackSelectionParameters2 == null) return;
            builder2 = trackSelectionParameters2.buildUpon();
            if (builder2 == null) return;
            builder = builder2.clearOverrides();
            if (builder == null) return;
            trackSelectionParameters = builder.build();
        } else {
            TrackSelectionParameters params;
            Object v5;
            ExoPlayer exoPlayer;
            block3: {
                if (!(hmsHlsLayer instanceof HmsHlsLayer.LayerInfo)) throw new NoWhenBranchMatchedException();
                ExoPlayer exoPlayer2 = this.player;
                exoPlayer = exoPlayer2;
                if (exoPlayer2 == null) return;
                Tracks tracks = exoPlayer.getCurrentTracks();
                exoPlayer = tracks;
                if (tracks == null) return;
                ImmutableList immutableList = exoPlayer.getGroups();
                exoPlayer = immutableList;
                if (immutableList == null) return;
                Iterable iterable = (Iterable)exoPlayer;
                for (Object t : iterable) {
                    Tracks.Group it = (Tracks.Group)t;
                    boolean bl = false;
                    if (!(it.getType() == 2)) continue;
                    v5 = t;
                    break block3;
                }
                v5 = null;
            }
            Tracks.Group group = v5;
            exoPlayer = group;
            if (group == null) return;
            TrackGroup trackGroup = exoPlayer.getMediaTrackGroup();
            TrackGroup trackGroupInfo = trackGroup;
            if (trackGroupInfo == null) return;
            builder2 = this.player;
            if (builder2 == null) return;
            builder = builder2.getTrackSelectionParameters();
            if (builder == null) return;
            TrackSelectionParameters.Builder builder3 = builder.buildUpon();
            if (builder3 == null) return;
            TrackSelectionParameters.Builder builder4 = builder3.addOverride(new TrackSelectionOverride(trackGroupInfo, ((HmsHlsLayer.LayerInfo)layer).getIndex$hls_player_release()));
            if (builder4 == null) return;
            TrackSelectionParameters trackSelectionParameters3 = builder4.build();
            trackSelectionParameters = params = trackSelectionParameters3;
        }
        TrackSelectionParameters params = trackSelectionParameters;
        if (params == null) return;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer == null) return;
        exoPlayer.setTrackSelectionParameters(params);
    }

    @Override
    @Nullable
    public HmsHlsLayer getCurrentHmsHlsLayer() {
        Tracks.Group trackGroupInfo;
        Tracks.Group group;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null && (exoPlayer = exoPlayer.getCurrentTracks()) != null && (exoPlayer = exoPlayer.getGroups()) != null) {
            Object v1;
            block6: {
                Iterable iterable = (Iterable)exoPlayer;
                for (Object t : iterable) {
                    Tracks.Group it = (Tracks.Group)t;
                    boolean bl = false;
                    if (!(it.getType() == 2)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            group = v1;
        } else {
            group = trackGroupInfo = null;
        }
        if (trackGroupInfo != null) {
            HmsHlsLayer hmsHlsLayer;
            Integer selectedIndex;
            ImmutableMap immutableMap;
            TrackSelectionParameters trackSelectionParameters;
            ExoPlayer exoPlayer2 = this.player;
            Object selected = exoPlayer2 != null && (trackSelectionParameters = exoPlayer2.getTrackSelectionParameters()) != null && (immutableMap = trackSelectionParameters.overrides) != null ? (TrackSelectionOverride)immutableMap.getOrDefault((Object)trackGroupInfo.getMediaTrackGroup(), null) : null;
            ImmutableList immutableList = selected;
            Integer n = immutableList != null && (immutableList = immutableList.trackIndices) != null ? (Integer)CollectionsKt.getOrNull((List)((List)immutableList), (int)0) : (selectedIndex = null);
            if (selectedIndex != null && selectedIndex < selected.mediaTrackGroup.length) {
                Format format = selected.mediaTrackGroup.getFormat(selectedIndex.intValue());
                Intrinsics.checkNotNullExpressionValue((Object)format, (String)"selected.mediaTrackGroup.getFormat(selectedIndex)");
                Format selectedFormat = format;
                HMSVideoResolution hMSVideoResolution = new HMSVideoResolution(selectedFormat.width, selectedFormat.height);
                int n2 = selectedFormat.bitrate;
                TrackGroup trackGroup = trackGroupInfo.getMediaTrackGroup();
                Intrinsics.checkNotNullExpressionValue((Object)trackGroup, (String)"trackGroupInfo.mediaTrackGroup");
                hmsHlsLayer = new HmsHlsLayer.LayerInfo(hMSVideoResolution, n2, trackGroup, trackGroupInfo.getMediaTrackGroup().indexOf(selectedFormat));
            } else {
                hmsHlsLayer = HmsHlsLayer.AUTO.INSTANCE;
            }
            return hmsHlsLayer;
        }
        return null;
    }

    @Override
    public void seekForward(long value, @NotNull TimeUnit unit) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            ExoPlayer $this$seekForward_u24lambda_u247 = this.player;
            boolean bl = false;
            ExoPlayer exoPlayer = $this$seekForward_u24lambda_u247;
            if (exoPlayer == null) break block0;
            exoPlayer.seekTo($this$seekForward_u24lambda_u247.getCurrentPosition() + unit.toMillis(value));
        }
    }

    @Override
    public void seekBackward(long value, @NotNull TimeUnit unit) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            ExoPlayer $this$seekBackward_u24lambda_u248 = this.player;
            boolean bl = false;
            ExoPlayer exoPlayer = $this$seekBackward_u24lambda_u248;
            if (exoPlayer == null) break block0;
            exoPlayer.seekTo($this$seekBackward_u24lambda_u248.getCurrentPosition() - unit.toMillis(value));
        }
    }

    @Override
    public void seekToLivePosition() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.seekToDefaultPosition();
        }
        this.resume();
    }

    @Override
    public void play(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.createPlayer(this.context, url, true).play();
    }

    @Override
    public void stop() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.stop();
        }
        this.releasePlayer();
    }

    private final ExoPlayer createPlayer(Context context, String url, boolean playWhenready) {
        HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory(this.dataSourceFactory).setAllowChunklessPreparation(true).createMediaSource(MediaItem.fromUri((String)url));
        Intrinsics.checkNotNullExpressionValue((Object)hlsMediaSource, (String)"Factory(dataSourceFactor\u2026e(MediaItem.fromUri(url))");
        HlsMediaSource hlsMediaSource2 = hlsMediaSource;
        this.createPlayerIfRequired(context);
        ExoPlayer exoPlayer = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer);
        ExoPlayer $this$createPlayer_u24lambda_u249 = exoPlayer;
        boolean bl = false;
        PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
        if (playerEventsCollector != null) {
            playerEventsCollector.setExoPlayer($this$createPlayer_u24lambda_u249);
        }
        $this$createPlayer_u24lambda_u249.setMediaSource((MediaSource)hlsMediaSource2);
        $this$createPlayer_u24lambda_u249.setPlayWhenReady(playWhenready);
        $this$createPlayer_u24lambda_u249.prepare();
        $this$createPlayer_u24lambda_u249.addAnalyticsListener((AnalyticsListener)new EventLogger(null));
        this.addHlsMetadataListener($this$createPlayer_u24lambda_u249);
        ExoPlayer exoPlayer2 = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer2);
        return exoPlayer2;
    }

    static /* synthetic */ ExoPlayer createPlayer$default(HmsHlsPlayer hmsHlsPlayer, Context context, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return hmsHlsPlayer.createPlayer(context, string, bl);
    }

    private final void addHlsMetadataListener(ExoPlayer player) {
        block0: {
            HlsMetadataHandler hlsMetadataHandler = this.hlsMetadataHandler = new HlsMetadataHandler(player, (Function1<? super HmsHlsCue, Unit>)((Function1)new Function1<HmsHlsCue, Unit>(this){
                final /* synthetic */ HmsHlsPlayer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull HmsHlsCue localMetaDataModel) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)localMetaDataModel, (String)"localMetaDataModel");
                        Log.d((String)this.this$0.getTAG(), (String)String.valueOf(localMetaDataModel));
                        HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                        if (hmsHlsPlaybackEvents == null) break block0;
                        hmsHlsPlaybackEvents.onCue(localMetaDataModel);
                    }
                }
            }));
            if (hlsMetadataHandler == null) break block0;
            hlsMetadataHandler.start();
        }
    }

    private final void releasePlayer() {
        Log.d((String)this.TAG, (String)"Stopping");
        PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
        if (playerEventsCollector != null) {
            playerEventsCollector.removeListener();
        }
        this.playerStatsCollector = null;
        this.playerStatsListener = null;
        HlsMetadataHandler hlsMetadataHandler = this.hlsMetadataHandler;
        if (hlsMetadataHandler != null) {
            hlsMetadataHandler.stop();
        }
        this.hlsMetadataHandler = null;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            ExoPlayer $this$releasePlayer_u24lambda_u2410 = exoPlayer;
            boolean bl = false;
            $this$releasePlayer_u24lambda_u2410.setPlayWhenReady($this$releasePlayer_u24lambda_u2410.getPlayWhenReady());
            $this$releasePlayer_u24lambda_u2410.release();
        }
        this.player = null;
    }

    public final void mute(boolean mute) {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.setDeviceMuted(mute);
        }
    }

    public final void sendError(@NotNull HmsHlsException hmsError) {
        Intrinsics.checkNotNullParameter((Object)hmsError, (String)"hmsError");
        HmsHlsPlaybackEvents hmsHlsPlaybackEvents = this.events;
        if (hmsHlsPlaybackEvents != null) {
            hmsHlsPlaybackEvents.onPlaybackFailure(hmsError);
        }
        this.hmsLastError = hmsError;
    }

    public final boolean areClosedCaptionsSupported() {
        Integer n;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null && (exoPlayer = exoPlayer.getCurrentTracks()) != null && (exoPlayer = exoPlayer.getGroups()) != null) {
            int n2;
            Iterable $this$count$iv = (Iterable)exoPlayer;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Tracks.Group it = (Tracks.Group)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == 3 && !Intrinsics.areEqual((Object)it.getMediaTrackGroup().id, (Object)"main:muxed:2")) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            n = n2;
        } else {
            n = null;
        }
        Integer numSubtitleTracks = n;
        return numSubtitleTracks != null && numSubtitleTracks > 0;
    }

    public static final /* synthetic */ HmsHlsPlaybackEvents access$getEvents$p(HmsHlsPlayer $this) {
        return $this.events;
    }
}

