/*
 * Decompiled with CFR 0.152.
 */
package live.hms.hls_player;

import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import androidx.media3.common.Timeline;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.hls.HlsManifest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import live.hms.hls_player.HmsHlsCue;
import live.hms.hls_player.MetadataMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\"\u001a\u00020\u0007H\u0002J\u0006\u0010#\u001a\u00020\u0007J\u0006\u0010$\u001a\u00020\u0007R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Llive/hms/hls_player/HlsMetadataHandler;", "", "exoPlayer", "Landroidx/media3/exoplayer/ExoPlayer;", "listener", "Lkotlin/Function1;", "Llive/hms/hls_player/HmsHlsCue;", "", "(Landroidx/media3/exoplayer/ExoPlayer;Lkotlin/jvm/functions/Function1;)V", "eventRunnable", "Ljava/lang/Runnable;", "existingCues", "", "getExoPlayer", "()Landroidx/media3/exoplayer/ExoPlayer;", "formatter", "Ljava/text/SimpleDateFormat;", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "setHandler", "(Landroid/os/Handler;)V", "knownTags", "", "", "getListener", "()Lkotlin/jvm/functions/Function1;", "metadataMatcher", "Llive/hms/hls_player/MetadataMatcher;", "getCueFromTag", "tag", "getCurrentAbsoluteTime", "", "handle", "start", "stop", "Companion", "hls-player_release"})
@SourceDebugExtension(value={"SMAP\nHlsMetadataHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HlsMetadataHandler.kt\nlive/hms/hls_player/HlsMetadataHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1#2:138\n766#3:139\n857#3,2:140\n1855#3,2:142\n766#3:144\n857#3,2:145\n1855#3,2:147\n*S KotlinDebug\n*F\n+ 1 HlsMetadataHandler.kt\nlive/hms/hls_player/HlsMetadataHandler\n*L\n66#1:139\n66#1:140,2\n68#1:142,2\n79#1:144\n79#1:145,2\n86#1:147,2\n*E\n"})
public final class HlsMetadataHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExoPlayer exoPlayer;
    @NotNull
    private final Function1<HmsHlsCue, Unit> listener;
    @NotNull
    private final SimpleDateFormat formatter;
    @Nullable
    private Handler handler;
    @Nullable
    private Runnable eventRunnable;
    @NotNull
    private final List<HmsHlsCue> existingCues;
    @NotNull
    private final MetadataMatcher metadataMatcher;
    @NotNull
    private Set<String> knownTags;
    @NotNull
    public static final String TAG = "HlsMetadataTAG";

    public HlsMetadataHandler(@NotNull ExoPlayer exoPlayer, @NotNull Function1<? super HmsHlsCue, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)exoPlayer, (String)"exoPlayer");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.exoPlayer = exoPlayer;
        this.listener = listener;
        this.formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.existingCues = new ArrayList();
        this.metadataMatcher = new MetadataMatcher();
        this.knownTags = new LinkedHashSet();
    }

    @NotNull
    public final ExoPlayer getExoPlayer() {
        return this.exoPlayer;
    }

    @NotNull
    public final Function1<HmsHlsCue, Unit> getListener() {
        return this.listener;
    }

    @Nullable
    public final Handler getHandler() {
        return this.handler;
    }

    public final void setHandler(@Nullable Handler handler) {
        this.handler = handler;
    }

    public final void start() {
        block1: {
            this.eventRunnable = () -> HlsMetadataHandler.start$lambda$1(this);
            this.handler = new Handler(Looper.getMainLooper());
            Runnable runnable = this.eventRunnable;
            if (runnable == null) break block1;
            Runnable it = runnable;
            boolean bl = false;
            Handler handler = this.handler;
            if (handler != null) {
                handler.post(it);
            }
        }
    }

    public final void stop() {
        Runnable runnable = this.eventRunnable;
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            Handler handler = this.handler;
            if (handler != null) {
                handler.removeCallbacks(it);
            }
        }
        this.eventRunnable = null;
        this.handler = null;
    }

    private final long getCurrentAbsoluteTime(ExoPlayer exoPlayer) {
        int windowIndex = exoPlayer.getCurrentMediaItemIndex();
        Timeline timeline = exoPlayer.getCurrentTimeline();
        Intrinsics.checkNotNullExpressionValue((Object)timeline, (String)"exoPlayer.currentTimeline");
        Timeline timeline2 = timeline;
        Timeline.Window window = timeline2.getWindow(windowIndex, new Timeline.Window());
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"timeline.getWindow(windowIndex, Timeline.Window())");
        Timeline.Window window2 = window;
        return window2.windowStartTimeMs + exoPlayer.getCurrentPosition();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void handle() {
        block10: {
            block9: {
                hlsManifest = (HlsManifest)this.exoPlayer.getCurrentManifest();
                currentAbsolutePosition = this.getCurrentAbsoluteTime(this.exoPlayer);
                v0 /* !! */  = hlsManifest;
                if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .mediaPlaylist) == null || (v0 /* !! */  = v0 /* !! */ .tags) == null) break block9;
                $this$filter$iv = (Iterable)v0 /* !! */ ;
                $i$f$filter = false;
                var9_10 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-filter-HlsMetadataHandler$handle$allTags$1 = false;
                    if (this.knownTags.contains(it)) ** GOTO lbl-1000
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (StringsKt.contains$default((CharSequence)it, (CharSequence)"X-100MSLIVE-PAYLOAD", (boolean)false, (int)2, null)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v2 = (List)destination$iv$iv;
                break block10;
            }
            v2 = null;
        }
        v3 = allTags = v2;
        if (v3 != null) {
            $this$forEach$iv = v3;
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                $i$a$-forEach-HlsMetadataHandler$handle$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.knownTags.add(it);
                cue = this.getCueFromTag(it);
                if (cue == null) continue;
                this.existingCues.add(cue);
            }
        }
        $this$filter$iv = this.existingCues;
        $i$f$filter = false;
        element$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            tag = (HmsHlsCue)element$iv$iv;
            $i$a$-filter-HlsMetadataHandler$handle$cuesToShow$1 = false;
            tagStartTime = tag.getStartDate().getTime();
            if (!(tagStartTime <= currentAbsolutePosition && (tag.getEndDate() == null || currentAbsolutePosition <= tag.getEndDate().getTime()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        cuesToShow = (List)destination$iv$iv;
        this.existingCues.removeAll(cuesToShow);
        $this$filter$iv = cuesToShow;
        action$iv = this.listener;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            action$iv.invoke(element$iv);
        }
        if (this.knownTags.size() > 50) {
            v4 /* !! */  = hlsManifest;
            currentExistingTags = v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .mediaPlaylist) != null && (v4 /* !! */  = v4 /* !! */ .tags) != null ? CollectionsKt.toSet((Iterable)((Iterable)v4 /* !! */ )) : null;
            v5 = currentExistingTags;
            v6 = v5 != null && (v5 = CollectionsKt.intersect((Iterable)v5, (Iterable)this.knownTags)) != null ? CollectionsKt.toMutableSet((Iterable)v5) : (trimmedTags = null);
            if (trimmedTags != null) {
                this.knownTags = trimmedTags;
            }
        }
    }

    private final HmsHlsCue getCueFromTag(String tag) {
        Pattern pattern;
        Matcher matcher;
        if (tag == null) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)tag, (CharSequence)"EXT-X-DATERANGE", (boolean)false, (int)2, null) && (matcher = (pattern = this.metadataMatcher.getPattern()).matcher(tag)).matches()) {
            try {
                String string = matcher.group(1);
                if (string == null) {
                    string = "";
                }
                byte[] byArray = Base64.decode((String)string, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(matcher.group(1).orEmpty(),Base64.DEFAULT)");
                byte[] byArray2 = byArray;
                String payloadJson = new String(byArray2, Charsets.UTF_8);
                JSONObject data = new JSONObject(payloadJson);
                String payload = data.getString("payload");
                String startDate = data.getString("start_date");
                String endDate = data.getString("end_date");
                Date tagStartTime = this.formatter.parse(startDate);
                Date tagEndTime = this.formatter.parse(endDate);
                if (tagStartTime == null) {
                    return null;
                }
                HmsHlsCue currentCue = new HmsHlsCue(tagStartTime, tagEndTime, payload, null, 8, null);
                return currentCue;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return null;
    }

    private static final void start$lambda$1(HlsMetadataHandler this$0) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.handle();
            Runnable runnable = this$0.eventRunnable;
            if (runnable == null) break block1;
            Runnable it = runnable;
            boolean bl = false;
            Handler handler = this$0.handler;
            if (handler != null) {
                handler.postDelayed(it, 500L);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/hls_player/HlsMetadataHandler$Companion;", "", "()V", "TAG", "", "hls-player_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

