/*
 * Decompiled with CFR 0.152.
 */
package live.hms.hls_player;

import android.content.Context;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.Player;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionOverride;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.hls.HlsMediaSource;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.util.EventLogger;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.hls_player.HlsMetadataHandler;
import live.hms.hls_player.HmsHlsCue;
import live.hms.hls_player.HmsHlsException;
import live.hms.hls_player.HmsHlsLayer;
import live.hms.hls_player.HmsHlsPlaybackEvents;
import live.hms.hls_player.HmsHlsPlaybackState;
import live.hms.hls_player.HmsHlsPlayerInterface;
import live.hms.stats.PlayerEventsCollector;
import live.hms.stats.PlayerStatsListener;
import live.hms.video.media.settings.HMSVideoResolution;
import live.hms.video.sdk.HMSSDK;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010)\u001a\u00020(2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\"\u0010*\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u000e2\b\b\u0002\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u001bH\u0002J\n\u00101\u001a\u0004\u0018\u000102H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020204H\u0016J\n\u00105\u001a\u0004\u0018\u00010\u0018H\u0016J\u0006\u00106\u001a\u00020\u001bJ\u000e\u00107\u001a\u00020(2\u0006\u00107\u001a\u00020-J\b\u00108\u001a\u00020(H\u0016J\u0010\u00109\u001a\u00020(2\u0006\u0010+\u001a\u00020\u000eH\u0016J\b\u0010:\u001a\u00020(H\u0002J\b\u0010;\u001a\u00020(H\u0016J\u0018\u0010<\u001a\u00020(2\u0006\u0010 \u001a\u00020\b2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010?\u001a\u00020(2\u0006\u0010 \u001a\u00020\b2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010@\u001a\u00020(H\u0016J\u000e\u0010A\u001a\u00020(2\u0006\u0010B\u001a\u00020\u0018J\u0012\u0010C\u001a\u00020(2\b\u0010D\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010E\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010F\u001a\u00020(2\u0006\u0010G\u001a\u000202H\u0016J\u0012\u0010H\u001a\u00020(2\b\u0010I\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010J\u001a\u00020(H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\"\u001a\u00020!2\b\b\u0001\u0010 \u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006K"}, d2={"Llive/hms/hls_player/HmsHlsPlayer;", "Llive/hms/hls_player/HmsHlsPlayerInterface;", "context", "Landroid/content/Context;", "hmssdk", "Llive/hms/video/sdk/HMSSDK;", "(Landroid/content/Context;Llive/hms/video/sdk/HMSSDK;)V", "MILLISECONDS_BEHIND_LIVE_IS_PAUSED", "", "getMILLISECONDS_BEHIND_LIVE_IS_PAUSED", "()J", "setMILLISECONDS_BEHIND_LIVE_IS_PAUSED", "(J)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "dataSourceFactory", "Landroidx/media3/datasource/DataSource$Factory;", "events", "Llive/hms/hls_player/HmsHlsPlaybackEvents;", "hlsMetadataHandler", "Llive/hms/hls_player/HlsMetadataHandler;", "hmsLastError", "Llive/hms/hls_player/HmsHlsException;", "playbackPosition", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "playerStatsCollector", "Llive/hms/stats/PlayerEventsCollector;", "playerStatsListener", "Llive/hms/stats/PlayerStatsListener;", "value", "", "volume", "getVolume", "()I", "setVolume", "(I)V", "addHlsMetadataListener", "", "addPlayerEventListener", "createPlayer", "url", "playWhenready", "", "createPlayerIfRequired", "gatherPlayerStatsForClients", "exoPlayer", "getCurrentHmsHlsLayer", "Llive/hms/hls_player/HmsHlsLayer;", "getHmsHlsLayers", "", "getLastError", "getNativePlayer", "mute", "pause", "play", "releasePlayer", "resume", "seekBackward", "unit", "Ljava/util/concurrent/TimeUnit;", "seekForward", "seekToLivePosition", "sendError", "hmsError", "setAnalytics", "analytics", "setEventsListeners", "setHmsHlsLayer", "layer", "setStatsMonitor", "statsListener", "stop", "hls-player_release"})
public final class HmsHlsPlayer
implements HmsHlsPlayerInterface {
    @NotNull
    private final Context context;
    @Nullable
    private final HMSSDK hmssdk;
    private long MILLISECONDS_BEHIND_LIVE_IS_PAUSED;
    @Nullable
    private PlayerEventsCollector playerStatsCollector;
    @Nullable
    private PlayerStatsListener playerStatsListener;
    @Nullable
    private HlsMetadataHandler hlsMetadataHandler;
    @NotNull
    private final String TAG;
    @Nullable
    private HmsHlsException hmsLastError;
    @Nullable
    private HmsHlsPlaybackEvents events;
    @NotNull
    private final DataSource.Factory dataSourceFactory;
    private long playbackPosition;
    @Nullable
    private ExoPlayer player;

    public HmsHlsPlayer(@NotNull Context context, @Nullable HMSSDK hmssdk) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.hmssdk = hmssdk;
        this.MILLISECONDS_BEHIND_LIVE_IS_PAUSED = 10000L;
        this.TAG = "HMSHLSPLAYER";
        this.dataSourceFactory = (DataSource.Factory)new DefaultHttpDataSource.Factory();
    }

    public /* synthetic */ HmsHlsPlayer(Context context, HMSSDK hMSSDK, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            hMSSDK = null;
        }
        this(context, hMSSDK);
    }

    public final long getMILLISECONDS_BEHIND_LIVE_IS_PAUSED() {
        return this.MILLISECONDS_BEHIND_LIVE_IS_PAUSED;
    }

    public final void setMILLISECONDS_BEHIND_LIVE_IS_PAUSED(long l) {
        this.MILLISECONDS_BEHIND_LIVE_IS_PAUSED = l;
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final ExoPlayer getNativePlayer() {
        this.createPlayerIfRequired(this.context);
        ExoPlayer exoPlayer = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer);
        return exoPlayer;
    }

    @Override
    public void setAnalytics(@Nullable HMSSDK analytics) {
        PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
        if (playerEventsCollector != null) {
            playerEventsCollector.setHmsSdk(analytics);
        }
    }

    @Override
    public void setStatsMonitor(@Nullable PlayerStatsListener statsListener) {
        if (statsListener != null) {
            this.playerStatsListener = statsListener;
            PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
            if (playerEventsCollector != null) {
                playerEventsCollector.addStatsListener(statsListener);
            }
        } else {
            PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
            if (playerEventsCollector != null) {
                playerEventsCollector.removeStatsListener();
            }
        }
    }

    @Override
    @Nullable
    public HmsHlsException getLastError() {
        return this.hmsLastError;
    }

    @Override
    public void addPlayerEventListener(@Nullable HmsHlsPlaybackEvents events) {
        this.events = events;
    }

    /*
     * WARNING - void declaration
     */
    private final void createPlayerIfRequired(Context context) {
        Log.d((String)this.TAG, (String)Intrinsics.stringPlus((String)"Is going to create player? ", (Object)(this.player == null ? 1 : 0)));
        if (this.player == null) {
            void $this$createPlayerIfRequired_u24lambda_u2d0;
            ExoPlayer exoPlayer;
            ExoPlayer exoPlayer2 = exoPlayer = new ExoPlayer.Builder(context).build();
            HmsHlsPlayer hmsHlsPlayer = this;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$createPlayerIfRequired_u24lambda_u2d0, (String)"this");
            this.setEventsListeners((ExoPlayer)$this$createPlayerIfRequired_u24lambda_u2d0);
            this.gatherPlayerStatsForClients((ExoPlayer)$this$createPlayerIfRequired_u24lambda_u2d0);
            Unit unit = Unit.INSTANCE;
            hmsHlsPlayer.player = exoPlayer;
        }
    }

    private final void gatherPlayerStatsForClients(ExoPlayer exoPlayer) {
        PlayerEventsCollector playerEventsCollector;
        this.playerStatsCollector = new PlayerEventsCollector(this.hmssdk, null, 2, null);
        PlayerEventsCollector playerEventsCollector2 = this.playerStatsCollector;
        if (playerEventsCollector2 != null) {
            playerEventsCollector2.setExoPlayer(exoPlayer);
        }
        PlayerStatsListener reporterNullChecked = this.playerStatsListener;
        if (reporterNullChecked != null && (playerEventsCollector = this.playerStatsCollector) != null) {
            playerEventsCollector.addStatsListener(reporterNullChecked);
        }
    }

    private final void setEventsListeners(ExoPlayer player) {
        player.addListener(new Player.Listener(this){
            final /* synthetic */ HmsHlsPlayer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPlaybackStateChanged(int playbackState) {
                super.onPlaybackStateChanged(playbackState);
                int n = playbackState;
                switch (n) {
                    case 2: {
                        HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                        if (hmsHlsPlaybackEvents == null) break;
                        hmsHlsPlaybackEvents.onPlaybackStateChanged(HmsHlsPlaybackState.buffering);
                        break;
                    }
                    case 4: {
                        HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                        if (hmsHlsPlaybackEvents == null) break;
                        hmsHlsPlaybackEvents.onPlaybackStateChanged(HmsHlsPlaybackState.stopped);
                    }
                }
            }

            public void onIsPlayingChanged(boolean isPlaying) {
                HmsHlsPlaybackEvents hmsHlsPlaybackEvents;
                super.onIsPlayingChanged(isPlaying);
                if (isPlaying && (hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0)) != null) {
                    hmsHlsPlaybackEvents.onPlaybackStateChanged(HmsHlsPlaybackState.playing);
                }
            }

            public void onPlayerError(@NotNull PlaybackException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super.onPlayerError(error);
                if (error.errorCode != 1002) {
                    HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                    if (hmsHlsPlaybackEvents != null) {
                        hmsHlsPlaybackEvents.onPlaybackStateChanged(HmsHlsPlaybackState.failed);
                    }
                    this.this$0.sendError(new HmsHlsException(error));
                }
            }
        });
    }

    @Override
    public void pause() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.pause();
        }
    }

    @Override
    public void resume() {
        Log.d((String)this.TAG, (String)"Resuming");
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.play();
        }
    }

    @Override
    public int getVolume() {
        int n;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer == null) {
            n = 0;
        } else {
            int n2;
            ExoPlayer exoPlayer2;
            ExoPlayer it = exoPlayer2 = exoPlayer;
            boolean bl = false;
            n = n2 = (int)(it.getVolume() * (float)10);
        }
        return n;
    }

    @Override
    public void setVolume(@IntRange(from=0L, to=10L) int value) {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.setVolume((float)value / 10.0f);
        }
    }

    @Override
    @NotNull
    public List<HmsHlsLayer> getHmsHlsLayers() {
        Iterable iterable;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer == null) {
            iterable = null;
        } else {
            Tracks tracks = exoPlayer.getCurrentTracks();
            if (tracks == null) {
                iterable = null;
            } else {
                ImmutableList immutableList = tracks.getGroups();
                if (immutableList == null) {
                    iterable = null;
                } else {
                    Object v1;
                    Iterable iterable2;
                    Iterable iterable3;
                    block11: {
                        iterable2 = iterable3 = (Iterable)immutableList;
                        boolean bl = false;
                        for (Object t : iterable2) {
                            Tracks.Group it = (Tracks.Group)t;
                            boolean bl2 = false;
                            if (!(it.getType() == 2)) continue;
                            v1 = t;
                            break block11;
                        }
                        v1 = null;
                    }
                    Tracks.Group group = v1;
                    if (group == null) {
                        iterable = null;
                    } else {
                        Iterable trackGroupInfo = iterable2 = group;
                        boolean bl = false;
                        List layers = new ArrayList();
                        int n = 0;
                        int n2 = trackGroupInfo.getMediaTrackGroup().length;
                        if (n < n2) {
                            do {
                                int index = n++;
                                if (trackGroupInfo.getType() != 2) continue;
                                Format format = trackGroupInfo.getTrackFormat(index);
                                Intrinsics.checkNotNullExpressionValue((Object)format, (String)"trackGroupInfo.getTrackFormat(index)");
                                Format format2 = format;
                                HMSVideoResolution hMSVideoResolution = new HMSVideoResolution(format2.width, format2.height);
                                int n3 = format2.bitrate;
                                format = trackGroupInfo.getMediaTrackGroup();
                                Intrinsics.checkNotNullExpressionValue((Object)format, (String)"trackGroupInfo.mediaTrackGroup");
                                layers.add(new HmsHlsLayer.LayerInfo(hMSVideoResolution, n3, (TrackGroup)format, index));
                            } while (n < n2);
                        }
                        Iterable $this$getHmsHlsLayers_u24lambda_u2d4 = iterable2 = (iterable3 = layers);
                        boolean bl3 = false;
                        $this$getHmsHlsLayers_u24lambda_u2d4.add(HmsHlsLayer.AUTO.INSTANCE);
                        iterable = iterable2;
                    }
                }
            }
        }
        Iterable iterable4 = iterable;
        return iterable4 == null ? CollectionsKt.emptyList() : iterable4;
    }

    @Override
    public void setHmsHlsLayer(@NotNull HmsHlsLayer layer) {
        TrackSelectionParameters trackSelectionParameters;
        ImmutableList immutableList;
        Tracks tracks;
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        HmsHlsLayer hmsHlsLayer = layer;
        if (hmsHlsLayer instanceof HmsHlsLayer.AUTO) {
            ExoPlayer exoPlayer2 = this.player;
            trackSelectionParameters = exoPlayer2 == null ? null : ((exoPlayer = exoPlayer2.getTrackSelectionParameters()) == null ? null : ((tracks = exoPlayer.buildUpon()) == null ? null : ((immutableList = tracks.clearOverrides()) == null ? null : immutableList.build())));
        } else if (hmsHlsLayer instanceof HmsHlsLayer.LayerInfo) {
            TrackSelectionParameters params;
            TrackGroup trackGroupInfo;
            TrackSelectionParameters.Builder builder;
            Iterable iterable;
            TrackGroup trackGroup;
            exoPlayer = this.player;
            if (exoPlayer == null) {
                trackGroup = null;
            } else {
                tracks = exoPlayer.getCurrentTracks();
                if (tracks == null) {
                    trackGroup = null;
                } else {
                    immutableList = tracks.getGroups();
                    if (immutableList == null) {
                        trackGroup = null;
                    } else {
                        Object v2;
                        block12: {
                            Iterable iterable2 = iterable = (Iterable)immutableList;
                            boolean bl = false;
                            for (Object t : iterable2) {
                                Tracks.Group it = (Tracks.Group)t;
                                boolean bl2 = false;
                                if (!(it.getType() == 2)) continue;
                                v2 = t;
                                break block12;
                            }
                            v2 = null;
                        }
                        builder = v2;
                        trackGroup = trackGroupInfo = builder == null ? null : builder.getMediaTrackGroup();
                    }
                }
            }
            trackSelectionParameters = trackGroupInfo != null ? (params = (tracks = this.player) == null ? null : ((immutableList = tracks.getTrackSelectionParameters()) == null ? null : ((builder = immutableList.buildUpon()) == null ? null : ((iterable = builder.addOverride(new TrackSelectionOverride(trackGroupInfo, ((HmsHlsLayer.LayerInfo)layer).getIndex$hls_player_release()))) == null ? null : iterable.build())))) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TrackSelectionParameters params = trackSelectionParameters;
        if (params != null && (hmsHlsLayer = this.player) != null) {
            hmsHlsLayer.setTrackSelectionParameters(params);
        }
    }

    @Override
    @Nullable
    public HmsHlsLayer getCurrentHmsHlsLayer() {
        Tracks.Group trackGroupInfo;
        Iterable iterable;
        ImmutableList immutableList;
        Tracks tracks;
        Tracks.Group group;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer == null) {
            group = null;
        } else {
            tracks = exoPlayer.getCurrentTracks();
            if (tracks == null) {
                group = null;
            } else {
                immutableList = tracks.getGroups();
                if (immutableList == null) {
                    group = null;
                } else {
                    Object v1;
                    block10: {
                        Iterable iterable2 = iterable = (Iterable)immutableList;
                        boolean bl = false;
                        for (Object t : iterable2) {
                            Tracks.Group it = (Tracks.Group)t;
                            boolean bl2 = false;
                            if (!(it.getType() == 2)) continue;
                            v1 = t;
                            break block10;
                        }
                        v1 = null;
                    }
                    group = trackGroupInfo = (Tracks.Group)v1;
                }
            }
        }
        if (trackGroupInfo != null) {
            HmsHlsLayer hmsHlsLayer;
            Integer selectedIndex;
            tracks = this.player;
            TrackSelectionOverride selected = tracks == null ? null : ((immutableList = tracks.getTrackSelectionParameters()) == null ? null : ((iterable = immutableList.overrides) == null ? null : (TrackSelectionOverride)iterable.getOrDefault(trackGroupInfo.getMediaTrackGroup(), null)));
            immutableList = selected;
            Integer n = immutableList == null ? null : (selectedIndex = (iterable = immutableList.trackIndices) == null ? null : (Integer)CollectionsKt.getOrNull((List)((List)iterable), (int)0));
            if (selectedIndex != null && selectedIndex < selected.mediaTrackGroup.length) {
                iterable = selected.mediaTrackGroup.getFormat(selectedIndex.intValue());
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"selected.mediaTrackGroup.getFormat(selectedIndex)");
                Iterable selectedFormat = iterable;
                HMSVideoResolution hMSVideoResolution = new HMSVideoResolution(((Format)selectedFormat).width, ((Format)selectedFormat).height);
                int n2 = ((Format)selectedFormat).bitrate;
                iterable = trackGroupInfo.getMediaTrackGroup();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"trackGroupInfo.mediaTrackGroup");
                hmsHlsLayer = new HmsHlsLayer.LayerInfo(hMSVideoResolution, n2, (TrackGroup)iterable, trackGroupInfo.getMediaTrackGroup().indexOf((Format)selectedFormat));
            } else {
                hmsHlsLayer = HmsHlsLayer.AUTO.INSTANCE;
            }
            return hmsHlsLayer;
        }
        return null;
    }

    @Override
    public void seekForward(long value, @NotNull TimeUnit unit) {
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        ExoPlayer $this$seekForward_u24lambda_u2d7 = exoPlayer = this.player;
        boolean bl = false;
        ExoPlayer exoPlayer2 = $this$seekForward_u24lambda_u2d7;
        if (exoPlayer2 != null) {
            exoPlayer2.seekTo($this$seekForward_u24lambda_u2d7.getCurrentPosition() + unit.toMillis(value));
        }
    }

    @Override
    public void seekBackward(long value, @NotNull TimeUnit unit) {
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        ExoPlayer $this$seekBackward_u24lambda_u2d8 = exoPlayer = this.player;
        boolean bl = false;
        ExoPlayer exoPlayer2 = $this$seekBackward_u24lambda_u2d8;
        if (exoPlayer2 != null) {
            exoPlayer2.seekTo($this$seekBackward_u24lambda_u2d8.getCurrentPosition() - unit.toMillis(value));
        }
    }

    @Override
    public void seekToLivePosition() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.seekToDefaultPosition();
        }
        this.resume();
    }

    @Override
    public void play(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.createPlayer(this.context, url, true).play();
    }

    @Override
    public void stop() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.stop();
        }
        this.releasePlayer();
    }

    private final ExoPlayer createPlayer(Context context, String url, boolean playWhenready) {
        HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory(this.dataSourceFactory).setAllowChunklessPreparation(true).createMediaSource(MediaItem.fromUri((String)url));
        Intrinsics.checkNotNullExpressionValue((Object)hlsMediaSource, (String)"Factory(dataSourceFactory)\n            .setAllowChunklessPreparation(true)\n            .createMediaSource(MediaItem.fromUri(url))");
        HlsMediaSource hlsMediaSource2 = hlsMediaSource;
        this.createPlayerIfRequired(context);
        ExoPlayer exoPlayer = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer);
        HlsMediaSource $this$createPlayer_u24lambda_u2d9 = hlsMediaSource = exoPlayer;
        boolean bl = false;
        PlayerEventsCollector playerEventsCollector = this.playerStatsCollector;
        if (playerEventsCollector != null) {
            playerEventsCollector.setExoPlayer((ExoPlayer)$this$createPlayer_u24lambda_u2d9);
        }
        $this$createPlayer_u24lambda_u2d9.setMediaSource((MediaSource)hlsMediaSource2);
        $this$createPlayer_u24lambda_u2d9.setPlayWhenReady(playWhenready);
        $this$createPlayer_u24lambda_u2d9.prepare();
        $this$createPlayer_u24lambda_u2d9.addAnalyticsListener((AnalyticsListener)new EventLogger(null));
        this.addHlsMetadataListener((ExoPlayer)$this$createPlayer_u24lambda_u2d9);
        ExoPlayer exoPlayer2 = this.player;
        Intrinsics.checkNotNull((Object)exoPlayer2);
        return exoPlayer2;
    }

    static /* synthetic */ ExoPlayer createPlayer$default(HmsHlsPlayer hmsHlsPlayer, Context context, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return hmsHlsPlayer.createPlayer(context, string, bl);
    }

    private final void addHlsMetadataListener(ExoPlayer player) {
        this.hlsMetadataHandler = new HlsMetadataHandler(player, (Function1<? super HmsHlsCue, Unit>)((Function1)new Function1<HmsHlsCue, Unit>(this){
            final /* synthetic */ HmsHlsPlayer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HmsHlsCue localMetaDataModel) {
                Intrinsics.checkNotNullParameter((Object)localMetaDataModel, (String)"localMetaDataModel");
                Log.d((String)this.this$0.getTAG(), (String)String.valueOf(localMetaDataModel));
                HmsHlsPlaybackEvents hmsHlsPlaybackEvents = HmsHlsPlayer.access$getEvents$p(this.this$0);
                if (hmsHlsPlaybackEvents != null) {
                    hmsHlsPlaybackEvents.onCue(localMetaDataModel);
                }
            }
        }));
        HlsMetadataHandler hlsMetadataHandler = this.hlsMetadataHandler;
        if (hlsMetadataHandler != null) {
            hlsMetadataHandler.start();
        }
    }

    private final void releasePlayer() {
        Log.d((String)this.TAG, (String)"Stopping");
        Object object = this.playerStatsCollector;
        if (object != null) {
            object.removeListener();
        }
        this.playerStatsCollector = null;
        this.playerStatsListener = null;
        object = this.hlsMetadataHandler;
        if (object != null) {
            ((HlsMetadataHandler)object).stop();
        }
        this.hlsMetadataHandler = null;
        object = this.player;
        if (object != null) {
            Object object2;
            Object $this$releasePlayer_u24lambda_u2d10 = object2 = object;
            boolean bl = false;
            $this$releasePlayer_u24lambda_u2d10.setPlayWhenReady($this$releasePlayer_u24lambda_u2d10.getPlayWhenReady());
            $this$releasePlayer_u24lambda_u2d10.release();
        }
        this.player = null;
    }

    public final void mute(boolean mute) {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.setDeviceMuted(mute);
        }
    }

    public final void sendError(@NotNull HmsHlsException hmsError) {
        Intrinsics.checkNotNullParameter((Object)hmsError, (String)"hmsError");
        HmsHlsPlaybackEvents hmsHlsPlaybackEvents = this.events;
        if (hmsHlsPlaybackEvents != null) {
            hmsHlsPlaybackEvents.onPlaybackFailure(hmsError);
        }
        this.hmsLastError = hmsError;
    }

    public static final /* synthetic */ HmsHlsPlaybackEvents access$getEvents$p(HmsHlsPlayer $this) {
        return $this.events;
    }
}

