/*
 * Decompiled with CFR 0.152.
 */
package live.hms.stats;

import android.os.Handler;
import android.os.Looper;
import androidx.media3.common.Format;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.VideoSize;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.stats.PlayerStatsListener;
import live.hms.stats.model.InitConfig;
import live.hms.stats.model.PlayerStatsModel;
import live.hms.video.error.HMSException;
import live.hms.video.sdk.HMSSDK;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u00011B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J(\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016J \u0010\"\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020 H\u0016J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0016J\"\u0010(\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0006\u0010-\u001a\u00020\u0016J\u0006\u0010.\u001a\u00020\u0016J\u0010\u0010/\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u00100\u001a\u00020\u0016H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Llive/hms/stats/PlayerEventsCollector;", "Landroidx/media3/exoplayer/analytics/AnalyticsListener;", "hmsSdk", "Llive/hms/video/sdk/HMSSDK;", "initConfig", "Llive/hms/stats/model/InitConfig;", "(Llive/hms/video/sdk/HMSSDK;Llive/hms/stats/model/InitConfig;)V", "eventsHandler", "Landroid/os/Handler;", "eventsRunnable", "Ljava/lang/Runnable;", "exoPlayer", "Landroidx/media3/exoplayer/ExoPlayer;", "getHmsSdk", "()Llive/hms/video/sdk/HMSSDK;", "setHmsSdk", "(Llive/hms/video/sdk/HMSSDK;)V", "playerPlayerStatsModel", "Llive/hms/stats/model/PlayerStatsModel;", "playerStatsListener", "Llive/hms/stats/PlayerStatsListener;", "addStatsListener", "", "playerEventsListener", "fireEvent", "init", "onBandwidthEstimate", "eventTime", "Landroidx/media3/exoplayer/analytics/AnalyticsListener$EventTime;", "totalLoadTimeMs", "", "totalBytesLoaded", "", "bitrateEstimate", "onDroppedVideoFrames", "droppedFrames", "elapsedMs", "onPlayerError", "error", "Landroidx/media3/common/PlaybackException;", "onVideoInputFormatChanged", "format", "Landroidx/media3/common/Format;", "decoderReuseEvaluation", "Landroidx/media3/exoplayer/DecoderReuseEvaluation;", "removeListener", "removeStatsListener", "setExoPlayer", "setInitialValues", "Companion", "stats_release"})
public final class PlayerEventsCollector
implements AnalyticsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HMSSDK hmsSdk;
    @NotNull
    private final InitConfig initConfig;
    @Nullable
    private ExoPlayer exoPlayer;
    @Nullable
    private PlayerStatsListener playerStatsListener;
    @Nullable
    private PlayerStatsModel playerPlayerStatsModel;
    @Nullable
    private Handler eventsHandler;
    @Nullable
    private Runnable eventsRunnable;
    @NotNull
    public static final String TAG = "PlayerEventsCollector";

    public PlayerEventsCollector(@Nullable HMSSDK hmsSdk, @NotNull InitConfig initConfig) {
        Intrinsics.checkNotNullParameter((Object)initConfig, (String)"initConfig");
        this.hmsSdk = hmsSdk;
        this.initConfig = initConfig;
        this.playerPlayerStatsModel = new PlayerStatsModel(null, null, null, 0L, 0L, 31, null);
    }

    public /* synthetic */ PlayerEventsCollector(HMSSDK hMSSDK, InitConfig initConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            initConfig = new InitConfig(0L, 1, null);
        }
        this(hMSSDK, initConfig);
    }

    @Nullable
    public final HMSSDK getHmsSdk() {
        return this.hmsSdk;
    }

    public final void setHmsSdk(@Nullable HMSSDK hMSSDK) {
        this.hmsSdk = hMSSDK;
    }

    public final void setExoPlayer(@Nullable ExoPlayer exoPlayer) {
        this.exoPlayer = exoPlayer;
        ExoPlayer exoPlayer2 = this.exoPlayer;
        if (exoPlayer2 != null) {
            exoPlayer2.addAnalyticsListener((AnalyticsListener)this);
        }
        this.init();
    }

    public final void removeStatsListener() {
        this.playerStatsListener = null;
    }

    public final void removeListener() {
        Runnable runnable = this.eventsRunnable;
        if (runnable != null) {
            Runnable runnable2;
            Runnable it = runnable2 = runnable;
            boolean bl = false;
            Handler handler = this.eventsHandler;
            if (handler != null) {
                handler.removeCallbacks(it);
            }
        }
        runnable = this.exoPlayer;
        if (runnable != null) {
            runnable.removeAnalyticsListener(this);
        }
        this.eventsRunnable = null;
    }

    public final void addStatsListener(@NotNull PlayerStatsListener playerEventsListener) {
        Intrinsics.checkNotNullParameter((Object)playerEventsListener, (String)"playerEventsListener");
        this.playerStatsListener = playerEventsListener;
    }

    private final void init() {
        this.setInitialValues();
        this.eventsRunnable = () -> PlayerEventsCollector.init$lambda-2(this);
        this.eventsHandler = new Handler(Looper.getMainLooper());
        Runnable runnable = this.eventsRunnable;
        if (runnable != null) {
            Runnable runnable2;
            Runnable it = runnable2 = runnable;
            boolean bl = false;
            Handler handler = this.eventsHandler;
            if (handler != null) {
                handler.post(it);
            }
        }
    }

    private final void setInitialValues() {
        Object object;
        VideoSize videoSize;
        int n;
        Format format;
        ExoPlayer exoPlayer = this.exoPlayer;
        int averageBitrate = exoPlayer == null ? -1 : ((format = exoPlayer.getVideoFormat()) == null ? -1 : (n = format.bitrate));
        format = this.exoPlayer;
        Integer videoHeight = format == null ? null : ((videoSize = format.getVideoSize()) == null ? null : Integer.valueOf(videoSize.height));
        Object object2 = this.exoPlayer;
        Integer videoWidth = object2 == null ? null : ((object = object2.getVideoSize()) == null ? null : Integer.valueOf(((VideoSize)object).width));
        object = this.playerPlayerStatsModel;
        PlayerStatsModel.VideoInfo videoInfo = object2 = object == null ? null : ((PlayerStatsModel)object).getVideoInfo();
        if (object2 != null) {
            ((PlayerStatsModel.VideoInfo)object2).setAverageBitrate(averageBitrate);
        }
        if (videoHeight != null) {
            object = this.playerPlayerStatsModel;
            PlayerStatsModel.VideoInfo videoInfo2 = object2 = object == null ? null : ((PlayerStatsModel)object).getVideoInfo();
            if (object2 != null) {
                ((PlayerStatsModel.VideoInfo)object2).setVideoHeight(videoHeight);
            }
        }
        if (videoWidth != null) {
            object = this.playerPlayerStatsModel;
            PlayerStatsModel.VideoInfo videoInfo3 = object2 = object == null ? null : ((PlayerStatsModel)object).getVideoInfo();
            if (object2 != null) {
                ((PlayerStatsModel.VideoInfo)object2).setVideoWidth(videoWidth);
            }
        }
    }

    private final void fireEvent() {
        ExoPlayer exoPlayer = this.exoPlayer;
        if (exoPlayer == null) {
            return;
        }
        long currentBufferedPosition = exoPlayer.getBufferedPosition() - exoPlayer.getCurrentPosition();
        long distanceFromLive = exoPlayer.getDuration() - exoPlayer.getCurrentPosition();
        PlayerStatsModel playerStatsModel = this.playerPlayerStatsModel;
        if (playerStatsModel != null) {
            PlayerStatsModel playerStatsModel2;
            PlayerStatsModel playerPlayerStatsModel = playerStatsModel2 = playerStatsModel;
            boolean bl = false;
            playerPlayerStatsModel.setBufferedDuration(currentBufferedPosition);
            playerPlayerStatsModel.setDistanceFromLive(distanceFromLive);
            PlayerStatsListener playerStatsListener = this.playerStatsListener;
            if (playerStatsListener != null) {
                playerStatsListener.onEventUpdate(playerPlayerStatsModel);
            }
        }
    }

    public void onBandwidthEstimate(@NotNull AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        super.onBandwidthEstimate(eventTime, totalLoadTimeMs, totalBytesLoaded, bitrateEstimate);
        PlayerStatsModel playerStatsModel = this.playerPlayerStatsModel;
        if (playerStatsModel != null) {
            playerStatsModel.setBandwidth(new PlayerStatsModel.Bandwidth(bitrateEstimate, totalBytesLoaded, eventTime));
        }
    }

    public void onPlayerError(@NotNull AnalyticsListener.EventTime eventTime, @NotNull PlaybackException error) {
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        super.onPlayerError(eventTime, error);
        int n = error.errorCode;
        String string = String.valueOf(error.getMessage());
        String string2 = String.valueOf(error.getMessage());
        String string3 = String.valueOf(error.getMessage());
        HMSException hmsException = new HMSException(n, "hlsstream.failure", string, string3, string2, (Throwable)error, true, null, 128, null);
        PlayerStatsListener playerStatsListener = this.playerStatsListener;
        if (playerStatsListener != null) {
            playerStatsListener.onError(hmsException);
        }
        playerStatsListener = this.hmsSdk;
        if (playerStatsListener != null) {
            playerStatsListener.sendErrorEvent(hmsException);
        }
    }

    public void onVideoInputFormatChanged(@NotNull AnalyticsListener.EventTime eventTime, @NotNull Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        super.onVideoInputFormatChanged(eventTime, format, decoderReuseEvaluation);
        PlayerStatsModel playerStatsModel = this.playerPlayerStatsModel;
        if (playerStatsModel != null) {
            int n = format.height;
            int n2 = format.width;
            float f = format.frameRate;
            int n3 = format.bitrate;
            playerStatsModel.setVideoInfo(new PlayerStatsModel.VideoInfo(n, n2, n3, f, eventTime));
        }
    }

    public void onDroppedVideoFrames(@NotNull AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        super.onDroppedVideoFrames(eventTime, droppedFrames, elapsedMs);
        PlayerStatsModel playerStatsModel = this.playerPlayerStatsModel;
        if (playerStatsModel != null) {
            playerStatsModel.setFrameInfo(new PlayerStatsModel.FrameInfo(droppedFrames, 0, eventTime, 2, null));
        }
    }

    private static final void init$lambda-2(PlayerEventsCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.fireEvent();
        Runnable runnable = this$0.eventsRunnable;
        if (runnable != null) {
            Runnable runnable2;
            Runnable it = runnable2 = runnable;
            boolean bl = false;
            Handler handler = this$0.eventsHandler;
            if (handler != null) {
                handler.postDelayed(it, this$0.initConfig.getEventRate());
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/stats/PlayerEventsCollector$Companion;", "", "()V", "TAG", "", "stats_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

