/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import live.hms.video.media.tracks.HMSAudioTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSRoom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Llive/hms/video/utils/HmsUtilities;", "", "<init>", "()V", "Companion", "lib_release"})
public final class HmsUtilities {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES;

    static {
        String[] stringArray = new String[]{"OMX.google.", "OMX.SEC.", "c2.android"};
        SOFTWARE_IMPLEMENTATION_PREFIXES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\rj\b\u0012\u0004\u0012\u00020\f`\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00120\rj\b\u0012\u0004\u0012\u00020\u0012`\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dJ\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Llive/hms/video/utils/HmsUtilities$Companion;", "", "<init>", "()V", "SOFTWARE_IMPLEMENTATION_PREFIXES", "", "", "getSOFTWARE_IMPLEMENTATION_PREFIXES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getAllVideoTracks", "Lkotlin/collections/ArrayList;", "Llive/hms/video/media/tracks/HMSVideoTrack;", "Ljava/util/ArrayList;", "room", "Llive/hms/video/sdk/models/HMSRoom;", "(Llive/hms/video/sdk/models/HMSRoom;)Ljava/util/ArrayList;", "getAllAudioTracks", "Llive/hms/video/media/tracks/HMSAudioTrack;", "getPeer", "Llive/hms/video/sdk/models/HMSPeer;", "peerId", "getTrack", "Llive/hms/video/media/tracks/HMSTrack;", "trackId", "getAudioTrack", "getVideoTrack", "getSupportedVp8CodecsList", "", "Landroid/media/MediaCodecInfo;", "isSoftwareOnly", "", "codecInfo", "isSoftwareOnlyQOrHigher", "lib_release"})
    @SourceDebugExtension(value={"SMAP\nHmsUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HmsUtilities.kt\nlive/hms/video/utils/HmsUtilities$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,109:1\n1863#2:110\n1863#2,2:111\n1864#2:113\n1863#2:114\n1863#2,2:115\n1864#2:117\n295#2,2:118\n295#2,2:120\n295#2,2:122\n3829#3:124\n4344#3,2:125\n*S KotlinDebug\n*F\n+ 1 HmsUtilities.kt\nlive/hms/video/utils/HmsUtilities$Companion\n*L\n25#1:110\n29#1:111,2\n25#1:113\n42#1:114\n46#1:115,2\n42#1:117\n57#1:118,2\n73#1:120,2\n79#1:122,2\n85#1:124\n85#1:125,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getSOFTWARE_IMPLEMENTATION_PREFIXES() {
            return SOFTWARE_IMPLEMENTATION_PREFIXES;
        }

        @NotNull
        public final ArrayList<HMSVideoTrack> getAllVideoTracks(@NotNull HMSRoom room) {
            Intrinsics.checkNotNullParameter((Object)room, (String)"room");
            ArrayList<HMSVideoTrack> tracks = new ArrayList<HMSVideoTrack>();
            Iterable $this$forEach$iv = room.getPeerList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HMSPeer peer = (HMSPeer)element$iv;
                boolean bl = false;
                if (peer.getVideoTrack() != null) {
                    HMSVideoTrack it;
                    boolean bl2 = false;
                    tracks.add(it);
                }
                Iterable $this$forEach$iv2 = peer.getAuxiliaryTracks();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    HMSTrack track = (HMSTrack)element$iv2;
                    boolean bl3 = false;
                    if (!(track instanceof HMSVideoTrack)) continue;
                    tracks.add((HMSVideoTrack)track);
                }
            }
            return tracks;
        }

        @NotNull
        public final ArrayList<HMSAudioTrack> getAllAudioTracks(@NotNull HMSRoom room) {
            Intrinsics.checkNotNullParameter((Object)room, (String)"room");
            ArrayList<HMSAudioTrack> tracks = new ArrayList<HMSAudioTrack>();
            Iterable $this$forEach$iv = room.getPeerList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HMSPeer peer = (HMSPeer)element$iv;
                boolean bl = false;
                if (peer.getAudioTrack() != null) {
                    HMSAudioTrack it;
                    boolean bl2 = false;
                    tracks.add(it);
                }
                Iterable $this$forEach$iv2 = peer.getAuxiliaryTracks();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    HMSTrack track = (HMSTrack)element$iv2;
                    boolean bl3 = false;
                    if (!(track instanceof HMSAudioTrack)) continue;
                    tracks.add((HMSAudioTrack)track);
                }
            }
            return tracks;
        }

        @Nullable
        public final HMSPeer getPeer(@NotNull String peerId, @NotNull HMSRoom room) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
                Intrinsics.checkNotNullParameter((Object)room, (String)"room");
                Iterable $this$firstOrNull$iv = room.getPeerList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HMSPeer peer = (HMSPeer)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)peer.getPeerID(), (Object)peerId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final HMSTrack getTrack(@NotNull String trackId, @NotNull HMSRoom room) {
            Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
            Intrinsics.checkNotNullParameter((Object)room, (String)"room");
            HMSAudioTrack hMSAudioTrack = this.getAudioTrack(trackId, room);
            if (hMSAudioTrack != null) {
                HMSAudioTrack it = hMSAudioTrack;
                boolean bl = false;
                return it;
            }
            HMSVideoTrack hMSVideoTrack = this.getVideoTrack(trackId, room);
            if (hMSVideoTrack != null) {
                HMSVideoTrack it = hMSVideoTrack;
                boolean bl = false;
                return it;
            }
            return null;
        }

        @Nullable
        public final HMSAudioTrack getAudioTrack(@NotNull String trackId, @NotNull HMSRoom room) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
                Intrinsics.checkNotNullParameter((Object)room, (String)"room");
                Iterable $this$firstOrNull$iv = this.getAllAudioTracks(room);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HMSAudioTrack it = (HMSAudioTrack)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTrackId(), (Object)trackId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final HMSVideoTrack getVideoTrack(@NotNull String trackId, @NotNull HMSRoom room) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
                Intrinsics.checkNotNullParameter((Object)room, (String)"room");
                Iterable $this$firstOrNull$iv = this.getAllVideoTracks(room);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HMSVideoTrack it = (HMSVideoTrack)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTrackId(), (Object)trackId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final List<MediaCodecInfo> getSupportedVp8CodecsList() {
            v0 = new MediaCodecList(1).getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getCodecInfos(...)");
            $this$filter$iv = v0;
            $i$f$filter = false;
            var4_3 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                it = (MediaCodecInfo)element$iv$iv;
                $i$a$-filter-HmsUtilities$Companion$getSupportedVp8CodecsList$supportedVideoCodecs$1 = false;
                if (!it.isEncoder()) ** GOTO lbl-1000
                v1 = it.getSupportedTypes()[0];
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
                if (!StringsKt.startsWith$default((String)v1, (String)"video", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"vp8", (boolean)false, (int)2, null)) {
                    v3 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            supportedVideoCodecs = (List)destination$iv$iv;
            return supportedVideoCodecs;
        }

        public final boolean isSoftwareOnly(@NotNull MediaCodecInfo codecInfo) {
            Intrinsics.checkNotNullParameter((Object)codecInfo, (String)"codecInfo");
            if (Build.VERSION.SDK_INT >= 29) {
                return this.isSoftwareOnlyQOrHigher(codecInfo);
            }
            String string = codecInfo.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name = string;
            for (String prefix : this.getSOFTWARE_IMPLEMENTATION_PREFIXES()) {
                if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                return true;
            }
            return false;
        }

        @TargetApi(value=29)
        private final boolean isSoftwareOnlyQOrHigher(MediaCodecInfo codecInfo) {
            return codecInfo.isSoftwareOnly();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

