/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.services;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import hms.webrtc.CapturerObserver;
import hms.webrtc.EglBase;
import hms.webrtc.SurfaceTextureHelper;
import hms.webrtc.VideoFrame;
import hms.webrtc.VideoSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import live.hms.video.factories.HMSPeerConnectionFactory;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.sdk.models.enums.AudioMixingMode;
import live.hms.video.services.ScreenCapturerAndroidCustom;
import live.hms.video.utils.HMSCoroutineScope;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import live.hms.video.utils.SharedEglContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 02\u00020\u0001:\u0002/0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0003J \u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002J'\u0010#\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&J\u0006\u0010'\u001a\u00020\u0018J\u0006\u0010(\u001a\u00020\u0018J\u0012\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010+\u001a\u00020\u0018H\u0016J\"\u0010,\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0016H\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Llive/hms/video/services/HMSScreenCaptureService;", "Landroid/app/Service;", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "screenCapturerAndroid", "Llive/hms/video/services/ScreenCapturerAndroidCustom;", "hmsPeerConnectionFactory", "Llive/hms/video/factories/HMSPeerConnectionFactory;", "mBinder", "Landroid/os/IBinder;", "customerNotification", "Landroid/app/Notification;", "endFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getEndFlow", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "oldOrientation", "", "createNotificationChannel", "", "startScreenCapture", "mediaProjectionPermissionResultData", "Landroid/content/Intent;", "hmsVideoTrackSettings", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "source", "Lhms/webrtc/VideoSource;", "checkForOrientationChange", "frame", "Lhms/webrtc/VideoFrame;", "startAudioSharing", "audioMixingMode", "Llive/hms/video/sdk/models/enums/AudioMixingMode;", "startAudioSharing$lib_release", "stopScreenCapturer", "stopAudioCaptuer", "onBind", "intent", "onDestroy", "onStartCommand", "flags", "startId", "LocalBinder", "Companion", "lib_release"})
public final class HMSScreenCaptureService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final String TAG = HMSScreenCaptureService.class.getSimpleName();
    @Nullable
    private ScreenCapturerAndroidCustom screenCapturerAndroid;
    @Nullable
    private HMSPeerConnectionFactory hmsPeerConnectionFactory;
    @NotNull
    private final IBinder mBinder = (IBinder)new LocalBinder();
    @Nullable
    private Notification customerNotification;
    @NotNull
    private final MutableSharedFlow<Boolean> endFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
    private int oldOrientation;
    private static final int SERVICE_ID = 123;
    @NotNull
    private static final String NOTIFICATION_CHANNEL_ID = "ScreenCapture channel";
    @NotNull
    public static final String ACTION_START = "AudioCaptureService:Start";
    @NotNull
    public static final String ACTION_STOP = "AudioCaptureService:Stop";
    @NotNull
    public static final String LOCAL_SCREEN_CAPTURER_THREAD = "local-screen-capturer-thread";
    @NotNull
    public static final String PERMISSION_RESULT_DATA = "permission_result_data";
    @NotNull
    public static final String SCREEN_WIDTH = "screen_width";
    @NotNull
    public static final String SCREEN_HEIGHT = "screen_height";

    @NotNull
    public final MutableSharedFlow<Boolean> getEndFlow() {
        return this.endFlow;
    }

    @RequiresApi(value=26)
    private final void createNotificationChannel() {
        Object object = this.customerNotification;
        if (object == null || (object = object.getChannelId()) == null) {
            object = NOTIFICATION_CHANNEL_ID;
        }
        NotificationChannel serviceChannel = new NotificationChannel((String)object, (CharSequence)"Screen Capture Service Channel", 3);
        NotificationManager manager = (NotificationManager)this.getApplicationContext().getSystemService(NotificationManager.class);
        manager.createNotificationChannel(serviceChannel);
    }

    public final void startScreenCapture(@Nullable Intent mediaProjectionPermissionResultData, @NotNull HMSVideoTrackSettings hmsVideoTrackSettings, @NotNull VideoSource source) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)hmsVideoTrackSettings, (String)"hmsVideoTrackSettings");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            ScreenCapturerAndroidCustom screenCapturerAndroidCustom = this.screenCapturerAndroid = new ScreenCapturerAndroidCustom(mediaProjectionPermissionResultData, new MediaProjection.Callback(){

                public void onStop() {
                    HMSLogger.e("HMSScreenCapturer", "onstop of screen capturer");
                }
            });
            if (screenCapturerAndroidCustom != null) {
                screenCapturerAndroidCustom.initialize(SurfaceTextureHelper.create((String)LOCAL_SCREEN_CAPTURER_THREAD, (EglBase.Context)SharedEglContext.INSTANCE.getContext()), this.getApplicationContext(), new CapturerObserver(source, this){
                    final /* synthetic */ VideoSource $source;
                    final /* synthetic */ HMSScreenCaptureService this$0;
                    {
                        this.$source = $source;
                        this.this$0 = $receiver;
                    }

                    public void onCapturerStarted(boolean success) {
                        this.$source.getCapturerObserver().onCapturerStarted(success);
                    }

                    public void onCapturerStopped() {
                        this.$source.getCapturerObserver().onCapturerStopped();
                    }

                    public void onFrameCaptured(VideoFrame frame) {
                        block0: {
                            this.$source.getCapturerObserver().onFrameCaptured(frame);
                            VideoFrame videoFrame = frame;
                            if (videoFrame == null) break block0;
                            VideoFrame videoFrame2 = videoFrame;
                            HMSScreenCaptureService hMSScreenCaptureService = this.this$0;
                            VideoFrame it = videoFrame2;
                            boolean bl = false;
                            HMSScreenCaptureService.access$checkForOrientationChange(hMSScreenCaptureService, it);
                        }
                    }
                });
            }
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            Point actualSize = HMSUtils.INSTANCE.getDeviceWidthAndHeight(context);
            Point constraintSize = HMSUtils.INSTANCE.applySizeConstraint(actualSize);
            ScreenCapturerAndroidCustom screenCapturerAndroidCustom2 = this.screenCapturerAndroid;
            if (screenCapturerAndroidCustom2 == null) break block1;
            screenCapturerAndroidCustom2.startCapture(constraintSize.x, constraintSize.y, 30);
        }
    }

    private final void checkForOrientationChange(VideoFrame frame) {
        block1: {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            int currentOrientation = HMSUtils.INSTANCE.getOrientation(context);
            if (!HMSUtils.INSTANCE.hasOrientationChange(currentOrientation, this.oldOrientation)) break block1;
            this.oldOrientation = currentOrientation;
            ScreenCapturerAndroidCustom screenCapturerAndroidCustom = this.screenCapturerAndroid;
            if (screenCapturerAndroidCustom != null) {
                screenCapturerAndroidCustom.changeCaptureFormat(frame.getBuffer().getHeight(), frame.getBuffer().getWidth(), 30);
            }
        }
    }

    @RequiresApi(value=29)
    public final void startAudioSharing$lib_release(@Nullable Intent mediaProjectionPermissionResultData, @NotNull HMSPeerConnectionFactory hmsPeerConnectionFactory, @NotNull AudioMixingMode audioMixingMode) {
        Intrinsics.checkNotNullParameter((Object)hmsPeerConnectionFactory, (String)"hmsPeerConnectionFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)audioMixingMode), (String)"audioMixingMode");
        this.hmsPeerConnectionFactory = hmsPeerConnectionFactory;
        Object object = this.getApplicationContext().getSystemService("media_projection");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)object;
        Intent intent = mediaProjectionPermissionResultData;
        Intrinsics.checkNotNull((Object)intent);
        MediaProjection mediaProjection = mediaProjectionManager.getMediaProjection(-1, intent);
        Intrinsics.checkNotNullExpressionValue((Object)mediaProjection, (String)"getMediaProjection(...)");
        MediaProjection mediaProjection2 = mediaProjection;
        hmsPeerConnectionFactory.startAudioMixing(mediaProjection2, audioMixingMode);
    }

    public final void stopScreenCapturer() {
        ScreenCapturerAndroidCustom screenCapturerAndroidCustom = this.screenCapturerAndroid;
        if (screenCapturerAndroidCustom != null) {
            screenCapturerAndroidCustom.stopCapture();
        }
        this.stopSelf();
    }

    public final void stopAudioCaptuer() {
        HMSPeerConnectionFactory hMSPeerConnectionFactory = this.hmsPeerConnectionFactory;
        if (hMSPeerConnectionFactory != null) {
            hMSPeerConnectionFactory.stopAudioMixing();
        }
        this.stopSelf();
    }

    @NotNull
    public IBinder onBind(@Nullable Intent intent) {
        Notification notification;
        Intent intent2 = intent;
        this.customerNotification = intent2 != null ? (Notification)intent2.getParcelableExtra("hms_screenshare_notification_extra") : null;
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        HMSLogger.INSTANCE.v(string, "Is customer intent null? " + (this.customerNotification == null));
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannel();
        }
        if ((notification = this.customerNotification) == null) {
            Notification notification2 = new NotificationCompat.Builder((Context)this, NOTIFICATION_CHANNEL_ID).setContentTitle((CharSequence)"Service running in background").setContentText((CharSequence)"Screen Capture is running in background").build();
            notification = notification2;
            Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"build(...)");
        }
        this.startForeground(123, notification);
        return this.mBinder;
    }

    public void onDestroy() {
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        HMSLogger.INSTANCE.v(string, "Being destroyed from the service");
        ScreenCapturerAndroidCustom screenCapturerAndroidCustom = this.screenCapturerAndroid;
        if (screenCapturerAndroidCustom != null) {
            screenCapturerAndroidCustom.stopCapture();
        }
        HMSPeerConnectionFactory hMSPeerConnectionFactory = this.hmsPeerConnectionFactory;
        if (hMSPeerConnectionFactory != null) {
            hMSPeerConnectionFactory.stopAudioMixing();
        }
        super.onDestroy();
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        int i = super.onStartCommand(intent, flags, startId);
        Intent intent2 = intent;
        if (Intrinsics.areEqual((Object)(intent2 != null ? intent2.getAction() : null), (Object)ACTION_STOP)) {
            BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ HMSScreenCaptureService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.getEndFlow().emit((Object)Boxing.boxBoolean((boolean)true), (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return i;
    }

    public static final /* synthetic */ void access$checkForOrientationChange(HMSScreenCaptureService $this, VideoFrame frame) {
        $this.checkForOrientationChange(frame);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llive/hms/video/services/HMSScreenCaptureService$Companion;", "", "<init>", "()V", "SERVICE_ID", "", "NOTIFICATION_CHANNEL_ID", "", "ACTION_START", "ACTION_STOP", "LOCAL_SCREEN_CAPTURER_THREAD", "PERMISSION_RESULT_DATA", "SCREEN_WIDTH", "SCREEN_HEIGHT", "getStopScreenSharePendingIntent", "Landroid/app/PendingIntent;", "context", "Landroid/content/Context;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PendingIntent getStopScreenSharePendingIntent(@NotNull Context context) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent $this$getStopScreenSharePendingIntent_u24lambda_u240 = intent = new Intent(context, HMSScreenCaptureService.class);
            boolean bl = false;
            $this$getStopScreenSharePendingIntent_u24lambda_u240.setAction(HMSScreenCaptureService.ACTION_STOP);
            Intent stopSelf = intent;
            PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getService((Context)context, (int)123, (Intent)stopSelf, (int)0x4000000) : PendingIntent.getBroadcast((Context)context, (int)123, (Intent)stopSelf, (int)0x8000000);
            Intrinsics.checkNotNull((Object)pendingIntent);
            return pendingIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Llive/hms/video/services/HMSScreenCaptureService$LocalBinder;", "Landroid/os/Binder;", "<init>", "(Llive/hms/video/services/HMSScreenCaptureService;)V", "service", "Llive/hms/video/services/HMSScreenCaptureService;", "getService", "()Llive/hms/video/services/HMSScreenCaptureService;", "lib_release"})
    public final class LocalBinder
    extends Binder {
        @NotNull
        public final HMSScreenCaptureService getService() {
            return HMSScreenCaptureService.this;
        }
    }
}

