/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.models;

import android.content.Context;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.network.HMSNetworkManager;
import live.hms.video.sdk.models.EVENT_TYPE;
import live.hms.video.sdk.models.IRetryAttemptTracking;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001dJ\u001e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b#JY\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020&0'j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020&`%2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010(\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010)J\r\u0010*\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u00020\u0019H\u0016J\b\u00100\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Llive/hms/video/sdk/models/PerformanceMeasurement;", "Ljava/io/Closeable;", "Llive/hms/video/sdk/models/IRetryAttemptTracking;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "applicationContext", "Landroid/content/Context;", "hmsNetworkManager", "Llive/hms/video/network/HMSNetworkManager;", "<init>", "(Llive/hms/video/events/AnalyticsEventsService;Landroid/content/Context;Llive/hms/video/network/HMSNetworkManager;)V", "startTimes", "Ljava/util/concurrent/ConcurrentHashMap;", "Llive/hms/video/sdk/models/EVENT_TYPE;", "", "stopTimes", "numberEvents", "", "previewStartTime", "isPreviewCalled", "", "eventsThatWereEnded", "Ljava/util/HashSet;", "eventsThatWereStarted", "start", "", "eventType", "start$lib_release", "end", "end$lib_release", "numberedValue", "times", "(Llive/hms/video/sdk/models/EVENT_TYPE;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fireJoinPerformanceMeasurementEvent", "success", "fireJoinPerformanceMeasurementEvent$lib_release", "getPropertiesFromTimes", "Lkotlin/collections/HashMap;", "", "Ljava/util/HashMap;", "isJoin", "(Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/concurrent/ConcurrentHashMap;Z)Ljava/util/HashMap;", "startPreview", "startPreview$lib_release", "firePreviewPerformanceMeasurementEvent", "eventSuccessful", "firePreviewPerformanceMeasurementEvent$lib_release", "close", "clearValues", "lib_release"})
@SourceDebugExtension(value={"SMAP\nPerformanceMeasurement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceMeasurement.kt\nlive/hms/video/sdk/models/PerformanceMeasurement\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,139:1\n126#2:140\n153#2,3:141\n*S KotlinDebug\n*F\n+ 1 PerformanceMeasurement.kt\nlive/hms/video/sdk/models/PerformanceMeasurement\n*L\n94#1:140\n94#1:141,3\n*E\n"})
public final class PerformanceMeasurement
implements Closeable,
IRetryAttemptTracking {
    @NotNull
    private AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final HMSNetworkManager hmsNetworkManager;
    @NotNull
    private final ConcurrentHashMap<EVENT_TYPE, Long> startTimes;
    @NotNull
    private final ConcurrentHashMap<EVENT_TYPE, Long> stopTimes;
    @NotNull
    private final ConcurrentHashMap<String, Long> numberEvents;
    private long previewStartTime;
    private boolean isPreviewCalled;
    @NotNull
    private final HashSet<String> eventsThatWereEnded;
    @NotNull
    private final HashSet<String> eventsThatWereStarted;

    public PerformanceMeasurement(@NotNull AnalyticsEventsService analyticsEventsService2, @NotNull Context applicationContext, @NotNull HMSNetworkManager hmsNetworkManager) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)hmsNetworkManager, (String)"hmsNetworkManager");
        this.analyticsEventsService = analyticsEventsService2;
        this.hmsNetworkManager = hmsNetworkManager;
        this.startTimes = new ConcurrentHashMap();
        this.stopTimes = new ConcurrentHashMap();
        this.numberEvents = new ConcurrentHashMap();
        this.eventsThatWereEnded = new HashSet();
        this.eventsThatWereStarted = new HashSet();
    }

    public final void start$lib_release(@NotNull EVENT_TYPE eventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        ((Map)this.startTimes).put(eventType, System.currentTimeMillis());
    }

    @NotNull
    public final PerformanceMeasurement end$lib_release(@NotNull EVENT_TYPE eventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        long endTime = System.currentTimeMillis();
        Long l = endTime;
        ((Map)this.stopTimes).put(eventType, l);
        return this;
    }

    @Override
    @Nullable
    public Object numberedValue(@NotNull EVENT_TYPE eventType, long times, @NotNull Continuation<? super Unit> $completion) {
        Long l = Boxing.boxLong((long)times);
        ((Map)this.numberEvents).put(eventType.getValue(), l);
        return Unit.INSTANCE;
    }

    public final void fireJoinPerformanceMeasurementEvent$lib_release(boolean success) {
        boolean hasJoined = this.startTimes.containsKey((Object)EVENT_TYPE.JOIN_CALL);
        if (hasJoined) {
            HashMap<String, Object> properties = this.getPropertiesFromTimes(this.startTimes, this.stopTimes, true);
            ((Map)properties).put("is_preview_called", this.isPreviewCalled);
            ((Map)properties).put("network_type", this.hmsNetworkManager.getConnectedNetworkType());
            HMSLogger.d("PerformanceJoinEvents", "Sending event: " + properties);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.joinStatusEvent(success, properties)).flush();
        } else {
            HMSLogger.e("PerformanceJoinEvents", "Throwing away a flush since the measurement was wrong by not having a time at all");
        }
        this.clearValues();
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, Object> getPropertiesFromTimes(ConcurrentHashMap<EVENT_TYPE, Long> startTimes, ConcurrentHashMap<EVENT_TYPE, Long> stopTimes, boolean isJoin) {
        void $this$mapTo$iv$iv;
        if (isJoin) {
            startTimes.remove((Object)EVENT_TYPE.PREVIEW_CALL);
            stopTimes.remove((Object)EVENT_TYPE.PREVIEW_CALL);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Map $this$map$iv = startTimes;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Long time;
            Long l;
            void startMap;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l2 = stopTimes.get(startMap.getKey());
            if (l2 != null) {
                long stop = ((Number)l2).longValue();
                boolean bl2 = false;
                l = stop - ((Number)startMap.getValue()).longValue();
            } else {
                l = time = null;
            }
            if (time != null && time >= 0L) {
                ((Map)properties).put(((EVENT_TYPE)((Object)startMap.getKey())).getValue(), time);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        properties.putAll((Map)this.numberEvents);
        return properties;
    }

    public final void startPreview$lib_release() {
        this.previewStartTime = System.currentTimeMillis();
        this.isPreviewCalled = true;
    }

    public final void firePreviewPerformanceMeasurementEvent$lib_release(boolean eventSuccessful) {
        ((Map)this.stopTimes).put(EVENT_TYPE.PREVIEW_CALL, System.currentTimeMillis());
        ((Map)this.startTimes).put(EVENT_TYPE.PREVIEW_CALL, this.previewStartTime);
        HashMap<String, Object> properties = this.getPropertiesFromTimes(this.startTimes, this.stopTimes, false);
        AnalyticsEvent event = AnalyticsEventFactory.INSTANCE.previewStatusEvent(eventSuccessful, properties);
        this.analyticsEventsService.queue(event).flush();
        HMSLogger.d("PerformanceJoinEvents", "Fire preview measurement: " + event);
    }

    @Override
    public void close() {
        this.isPreviewCalled = false;
        this.clearValues();
    }

    private final void clearValues() {
        this.startTimes.clear();
        this.stopTimes.clear();
        this.numberEvents.clear();
    }
}

