/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories;

import hms.webrtc.PeerConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ$\u0010\n\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Llive/hms/video/factories/IceCandidateFactory;", "", "<init>", "()V", "TAG", "", "makeStunServer", "Lhms/webrtc/PeerConnection$IceServer;", "urls", "", "makeTurnServer", "username", "password", "DEFAULT_ICE_SERVERS", "getDEFAULT_ICE_SERVERS", "()Ljava/util/List;", "lib_release"})
public final class IceCandidateFactory {
    @NotNull
    public static final IceCandidateFactory INSTANCE = new IceCandidateFactory();
    @NotNull
    private static final String TAG = "IceCandidateFactory";
    @NotNull
    private static final List<PeerConnection.IceServer> DEFAULT_ICE_SERVERS = CollectionsKt.listOf((Object)INSTANCE.makeStunServer(CollectionsKt.listOf((Object)"stun:stun.stunprotocol.org:3478")));

    private IceCandidateFactory() {
    }

    @NotNull
    public final PeerConnection.IceServer makeStunServer(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        HMSLogger.d(TAG, "Building stun server with urls=" + urls);
        PeerConnection.IceServer.Builder builder = PeerConnection.IceServer.builder(urls);
        PeerConnection.IceServer iceServer = builder.createIceServer();
        Intrinsics.checkNotNullExpressionValue((Object)iceServer, (String)"createIceServer(...)");
        return iceServer;
    }

    @NotNull
    public final PeerConnection.IceServer makeTurnServer(@NotNull List<String> urls, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        HMSLogger.d(TAG, "Building turn server with urls=" + urls);
        PeerConnection.IceServer.Builder builder = PeerConnection.IceServer.builder(urls);
        builder.setUsername(username);
        builder.setPassword(password);
        PeerConnection.IceServer iceServer = builder.createIceServer();
        Intrinsics.checkNotNullExpressionValue((Object)iceServer, (String)"createIceServer(...)");
        return iceServer;
    }

    @NotNull
    public final List<PeerConnection.IceServer> getDEFAULT_ICE_SERVERS() {
        return DEFAULT_ICE_SERVERS;
    }
}

