/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.events;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.database.entity.AnalyticsEntityModel;
import live.hms.video.factories.OkHttpFactory;
import live.hms.video.signal.init.ShortCodeInput;
import live.hms.video.signal.init.TokenRequest;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSAgentOs;
import live.hms.video.utils.HMSLogger;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J'\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0011J'\u0010\u0012\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0013J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llive/hms/video/events/HMSApiClient;", "", "<init>", "()V", "TAG", "", "makeEventRequest", "Lokhttp3/Request;", "analyticsEntityModel", "Llive/hms/video/database/entity/AnalyticsEntityModel;", "token", "hmsAgentOs", "Llive/hms/video/utils/HMSAgentOs;", "makeTokenRequest", "tokenRequest", "Llive/hms/video/signal/init/TokenRequest;", "baseUrl", "makeTokenRequest$lib_release", "makeLayoutRequest", "makeLayoutRequest$lib_release", "reportAnalyticsEvent", "", "(Llive/hms/video/database/entity/AnalyticsEntityModel;Llive/hms/video/utils/HMSAgentOs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
public final class HMSApiClient {
    @NotNull
    public static final HMSApiClient INSTANCE = new HMSApiClient();
    @NotNull
    private static final String TAG = "HMSApiClient";

    private HMSApiClient() {
    }

    private final Request makeEventRequest(AnalyticsEntityModel analyticsEntityModel, String token, HMSAgentOs hmsAgentOs) {
        String agentUrlEncoded = hmsAgentOs.getUserAgent();
        String url = analyticsEntityModel.isQa() ? "https://event-nonprod.100ms.live/v2/client/report" : "https://event.100ms.live/v2/client/report";
        MediaType mediaType = MediaType.Companion.parse("application/json; charset=utf-8");
        String jsonPayload = GsonUtils.INSTANCE.getGson().toJson((Object)analyticsEntityModel);
        Intrinsics.checkNotNull((Object)jsonPayload);
        RequestBody body = RequestBody.Companion.create(jsonPayload, mediaType);
        Request request = new Request.Builder().url(url).addHeader(hmsAgentOs.getUSER_AGENT_V2_NAME(), agentUrlEncoded).addHeader("Authorization", "Bearer " + token).addHeader("Accept-Type", "application/json").post(body).build();
        HMSLogger.d(TAG, "makeEventRequest: request=" + request);
        return request;
    }

    @NotNull
    public final Request makeTokenRequest$lib_release(@NotNull TokenRequest tokenRequest, @Nullable String baseUrl, @NotNull HMSAgentOs hmsAgentOs) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)hmsAgentOs, (String)"hmsAgentOs");
        String agentUrlEncoded = hmsAgentOs.getUserAgent();
        MediaType mediaType = MediaType.Companion.parse("application/json; charset=utf-8");
        String jsonPayload = GsonUtils.INSTANCE.getGson().toJson((Object)new ShortCodeInput(tokenRequest.getRoomCode(), tokenRequest.getUserId()));
        Intrinsics.checkNotNull((Object)jsonPayload);
        RequestBody body = RequestBody.Companion.create(jsonPayload, mediaType);
        CharSequence charSequence = baseUrl;
        String tokenEndpoint = charSequence == null || charSequence.length() == 0 ? "https://auth.100ms.live" : baseUrl;
        return new Request.Builder().url(tokenEndpoint + "/v2/token").addHeader(hmsAgentOs.getUSER_AGENT_V2_NAME(), agentUrlEncoded).post(body).build();
    }

    @NotNull
    public final Request makeLayoutRequest$lib_release(@NotNull String token, @Nullable String baseUrl, @NotNull HMSAgentOs hmsAgentOs) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)hmsAgentOs, (String)"hmsAgentOs");
        String agentUrlEncoded = hmsAgentOs.getUserAgent();
        MediaType mediaType = MediaType.Companion.parse("application/json; charset=utf-8");
        CharSequence charSequence = baseUrl;
        String layoutEndpoint = charSequence == null || charSequence.length() == 0 ? "https://api.100ms.live" : baseUrl;
        return new Request.Builder().url(layoutEndpoint + "/v2/layouts/ui").addHeader(hmsAgentOs.getUSER_AGENT_V2_NAME(), agentUrlEncoded).addHeader("Authorization", "Bearer " + token).addHeader("Accept-Type", "application/json").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object reportAnalyticsEvent(@NotNull AnalyticsEntityModel analyticsEntityModel, @NotNull HMSAgentOs hmsAgentOs, @NotNull Continuation<? super Boolean> $completion) {
        Request request = this.makeEventRequest(analyticsEntityModel, analyticsEntityModel.getToken(), hmsAgentOs);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        try {
            Closeable closeable = (Closeable)OkHttpFactory.INSTANCE.getClient().newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                boolean bl2 = response.isSuccessful() ? deferred.complete((Object)Boxing.boxBoolean((boolean)true)) : deferred.complete((Object)Boxing.boxBoolean((boolean)false));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HMSLogger.e(TAG, Unit.INSTANCE.toString());
            deferred.complete((Object)Boxing.boxBoolean((boolean)false));
        }
        return deferred.await($completion);
    }
}

