/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.stats;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.degredation.Track;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ3\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0013R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Llive/hms/video/connection/stats/BitrateCalculator;", "", "<init>", "()V", "prevTrackStatsReceivedTime", "Ljava/util/HashMap;", "", "Lkotlin/Pair;", "", "Ljava/math/BigInteger;", "prevBitrate", "", "getBitrateFromTrackUpdatePrev", "stat", "Llive/hms/video/connection/degredation/Track;", "trackId", "remoteTimeStamp", "bytesTransported", "postfix", "(Ljava/lang/String;Ljava/lang/Double;Ljava/math/BigInteger;Ljava/lang/String;)Ljava/lang/Double;", "lib_release"})
public final class BitrateCalculator {
    @NotNull
    private final HashMap<String, Pair<Double, BigInteger>> prevTrackStatsReceivedTime = new HashMap();
    @NotNull
    private final Map<String, Double> prevBitrate = new LinkedHashMap();

    public final double getBitrateFromTrackUpdatePrev(@NotNull Track stat) {
        double d;
        String connectionTypePostfix;
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        BigInteger bigInteger = stat.getBytesTransported();
        Float bytesTransported = bigInteger != null ? Float.valueOf(bigInteger.floatValue()) : null;
        Object object = stat instanceof Track.LocalTrack.LocalVideo ? (Track.LocalTrack.LocalVideo)stat : null;
        if (object == null || (object = ((Track.LocalTrack.LocalVideo)object).getHmsLayer()) == null || (object = ((Enum)object).name()) == null) {
            object = "";
        }
        Object simulcastPostFix = object;
        String string = connectionTypePostfix = stat instanceof Track.LocalTrack ? "_publish" : "_subscribe";
        if (bytesTransported == null || (double)bytesTransported.floatValue() < 0.0) {
            Double d2 = this.prevBitrate.get(stat.getTrackIdentifier() + '_' + (String)simulcastPostFix + '_' + connectionTypePostfix);
            return d2 != null ? d2 : 0.0;
        }
        Double d3 = this.getBitrateFromTrackUpdatePrev(stat.getTrackIdentifier(), stat.getRemoteTimestamp(), stat.getBytesTransported(), (String)simulcastPostFix + connectionTypePostfix);
        if (d3 != null) {
            d = d3;
        } else {
            Double d4 = this.prevBitrate.get(stat.getTrackIdentifier() + '_' + (String)simulcastPostFix + '_' + connectionTypePostfix);
            d = d4 != null ? d4 : 0.0;
        }
        return d;
    }

    @Nullable
    public final Double getBitrateFromTrackUpdatePrev(@Nullable String trackId, @Nullable Double remoteTimeStamp, @Nullable BigInteger bytesTransported, @NotNull String postfix) {
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        String trackIdentifier = trackId;
        Double bitrate = 0.0;
        if (trackIdentifier != null && remoteTimeStamp != null) {
            double timeDelta;
            BigInteger prevBytesReceived;
            Pair<Double, BigInteger> prevInfo;
            Pair<Double, BigInteger> pair = prevInfo = this.prevTrackStatsReceivedTime.get(trackIdentifier + '_' + postfix);
            Double prevTime = pair != null ? (Double)pair.getFirst() : null;
            Pair<Double, BigInteger> pair2 = prevInfo;
            BigInteger bigInteger = prevBytesReceived = pair2 != null ? (BigInteger)pair2.getSecond() : null;
            Double d = prevBytesReceived != null && prevTime != null && bytesTransported != null ? ((timeDelta = (remoteTimeStamp - prevTime) / (double)1000000) > 0.0 ? Double.valueOf((double)(0.008f * (bytesTransported.floatValue() - prevBytesReceived.floatValue())) / timeDelta) : null) : (bitrate = Double.valueOf(0.0));
            if (bitrate != null) {
                ((Map)this.prevTrackStatsReceivedTime).put(trackIdentifier + '_' + postfix, new Pair((Object)remoteTimeStamp, (Object)bytesTransported));
                this.prevBitrate.put(trackIdentifier + '_' + postfix, bitrate);
            }
        }
        return bitrate;
    }
}

