/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.models;

import hms.webrtc.PeerConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import live.hms.video.factories.IceCandidateFactory;
import live.hms.video.signal.init.IceServer;
import live.hms.video.signal.init.InitConfig;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Llive/hms/video/connection/models/HMSConfiguration;", "Lhms/webrtc/PeerConnection$RTCConfiguration;", "iceServers", "", "Lhms/webrtc/PeerConnection$IceServer;", "<init>", "(Ljava/util/List;)V", "enableIceGatheringOnAnyAddressPorts", "", "enable", "", "toString", "", "Companion", "lib_release"})
public final class HMSConfiguration
extends PeerConnection.RTCConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "HMSConfiguration";

    public HMSConfiguration(@NotNull List<? extends PeerConnection.IceServer> iceServers) {
        Intrinsics.checkNotNullParameter(iceServers, (String)"iceServers");
        super(iceServers);
        this.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
    }

    public final void enableIceGatheringOnAnyAddressPorts(boolean enable) {
        if (!enable) {
            return;
        }
        PeerConnection.PortAllocatorFlag[] portAllocatorFlagArray = new PeerConnection.PortAllocatorFlag[]{PeerConnection.PortAllocatorFlag.ENABLE_ANY_ADDRESS_PORTS};
        this.portAllocatorConfig = new PeerConnection.PortAllocatorConfig(portAllocatorFlagArray);
    }

    @NotNull
    public String toString() {
        return super.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Llive/hms/video/connection/models/HMSConfiguration$Companion;", "", "<init>", "()V", "TAG", "", "from", "Llive/hms/video/connection/models/HMSConfiguration;", "config", "Llive/hms/video/signal/init/InitConfig;", "lib_release"})
    @SourceDebugExtension(value={"SMAP\nHMSConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSConfiguration.kt\nlive/hms/video/connection/models/HMSConfiguration$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HMSConfiguration from(@NotNull InitConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            ArrayList<PeerConnection.IceServer> servers = new ArrayList<PeerConnection.IceServer>();
            Iterator<IceServer> iterator = config.getRtcConfig().getIceServers().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<IceServer> iterator2 = iterator;
            while (iterator2.hasNext()) {
                IceServer server;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                String string = server.getUrls().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                if (StringsKt.startsWith$default((String)string, (String)"stun:", (boolean)false, (int)2, null)) {
                    servers.add(IceCandidateFactory.INSTANCE.makeStunServer((List<String>)server.getUrls()));
                    continue;
                }
                String string2 = server.getUrls().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                if (StringsKt.startsWith$default((String)string2, (String)"turn:", (boolean)false, (int)2, null)) {
                    List list = server.getUrls();
                    String string3 = server.getUsername();
                    Intrinsics.checkNotNull((Object)string3);
                    String string4 = server.getCredential();
                    Intrinsics.checkNotNull((Object)string4);
                    servers.add(IceCandidateFactory.INSTANCE.makeTurnServer(list, string3, string4));
                    continue;
                }
                HMSLogger.INSTANCE.w(HMSConfiguration.TAG, "Unknown server received: " + server);
            }
            HMSLogger.d(HMSConfiguration.TAG, "parsed ice-server: " + servers);
            if (!(servers.size() > 0)) {
                boolean bl = false;
                String string = "Expected at least one ice-server in config=" + config;
                throw new IllegalArgumentException(string.toString());
            }
            return new HMSConfiguration((List<? extends PeerConnection.IceServer>)servers);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

