/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.network;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyCallback;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.TelephonyManager;
import androidx.annotation.RequiresApi;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.network.HMSNetworkManager;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.TelephonyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0016H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Llive/hms/video/network/HMSNetworkManagerApi31;", "Llive/hms/video/network/HMSNetworkManager;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "telephonyManager", "Landroid/telephony/TelephonyManager;", "exec", "Ljava/util/concurrent/ExecutorService;", "callback", "Landroid/telephony/TelephonyCallback;", "networkType", "", "getNetworkType", "()Ljava/lang/Integer;", "setNetworkType", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getConnectedNetworkType", "", "start", "", "stop", "lib_release"})
public final class HMSNetworkManagerApi31
extends HMSNetworkManager {
    @NotNull
    private final TelephonyManager telephonyManager;
    @NotNull
    private final ExecutorService exec;
    @NotNull
    private final TelephonyCallback callback;
    @Nullable
    private Integer networkType;

    public HMSNetworkManagerApi31(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        Object object = context.getSystemService("phone");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telephony.TelephonyManager");
        this.telephonyManager = (TelephonyManager)object;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.exec = executorService;
        this.callback = (TelephonyCallback)new TelephonyCallback.DisplayInfoListener(this){
            final /* synthetic */ HMSNetworkManagerApi31 this$0;
            {
                this.this$0 = $receiver;
            }

            public void onDisplayInfoChanged(TelephonyDisplayInfo telephonyDisplayInfo) {
                Intrinsics.checkNotNullParameter((Object)telephonyDisplayInfo, (String)"telephonyDisplayInfo");
                HMSLogger.d("HMSNetworkManager", "telephonyDisplayInfo :: " + telephonyDisplayInfo);
                this.this$0.setNetworkType(telephonyDisplayInfo.getNetworkType());
            }
        };
    }

    @Nullable
    public final Integer getNetworkType() {
        return this.networkType;
    }

    public final void setNetworkType(@Nullable Integer n) {
        this.networkType = n;
    }

    @Override
    @NotNull
    public String getConnectedNetworkType() {
        String string;
        if (Build.VERSION.SDK_INT < 23) {
            return "unknown";
        }
        if (this.isConnectedOverWifi()) {
            string = "wifi";
        } else if (Build.VERSION.SDK_INT >= 31) {
            string = TelephonyUtil.INSTANCE.getNetworkType(this.networkType);
        } else {
            return "cellular";
        }
        return string;
    }

    @Override
    @RequiresApi(value=31)
    public void start() {
        this.telephonyManager.registerTelephonyCallback((Executor)this.exec, this.callback);
    }

    @Override
    @RequiresApi(value=31)
    public void stop() {
        this.telephonyManager.unregisterTelephonyCallback(this.callback);
    }
}

