/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.plugin.video;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSAction;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.events.MediaPluginsAnalyticsFactory;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.RunningAverage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007J%\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007J\u0016\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u001c\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0(J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007J\u0014\u0010*\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0(R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0014`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0014`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0017`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0017`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Llive/hms/video/plugin/video/HMSVideoPluginAnalytics;", "", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Llive/hms/video/events/AnalyticsEventsService;)V", "addedTimestamps", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "setAnalyticsEventsService", "initTime", "peakValueWithMl", "", "peakValueWithoutMl", "pluginAdded", "", "pluginFrameRate", "", "pluginInputFrameRate", "processingAvgsWithMl", "Llive/hms/video/utils/RunningAverage;", "processingAvgsWithoutMl", "addPluginSuccess", "", "name", "added", "inputFrameRate", "(Ljava/lang/String;ILjava/lang/Integer;)V", "clean", "failure", "error", "Llive/hms/video/error/HMSException;", "processTime", "timeWithML", "timeWithoutML", "processWithTime", "processFn", "Lkotlin/Function0;", "removed", "timeInMs", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSVideoPluginAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSVideoPluginAnalytics.kt\nlive/hms/video/plugin/video/HMSVideoPluginAnalytics\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,145:1\n17#2,6:146\n*S KotlinDebug\n*F\n+ 1 HMSVideoPluginAnalytics.kt\nlive/hms/video/plugin/video/HMSVideoPluginAnalytics\n*L\n130#1:146,6\n*E\n"})
public final class HMSVideoPluginAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AnalyticsEventsService analyticsEventsService;
    @NotNull
    private HashMap<String, Long> initTime;
    @NotNull
    private HashMap<String, Long> addedTimestamps;
    @NotNull
    private HashMap<String, RunningAverage> processingAvgsWithMl;
    @NotNull
    private HashMap<String, Double> peakValueWithMl;
    @NotNull
    private HashMap<String, RunningAverage> processingAvgsWithoutMl;
    @NotNull
    private HashMap<String, Double> peakValueWithoutMl;
    @NotNull
    private HashMap<String, Boolean> pluginAdded;
    @NotNull
    private HashMap<String, Integer> pluginInputFrameRate;
    @NotNull
    private HashMap<String, Integer> pluginFrameRate;
    @NotNull
    public static final String TAG = "HMSVideoPluginAnalytics";

    public HMSVideoPluginAnalytics(@NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        this.analyticsEventsService = analyticsEventsService2;
        this.initTime = new HashMap();
        this.addedTimestamps = new HashMap();
        this.processingAvgsWithMl = new HashMap();
        this.peakValueWithMl = new HashMap();
        this.processingAvgsWithoutMl = new HashMap();
        this.peakValueWithoutMl = new HashMap();
        this.pluginAdded = new HashMap();
        this.pluginInputFrameRate = new HashMap();
        this.pluginFrameRate = new HashMap();
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService() {
        return this.analyticsEventsService;
    }

    public final void setAnalyticsEventsService(@NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"<set-?>");
        this.analyticsEventsService = analyticsEventsService2;
    }

    public final void added(@NotNull String name, int inputFrameRate, @Nullable Integer pluginFrameRate) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ((Map)this.pluginAdded).put(name, true);
        ((Map)this.addedTimestamps).put(name, System.currentTimeMillis());
        ((Map)this.processingAvgsWithMl).put(name, new RunningAverage());
        ((Map)this.processingAvgsWithoutMl).put(name, new RunningAverage());
        ((Map)this.peakValueWithMl).put(name, 0.0);
        ((Map)this.peakValueWithoutMl).put(name, 0.0);
        Integer n = inputFrameRate;
        ((Map)this.pluginInputFrameRate).put(name, n);
        if (pluginFrameRate != null) {
            ((Map)this.pluginFrameRate).put(name, pluginFrameRate);
        } else {
            n = inputFrameRate;
            ((Map)this.pluginFrameRate).put(name, n);
        }
    }

    public final void removed(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.pluginAdded.containsKey(name)) {
            long l = System.currentTimeMillis();
            Long l2 = this.addedTimestamps.get(name);
            Intrinsics.checkNotNull((Object)l2);
            long duration = (l - ((Number)l2).longValue()) / (long)1000;
            Long loadTime = this.initTime.get(name);
            RunningAverage runningAverage = this.processingAvgsWithMl.get(name);
            Double avgProcessingTimeWithMl = runningAverage != null ? Double.valueOf(runningAverage.getAvg()) : null;
            RunningAverage runningAverage2 = this.processingAvgsWithoutMl.get(name);
            Double avgProcessingTimeWithoutMl = runningAverage2 != null ? Double.valueOf(runningAverage2.getAvg()) : null;
            Integer inputFrameRate = this.pluginInputFrameRate.get(name);
            Integer pluginFrameRate = this.pluginFrameRate.get(name);
            HMSLogger.INSTANCE.i(TAG, "pluginName = " + name + ", duration = " + duration + ", loadTime = " + loadTime + ", avgProcesstimeWithMl = " + avgProcessingTimeWithMl + ", avgProcesstimeWithoutMl = " + avgProcessingTimeWithoutMl + ", inputFR = " + inputFrameRate + ", pluginFr = " + pluginFrameRate);
            Long l3 = loadTime;
            long l4 = l3 != null ? l3 : 0L;
            Double d = avgProcessingTimeWithMl;
            double d2 = d != null ? d : 0.0;
            Double d3 = avgProcessingTimeWithoutMl;
            double d4 = d3 != null ? d3 : 0.0;
            Double d5 = this.peakValueWithMl.get(name);
            if (d5 == null) {
                d5 = 0.0;
            }
            double d6 = ((Number)d5).doubleValue();
            Double d7 = this.peakValueWithoutMl.get(name);
            if (d7 == null) {
                d7 = 0.0;
            }
            Integer n = inputFrameRate;
            Integer n2 = pluginFrameRate;
            AnalyticsEvent event = MediaPluginsAnalyticsFactory.INSTANCE.stats(name, duration, l4, d2, d4, d6, ((Number)d7).doubleValue(), n != null ? n : 0, n2 != null ? n2 : 0);
            HMSLogger.INSTANCE.i(TAG, "event got = " + event + ", sending to service " + this.analyticsEventsService);
            this.analyticsEventsService.queue(event).flush();
            this.clean(name);
        }
    }

    public final void failure(@NotNull String name, @NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.analyticsEventsService.queue(MediaPluginsAnalyticsFactory.INSTANCE.failure(name, error)).flush();
        this.clean(name);
    }

    public final void addPluginSuccess(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.pluginAdded.get(name), (Object)true)) {
                this.analyticsEventsService.queue(MediaPluginsAnalyticsFactory.INSTANCE.added(name)).flush();
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final void processWithTime(@NotNull String name, @NotNull Function0<Unit> processFn2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(processFn2, (String)"processFn");
            Long time = null;
            try {
                time = this.timeInMs(processFn2);
            }
            catch (HMSException e) {
                HMSException err = ErrorFactory.MediaPluginErrors.INSTANCE.ProcessingFailed(HMSAction.VIDEO_PLUGINS, "Failed during processing of plugin" + e.getMessage());
                HMSLogger.e(TAG, err.toString());
                this.failure(name, err);
                throw err;
            }
            if (((Number)time).longValue() < 0L) break block3;
            RunningAverage runningAverage = this.processingAvgsWithMl.get(name);
            if (runningAverage != null) {
                runningAverage.add(((Number)time).longValue());
            }
        }
    }

    public final void processTime(@NotNull String name, long timeWithML, long timeWithoutML) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (timeWithML > 0L) {
            RunningAverage runningAverage = this.processingAvgsWithMl.get(name);
            if (runningAverage != null) {
                runningAverage.add(timeWithML);
            }
            if (this.peakValueWithMl.containsKey(name)) {
                Double d = this.peakValueWithMl.get(name);
                Intrinsics.checkNotNull((Object)d);
                if (((Number)d).doubleValue() < (double)timeWithML) {
                    ((Map)this.peakValueWithMl).put(name, Double.valueOf(timeWithML));
                }
            }
        }
        if (timeWithoutML > 0L) {
            RunningAverage runningAverage = this.processingAvgsWithoutMl.get(name);
            if (runningAverage != null) {
                runningAverage.add(timeWithoutML);
            }
            if (this.peakValueWithoutMl.containsKey(name)) {
                Double d = this.peakValueWithoutMl.get(name);
                Intrinsics.checkNotNull((Object)d);
                if (((Number)d).doubleValue() < (double)timeWithoutML) {
                    ((Map)this.peakValueWithoutMl).put(name, Double.valueOf(timeWithoutML));
                }
            }
        }
    }

    public final long timeInMs(@NotNull Function0<Unit> processFn2) {
        Intrinsics.checkNotNullParameter(processFn2, (String)"processFn");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        processFn2.invoke();
        long elapsedTime = System.currentTimeMillis() - start$iv;
        return elapsedTime;
    }

    public final void clean(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addedTimestamps.remove(name);
        this.initTime.remove(name);
        this.processingAvgsWithMl.remove(name);
        this.peakValueWithMl.remove(name);
        this.peakValueWithoutMl.remove(name);
        this.processingAvgsWithoutMl.remove(name);
        this.pluginAdded.remove(name);
        this.pluginInputFrameRate.remove(name);
        this.pluginFrameRate.remove(name);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/plugin/video/HMSVideoPluginAnalytics$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

