/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers;

import android.content.Context;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.media.capturers.HMSCapturer;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Llive/hms/video/media/capturers/HMSWavCapturer;", "Llive/hms/video/media/capturers/HMSCapturer;", "context", "Landroid/content/Context;", "sampleRate", "", "numChannels", "bitsPerSample", "(Landroid/content/Context;III)V", "TAG", "", "bytesPer10ms", "getContext", "()Landroid/content/Context;", "fileInputStream", "Ljava/io/InputStream;", "isStarted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "", "close", "", "loadUrl", "rawRes", "readNext10ms", "", "destBuffer", "Ljava/nio/ByteBuffer;", "start", "stop", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSWavCapturer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSWavCapturer.kt\nlive/hms/video/media/capturers/HMSWavCapturer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class HMSWavCapturer
implements HMSCapturer {
    @NotNull
    private final Context context;
    private final int sampleRate;
    private final int numChannels;
    private final int bitsPerSample;
    @Nullable
    private InputStream fileInputStream;
    private int bytesPer10ms;
    @NotNull
    private final String TAG;
    @NotNull
    private final AtomicBoolean isStarted;
    @NotNull
    private final Object lock;

    public HMSWavCapturer(@NotNull Context context, int sampleRate, int numChannels, int bitsPerSample) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.sampleRate = sampleRate;
        this.numChannels = numChannels;
        this.bitsPerSample = bitsPerSample;
        this.bytesPer10ms = -1;
        this.TAG = "HMSWavCapturer";
        this.isStarted = new AtomicBoolean(false);
        this.lock = new Object();
    }

    public /* synthetic */ HMSWavCapturer(Context context, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = 16;
        }
        this(context, n, n2, n3);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AtomicBoolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadUrl(int rawRes) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            HMSLogger.d(this.TAG, "loadUrl");
            this.isStarted.set(true);
            try {
                Unit unit;
                boolean bl2 = false;
                InputStream inputStream = this.fileInputStream;
                if (inputStream != null) {
                    inputStream.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Object object2 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            this.fileInputStream = this.context.getResources().openRawResource(rawRes);
            long WAV_HEADER_SIZE = 44L;
            InputStream inputStream = this.fileInputStream;
            if (inputStream == null) {
                return;
            }
            long skipped = inputStream.skip(WAV_HEADER_SIZE);
            if (skipped < WAV_HEADER_SIZE) {
                HMSLogger.e(this.TAG, "Invalid or corrupt WAV file (header too short).");
                this.isStarted.set(false);
            }
            this.bytesPer10ms = this.sampleRate * (this.bitsPerSample / 8) * this.numChannels * 10 / 1000;
            if (this.bytesPer10ms <= 0) {
                HMSLogger.e(this.TAG, "Invalid WAV file: bytesPer10ms <= 0");
                this.isStarted.set(false);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean readNext10ms(@NotNull ByteBuffer destBuffer) {
        Intrinsics.checkNotNullParameter((Object)destBuffer, (String)"destBuffer");
        Object object = this.lock;
        synchronized (object) {
            byte[] tempBytes;
            block8: {
                block7: {
                    boolean bl = false;
                    if (this.isStarted.get()) break block7;
                    HMSLogger.e(this.TAG, "WAV file not loaded.");
                    boolean bl2 = false;
                    return bl2;
                }
                destBuffer.order(ByteOrder.LITTLE_ENDIAN);
                destBuffer.clear();
                tempBytes = new byte[this.bytesPer10ms];
                InputStream inputStream = this.fileInputStream;
                if (inputStream == null) {
                    boolean bl = false;
                    return bl;
                }
                int n = inputStream.read(tempBytes, 0, this.bytesPer10ms);
                int bytesRead = n;
                if (bytesRead >= this.bytesPer10ms) break block8;
                HMSLogger.d(this.TAG, "End of WAV file reached.");
                this.isStarted.set(false);
                boolean bl = false;
                return bl;
            }
            destBuffer.put(tempBytes);
            destBuffer.flip();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            HMSLogger.d(this.TAG, "close");
            this.isStarted.set(false);
            try {
                Unit unit;
                boolean bl2 = false;
                InputStream inputStream = this.fileInputStream;
                if (inputStream != null) {
                    inputStream.close();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object2 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object3 = object2;
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void dispose() {
        HMSCapturer.DefaultImpls.dispose(this);
    }
}

