/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers;

import android.content.Context;
import android.graphics.Bitmap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.capturers.HMSCameraCapturer;
import live.hms.video.media.capturers.HMSCapturer;
import live.hms.video.media.capturers.camera.CameraControl;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sdk.HmsVideoFrameListener;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HmsCamera;
import live.hms.video.utils.SharedEglContext;
import live.hms.video.utils.YuvFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera2Session;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraSession;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.CapturerObserver;
import org.webrtc.EglBase;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\f\b\u0000\u0018\u0000 J2\u00020\u0001:\u0001JB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020*J\u000e\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020,H\u0016J\b\u00101\u001a\u0004\u0018\u00010\u000fJ\u0014\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020503H\u0002J\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020/03J\u0006\u00107\u001a\u00020(J\u0010\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020:H\u0002J\u001b\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020\u0007H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b=\u0010>J\b\u0010?\u001a\u00020,H\u0016J\b\u0010@\u001a\u00020,H\u0016J-\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020\u00152\b\u0010C\u001a\u0004\u0018\u00010\u00172\b\u0010D\u001a\u0004\u0018\u00010EH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ#\u0010A\u001a\u00020,2\u0006\u0010G\u001a\u00020\u00172\b\u0010D\u001a\u0004\u0018\u00010EH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010HJ\u001b\u0010A\u001a\u00020,2\b\u0010D\u001a\u0004\u0018\u00010EH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010IR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Llive/hms/video/media/capturers/HMSCameraCapturer;", "Llive/hms/video/media/capturers/HMSCapturer;", "context", "Landroid/content/Context;", "source", "Lorg/webrtc/VideoSource;", "settings", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Landroid/content/Context;Lorg/webrtc/VideoSource;Llive/hms/video/media/settings/HMSVideoTrackSettings;Llive/hms/video/events/AnalyticsEventsService;)V", "cameraCaptureObserver", "live/hms/video/media/capturers/HMSCameraCapturer$cameraCaptureObserver$1", "Llive/hms/video/media/capturers/HMSCameraCapturer$cameraCaptureObserver$1;", "cameraControls", "Llive/hms/video/media/capturers/camera/CameraControl;", "capturer", "Lorg/webrtc/CameraVideoCapturer;", "getContext", "()Landroid/content/Context;", "currentCameraDeviceId", "", "currentCameraFace", "Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "getCurrentCameraFace", "()Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "setCurrentCameraFace", "(Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;)V", "hmsCamera", "Llive/hms/video/utils/HmsCamera;", "isStarted", "", "()Z", "setStarted", "(Z)V", "getSource", "()Lorg/webrtc/VideoSource;", "setSource", "(Lorg/webrtc/VideoSource;)V", "surTexture", "Lorg/webrtc/SurfaceTextureHelper;", "videoFrameListener", "Llive/hms/video/sdk/HmsVideoFrameListener;", "addVideoFrameCapturer", "", "changeInputFps", "fps", "", "dispose", "getCameraControl", "getClosestSizeAndFps", "Lkotlin/Pair;", "Lorg/webrtc/Size;", "Lorg/webrtc/CameraEnumerationAndroid$CaptureFormat$FramerateRange;", "getInputResolution", "getSurfaceTexture", "processFrameAndFireCallback", "frame", "Lorg/webrtc/VideoFrame;", "setSettings", "newSettings", "setSettings$lib_release", "(Llive/hms/video/media/settings/HMSVideoTrackSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "stop", "switchCamera", "deviceId", "givenFace", "onAction", "Llive/hms/video/sdk/HMSActionResultListener;", "(Ljava/lang/String;Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;Llive/hms/video/sdk/HMSActionResultListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "face", "(Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;Llive/hms/video/sdk/HMSActionResultListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Llive/hms/video/sdk/HMSActionResultListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHMSCameraCapturer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HMSCameraCapturer.kt\nlive/hms/video/media/capturers/HMSCameraCapturer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,377:1\n1855#2,2:378\n*S KotlinDebug\n*F\n+ 1 HMSCameraCapturer.kt\nlive/hms/video/media/capturers/HMSCameraCapturer\n*L\n304#1:378,2\n*E\n"})
public final class HMSCameraCapturer
implements HMSCapturer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private VideoSource source;
    @NotNull
    private HMSVideoTrackSettings settings;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @Nullable
    private HmsVideoFrameListener videoFrameListener;
    @NotNull
    private final CameraVideoCapturer capturer;
    @NotNull
    private final SurfaceTextureHelper surTexture;
    @Nullable
    private CameraControl cameraControls;
    private boolean isStarted;
    @Nullable
    private HMSVideoTrackSettings.CameraFacing currentCameraFace;
    @NotNull
    private final cameraCaptureObserver.1 cameraCaptureObserver;
    @NotNull
    private HmsCamera hmsCamera;
    @NotNull
    private String currentCameraDeviceId;
    @NotNull
    public static final String TAG = "HMSVideoCapturer";
    @NotNull
    private static final String LOCAL_CAMERA_CAPTURER_THREAD = "local-camera-capturer-thread";

    public HMSCameraCapturer(@NotNull Context context, @NotNull VideoSource source, @NotNull HMSVideoTrackSettings settings, @NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        this.context = context;
        this.source = source;
        this.settings = settings;
        this.analyticsEventsService = analyticsEventsService2;
        SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create((String)LOCAL_CAMERA_CAPTURER_THREAD, (EglBase.Context)SharedEglContext.INSTANCE.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)surfaceTextureHelper, (String)"create(\n    LOCAL_CAMERA\u2026redEglContext.context\n  )");
        this.surTexture = surfaceTextureHelper;
        this.cameraCaptureObserver = new CapturerObserver(this){
            final /* synthetic */ HMSCameraCapturer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCapturerStarted(boolean success) {
                this.this$0.getSource().getCapturerObserver().onCapturerStarted(success);
            }

            public void onCapturerStopped() {
                this.this$0.getSource().getCapturerObserver().onCapturerStopped();
            }

            public void onFrameCaptured(@Nullable VideoFrame frame) {
                block1: {
                    this.this$0.getSource().getCapturerObserver().onFrameCaptured(frame);
                    HmsVideoFrameListener hmsVideoFrameListener = HMSCameraCapturer.access$getVideoFrameListener$p(this.this$0);
                    if (hmsVideoFrameListener == null) break block1;
                    HmsVideoFrameListener hmsVideoFrameListener2 = hmsVideoFrameListener;
                    HMSCameraCapturer hMSCameraCapturer = this.this$0;
                    HmsVideoFrameListener it = hmsVideoFrameListener2;
                    boolean bl = false;
                    VideoFrame videoFrame = frame;
                    if (videoFrame != null) {
                        VideoFrame it2 = videoFrame;
                        boolean bl2 = false;
                        HMSCameraCapturer.access$processFrameAndFireCallback(hMSCameraCapturer, it2);
                    }
                }
            }
        };
        this.hmsCamera = new HmsCamera(this.context, this.analyticsEventsService);
        this.currentCameraDeviceId = this.hmsCamera.getDeviceId(this.settings.getCameraFacing());
        CameraVideoCapturer cameraVideoCapturer = this.hmsCamera.getEnumerator().createCapturer(this.currentCameraDeviceId, new CameraVideoCapturer.CameraEventsHandler(this){
            @NotNull
            private final String logPrefix;
            {
                this.logPrefix = "DeviceName=" + $receiver.currentCameraDeviceId + " CameraVideoCapturer.CameraEventsHandler.";
            }

            @NotNull
            public final String getLogPrefix() {
                return this.logPrefix;
            }

            public void onCameraError(@Nullable String errorDescription) {
                HMSLogger.e(HMSCameraCapturer.TAG, this.logPrefix + "onCameraError: " + errorDescription);
            }

            public void onCameraDisconnected() {
                HMSLogger.d(HMSCameraCapturer.TAG, this.logPrefix + "onCameraDisconnected");
            }

            public void onCameraFreezed(@Nullable String errorDescription) {
                HMSLogger.d(HMSCameraCapturer.TAG, this.logPrefix + "onCameraFreezed: " + errorDescription);
            }

            public void onCameraOpening(@Nullable String cameraName) {
                HMSLogger.d(HMSCameraCapturer.TAG, this.logPrefix + "onCameraOpening: " + cameraName);
            }

            public void onFirstFrameAvailable() {
                HMSLogger.d(HMSCameraCapturer.TAG, this.logPrefix + "onFirstFrameAvailable");
            }

            public void onCameraClosed() {
                HMSLogger.d(HMSCameraCapturer.TAG, this.logPrefix + "onCameraClosed");
            }
        }, arg_0 -> HMSCameraCapturer._init_$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)cameraVideoCapturer, (String)"hmsCamera.getEnumerator(\u2026(session)\n       }\n\n    }");
        this.capturer = cameraVideoCapturer;
        this.capturer.initialize(this.surTexture, this.context, (CapturerObserver)this.cameraCaptureObserver);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final VideoSource getSource() {
        return this.source;
    }

    public final void setSource(@NotNull VideoSource videoSource) {
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"<set-?>");
        this.source = videoSource;
    }

    public final boolean isStarted() {
        return this.isStarted;
    }

    public final void setStarted(boolean bl) {
        this.isStarted = bl;
    }

    @Nullable
    public final HMSVideoTrackSettings.CameraFacing getCurrentCameraFace() {
        return this.currentCameraFace;
    }

    public final void setCurrentCameraFace(@Nullable HMSVideoTrackSettings.CameraFacing cameraFacing) {
        this.currentCameraFace = cameraFacing;
    }

    @Nullable
    public final Object setSettings$lib_release(@NotNull HMSVideoTrackSettings newSettings, @NotNull Continuation<? super Unit> $completion) {
        HMSVideoTrackSettings previousSettings = this.settings;
        this.settings = newSettings;
        if (!Intrinsics.areEqual((Object)newSettings.getResolution(), (Object)previousSettings.getResolution()) || newSettings.getMaxFrameRate() != previousSettings.getMaxFrameRate()) {
            Pair<Size, CameraEnumerationAndroid.CaptureFormat.FramerateRange> config = this.getClosestSizeAndFps();
            Size size = (Size)config.getFirst();
            CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = (CameraEnumerationAndroid.CaptureFormat.FramerateRange)config.getSecond();
            if (!this.isStarted) {
                this.capturer.startCapture(size.width, size.height, fpsRange.max);
                this.isStarted = true;
            } else {
                this.capturer.changeCaptureFormat(size.width, size.height, fpsRange.max);
            }
        }
        if (newSettings.getCameraFacing() != previousSettings.getCameraFacing()) {
            Object object = this.switchCamera(newSettings.getCameraFacing(), null, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object switchCamera(@Nullable HMSActionResultListener onAction, @NotNull Continuation<? super Unit> $completion) {
        HMSVideoTrackSettings.CameraFacing cameraFacing;
        switch (WhenMappings.$EnumSwitchMapping$0[this.settings.getCameraFacing().ordinal()]) {
            case 1: {
                cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
                break;
            }
            case 2: {
                cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HMSVideoTrackSettings.CameraFacing newFace = cameraFacing;
        Object object = this.switchCamera(newFace, onAction, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object switchCamera(@NotNull HMSVideoTrackSettings.CameraFacing var1_1, @Nullable HMSActionResultListener var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof switchCamera.2)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ HMSCameraCapturer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.switchCamera(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = this;
                $this$switchCamera_u24lambda_u242 = var4_7;
                $i$a$-runCatching-HMSCameraCapturer$switchCamera$3 = false;
                deviceId = $this$switchCamera_u24lambda_u242.hmsCamera.getDeviceId((HMSVideoTrackSettings.CameraFacing)face);
                $continuation.label = 1;
                v0 = $this$switchCamera_u24lambda_u242.switchCamera(deviceId, (HMSVideoTrackSettings.CameraFacing)face, (HMSActionResultListener)onAction, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var10_6) goto lbl23
lbl22:
                // 1 sources

                return var10_6;
lbl23:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                $i$a$-runCatching-HMSCameraCapturer$switchCamera$3 = false;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    var5_8 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable var6_12) {
                    var5_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var6_12));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void addVideoFrameCapturer(@NotNull HmsVideoFrameListener videoFrameListener) {
        Intrinsics.checkNotNullParameter((Object)videoFrameListener, (String)"videoFrameListener");
        this.videoFrameListener = videoFrameListener;
    }

    private final void processFrameAndFireCallback(VideoFrame frame) {
        YuvFrame yuvFrame = new YuvFrame(frame, 0, frame.getTimestampNs());
        Bitmap inputFrameBitmap = yuvFrame.getBitmap();
        HmsVideoFrameListener hmsVideoFrameListener = this.videoFrameListener;
        if (hmsVideoFrameListener != null) {
            Intrinsics.checkNotNullExpressionValue((Object)inputFrameBitmap, (String)"inputFrameBitmap");
            hmsVideoFrameListener.onFrameCaptured(inputFrameBitmap);
        }
        this.videoFrameListener = null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object switchCamera(@NotNull String var1_1, @Nullable HMSVideoTrackSettings.CameraFacing var2_2, @Nullable HMSActionResultListener var3_3, @NotNull Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof switchCamera.4)) ** GOTO lbl-1000
        var9_5 = var4_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                final /* synthetic */ HMSCameraCapturer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.switchCamera(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (Intrinsics.areEqual((Object)deviceId, (Object)this.currentCameraDeviceId)) {
                    HMSLogger.INSTANCE.w("HMSVideoCapturer", "switchCamera: Ignoring request to switch from " + this.currentCameraDeviceId + " -> " + (String)deviceId);
                    return Unit.INSTANCE;
                }
                this.currentCameraFace = givenFace;
                v0 = givenFace;
                if (v0 == null) {
                    v0 = this.hmsCamera.getCameraFaceFromId((String)deviceId);
                }
                if ((face = v0) == null) {
                    error = ErrorFactory.TracksErrors.GenericTrack$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "It cannot be determined if " + (String)deviceId + " is front facing or back facing. Camera was not switched.", null, null, false, 12, null);
                    v1 = onAction;
                    if (v1 != null) {
                        v1.onError(error);
                    }
                    return Unit.INSTANCE;
                }
                deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                this.capturer.switchCamera(new CameraVideoCapturer.CameraSwitchHandler(this, (HMSVideoTrackSettings.CameraFacing)face, (String)deviceId, (HMSActionResultListener)onAction, (CompletableDeferred<String>)deferred){
                    final /* synthetic */ HMSCameraCapturer this$0;
                    final /* synthetic */ HMSVideoTrackSettings.CameraFacing $face;
                    final /* synthetic */ String $deviceId;
                    final /* synthetic */ HMSActionResultListener $onAction;
                    final /* synthetic */ CompletableDeferred<String> $deferred;
                    {
                        this.this$0 = $receiver;
                        this.$face = $face;
                        this.$deviceId = $deviceId;
                        this.$onAction = $onAction;
                        this.$deferred = $deferred;
                    }

                    public void onCameraSwitchDone(boolean isFrontCamera) {
                        HMSCameraCapturer.access$getSettings$p(this.this$0).setCameraFacing(this.$face);
                        HMSCameraCapturer.access$setCurrentCameraDeviceId$p(this.this$0, this.$deviceId);
                        HMSActionResultListener hMSActionResultListener = this.$onAction;
                        if (hMSActionResultListener != null) {
                            hMSActionResultListener.onSuccess();
                        }
                        this.$deferred.complete(null);
                    }

                    public void onCameraSwitchError(@NotNull String errorDescription) {
                        Intrinsics.checkNotNullParameter((Object)errorDescription, (String)"errorDescription");
                        HMSException error = ErrorFactory.TracksErrors.GenericTrack$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, errorDescription, null, null, false, 28, null);
                        error.setTerminal(false);
                        HMSActionResultListener hMSActionResultListener = this.$onAction;
                        if (hMSActionResultListener != null) {
                            hMSActionResultListener.onError(error);
                        }
                        this.$deferred.complete((Object)errorDescription);
                    }
                }, var1_1);
                $continuation.label = 1;
                v2 = deferred.await((Continuation)$continuation);
                if (v2 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl35
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                if ((error = (String)v2) != null) {
                    HMSLogger.e("HMSVideoCapturer", "Implement onAction to be made aware of these. " + error);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void start() {
        Pair<Size, CameraEnumerationAndroid.CaptureFormat.FramerateRange> config = this.getClosestSizeAndFps();
        Size size = (Size)config.getFirst();
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = (CameraEnumerationAndroid.CaptureFormat.FramerateRange)config.getSecond();
        this.capturer.startCapture(size.width, size.height, fpsRange.max);
        this.isStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future2 = executor.submit(() -> HMSCameraCapturer.stop$lambda$3(this));
        try {
            future2.get(3L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            future2.cancel(true);
        }
        catch (Exception exception) {
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Override
    public void dispose() {
        HMSCapturer.DefaultImpls.dispose(this);
        try {
            boolean bl = false;
            this.source.dispose();
            this.surTexture.stopListening();
            this.surTexture.dispose();
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final Pair<Size, CameraEnumerationAndroid.CaptureFormat.FramerateRange> getClosestSizeAndFps() {
        ArrayList<Size> sizes = new ArrayList<Size>();
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> fpsRanges = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        boolean isPotraitResolutionAvailable = false;
        List list = this.hmsCamera.getEnumerator().getSupportedFormats(this.currentCameraDeviceId);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"hmsCamera.getEnumerator(\u2026ts(currentCameraDeviceId)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CameraEnumerationAndroid.CaptureFormat format = (CameraEnumerationAndroid.CaptureFormat)element$iv;
            boolean bl = false;
            if (format.height > format.width) {
                isPotraitResolutionAvailable = true;
            }
            sizes.add(new Size(format.width, format.height));
            fpsRanges.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(format.framerate.min, format.framerate.max));
        }
        if (sizes.isEmpty() || fpsRanges.isEmpty()) {
            HMSException videoPublishException = ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "camera", "Camera occupied. Sizes was " + sizes + " and fpsRanges are " + fpsRanges + " both must be non-empty.", false, null, null, 56, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(videoPublishException)).flush();
            throw videoPublishException;
        }
        HMSLogger.d(TAG, "[Device=" + this.currentCameraDeviceId + "] Supported Sizes: " + sizes);
        HMSLogger.d(TAG, "[Device=" + this.currentCameraDeviceId + "] Supported FrameRate Ranges: " + fpsRanges);
        int inputWidth = this.settings.getResolution().getWidth();
        int inputHeight = this.settings.getResolution().getHeight();
        if (!isPotraitResolutionAvailable) {
            inputWidth = Math.max(this.settings.getResolution().getWidth(), this.settings.getResolution().getHeight());
            inputHeight = Math.min(this.settings.getResolution().getWidth(), this.settings.getResolution().getHeight());
        }
        Size closestSize = CameraEnumerationAndroid.getClosestSupportedSize((List)sizes, (int)inputWidth, (int)inputHeight);
        CameraEnumerationAndroid.CaptureFormat.FramerateRange closesFpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange((List)fpsRanges, (int)this.settings.getMaxFrameRate());
        HMSLogger.d(TAG, "[Device=" + this.currentCameraDeviceId + "] Using Size=" + closestSize + " FrameRate Range=" + closesFpsRange);
        return new Pair((Object)closestSize, (Object)closesFpsRange);
    }

    @Nullable
    public final CameraControl getCameraControl() {
        return this.cameraControls;
    }

    @NotNull
    public final SurfaceTextureHelper getSurfaceTexture() {
        return this.surTexture;
    }

    @NotNull
    public final Pair<Size, Integer> getInputResolution() {
        return new Pair((Object)new Size(this.settings.getResolution().getWidth(), this.settings.getResolution().getHeight()), (Object)this.settings.getMaxFrameRate());
    }

    public final void changeInputFps(int fps) {
        this.capturer.changeCaptureFormat(this.settings.getResolution().getWidth(), this.settings.getResolution().getHeight(), fps);
    }

    private static final void _init_$lambda$1(HMSCameraCapturer this$0, CameraSession it) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Camera2Session camera2Session = it instanceof Camera2Session ? (Camera2Session)it : null;
            if (camera2Session == null) break block2;
            Camera2Session session = camera2Session;
            boolean bl = false;
            if (this$0.cameraControls == null) {
                this$0.cameraControls = new CameraControl(this$0.surTexture.getHandler(), this$0.context, this$0.analyticsEventsService);
            }
            CameraControl cameraControl = this$0.cameraControls;
            if (cameraControl != null) {
                cameraControl.onCameraSessionUpdate$lib_release(session);
            }
        }
    }

    private static final void stop$lambda$3(HMSCameraCapturer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.capturer.stopCapture();
    }

    public static final /* synthetic */ HMSVideoTrackSettings access$getSettings$p(HMSCameraCapturer $this) {
        return $this.settings;
    }

    public static final /* synthetic */ void access$setCurrentCameraDeviceId$p(HMSCameraCapturer $this, String string) {
        $this.currentCameraDeviceId = string;
    }

    public static final /* synthetic */ HmsVideoFrameListener access$getVideoFrameListener$p(HMSCameraCapturer $this) {
        return $this.videoFrameListener;
    }

    public static final /* synthetic */ void access$processFrameAndFireCallback(HMSCameraCapturer $this, VideoFrame frame) {
        $this.processFrameAndFireCallback(frame);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSVideoTrackSettings.CameraFacing.values().length];
            try {
                nArray[HMSVideoTrackSettings.CameraFacing.FRONT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSVideoTrackSettings.CameraFacing.BACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llive/hms/video/media/capturers/HMSCameraCapturer$Companion;", "", "()V", "LOCAL_CAMERA_CAPTURER_THREAD", "", "TAG", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

