/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.events;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.sdk.models.enums.HMSAnalyticsEventLevel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJN\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u00a8\u0006\u0016"}, d2={"Llive/hms/video/events/MediaPluginsAnalyticsFactory;", "", "()V", "added", "Llive/hms/video/events/AnalyticsEvent;", "pluginName", "", "failure", "error", "Llive/hms/video/error/HMSException;", "stats", "duration", "", "loadTime", "avgProcessingTimeWithMl", "", "avgProcessingTimeWithoutMl", "peakValueWithMl", "peakValueWithoutMl", "inputFrameRate", "", "pluginFrameRate", "lib_release"})
public final class MediaPluginsAnalyticsFactory {
    @NotNull
    public static final MediaPluginsAnalyticsFactory INSTANCE = new MediaPluginsAnalyticsFactory();

    private MediaPluginsAnalyticsFactory() {
    }

    @NotNull
    public final AnalyticsEvent failure(@NotNull String pluginName, @NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        String name = "mediaPlugin.failed";
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ((Map)properties).put("plugin_name", pluginName);
        properties.putAll((Map)error.toAnalyticsProperties());
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent added(@NotNull String pluginName) {
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        String name = "mediaPlugin.added";
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ((Map)properties).put("plugin_name", pluginName);
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent stats(@NotNull String pluginName, long duration, long loadTime, double avgProcessingTimeWithMl, double avgProcessingTimeWithoutMl, double peakValueWithMl, double peakValueWithoutMl, int inputFrameRate, int pluginFrameRate) {
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        String name = "mediaPlugin.stats";
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ((Map)properties).put("plugin_name", pluginName);
        Number number = duration;
        ((Map)properties).put("duration", number);
        number = loadTime;
        ((Map)properties).put("load_time", number);
        number = avgProcessingTimeWithMl;
        ((Map)properties).put("avg_processing_time", number);
        number = avgProcessingTimeWithoutMl;
        ((Map)properties).put("avg_processing_time_withoutML", number);
        number = peakValueWithMl;
        ((Map)properties).put("peak_processing_time", number);
        number = peakValueWithoutMl;
        ((Map)properties).put("peak_processing_time_withoutML", number);
        number = inputFrameRate;
        ((Map)properties).put("input_frame_rate", number);
        number = pluginFrameRate;
        ((Map)properties).put("plugin_frame_rate", number);
        return new AnalyticsEvent(name, level, false, properties);
    }
}

