/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import live.hms.video.connection.degredation.Audio;
import live.hms.video.connection.degredation.ConnectionInfo;
import live.hms.video.connection.degredation.Peer;
import live.hms.video.connection.degredation.StatsBundle;
import live.hms.video.connection.degredation.Track;
import live.hms.video.connection.degredation.Video;
import live.hms.video.connection.degredation.WebrtcStats;
import live.hms.video.connection.stats.BitrateCalculator;
import live.hms.video.connection.stats.HMSLocalAudioStats;
import live.hms.video.connection.stats.HMSLocalVideoStats;
import live.hms.video.connection.stats.HMSRTCStats;
import live.hms.video.connection.stats.HMSRTCStatsReport;
import live.hms.video.connection.stats.HMSRemoteAudioStats;
import live.hms.video.connection.stats.HMSRemoteVideoStats;
import live.hms.video.connection.stats.HMSStatsObserver;
import live.hms.video.media.settings.HMSLayer;
import live.hms.video.media.settings.HMSVideoResolution;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.sdk.PublishConnection;
import live.hms.video.sdk.SubscribeConnection;
import live.hms.video.sdk.models.HMSLocalPeer;
import live.hms.video.sdk.models.HMSPeer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00100\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002JB\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Llive/hms/video/sdk/BundleToStatsObserver;", "", "()V", "bitrateCalculator", "Llive/hms/video/connection/stats/BitrateCalculator;", "convertBundleToStatsObserverEvents", "", "bundle", "Llive/hms/video/connection/degredation/StatsBundle;", "hmsStatsObserver", "Llive/hms/video/connection/stats/HMSStatsObserver;", "getTrackForId", "Lkotlin/Function1;", "", "Llive/hms/video/media/tracks/HMSTrack;", "getRemotePeerForTrackId", "Llive/hms/video/sdk/models/HMSPeer;", "getLocalPeer", "Lkotlin/Function0;", "Llive/hms/video/sdk/models/HMSLocalPeer;", "layerSortOrder", "", "hmsLayer", "Llive/hms/video/media/settings/HMSLayer;", "sendOverallRtcStats", "audioPubConnection", "Llive/hms/video/sdk/PublishConnection;", "videoPubConnection", "audioSubConnection", "Llive/hms/video/sdk/SubscribeConnection;", "videoSubConnection", "subscribeRoundTripTime", "", "publishRoundTripTime", "lib_release"})
@SourceDebugExtension(value={"SMAP\nBundleToStatsObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleToStatsObserver.kt\nlive/hms/video/sdk/BundleToStatsObserver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n288#2,2:287\n1002#2,2:290\n1#3:289\n*S KotlinDebug\n*F\n+ 1 BundleToStatsObserver.kt\nlive/hms/video/sdk/BundleToStatsObserver\n*L\n52#1:287,2\n201#1:290,2\n*E\n"})
public final class BundleToStatsObserver {
    @NotNull
    private final BitrateCalculator bitrateCalculator = new BitrateCalculator();

    public final void convertBundleToStatsObserverEvents(@NotNull StatsBundle bundle, @Nullable HMSStatsObserver hmsStatsObserver, @NotNull Function1<? super String, ? extends HMSTrack> getTrackForId, @NotNull Function1<? super String, ? extends HMSPeer> getRemotePeerForTrackId, @NotNull Function0<HMSLocalPeer> getLocalPeer) {
        block27: {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter(getTrackForId, (String)"getTrackForId");
            Intrinsics.checkNotNullParameter(getRemotePeerForTrackId, (String)"getRemotePeerForTrackId");
            Intrinsics.checkNotNullParameter(getLocalPeer, (String)"getLocalPeer");
            PublishConnection audioPubConnection = new PublishConnection(0L, null, 0L, 0L, 15, null);
            PublishConnection videoPubConnection = new PublishConnection(0L, null, 0L, 0L, 15, null);
            SubscribeConnection audioSubConnection = new SubscribeConnection(0L, null, 0L, 0L, 15, null);
            SubscribeConnection videoSubConnection = new SubscribeConnection(0L, null, 0L, 0L, 15, null);
            List localVideoStats = new ArrayList();
            double publishRoundTripTime = 0.0;
            double subscribeRoundTripTime = 0.0;
            HMSTrack localVideoTrack = null;
            for (Map.Entry<String, WebrtcStats> item : bundle.getAllStats().entrySet()) {
                long bytesReceived;
                String[] stringArray;
                String[] screenShareTrack;
                long bytesSent;
                double bitrate;
                WebrtcStats stat = item.getValue();
                if (stat instanceof Peer) continue;
                if (stat instanceof Track.LocalTrack.LocalVideo) {
                    String[] stringArray2;
                    bitrate = this.bitrateCalculator.getBitrateFromTrackUpdatePrev((Track)stat);
                    BigInteger bigInteger = ((Track.LocalTrack.LocalVideo)stat).getBytesTransported();
                    bytesSent = bigInteger != null ? bigInteger.longValue() : 0L;
                    String string = ((Track.LocalTrack.LocalVideo)stat).getTrackIdentifier();
                    if (string == null) {
                        string = "";
                    }
                    localVideoTrack = (HMSTrack)getTrackForId.invoke((Object)string);
                    Object object = (HMSLocalPeer)getLocalPeer.invoke();
                    if (object != null && (object = ((HMSPeer)object).getAuxiliaryTracks()) != null) {
                        Object v3;
                        block26: {
                            Iterable $this$firstOrNull$iv = (Iterable)object;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                HMSTrack it = (HMSTrack)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getSource(), (Object)"screen")) continue;
                                v3 = element$iv;
                                break block26;
                            }
                            v3 = null;
                        }
                        stringArray2 = v3;
                    } else {
                        stringArray2 = screenShareTrack = null;
                    }
                    if (localVideoTrack == null && screenShareTrack != null) {
                        Number number = ((Track.LocalTrack.LocalVideo)stat).getFrameRate();
                        HMSLocalVideoStats screenShareStat = new HMSLocalVideoStats(((Track.LocalTrack.LocalVideo)stat).getJitter(), ((Track.LocalTrack.LocalVideo)stat).getRoundTripTime(), bytesSent, bitrate, ((Track.LocalTrack.LocalVideo)stat).getResolution(), number != null ? Double.valueOf(number.doubleValue()) : null, ((Track.LocalTrack.LocalVideo)stat).getQualityLimitations(), ((Track.LocalTrack.LocalVideo)stat).getHmsLayer(), ((Track.LocalTrack.LocalVideo)stat).getPacketLoss(), ((Track.LocalTrack.LocalVideo)stat).getPacketsSent());
                        videoPubConnection.getAvailableOutgoingBitrates().add(bitrate);
                        if (bytesSent > 0L) {
                            videoPubConnection.setBytesSent(videoPubConnection.getBytesSent() + bytesSent);
                        }
                        Long l = ((Track.LocalTrack.LocalVideo)stat).getPacketsSent();
                        if ((l != null ? l : 0L) > 0L) {
                            Long l2 = ((Track.LocalTrack.LocalVideo)stat).getPacketsSent();
                            videoPubConnection.setPacketsSent(videoPubConnection.getPacketsSent() + (l2 != null ? l2 : 0L));
                        }
                        HMSStatsObserver hMSStatsObserver = hmsStatsObserver;
                        if (hMSStatsObserver != null) {
                            hMSStatsObserver.onLocalVideoStats(CollectionsKt.listOf((Object)screenShareStat), (HMSTrack)screenShareTrack, (HMSPeer)getLocalPeer.invoke());
                        }
                        continue;
                    }
                    stringArray = (String[])localVideoStats;
                    Number number = ((Track.LocalTrack.LocalVideo)stat).getFrameRate();
                    stringArray.add(new HMSLocalVideoStats(((Track.LocalTrack.LocalVideo)stat).getJitter(), ((Track.LocalTrack.LocalVideo)stat).getRoundTripTime(), bytesSent, bitrate, ((Track.LocalTrack.LocalVideo)stat).getResolution(), number != null ? Double.valueOf(number.doubleValue()) : null, ((Track.LocalTrack.LocalVideo)stat).getQualityLimitations(), ((Track.LocalTrack.LocalVideo)stat).getHmsLayer(), ((Track.LocalTrack.LocalVideo)stat).getPacketLoss(), ((Track.LocalTrack.LocalVideo)stat).getPacketsSent()));
                    videoPubConnection.getAvailableOutgoingBitrates().add(bitrate);
                    if (bytesSent > 0L) {
                        videoPubConnection.setBytesSent(videoPubConnection.getBytesSent() + bytesSent);
                    }
                    Long l = ((Track.LocalTrack.LocalVideo)stat).getPacketsSent();
                    if ((l != null ? l : 0L) > 0L) {
                        Long l3 = ((Track.LocalTrack.LocalVideo)stat).getPacketsSent();
                        videoPubConnection.setPacketsSent(videoPubConnection.getPacketsSent() + (l3 != null ? l3 : 0L));
                    }
                    videoPubConnection.setPacketLoss(((Track.LocalTrack.LocalVideo)stat).getPacketLoss());
                    continue;
                }
                if (stat instanceof Track.LocalTrack.LocalAudio) {
                    bitrate = this.bitrateCalculator.getBitrateFromTrackUpdatePrev((Track)stat);
                    BigInteger bigInteger = ((Track.LocalTrack.LocalAudio)stat).getBytesTransported();
                    bytesSent = bigInteger != null ? bigInteger.longValue() : 0L;
                    HMSStatsObserver hMSStatsObserver = hmsStatsObserver;
                    if (hMSStatsObserver != null) {
                        BigInteger bigInteger2 = ((Track.LocalTrack.LocalAudio)stat).getBytesTransported();
                        screenShareTrack = new String[]{"_"};
                        hMSStatsObserver.onLocalAudioStats(new HMSLocalAudioStats(((Track.LocalTrack.LocalAudio)stat).getJitter(), ((Track.LocalTrack.LocalAudio)stat).getRoundTripTime(), bigInteger2 != null ? Long.valueOf(bigInteger2.longValue()) : null, bitrate, ((Track.LocalTrack.LocalAudio)stat).getPacketLoss(), ((Track.LocalTrack.LocalAudio)stat).getPacketsSent()), (HMSTrack)getTrackForId.invoke(StringsKt.split$default((CharSequence)item.getKey(), (String[])screenShareTrack, (boolean)false, (int)0, (int)6, null).get(0)), (HMSPeer)getLocalPeer.invoke());
                    }
                    audioPubConnection.getAvailableOutgoingBitrates().add(bitrate);
                    if (bytesSent > 0L) {
                        audioPubConnection.setBytesSent(audioPubConnection.getBytesSent() + bytesSent);
                    }
                    Long l = ((Track.LocalTrack.LocalAudio)stat).getPacketsSent();
                    if ((l != null ? l : 0L) > 0L) {
                        Long l4 = ((Track.LocalTrack.LocalAudio)stat).getPacketsSent();
                        audioPubConnection.setPacketsSent(audioPubConnection.getPacketsSent() + (l4 != null ? l4 : 0L));
                    }
                    audioPubConnection.setPacketLoss(((Track.LocalTrack.LocalAudio)stat).getPacketLoss());
                    continue;
                }
                if (stat instanceof Audio) {
                    bitrate = this.bitrateCalculator.getBitrateFromTrackUpdatePrev((Track)stat);
                    BigInteger bigInteger = ((Audio)stat).getBytesTransported();
                    bytesReceived = bigInteger != null ? bigInteger.longValue() : 0L;
                    Audio $this$convertBundleToStatsObserverEvents_u24lambda_u241 = (Audio)stat;
                    boolean bl = false;
                    HMSRemoteAudioStats audioStats = new HMSRemoteAudioStats($this$convertBundleToStatsObserverEvents_u24lambda_u241.getJitter(), bytesReceived, bitrate, $this$convertBundleToStatsObserverEvents_u24lambda_u241.getPacketsReceived(), $this$convertBundleToStatsObserverEvents_u24lambda_u241.getPacketsLost());
                    HMSStatsObserver hMSStatsObserver = hmsStatsObserver;
                    if (hMSStatsObserver != null) {
                        stringArray = new String[]{"_"};
                        HMSTrack hMSTrack = (HMSTrack)getTrackForId.invoke(StringsKt.split$default((CharSequence)item.getKey(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0));
                        stringArray = new String[]{"_"};
                        hMSStatsObserver.onRemoteAudioStats(audioStats, hMSTrack, (HMSPeer)getRemotePeerForTrackId.invoke(StringsKt.split$default((CharSequence)item.getKey(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)));
                    }
                    if (bytesReceived > 0L) {
                        audioSubConnection.setBytesReceived(audioSubConnection.getBytesReceived() + bytesReceived);
                    }
                    audioSubConnection.getAvailableIncomingBitrates().add(bitrate);
                    Long l = ((Audio)stat).getPacketsReceived();
                    if ((l != null ? l : 0L) <= 0L) continue;
                    Long l5 = ((Audio)stat).getPacketsReceived();
                    audioSubConnection.setPacketsReceived(audioSubConnection.getPacketsReceived() + (l5 != null ? l5 : 0L));
                    continue;
                }
                if (stat instanceof Video) {
                    bitrate = this.bitrateCalculator.getBitrateFromTrackUpdatePrev((Track)stat);
                    BigInteger bigInteger = ((Video)stat).getBytesTransported();
                    bytesReceived = bigInteger != null ? bigInteger.longValue() : 0L;
                    Video $this$convertBundleToStatsObserverEvents_u24lambda_u242 = (Video)stat;
                    boolean bl = false;
                    HMSVideoResolution resolution = $this$convertBundleToStatsObserverEvents_u24lambda_u242.getFrameWidth() != null && $this$convertBundleToStatsObserverEvents_u24lambda_u242.getFrameHeight() != null ? new HMSVideoResolution((int)$this$convertBundleToStatsObserverEvents_u24lambda_u242.getFrameWidth().longValue(), (int)$this$convertBundleToStatsObserverEvents_u24lambda_u242.getFrameHeight().longValue()) : null;
                    HMSRemoteVideoStats videoStats = new HMSRemoteVideoStats($this$convertBundleToStatsObserverEvents_u24lambda_u242.getJitter(), bytesReceived, bitrate, $this$convertBundleToStatsObserverEvents_u24lambda_u242.getPacketsReceived(), $this$convertBundleToStatsObserverEvents_u24lambda_u242.getPacketsLost(), resolution, $this$convertBundleToStatsObserverEvents_u24lambda_u242.getFramesPerSecond());
                    HMSStatsObserver hMSStatsObserver = hmsStatsObserver;
                    if (hMSStatsObserver != null) {
                        stringArray = new String[]{"_"};
                        HMSTrack hMSTrack = (HMSTrack)getTrackForId.invoke(StringsKt.split$default((CharSequence)item.getKey(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0));
                        stringArray = new String[]{"_"};
                        hMSStatsObserver.onRemoteVideoStats(videoStats, hMSTrack, (HMSPeer)getRemotePeerForTrackId.invoke(StringsKt.split$default((CharSequence)item.getKey(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)));
                    }
                    if (bytesReceived > 0L) {
                        videoSubConnection.setBytesReceived(videoSubConnection.getBytesReceived() + bytesReceived);
                    }
                    videoSubConnection.getAvailableIncomingBitrates().add(bitrate);
                    Long l = ((Video)stat).getPacketsReceived();
                    if ((l != null ? l : 0L) <= 0L) continue;
                    Long l6 = ((Video)stat).getPacketsReceived();
                    videoSubConnection.setPacketsReceived(videoSubConnection.getPacketsReceived() + (l6 != null ? l6 : 0L));
                    continue;
                }
                if (stat instanceof ConnectionInfo.PublishConnection) {
                    Double d = ((ConnectionInfo.PublishConnection)stat).getCurrentRoundTripTime();
                    publishRoundTripTime = d != null ? d : 0.0;
                    continue;
                }
                if (stat instanceof ConnectionInfo.SubscribeConnection) {
                    Double d = ((ConnectionInfo.SubscribeConnection)stat).getCurrentRoundTripTime();
                    subscribeRoundTripTime = d != null ? d : 0.0;
                    continue;
                }
                if (!_Assertions.ENABLED) continue;
                boolean bl = false;
                String string = "Should not have reached here";
                throw new AssertionError((Object)string);
            }
            this.sendOverallRtcStats(audioPubConnection, videoPubConnection, audioSubConnection, videoSubConnection, hmsStatsObserver, subscribeRoundTripTime, publishRoundTripTime);
            if (localVideoStats.isEmpty()) break block27;
            List $this$sortBy$iv = localVideoStats;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(this){
                    final /* synthetic */ BundleToStatsObserver this$0;
                    {
                        this.this$0 = bundleToStatsObserver;
                    }

                    public final int compare(T a, T b) {
                        HMSLocalVideoStats it = (HMSLocalVideoStats)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(BundleToStatsObserver.access$layerSortOrder(this.this$0, it.getHmsLayer()));
                        it = (HMSLocalVideoStats)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(BundleToStatsObserver.access$layerSortOrder(this.this$0, it.getHmsLayer())));
                    }
                });
            }
            HMSStatsObserver hMSStatsObserver = hmsStatsObserver;
            if (hMSStatsObserver != null) {
                hMSStatsObserver.onLocalVideoStats(localVideoStats, localVideoTrack, (HMSPeer)getLocalPeer.invoke());
            }
        }
    }

    private final void sendOverallRtcStats(PublishConnection audioPubConnection, PublishConnection videoPubConnection, SubscribeConnection audioSubConnection, SubscribeConnection videoSubConnection, HMSStatsObserver hmsStatsObserver, double subscribeRoundTripTime, double publishRoundTripTime) {
        block0: {
            HMSRTCStats allVideoHMSRTCStatsReport = new HMSRTCStats(videoPubConnection.getBytesSent(), videoSubConnection.getBytesReceived(), videoSubConnection.getPacketsReceived(), videoPubConnection.getPacketLoss(), CollectionsKt.averageOfDouble((Iterable)videoPubConnection.getAvailableOutgoingBitrates()), CollectionsKt.averageOfDouble((Iterable)videoSubConnection.getAvailableIncomingBitrates()), (subscribeRoundTripTime + publishRoundTripTime) / (double)2);
            HMSRTCStats allAudioHMSRTCStatsReport = new HMSRTCStats(audioPubConnection.getBytesSent(), audioSubConnection.getBytesReceived(), audioSubConnection.getPacketsReceived(), audioPubConnection.getPacketLoss(), CollectionsKt.averageOfDouble((Iterable)audioPubConnection.getAvailableOutgoingBitrates()), CollectionsKt.averageOfDouble((Iterable)audioSubConnection.getAvailableIncomingBitrates()), (subscribeRoundTripTime + publishRoundTripTime) / (double)2);
            HMSRTCStats totalHMSRtcStats = new HMSRTCStats(allAudioHMSRTCStatsReport.getBytesSent() + allVideoHMSRTCStatsReport.getBytesSent(), allAudioHMSRTCStatsReport.getBytesReceived() + allVideoHMSRTCStatsReport.getBytesReceived(), allAudioHMSRTCStatsReport.getPacketsReceived() + allVideoHMSRTCStatsReport.getPacketsReceived(), allAudioHMSRTCStatsReport.getPacketsLost() + allVideoHMSRTCStatsReport.getPacketsLost(), CollectionsKt.averageOfDouble((Iterable)CollectionsKt.plus((Collection)audioPubConnection.getAvailableOutgoingBitrates(), (Iterable)videoPubConnection.getAvailableOutgoingBitrates())), CollectionsKt.averageOfDouble((Iterable)CollectionsKt.plus((Collection)audioSubConnection.getAvailableIncomingBitrates(), (Iterable)videoSubConnection.getAvailableIncomingBitrates())), (subscribeRoundTripTime + publishRoundTripTime) / (double)2);
            HMSRTCStatsReport report = new HMSRTCStatsReport(totalHMSRtcStats, allAudioHMSRTCStatsReport, allVideoHMSRTCStatsReport);
            HMSStatsObserver hMSStatsObserver = hmsStatsObserver;
            if (hMSStatsObserver == null) break block0;
            hMSStatsObserver.onRTCStats(report);
        }
    }

    private final int layerSortOrder(HMSLayer hmsLayer) {
        int n;
        HMSLayer hMSLayer = hmsLayer;
        switch (hMSLayer == null ? -1 : WhenMappings.$EnumSwitchMapping$0[hMSLayer.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public static final /* synthetic */ int access$layerSortOrder(BundleToStatsObserver $this, HMSLayer hmsLayer) {
        return $this.layerSortOrder(hmsLayer);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSLayer.values().length];
            try {
                nArray[HMSLayer.LOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSLayer.MEDIUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSLayer.HIGH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

