/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.encoder.video;

import android.os.Build;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoEncoderFactory;
import org.webrtc.SimulcastVideoEncoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoEncoderFallback;
import org.webrtc.VideoFrame;
import org.webrtc.WrappedNativeVideoEncoder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llive/hms/video/encoder/video/SimulcastVideoEncoderFactoryWrapper;", "Lorg/webrtc/VideoEncoderFactory;", "sharedContext", "Lorg/webrtc/EglBase$Context;", "enableIntelVp8Encoder", "", "enableH264HighProfile", "forceSoftwareEncoder", "(Lorg/webrtc/EglBase$Context;ZZZ)V", "fallback", "native", "Lorg/webrtc/SimulcastVideoEncoderFactory;", "primary", "createEncoder", "Lorg/webrtc/VideoEncoder;", "info", "Lorg/webrtc/VideoCodecInfo;", "getSupportedCodecs", "", "()[Lorg/webrtc/VideoCodecInfo;", "FallbackFactory", "StreamEncoderWrapper", "StreamEncoderWrapperFactory", "lib_release"})
public final class SimulcastVideoEncoderFactoryWrapper
implements VideoEncoderFactory {
    @NotNull
    private final VideoEncoderFactory primary;
    @NotNull
    private final VideoEncoderFactory fallback;
    @NotNull
    private final SimulcastVideoEncoderFactory native;

    /*
     * Unable to fully structure code
     */
    public SimulcastVideoEncoderFactoryWrapper(@Nullable EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, boolean forceSoftwareEncoder) {
        super();
        hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory(sharedContext, enableIntelVp8Encoder, enableH264HighProfile);
        this.primary = new StreamEncoderWrapperFactory((VideoEncoderFactory)hardwareVideoEncoderFactory);
        this.fallback = new StreamEncoderWrapperFactory(new FallbackFactory(this.primary));
        if (forceSoftwareEncoder) ** GOTO lbl-1000
        v0 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)v0, (CharSequence)"Pixel 3", (boolean)false, (int)2, null)) lbl-1000:
        // 2 sources

        {
            v1 = new SimulcastVideoEncoderFactory(this.fallback, this.primary);
        } else {
            v1 = new SimulcastVideoEncoderFactory(this.primary, this.fallback);
        }
        this.native = v1;
    }

    public /* synthetic */ SimulcastVideoEncoderFactoryWrapper(EglBase.Context context, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(context, bl, bl2, bl3);
    }

    @Nullable
    public VideoEncoder createEncoder(@Nullable VideoCodecInfo info) {
        return this.native.createEncoder(info);
    }

    @NotNull
    public VideoCodecInfo[] getSupportedCodecs() {
        VideoCodecInfo[] videoCodecInfoArray = this.native.getSupportedCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)videoCodecInfoArray, (String)"native.supportedCodecs");
        return videoCodecInfoArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Llive/hms/video/encoder/video/SimulcastVideoEncoderFactoryWrapper$StreamEncoderWrapperFactory;", "Lorg/webrtc/VideoEncoderFactory;", "factory", "(Lorg/webrtc/VideoEncoderFactory;)V", "createEncoder", "Lorg/webrtc/VideoEncoder;", "videoCodecInfo", "Lorg/webrtc/VideoCodecInfo;", "getSupportedCodecs", "", "()[Lorg/webrtc/VideoCodecInfo;", "lib_release"})
    private static final class StreamEncoderWrapperFactory
    implements VideoEncoderFactory {
        @NotNull
        private final VideoEncoderFactory factory;

        public StreamEncoderWrapperFactory(@NotNull VideoEncoderFactory factory) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            this.factory = factory;
        }

        @Nullable
        public VideoEncoder createEncoder(@Nullable VideoCodecInfo videoCodecInfo) {
            VideoEncoder encoder = this.factory.createEncoder(videoCodecInfo);
            if (encoder == null) {
                return null;
            }
            if (encoder instanceof WrappedNativeVideoEncoder) {
                return encoder;
            }
            return new StreamEncoderWrapper(encoder);
        }

        @NotNull
        public VideoCodecInfo[] getSupportedCodecs() {
            VideoCodecInfo[] videoCodecInfoArray = this.factory.getSupportedCodecs();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecInfoArray, (String)"factory.supportedCodecs");
            return videoCodecInfoArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Llive/hms/video/encoder/video/SimulcastVideoEncoderFactoryWrapper$FallbackFactory;", "Lorg/webrtc/VideoEncoderFactory;", "hardwareVideoEncoderFactory", "(Lorg/webrtc/VideoEncoderFactory;)V", "softwareVideoEncoderFactory", "createEncoder", "Lorg/webrtc/VideoEncoder;", "info", "Lorg/webrtc/VideoCodecInfo;", "getSupportedCodecs", "", "()[Lorg/webrtc/VideoCodecInfo;", "lib_release"})
    @SourceDebugExtension(value={"SMAP\nSimulcastVideoEncoderFactoryWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimulcastVideoEncoderFactoryWrapper.kt\nlive/hms/video/encoder/video/SimulcastVideoEncoderFactoryWrapper$FallbackFactory\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,230:1\n37#2,2:231\n*S KotlinDebug\n*F\n+ 1 SimulcastVideoEncoderFactoryWrapper.kt\nlive/hms/video/encoder/video/SimulcastVideoEncoderFactoryWrapper$FallbackFactory\n*L\n60#1:231,2\n*E\n"})
    private static final class FallbackFactory
    implements VideoEncoderFactory {
        @NotNull
        private final VideoEncoderFactory hardwareVideoEncoderFactory;
        @NotNull
        private final VideoEncoderFactory softwareVideoEncoderFactory;

        public FallbackFactory(@NotNull VideoEncoderFactory hardwareVideoEncoderFactory) {
            Intrinsics.checkNotNullParameter((Object)hardwareVideoEncoderFactory, (String)"hardwareVideoEncoderFactory");
            this.hardwareVideoEncoderFactory = hardwareVideoEncoderFactory;
            this.softwareVideoEncoderFactory = (VideoEncoderFactory)new SoftwareVideoEncoderFactory();
        }

        @Nullable
        public VideoEncoder createEncoder(@NotNull VideoCodecInfo info) {
            VideoEncoder videoEncoder;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            VideoEncoder softwareEncoder = this.softwareVideoEncoderFactory.createEncoder(info);
            VideoEncoder hardwareEncoder = this.hardwareVideoEncoderFactory.createEncoder(info);
            if (hardwareEncoder != null && softwareEncoder != null) {
                videoEncoder = (VideoEncoder)new VideoEncoderFallback(hardwareEncoder, softwareEncoder);
            } else {
                videoEncoder = softwareEncoder;
                if (videoEncoder == null) {
                    videoEncoder = hardwareEncoder;
                }
            }
            return videoEncoder;
        }

        @NotNull
        public VideoCodecInfo[] getSupportedCodecs() {
            List supportedCodecInfos = new ArrayList();
            Collection collection = supportedCodecInfos;
            VideoCodecInfo[] videoCodecInfoArray = this.softwareVideoEncoderFactory.getSupportedCodecs();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecInfoArray, (String)"softwareVideoEncoderFactory.supportedCodecs");
            CollectionsKt.addAll((Collection)collection, (Object[])videoCodecInfoArray);
            Collection collection2 = supportedCodecInfos;
            VideoCodecInfo[] videoCodecInfoArray2 = this.hardwareVideoEncoderFactory.getSupportedCodecs();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecInfoArray2, (String)"hardwareVideoEncoderFactory.supportedCodecs");
            CollectionsKt.addAll((Collection)collection2, (Object[])videoCodecInfoArray2);
            Collection $this$toTypedArray$iv = supportedCodecInfos;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new VideoCodecInfo[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0011H\u0016J\u001a\u0010'\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u00020\u00112\b\u0010-\u001a\u0004\u0018\u00010.H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006/"}, d2={"Llive/hms/video/encoder/video/SimulcastVideoEncoderFactoryWrapper$StreamEncoderWrapper;", "Lorg/webrtc/VideoEncoder;", "encoder", "(Lorg/webrtc/VideoEncoder;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "streamSettings", "Lorg/webrtc/VideoEncoder$Settings;", "getStreamSettings", "()Lorg/webrtc/VideoEncoder$Settings;", "setStreamSettings", "(Lorg/webrtc/VideoEncoder$Settings;)V", "createNativeVideoEncoder", "", "encode", "Lorg/webrtc/VideoCodecStatus;", "frame", "Lorg/webrtc/VideoFrame;", "encodeInfo", "Lorg/webrtc/VideoEncoder$EncodeInfo;", "getEncoderInfo", "Lorg/webrtc/VideoEncoder$EncoderInfo;", "getImplementationName", "", "getResolutionBitrateLimits", "", "Lorg/webrtc/VideoEncoder$ResolutionBitrateLimits;", "()[Lorg/webrtc/VideoEncoder$ResolutionBitrateLimits;", "getScalingSettings", "Lorg/webrtc/VideoEncoder$ScalingSettings;", "initEncode", "settings", "callback", "Lorg/webrtc/VideoEncoder$Callback;", "isHardwareEncoder", "", "release", "setRateAllocation", "allocation", "Lorg/webrtc/VideoEncoder$BitrateAllocation;", "frameRate", "", "setRates", "rcParameters", "Lorg/webrtc/VideoEncoder$RateControlParameters;", "lib_release"})
    private static final class StreamEncoderWrapper
    implements VideoEncoder {
        @NotNull
        private final VideoEncoder encoder;
        @NotNull
        private final ExecutorService executor;
        @Nullable
        private VideoEncoder.Settings streamSettings;

        public StreamEncoderWrapper(@NotNull VideoEncoder encoder) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            this.encoder = encoder;
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
            this.executor = executorService;
        }

        @NotNull
        public final ExecutorService getExecutor() {
            return this.executor;
        }

        @Nullable
        public final VideoEncoder.Settings getStreamSettings() {
            return this.streamSettings;
        }

        public final void setStreamSettings(@Nullable VideoEncoder.Settings settings) {
            this.streamSettings = settings;
        }

        @NotNull
        public VideoCodecStatus initEncode(@NotNull VideoEncoder.Settings settings, @Nullable VideoEncoder.Callback callback) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.streamSettings = settings;
            Future<VideoCodecStatus> future2 = this.executor.submit(() -> StreamEncoderWrapper.initEncode$lambda$0(this, settings, callback));
            VideoCodecStatus videoCodecStatus = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecStatus, (String)"future.get()");
            return videoCodecStatus;
        }

        @NotNull
        public VideoCodecStatus release() {
            Future<VideoCodecStatus> future2 = this.executor.submit(() -> StreamEncoderWrapper.release$lambda$1(this));
            VideoCodecStatus videoCodecStatus = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecStatus, (String)"future.get()");
            return videoCodecStatus;
        }

        @NotNull
        public VideoCodecStatus encode(@NotNull VideoFrame frame, @Nullable VideoEncoder.EncodeInfo encodeInfo) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Future<VideoCodecStatus> future2 = this.executor.submit(() -> StreamEncoderWrapper.encode$lambda$2(this, frame, encodeInfo));
            VideoCodecStatus videoCodecStatus = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecStatus, (String)"future.get()");
            return videoCodecStatus;
        }

        @NotNull
        public VideoCodecStatus setRateAllocation(@Nullable VideoEncoder.BitrateAllocation allocation, int frameRate) {
            Future<VideoCodecStatus> future2 = this.executor.submit(() -> StreamEncoderWrapper.setRateAllocation$lambda$3(this, allocation, frameRate));
            VideoCodecStatus videoCodecStatus = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecStatus, (String)"future.get()");
            return videoCodecStatus;
        }

        @NotNull
        public VideoEncoder.ScalingSettings getScalingSettings() {
            Future<VideoEncoder.ScalingSettings> future2 = this.executor.submit(() -> StreamEncoderWrapper.getScalingSettings$lambda$4(this));
            VideoEncoder.ScalingSettings scalingSettings = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)scalingSettings, (String)"future.get()");
            return scalingSettings;
        }

        @NotNull
        public String getImplementationName() {
            Future<String> future2 = this.executor.submit(() -> StreamEncoderWrapper.getImplementationName$lambda$5(this));
            String string = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"future.get()");
            return string;
        }

        public long createNativeVideoEncoder() {
            Future<Long> future2 = this.executor.submit(() -> StreamEncoderWrapper.createNativeVideoEncoder$lambda$6(this));
            Long l = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"future.get()");
            return ((Number)l).longValue();
        }

        public boolean isHardwareEncoder() {
            Future<Boolean> future2 = this.executor.submit(() -> StreamEncoderWrapper.isHardwareEncoder$lambda$7(this));
            Boolean bl = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"future.get()");
            return bl;
        }

        @NotNull
        public VideoCodecStatus setRates(@Nullable VideoEncoder.RateControlParameters rcParameters) {
            Future<VideoCodecStatus> future2 = this.executor.submit(() -> StreamEncoderWrapper.setRates$lambda$8(this, rcParameters));
            VideoCodecStatus videoCodecStatus = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecStatus, (String)"future.get()");
            return videoCodecStatus;
        }

        @NotNull
        public VideoEncoder.ResolutionBitrateLimits[] getResolutionBitrateLimits() {
            Future<VideoEncoder.ResolutionBitrateLimits[]> future2 = this.executor.submit(() -> StreamEncoderWrapper.getResolutionBitrateLimits$lambda$9(this));
            VideoEncoder.ResolutionBitrateLimits[] resolutionBitrateLimitsArray = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)resolutionBitrateLimitsArray, (String)"future.get()");
            return resolutionBitrateLimitsArray;
        }

        @NotNull
        public VideoEncoder.EncoderInfo getEncoderInfo() {
            Future<VideoEncoder.EncoderInfo> future2 = this.executor.submit(() -> StreamEncoderWrapper.getEncoderInfo$lambda$10(this));
            VideoEncoder.EncoderInfo encoderInfo = future2.get();
            Intrinsics.checkNotNullExpressionValue((Object)encoderInfo, (String)"future.get()");
            return encoderInfo;
        }

        private static final VideoCodecStatus initEncode$lambda$0(StreamEncoderWrapper this$0, VideoEncoder.Settings $settings, VideoEncoder.Callback $callback) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("initEncode() thread=").append(Thread.currentThread().getName()).append(" [").append(Thread.currentThread().getId()).append("]\n                |  encoder=").append(this$0.encoder.getImplementationName()).append("\n                |  streamSettings:\n                |    numberOfCores=").append($settings.numberOfCores).append("\n                |    width=").append($settings.width).append("\n                |    height=").append($settings.height).append("\n                |    startBitrate=").append($settings.startBitrate).append("\n                |    maxFramerate=").append($settings.maxFramerate).append("\n                |    automaticResizeOn=").append($settings.automaticResizeOn).append("\n                |    numberOfSimulcastStreams=").append($settings.numberOfSimulcastStreams).append("\n                |    lossNotification=").append($settings.capabilities.lossNotification).append("\n            ");
            HMSLogger.d("SimulcastVideoEncoderFactoryWrapper", StringsKt.trimMargin$default((String)stringBuilder.toString(), null, (int)1, null));
            return this$0.encoder.initEncode($settings, $callback);
        }

        private static final VideoCodecStatus release$lambda$1(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.release();
        }

        private static final VideoCodecStatus encode$lambda$2(StreamEncoderWrapper this$0, VideoFrame $frame, VideoEncoder.EncodeInfo $encodeInfo) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$frame, (String)"$frame");
            if (this$0.streamSettings == null) {
                return this$0.encoder.encode($frame, $encodeInfo);
            }
            int n = $frame.getBuffer().getWidth();
            VideoEncoder.Settings settings = this$0.streamSettings;
            Intrinsics.checkNotNull((Object)settings);
            if (n == settings.width) {
                return this$0.encoder.encode($frame, $encodeInfo);
            }
            VideoFrame.Buffer originalBuffer = $frame.getBuffer();
            int n2 = originalBuffer.getWidth();
            int n3 = originalBuffer.getHeight();
            VideoEncoder.Settings settings2 = this$0.streamSettings;
            Intrinsics.checkNotNull((Object)settings2);
            int n4 = settings2.width;
            VideoEncoder.Settings settings3 = this$0.streamSettings;
            Intrinsics.checkNotNull((Object)settings3);
            VideoFrame.Buffer adaptedBuffer = originalBuffer.cropAndScale(0, 0, n2, n3, n4, settings3.height);
            VideoFrame adaptedFrame = new VideoFrame(adaptedBuffer, $frame.getRotation(), $frame.getTimestampNs());
            VideoCodecStatus result2 = this$0.encoder.encode(adaptedFrame, $encodeInfo);
            adaptedBuffer.release();
            return result2;
        }

        private static final VideoCodecStatus setRateAllocation$lambda$3(StreamEncoderWrapper this$0, VideoEncoder.BitrateAllocation $allocation, int $frameRate) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.setRateAllocation($allocation, $frameRate);
        }

        private static final VideoEncoder.ScalingSettings getScalingSettings$lambda$4(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.getScalingSettings();
        }

        private static final String getImplementationName$lambda$5(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.getImplementationName();
        }

        private static final Long createNativeVideoEncoder$lambda$6(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.createNativeVideoEncoder();
        }

        private static final Boolean isHardwareEncoder$lambda$7(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.isHardwareEncoder();
        }

        private static final VideoCodecStatus setRates$lambda$8(StreamEncoderWrapper this$0, VideoEncoder.RateControlParameters $rcParameters) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.setRates($rcParameters);
        }

        private static final VideoEncoder.ResolutionBitrateLimits[] getResolutionBitrateLimits$lambda$9(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.getResolutionBitrateLimits();
        }

        private static final VideoEncoder.EncoderInfo getEncoderInfo$lambda$10(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.getEncoderInfo();
        }
    }
}

