/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\fJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Llive/hms/video/utils/HmsCamera;", "", "context", "Landroid/content/Context;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;)V", "backCameraId", "", "getContext", "()Landroid/content/Context;", "enumerator", "Lorg/webrtc/CameraEnumerator;", "frontCameraId", "enumerateAndAssignFrontBackValues", "", "getCachedCameraFacing", "Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "deviceId", "getCam2", "getCameraFaceFromId", "getCameraIdFromFace", "face", "throwException", "", "getDeviceId", "getEnumerator", "getWebrtcCameraFacing", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHmsCamera.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HmsCamera.kt\nlive/hms/video/utils/HmsCamera\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,241:1\n18#2:242\n26#3:243\n13579#4,2:244\n*S KotlinDebug\n*F\n+ 1 HmsCamera.kt\nlive/hms/video/utils/HmsCamera\n*L\n194#1:242\n194#1:243\n232#1:244,2\n*E\n"})
public final class HmsCamera {
    @NotNull
    private final Context context;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @Nullable
    private String frontCameraId;
    @Nullable
    private String backCameraId;
    @NotNull
    private CameraEnumerator enumerator;

    public HmsCamera(@NotNull Context context, @NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        this.context = context;
        this.analyticsEventsService = analyticsEventsService2;
        this.enumerator = (CameraEnumerator)new Camera2Enumerator(this.context);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final CameraEnumerator getEnumerator() {
        return this.enumerator;
    }

    @NotNull
    public final String getDeviceId(@NotNull HMSVideoTrackSettings.CameraFacing face) throws HMSException {
        Intrinsics.checkNotNullParameter((Object)((Object)face), (String)"face");
        try {
            String cacheCameraId = this.getCameraIdFromFace(face, false);
            if (cacheCameraId != null) {
                return cacheCameraId;
            }
            this.enumerateAndAssignFrontBackValues();
            String string = this.getCameraIdFromFace(face, true);
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        catch (NoSuchElementException e) {
            HMSException cantFindCameraIdForParticularOrientation = ErrorFactory.TracksErrors.CantFindCameraIdForParticularFace$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, HmsCamera.getDeviceId$getFaceString(face), "No camera device found for " + (Object)((Object)face) + " among " + Arrays.toString(this.enumerator.getDeviceNames()), false, null, null, 56, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(cantFindCameraIdForParticularOrientation)).flush();
            throw cantFindCameraIdForParticularOrientation;
        }
        catch (Exception e) {
            HMSException cameraCaptureException = ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "camera", String.valueOf(e.getMessage()), false, null, null, 48, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(cameraCaptureException)).flush();
            throw cameraCaptureException;
        }
    }

    private final String getCameraIdFromFace(HMSVideoTrackSettings.CameraFacing face, boolean throwException) {
        String string;
        CharSequence charSequence;
        if (this.frontCameraId == null && this.backCameraId == null && throwException) {
            throw new NoSuchElementException("both, front and back cameraId returned null for face " + (Object)((Object)face));
        }
        if (this.frontCameraId == null && this.backCameraId == null) {
            return null;
        }
        if (face == HMSVideoTrackSettings.CameraFacing.FRONT && !((charSequence = (CharSequence)this.frontCameraId) == null || charSequence.length() == 0)) {
            String string2 = this.frontCameraId;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else if (face == HMSVideoTrackSettings.CameraFacing.BACK && !((charSequence = (CharSequence)this.backCameraId) == null || charSequence.length() == 0)) {
            String string3 = this.backCameraId;
            string = string3;
            Intrinsics.checkNotNull((Object)string3);
        } else {
            if (throwException) {
                throw new NoSuchElementException("Couldn't find " + (Object)((Object)face) + " facing camera. Please restart your device");
            }
            return null;
        }
        return string;
    }

    @Nullable
    public final HMSVideoTrackSettings.CameraFacing getCameraFaceFromId(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        HMSVideoTrackSettings.CameraFacing cameraFacing = this.getCachedCameraFacing(deviceId);
        if (cameraFacing == null && (cameraFacing = this.getWebrtcCameraFacing(deviceId)) == null && (cameraFacing = this.getCam2(deviceId)) == null) {
            cameraFacing = this.getCachedCameraFacing(deviceId);
        }
        return cameraFacing;
    }

    private final HMSVideoTrackSettings.CameraFacing getCachedCameraFacing(String deviceId) {
        String string = deviceId;
        return Intrinsics.areEqual((Object)string, (Object)this.frontCameraId) ? HMSVideoTrackSettings.CameraFacing.FRONT : (Intrinsics.areEqual((Object)string, (Object)this.backCameraId) ? HMSVideoTrackSettings.CameraFacing.BACK : null);
    }

    private final HMSVideoTrackSettings.CameraFacing getWebrtcCameraFacing(String deviceId) {
        Object object;
        Object object2 = this;
        try {
            HmsCamera $this$getWebrtcCameraFacing_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)((Object)($this$getWebrtcCameraFacing_u24lambda_u240.enumerator.isFrontFacing(deviceId) ? HMSVideoTrackSettings.CameraFacing.FRONT : ($this$getWebrtcCameraFacing_u24lambda_u240.enumerator.isBackFacing(deviceId) ? HMSVideoTrackSettings.CameraFacing.BACK : null))));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (HMSVideoTrackSettings.CameraFacing)((Object)(Result.isFailure-impl((Object)object2) ? null : object2));
    }

    private final HMSVideoTrackSettings.CameraFacing getCam2(String deviceId) {
        Object object;
        Object object2 = this;
        try {
            HMSVideoTrackSettings.CameraFacing cameraFacing;
            HmsCamera $this$getCam2_u24lambda_u241 = object2;
            boolean bl = false;
            Object object3 = $this$getCam2_u24lambda_u241.context.getSystemService("camera");
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            CameraManager cameraManager = (CameraManager)object3;
            if ($this$getCam2_u24lambda_u241.enumerator.isBackFacing(deviceId)) {
                cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
            } else if ($this$getCam2_u24lambda_u241.enumerator.isFrontFacing(deviceId)) {
                cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
            } else if (($this$getCam2_u24lambda_u241.frontCameraId == null || $this$getCam2_u24lambda_u241.backCameraId == null) && $this$getCam2_u24lambda_u241.context.getPackageManager().hasSystemFeature("android.hardware.camera.external")) {
                Integer facing;
                Integer n;
                CameraCharacteristics characteristics;
                CameraCharacteristics cameraCharacteristics = characteristics = cameraManager.getCameraCharacteristics(deviceId);
                Integer n2 = n = (facing = cameraCharacteristics != null ? (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) : null);
                if (n2 != null && n2 == 0) {
                    cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
                } else {
                    Integer n3 = n;
                    int n4 = 1;
                    if (n3 != null && n3 == n4) {
                        cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
                    } else if (n == null) {
                        cameraFacing = null;
                    } else {
                        $this$getCam2_u24lambda_u241.enumerateAndAssignFrontBackValues();
                        if ($this$getCam2_u24lambda_u241.frontCameraId == null) {
                            $this$getCam2_u24lambda_u241.frontCameraId = deviceId;
                            cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
                        } else if ($this$getCam2_u24lambda_u241.backCameraId == null) {
                            $this$getCam2_u24lambda_u241.backCameraId = deviceId;
                            cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
                        } else {
                            cameraFacing = null;
                        }
                    }
                }
            } else {
                cameraFacing = null;
            }
            object = Result.constructor-impl((Object)((Object)cameraFacing));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (HMSVideoTrackSettings.CameraFacing)((Object)(Result.isFailure-impl((Object)object2) ? null : object2));
    }

    private final void enumerateAndAssignFrontBackValues() {
        Object $this$enumerateAndAssignFrontBackValues_u24lambda_u242;
        HmsCamera hmsCamera = this;
        try {
            $this$enumerateAndAssignFrontBackValues_u24lambda_u242 = hmsCamera;
            boolean bl = false;
            String[] $this$orEmpty$iv = ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).enumerator.getDeviceNames();
            int $i$f$orEmpty = 0;
            String[] stringArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                int $i$f$emptyArray = 0;
                stringArray = new String[]{};
            }
            String[] cameraDevices = stringArray;
            Object object = ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).context.getSystemService("camera");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            CameraManager cameraManager = (CameraManager)object;
            for (String cameraDeviceId : cameraDevices) {
                if (((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).frontCameraId == null && ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).enumerator.isFrontFacing(cameraDeviceId)) {
                    ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).frontCameraId = cameraDeviceId;
                }
                if (((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).backCameraId != null || !((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).enumerator.isBackFacing(cameraDeviceId)) continue;
                ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).backCameraId = cameraDeviceId;
            }
            if ((((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).frontCameraId == null || ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).backCameraId == null) && ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).context.getPackageManager().hasSystemFeature("android.hardware.camera.external")) {
                for (String cameraDeviceId : cameraDevices) {
                    boolean bl2;
                    int n;
                    CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(cameraDeviceId);
                    if (((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).frontCameraId == null) {
                        boolean bl3;
                        CameraCharacteristics cameraCharacteristics = characteristics;
                        if (cameraCharacteristics != null) {
                            Integer n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                            n = 2;
                            bl3 = n2 != null && n2 == n;
                        } else {
                            bl3 = false;
                        }
                        if (bl3) {
                            ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).frontCameraId = cameraDeviceId;
                            continue;
                        }
                    }
                    if (((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).backCameraId != null) continue;
                    CameraCharacteristics cameraCharacteristics = characteristics;
                    if (cameraCharacteristics != null) {
                        Integer n3 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                        n = 2;
                        bl2 = n3 != null && n3 == n;
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    ((HmsCamera)$this$enumerateAndAssignFrontBackValues_u24lambda_u242).backCameraId = cameraDeviceId;
                }
            }
            $this$enumerateAndAssignFrontBackValues_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $this$enumerateAndAssignFrontBackValues_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object cam2EnumResult = $this$enumerateAndAssignFrontBackValues_u24lambda_u242;
        if (this.frontCameraId == null && this.backCameraId == null || Result.isFailure-impl((Object)cam2EnumResult)) {
            this.enumerator = (CameraEnumerator)new Camera2Enumerator(this.context);
            String[] stringArray = this.enumerator.getDeviceNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"enumerator.deviceNames");
            Object[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String deviceId = (String)element$iv;
                boolean bl = false;
                if (this.frontCameraId == null && this.enumerator.isFrontFacing(deviceId)) {
                    this.frontCameraId = deviceId;
                }
                if (this.backCameraId != null || !this.enumerator.isBackFacing(deviceId)) continue;
                this.backCameraId = deviceId;
            }
        }
    }

    private static final String getDeviceId$getFaceString(HMSVideoTrackSettings.CameraFacing face) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[face.ordinal()]) {
            case 1: {
                string = "front facing";
                break;
            }
            case 2: {
                string = "back facing";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSVideoTrackSettings.CameraFacing.values().length];
            try {
                nArray[HMSVideoTrackSettings.CameraFacing.FRONT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSVideoTrackSettings.CameraFacing.BACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

