/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.factories.noisecancellation.AvailabilityStatus;
import live.hms.video.factories.noisecancellation.NoiseCancellationStatusChecker;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u0004\u0018\u00010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J'\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fJ\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Llive/hms/video/sdk/NoiseCancellationReportingUseCase;", "", "hmsTrackSettings", "Llive/hms/video/media/settings/HMSTrackSettings;", "ncStatusChecker", "Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;", "(Llive/hms/video/media/settings/HMSTrackSettings;Llive/hms/video/factories/noisecancellation/NoiseCancellationStatusChecker;)V", "TAG", "", "duration", "", "startTime", "getReport", "Llive/hms/video/events/AnalyticsEvent;", "isNcEnabledInTrackSettings", "", "localPeerRoleChanged", "", "isWebrtcPeer", "wasWebrtcPeer", "joined", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Z)V", "noiseCancellationState", "enabled", "peerJoined", "reset", "lib_release"})
public final class NoiseCancellationReportingUseCase {
    @NotNull
    private final HMSTrackSettings hmsTrackSettings;
    @NotNull
    private final NoiseCancellationStatusChecker ncStatusChecker;
    @NotNull
    private final String TAG;
    private long startTime;
    private long duration;

    public NoiseCancellationReportingUseCase(@NotNull HMSTrackSettings hmsTrackSettings, @NotNull NoiseCancellationStatusChecker ncStatusChecker2) {
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        Intrinsics.checkNotNullParameter((Object)ncStatusChecker2, (String)"ncStatusChecker");
        this.hmsTrackSettings = hmsTrackSettings;
        this.ncStatusChecker = ncStatusChecker2;
        this.TAG = "NCReportingUseCase";
    }

    public final void peerJoined(boolean isWebrtcPeer, @NotNull HMSTrackSettings hmsTrackSettings) {
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        if (isWebrtcPeer) {
            HMSAudioTrackSettings hMSAudioTrackSettings = hmsTrackSettings.getAudioSettings();
            boolean bl = hMSAudioTrackSettings != null ? hMSAudioTrackSettings.getEnableNoiseCancellation() : false;
            if (bl) {
                Log.d((String)this.TAG, (String)"Enabling noise cancellation from join");
                this.noiseCancellationState(true);
            }
        }
    }

    public final void noiseCancellationState(boolean enabled) {
        Log.d((String)this.TAG, (String)("NC " + enabled));
        if (!Intrinsics.areEqual((Object)this.ncStatusChecker.isNoiseCancellationAvailable(), (Object)AvailabilityStatus.Available.INSTANCE)) {
            return;
        }
        if (enabled && this.startTime != 0L || !enabled && this.startTime == 0L) {
            return;
        }
        if (enabled) {
            this.startTime = System.currentTimeMillis();
        } else {
            this.duration += System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AnalyticsEvent getReport() {
        AnalyticsEvent analyticsEvent;
        this.noiseCancellationState(false);
        if (this.duration != 0L) {
            void var1_1;
            AnalyticsEvent event = AnalyticsEventFactory.INSTANCE.noiseCancellationStats(this.duration);
            Log.d((String)this.TAG, (String)(" Generating event " + event));
            analyticsEvent = var1_1;
        } else {
            analyticsEvent = null;
        }
        return analyticsEvent;
    }

    public final void reset() {
        Log.d((String)this.TAG, (String)"Resetting all values");
        this.startTime = 0L;
        this.duration = 0L;
    }

    public final void localPeerRoleChanged(@Nullable Boolean isWebrtcPeer, @Nullable Boolean wasWebrtcPeer, boolean joined) {
        if (this.isNcEnabledInTrackSettings() && joined) {
            Log.d((String)this.TAG, (String)("Local peer role changed wasWebrtc: " + wasWebrtcPeer + ", isWebrtc: " + isWebrtcPeer));
            if (Intrinsics.areEqual((Object)isWebrtcPeer, (Object)true) && !Intrinsics.areEqual((Object)wasWebrtcPeer, (Object)true)) {
                this.noiseCancellationState(true);
            } else if (Intrinsics.areEqual((Object)isWebrtcPeer, (Object)false) && Intrinsics.areEqual((Object)wasWebrtcPeer, (Object)true)) {
                this.noiseCancellationState(false);
            }
        } else {
            Log.d((String)this.TAG, (String)("Local peer role changed, ignoring since NC is not enabled by default or join: " + joined));
        }
    }

    private final boolean isNcEnabledInTrackSettings() {
        HMSAudioTrackSettings hMSAudioTrackSettings = this.hmsTrackSettings.getAudioSettings();
        return hMSAudioTrackSettings != null ? hMSAudioTrackSettings.getEnableNoiseCancellation() : false;
    }
}

