/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00120\u0014J\u0006\u0010\u0018\u001a\u00020\u0012J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Llive/hms/video/utils/NetworkConnectionHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callback", "Landroid/net/ConnectivityManager$NetworkCallback;", "cellularNetworkHandle", "", "isCellularConnected", "", "()Z", "isConnected", "isWifiConnected", "manager", "Landroid/net/ConnectivityManager;", "wifiNetworkHandle", "start", "", "onStatusChange", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "connected", "stop", "updateNetworkInfo", "network", "Landroid/net/Network;", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nNetworkConnectionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkConnectionHelper.kt\nlive/hms/video/utils/NetworkConnectionHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class NetworkConnectionHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectivityManager manager;
    @Nullable
    private ConnectivityManager.NetworkCallback callback;
    @NotNull
    private String wifiNetworkHandle;
    @NotNull
    private String cellularNetworkHandle;
    @NotNull
    private static final String TAG = "NetworkConnectionHelper";

    public NetworkConnectionHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.manager = (ConnectivityManager)object;
        this.wifiNetworkHandle = "";
        this.cellularNetworkHandle = "";
    }

    private final boolean isWifiConnected() {
        return !StringsKt.isBlank((CharSequence)this.wifiNetworkHandle);
    }

    private final boolean isCellularConnected() {
        return !StringsKt.isBlank((CharSequence)this.cellularNetworkHandle);
    }

    private final void updateNetworkInfo(Network network) {
        NetworkCapabilities info = this.manager.getNetworkCapabilities(network);
        if (info == null) {
            if (Intrinsics.areEqual((Object)this.wifiNetworkHandle, (Object)network.toString())) {
                this.wifiNetworkHandle = "";
            }
            if (Intrinsics.areEqual((Object)this.cellularNetworkHandle, (Object)network.toString())) {
                this.cellularNetworkHandle = "";
            }
        } else {
            String string = info.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.toString()");
            String string2 = string;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            String infoStr = string3;
            if (StringsKt.contains$default((CharSequence)infoStr, (CharSequence)"wifi", (boolean)false, (int)2, null)) {
                String string4 = network.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"network.toString()");
                this.wifiNetworkHandle = string4;
            }
            if (infoStr.contentEquals("cellular")) {
                String string5 = network.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"network.toString()");
                this.cellularNetworkHandle = string5;
            }
        }
    }

    private final boolean isConnected() {
        return this.isWifiConnected() || this.isCellularConnected();
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull Function1<? super Boolean, Unit> onStatusChange) {
        void $this$start_u24lambda_u241;
        ConnectivityManager.NetworkCallback networkCallback;
        ConnectivityManager.NetworkCallback it;
        Intrinsics.checkNotNullParameter(onStatusChange, (String)"onStatusChange");
        ConnectivityManager.NetworkCallback networkCallback2 = this.callback;
        if (networkCallback2 != null) {
            it = networkCallback2;
            boolean bl = false;
            this.stop();
        }
        NetworkRequest request = new NetworkRequest.Builder().build();
        it = networkCallback = new ConnectivityManager.NetworkCallback(this, onStatusChange){
            final /* synthetic */ NetworkConnectionHelper this$0;
            final /* synthetic */ Function1<Boolean, Unit> $onStatusChange;
            {
                this.this$0 = $receiver;
                this.$onStatusChange = $onStatusChange;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onAvailable(network);
                boolean previousIsConnected = NetworkConnectionHelper.access$isConnected(this.this$0);
                NetworkConnectionHelper.access$updateNetworkInfo(this.this$0, network);
                if (!previousIsConnected && NetworkConnectionHelper.access$isConnected(this.this$0)) {
                    this.$onStatusChange.invoke((Object)NetworkConnectionHelper.access$isConnected(this.this$0));
                }
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onLost(network);
                NetworkConnectionHelper.access$updateNetworkInfo(this.this$0, network);
                this.$onStatusChange.invoke((Object)NetworkConnectionHelper.access$isConnected(this.this$0));
            }
        };
        NetworkConnectionHelper networkConnectionHelper = this;
        boolean bl = false;
        this.manager.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)$this$start_u24lambda_u241);
        networkConnectionHelper.callback = networkCallback;
    }

    public final void stop() {
        ConnectivityManager.NetworkCallback networkCallback = this.callback;
        Intrinsics.checkNotNull((Object)networkCallback);
        this.manager.unregisterNetworkCallback(networkCallback);
        this.callback = null;
    }

    public static final /* synthetic */ boolean access$isConnected(NetworkConnectionHelper $this) {
        return $this.isConnected();
    }

    public static final /* synthetic */ void access$updateNetworkInfo(NetworkConnectionHelper $this, Network network) {
        $this.updateNetworkInfo(network);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/utils/NetworkConnectionHelper$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

