/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.events;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.connection.stats.clientside.model.PublishAnalyticPayload;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.IAnalyticsPropertiesProvider;
import live.hms.video.sdk.models.enums.HMSAnalyticsEventLevel;
import live.hms.video.sdk.models.enums.RetrySchedulerState;
import live.hms.video.utils.ExtensionUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\tJ\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004J\u0016\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\fJ\u001e\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\t2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010'J\u001d\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0019J\u000e\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u000202J\"\u00103\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\t2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010'J\u000e\u00104\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ.\u00105\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\tJ\u000e\u00109\u001a\u00020\u00072\u0006\u00101\u001a\u000202J\u000e\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010>\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Llive/hms/video/events/AnalyticsEventFactory;", "", "()V", "cRequestedAt", "", "cRespondedAt", "audioEchoCancellation", "Llive/hms/video/events/AnalyticsEvent;", "isHardware", "", "audioPublishFail", "error", "Llive/hms/video/error/HMSException;", "cameraCapturingException", "exception", "", "clientSideStats", "publishAnalyticPayload", "Llive/hms/video/connection/stats/clientside/model/PublishAnalyticPayload;", "isSubscriber", "connect", "source", "Llive/hms/video/sdk/models/enums/RetrySchedulerState;", "degradation", "eventTime", "", "trackId", "disconnect", "focusOwnedStatus", "owned", "genericHMSExceptionEvent", "hmsException", "join", "requestedAt", "Ljava/util/Date;", "respondedAt", "joinStatusEvent", "eventSuccessful", "eventMap", "Ljava/util/HashMap;", "networkQualityInPreviewResults", "score", "", "speedKilobytesPerSecond", "", "(ILjava/lang/Double;)Llive/hms/video/events/AnalyticsEvent;", "noiseCancellationStats", "enabledDuration", "performance", "stats", "Llive/hms/video/events/IAnalyticsPropertiesProvider;", "previewStatusEvent", "publishFail", "restoration", "degradedAt", "durationDegraded", "hidden", "rtcStats", "selectedAudioDevice", "selectedDevice", "Llive/hms/video/audio/HMSAudioManager$AudioDevice;", "subscribeFail", "videoPublishFail", "lib_release"})
public final class AnalyticsEventFactory {
    @NotNull
    public static final AnalyticsEventFactory INSTANCE = new AnalyticsEventFactory();
    @NotNull
    private static final String cRequestedAt = "requested_at";
    @NotNull
    private static final String cRespondedAt = "responded_at";

    private AnalyticsEventFactory() {
    }

    @NotNull
    public final AnalyticsEvent disconnect(@NotNull HMSException error, @NotNull RetrySchedulerState source) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        ((Map)properties).put("transport_state", source.getCurrentState());
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "disconnected";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent join(@NotNull Date requestedAt, @NotNull Date respondedAt, @NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)requestedAt, (String)"requestedAt");
        Intrinsics.checkNotNullParameter((Object)respondedAt, (String)"respondedAt");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)cRequestedAt, (Object)String.valueOf(requestedAt.getTime())), TuplesKt.to((Object)cRespondedAt, (Object)String.valueOf(respondedAt.getTime()))};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        properties.putAll((Map)error.toAnalyticsProperties());
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "join.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent publishFail(@NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "publish.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent audioPublishFail(@NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "audiopresence.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent videoPublishFail(@NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "videopresence.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent subscribeFail(@NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "subscribe.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent connect(@NotNull HMSException error, @NotNull RetrySchedulerState source) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        HashMap<String, Object> properties = error.toAnalyticsProperties();
        ((Map)properties).put("transport_state", source.getCurrentState());
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "connect.failed";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent networkQualityInPreviewResults(int score, @Nullable Double speedKilobytesPerSecond) {
        Object object = speedKilobytesPerSecond;
        if (object == null) {
            object = "null";
        }
        Double downLink = object;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"score", (Object)score), TuplesKt.to((Object)"downLink", (Object)downLink)};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "perf.networkquality.preview";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent performance(@NotNull IAnalyticsPropertiesProvider stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        HashMap<String, Object> properties = stats.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "perf.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent rtcStats(@NotNull IAnalyticsPropertiesProvider stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        HashMap<String, Object> properties = stats.toAnalyticsProperties();
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "rtc.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent degradation(long eventTime, @NotNull String trackId) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"trackID", (Object)trackId), TuplesKt.to((Object)"degradedAt", (Object)String.valueOf(eventTime))};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "video.degradation.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent restoration(long eventTime, @NotNull String trackId, long degradedAt, long durationDegraded, boolean hidden) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"trackID", (Object)trackId), TuplesKt.to((Object)"recoveredAt", (Object)String.valueOf(eventTime)), TuplesKt.to((Object)"degradedAt", (Object)String.valueOf(degradedAt)), TuplesKt.to((Object)"duration", (Object)String.valueOf(durationDegraded)), TuplesKt.to((Object)"hidden", (Object)String.valueOf(hidden))};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.ERROR;
        String name = "video.degradation.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent selectedAudioDevice(@NotNull HMSAudioManager.AudioDevice selectedDevice) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)selectedDevice), (String)"selectedDevice");
        Pair[] pairArray = new Pair[1];
        switch (WhenMappings.$EnumSwitchMapping$0[selectedDevice.ordinal()]) {
            case 1: {
                string = "speakerphone";
                break;
            }
            case 2: {
                string = "wiredhs";
                break;
            }
            case 3: {
                string = "earpiece";
                break;
            }
            case 4: {
                string = "bt";
                break;
            }
            case 5: {
                string = "auto";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        pairArray[0] = TuplesKt.to((Object)"speakerOutput", (Object)string);
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "audio.stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent focusOwnedStatus(@NotNull String owned) {
        Intrinsics.checkNotNullParameter((Object)owned, (String)"owned");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusGained", (Object)owned)};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "audio.focus.owned";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent noiseCancellationStats(long enabledDuration) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"duration", (Object)enabledDuration)};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "krisp.usage";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent clientSideStats(@NotNull PublishAnalyticPayload publishAnalyticPayload, boolean isSubscriber) {
        Intrinsics.checkNotNullParameter((Object)publishAnalyticPayload, (String)"publishAnalyticPayload");
        HashMap<String, Object> properties = ExtensionUtilsKt.toMap(new JSONObject(ExtensionUtilsKt.toJson(publishAnalyticPayload)));
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = (isSubscriber ? "subscriber" : "publisher") + ".stats";
        return new AnalyticsEvent(name, level, false, properties);
    }

    public static /* synthetic */ AnalyticsEvent clientSideStats$default(AnalyticsEventFactory analyticsEventFactory, PublishAnalyticPayload publishAnalyticPayload, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return analyticsEventFactory.clientSideStats(publishAnalyticPayload, bl);
    }

    @NotNull
    public final AnalyticsEvent audioEchoCancellation(boolean isHardware) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"isHardwareAEC", (Object)isHardware)};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        HMSAnalyticsEventLevel level = HMSAnalyticsEventLevel.INFO;
        String name = "aec.isHardware";
        return new AnalyticsEvent(name, level, false, properties);
    }

    @NotNull
    public final AnalyticsEvent joinStatusEvent(boolean eventSuccessful, @NotNull HashMap<String, Object> eventMap) {
        Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
        String status = eventSuccessful ? "success" : "failure";
        HMSAnalyticsEventLevel level = eventSuccessful ? HMSAnalyticsEventLevel.INFO : HMSAnalyticsEventLevel.ERROR;
        String name = "join." + status;
        return new AnalyticsEvent(name, level, false, (HashMap)MapsKt.toMap((Map)eventMap, (Map)new HashMap()));
    }

    @NotNull
    public final AnalyticsEvent previewStatusEvent(boolean eventSuccessful, @NotNull HashMap<String, Object> eventMap) {
        Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
        String status = eventSuccessful ? "success" : "failure";
        HMSAnalyticsEventLevel level = eventSuccessful ? HMSAnalyticsEventLevel.INFO : HMSAnalyticsEventLevel.ERROR;
        String name = "preview." + status;
        return new AnalyticsEvent(name, level, false, (HashMap)MapsKt.toMap((Map)eventMap, (Map)new HashMap()));
    }

    @NotNull
    public final AnalyticsEvent genericHMSExceptionEvent(@NotNull HMSException hmsException) {
        Intrinsics.checkNotNullParameter((Object)hmsException, (String)"hmsException");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error_code", (Object)hmsException.getCode()), TuplesKt.to((Object)"error_message", (Object)String.valueOf(hmsException.getMessage())), TuplesKt.to((Object)"error_description", (Object)String.valueOf(hmsException.getCause())), TuplesKt.to((Object)"is_terminal", (Object)hmsException.isTerminal())};
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        return new AnalyticsEvent(hmsException.getName(), HMSAnalyticsEventLevel.ERROR, false, properties);
    }

    @NotNull
    public final AnalyticsEvent cameraCapturingException(@NotNull Throwable exception) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String name = "camera.captureImageAtMaxSupportedResolution.error";
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"error_code", (Object)"7006");
        pairArray[1] = TuplesKt.to((Object)"is_terminal", (Object)"false");
        pairArray[2] = TuplesKt.to((Object)"name", (Object)"Error in capturing image from camera pipeline");
        String string3 = exception.getMessage();
        if (string3 == null) {
            string3 = null;
        }
        pairArray[3] = TuplesKt.to((Object)"error_message", (Object)String.valueOf(string3));
        Object[] objectArray = exception.getStackTrace();
        if (objectArray != null) {
            String string4 = Arrays.toString(objectArray);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this)");
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        pairArray[4] = TuplesKt.to((Object)"error_description", (Object)StringsKt.take((String)string, (int)1024));
        HashMap properties = MapsKt.hashMapOf((Pair[])pairArray);
        return new AnalyticsEvent(name, HMSAnalyticsEventLevel.ERROR, false, properties);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSAudioManager.AudioDevice.values().length];
            try {
                nArray[HMSAudioManager.AudioDevice.SPEAKER_PHONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.WIRED_HEADSET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.EARPIECE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.BLUETOOTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HMSAudioManager.AudioDevice.AUTOMATIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

