/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import live.hms.video.audio.AudioChangeEvent;
import live.hms.video.audio.AudioManagerFocusChangeCallbacks;
import live.hms.video.audio.HMSAudioDeviceInfo;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.audio.HMSBluetoothManager;
import live.hms.video.error.ErrorFactory;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.PhoneCallState;
import live.hms.video.sdk.IErrorListener;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.ThreadUtils;

public class HMSAudioManagerLegacy
implements HMSAudioManager {
    private static final String TAG = "HMSAudioManagerLegacy";
    private static final String SPEAKERPHONE_AUTO = "auto";
    private static final String SPEAKERPHONE_TRUE = "true";
    private static final String SPEAKERPHONE_FALSE = "false";
    private static final String PREF_SPEAKERPHONE_KEY = "speakerphone_preference";
    private static final String PREF_SPEAKERPHONE_DEAFULT = "auto";
    private final AnalyticsEventsService analytics;
    private boolean isStarted;
    private final Context hmscontext;
    @Nullable
    private final AudioManager audioManager;
    private IErrorListener errorListener = null;
    @Nullable
    private HMSAudioManager.AudioManagerDeviceChangeListener audioManagerDeviceChangeListener;
    private HMSAudioManager.AudioManagerState amState;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn;
    private boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    private HMSAudioTrackSettings hmsAudioTrackSettings = null;
    private final Object TELEPHONY_LOCK = new Object();
    private HMSAudioManager.AudioDevice defaultAudioDevice;
    private HMSAudioManager.AudioDevice selectedAudioDevice = HMSAudioManager.AudioDevice.AUTOMATIC;
    private HMSAudioManager.AudioDevice userSelectedAudioDevice;
    private int userSelectedAudioMode = 3;
    @Nullable
    private final String useSpeakerphone;
    private final HMSBluetoothManager bluetoothManager;
    private Set<HMSAudioManager.AudioDevice> audioDevices = new HashSet<HMSAudioManager.AudioDevice>();
    private final BroadcastReceiver wiredHeadsetReceiver;
    Handler mainHandler;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    private final List<AudioManagerFocusChangeCallbacks> focusChangeCallbacks = new ArrayList<AudioManagerFocusChangeCallbacks>();
    private PhoneStateListener phoneStateChangeListener = null;

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void addAudioFocusChangeCallback(AudioManagerFocusChangeCallbacks callback) {
        this.focusChangeCallbacks.add(callback);
    }

    @Override
    public void removeAudioFocusChangeCallback(AudioManagerFocusChangeCallbacks callback) {
        this.focusChangeCallbacks.remove(callback);
    }

    private void onProximitySensorChangedState() {
        if (!this.useSpeakerphone.equals("auto")) {
            return;
        }
    }

    @MainThread
    public HMSAudioManagerLegacy(Context context, AnalyticsEventsService analytics, HMSAudioTrackSettings hmsAudioTrackSettings, IErrorListener errorListener, HMSAudioManager.AudioManagerDeviceChangeListener audioManagerDeviceChangeListener) {
        this.analytics = analytics;
        this.hmscontext = context;
        this.errorListener = errorListener;
        this.mainHandler = new Handler(this.hmscontext.getMainLooper());
        this.hmsAudioTrackSettings = hmsAudioTrackSettings;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.bluetoothManager = HMSBluetoothManager.create(context, this);
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.amState = HMSAudioManager.AudioManagerState.UNINITIALIZED;
        this.audioManagerDeviceChangeListener = audioManagerDeviceChangeListener;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.useSpeakerphone = sharedPreferences.getString(PREF_SPEAKERPHONE_KEY, "auto");
        HMSLogger.d(TAG, "useSpeakerphone: " + this.useSpeakerphone);
        this.defaultAudioDevice = this.useSpeakerphone.equals(SPEAKERPHONE_FALSE) ? HMSAudioManager.AudioDevice.EARPIECE : (this.hasWiredHeadset ? HMSAudioManager.AudioDevice.WIRED_HEADSET : HMSAudioManager.AudioDevice.SPEAKER_PHONE);
        HMSLogger.d(TAG, "defaultAudioDevice: " + (Object)((Object)this.defaultAudioDevice));
        HMSLogger.logDeviceInfo(TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTelephony(IErrorListener onErrorListener) {
        if (this.hmsAudioTrackSettings != null && this.mainHandler != null && this.hmsAudioTrackSettings.getPhoneCallState() == PhoneCallState.DISABLE_MUTE_ON_VOIP_PHONE_CALL_RING) {
            Object object = this.TELEPHONY_LOCK;
            synchronized (object) {
                this.mainHandler.post(() -> {
                    if (this.phoneStateChangeListener == null) {
                        this.phoneStateChangeListener = new PhoneStateListener(){

                            public void onCallStateChanged(int state2, @NonNull String phoneNumber) {
                                super.onCallStateChanged(state2, phoneNumber);
                                if (state2 == 2) {
                                    HMSLogger.d(HMSAudioManagerLegacy.TAG, "onCallStateChanged: " + (Object)((Object)AudioChangeEvent.PHONE_RINGING));
                                    HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.PHONE_RINGING);
                                }
                            }
                        };
                    }
                    TelephonyManager telephonyManager = (TelephonyManager)this.hmscontext.getSystemService("phone");
                    if (Build.VERSION.SDK_INT >= 30) {
                        if (ContextCompat.checkSelfPermission((Context)this.hmscontext, (String)"android.permission.READ_PHONE_STATE") == 0) {
                            telephonyManager.listen(this.phoneStateChangeListener, 32);
                        } else {
                            onErrorListener.onError(ErrorFactory.ReadPhoneStateError());
                        }
                    } else {
                        telephonyManager.listen(this.phoneStateChangeListener, 32);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deInitTelephony() {
        if (this.hmsAudioTrackSettings != null && this.mainHandler != null && this.phoneStateChangeListener != null && this.hmsAudioTrackSettings.getPhoneCallState() == PhoneCallState.DISABLE_MUTE_ON_VOIP_PHONE_CALL_RING) {
            Object object = this.TELEPHONY_LOCK;
            synchronized (object) {
                this.mainHandler.post(() -> {
                    TelephonyManager telephonyManager = (TelephonyManager)this.hmscontext.getSystemService("phone");
                    if (ContextCompat.checkSelfPermission((Context)this.hmscontext, (String)"android.permission.READ_PHONE_STATE") == 0) {
                        telephonyManager.listen(this.phoneStateChangeListener, 0);
                    }
                });
            }
        }
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    @MainThread
    public void start() {
        int result2;
        HMSLogger.d(TAG, "start HMSAudioManagerLegacy");
        if (this.amState == HMSAudioManager.AudioManagerState.RUNNING) {
            HMSLogger.e(TAG, "AudioManager is already active");
            return;
        }
        HMSLogger.d(TAG, "AudioManager starts...");
        this.amState = HMSAudioManager.AudioManagerState.RUNNING;
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.hasWiredHeadset = this.hasWiredHeadset();
        if (this.errorListener != null) {
            this.initTelephony(this.errorListener::onError);
        }
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                String typeOfChange;
                switch (focusChange) {
                    case 1: {
                        typeOfChange = "AUDIOFOCUS_GAIN";
                        HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.AUDIOFOCUS_GAIN);
                        HMSLogger.d(HMSAudioManagerLegacy.TAG, "Throwing away currently saved devices (forcing new device for onDeviceUpdate) since the audio was gained again.");
                        HMSAudioManagerLegacy.this.audioDevices = new HashSet();
                        HMSAudioManagerLegacy.this.updateAudioDeviceState();
                        break;
                    }
                    case 2: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT";
                        HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_TRANSIENT);
                        break;
                    }
                    case 4: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                        HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_EXCLUSIVE);
                        break;
                    }
                    case 3: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                        HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK);
                        break;
                    }
                    case -1: {
                        typeOfChange = "AUDIOFOCUS_LOSS";
                        HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_LOSS);
                        break;
                    }
                    case -2: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT";
                        HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.AUDIOFOCUS_LOSS_TRANSIENT);
                        break;
                    }
                    case -3: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                        HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK);
                        break;
                    }
                    default: {
                        typeOfChange = "AUDIOFOCUS_INVALID";
                        HMSAudioManagerLegacy.this.sendAudioChangeEvent(AudioChangeEvent.DEBUG_INVALID);
                    }
                }
                HMSLogger.d(HMSAudioManagerLegacy.TAG, "onAudioFocusChange: " + typeOfChange);
            }
        };
        if (Build.VERSION.SDK_INT >= 26) {
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(2).setContentType(1).build();
            AudioFocusRequest audioFocusRequest = new AudioFocusRequest.Builder(2).setAcceptsDelayedFocusGain(true).setAudioAttributes(audioAttributes).setOnAudioFocusChangeListener(this.audioFocusChangeListener).build();
            result2 = this.audioManager.requestAudioFocus(audioFocusRequest);
        } else {
            result2 = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 2);
        }
        if (result2 == 1) {
            HMSLogger.d(TAG, "Audio focus request granted for VOICE_CALL streams");
        } else {
            HMSLogger.e(TAG, "Audio focus request failed");
        }
        this.audioManager.setMode(this.userSelectedAudioMode);
        this.setMicrophoneMute(false);
        this.userSelectedAudioDevice = HMSAudioManager.AudioDevice.AUTOMATIC;
        this.audioDevices.clear();
        this.bluetoothManager.start(errorType -> this.errorListener.onError(ErrorFactory.BluetoothError(errorType)));
        this.updateAudioDeviceState();
        this.registerReceiver(this.wiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        HMSLogger.d(TAG, "AudioManager started");
        this.isStarted = true;
    }

    private void sendAudioChangeEvent(AudioChangeEvent event) {
        for (AudioManagerFocusChangeCallbacks callback : this.focusChangeCallbacks) {
            callback.onAudioFocusChange(event);
        }
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    @MainThread
    public void stop() {
        HMSLogger.d(TAG, "stop");
        if (this.amState != HMSAudioManager.AudioManagerState.RUNNING) {
            HMSLogger.e(TAG, "Trying to stop AudioManager in incorrect state: " + (Object)((Object)this.amState));
            return;
        }
        this.amState = HMSAudioManager.AudioManagerState.UNINITIALIZED;
        this.deInitTelephony();
        this.unregisterReceiver(this.wiredHeadsetReceiver);
        this.bluetoothManager.stop();
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        this.audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        HMSLogger.d(TAG, "Abandoned audio focus for VOICE_CALL streams");
        this.audioManagerDeviceChangeListener = null;
        HMSLogger.d(TAG, "AudioManager stopped");
        this.isStarted = false;
    }

    private void setAudioDeviceInternal(HMSAudioManager.AudioDevice device) {
        HMSLogger.d(TAG, "setAudioDeviceInternal(device=" + (Object)((Object)device) + ")");
        switch (device) {
            case SPEAKER_PHONE: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case EARPIECE: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case WIRED_HEADSET: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case BLUETOOTH: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                HMSLogger.e(TAG, "Invalid audio device selection");
            }
        }
        this.selectedAudioDevice = device;
    }

    private void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    @Override
    @MainThread
    public void selectAudioDevice(HMSAudioManager.AudioDevice device) {
        if (!this.audioDevices.contains((Object)device)) {
            HMSLogger.e(TAG, "Can not select " + (Object)((Object)device) + " from available " + this.audioDevices);
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    @Override
    @MainThread
    public Set<HMSAudioManager.AudioDevice> getAudioDevices() {
        return Collections.unmodifiableSet(new HashSet<HMSAudioManager.AudioDevice>(this.audioDevices));
    }

    @Override
    @MainThread
    public HMSAudioManager.AudioDevice getSelectedAudioDevice() {
        return this.selectedAudioDevice;
    }

    @Override
    @NonNull
    public List<HMSAudioDeviceInfo> getAudioDevicesInfoList() {
        ArrayList<HMSAudioDeviceInfo> deviceList = new ArrayList<HMSAudioDeviceInfo>();
        for (HMSAudioManager.AudioDevice audioDevice : this.audioDevices) {
            if (audioDevice == HMSAudioManager.AudioDevice.BLUETOOTH && this.bluetoothManager != null) {
                deviceList.add(new HMSAudioDeviceInfo(audioDevice, this.bluetoothManager.getBluetoothDeviceName()));
                continue;
            }
            deviceList.add(new HMSAudioDeviceInfo(audioDevice, ""));
        }
        return deviceList;
    }

    @Override
    @MainThread
    public void setAudioMode(int audioMode) {
        this.userSelectedAudioMode = audioMode;
        if (this.audioManager != null && this.isStarted) {
            this.audioManager.setMode(audioMode);
        }
    }

    private void registerReceiver(BroadcastReceiver receiver, IntentFilter filter2) {
        this.hmscontext.registerReceiver(receiver, filter2);
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        this.hmscontext.unregisterReceiver(receiver);
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.audioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(on);
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.audioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    private boolean hasEarpiece() {
        return this.hmscontext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        AudioDeviceInfo[] devices;
        if (Build.VERSION.SDK_INT < 23) {
            return this.audioManager.isWiredHeadsetOn();
        }
        for (AudioDeviceInfo device : devices = this.audioManager.getDevices(3)) {
            int type = device.getType();
            if (type == 3) {
                HMSLogger.d(TAG, "hasWiredHeadset: found wired headset");
                return true;
            }
            if (type != 11) continue;
            HMSLogger.d(TAG, "hasWiredHeadset: found USB audio device");
            return true;
        }
        return false;
    }

    @MainThread
    public void updateAudioDeviceState() {
        HMSAudioManager.AudioDevice newAudioDevice;
        boolean needBluetoothAudioStop;
        HMSLogger.d(TAG, "--- updateAudioDeviceState: wired headset=" + this.hasWiredHeadset + ", BT state=" + (Object)((Object)this.bluetoothManager.getState()));
        HMSLogger.d(TAG, "Device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)this.selectedAudioDevice) + ", user selected=" + (Object)((Object)this.userSelectedAudioDevice));
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_UNAVAILABLE || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_DISCONNECTING) {
            this.bluetoothManager.updateDevice();
        }
        HashSet<HMSAudioManager.AudioDevice> newAudioDevices = new HashSet<HMSAudioManager.AudioDevice>();
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_AVAILABLE) {
            newAudioDevices.add(HMSAudioManager.AudioDevice.BLUETOOTH);
        }
        newAudioDevices.add(HMSAudioManager.AudioDevice.EARPIECE);
        if (this.hasWiredHeadset) {
            newAudioDevices.add(HMSAudioManager.AudioDevice.WIRED_HEADSET);
            newAudioDevices.remove((Object)HMSAudioManager.AudioDevice.EARPIECE);
            this.defaultAudioDevice = HMSAudioManager.AudioDevice.WIRED_HEADSET;
        } else {
            newAudioDevices.add(HMSAudioManager.AudioDevice.SPEAKER_PHONE);
            if (this.hasEarpiece()) {
                newAudioDevices.add(HMSAudioManager.AudioDevice.EARPIECE);
            }
        }
        newAudioDevices.add(HMSAudioManager.AudioDevice.SPEAKER_PHONE);
        newAudioDevices.add(HMSAudioManager.AudioDevice.AUTOMATIC);
        boolean audioDeviceListUpdated = !this.audioDevices.equals(newAudioDevices);
        this.audioDevices = newAudioDevices;
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_UNAVAILABLE && this.userSelectedAudioDevice == HMSAudioManager.AudioDevice.BLUETOOTH) {
            this.userSelectedAudioDevice = HMSAudioManager.AudioDevice.AUTOMATIC;
        }
        if (this.hasWiredHeadset && this.userSelectedAudioDevice == HMSAudioManager.AudioDevice.WIRED_HEADSET) {
            this.userSelectedAudioDevice = HMSAudioManager.AudioDevice.WIRED_HEADSET;
        }
        if (!this.hasWiredHeadset && this.userSelectedAudioDevice == HMSAudioManager.AudioDevice.WIRED_HEADSET) {
            this.userSelectedAudioDevice = HMSAudioManager.AudioDevice.SPEAKER_PHONE;
        }
        boolean needBluetoothAudioStart = this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_AVAILABLE && (this.userSelectedAudioDevice == HMSAudioManager.AudioDevice.AUTOMATIC || this.userSelectedAudioDevice == HMSAudioManager.AudioDevice.BLUETOOTH);
        boolean bl = needBluetoothAudioStop = (this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTING) && this.userSelectedAudioDevice != HMSAudioManager.AudioDevice.AUTOMATIC && this.userSelectedAudioDevice != HMSAudioManager.AudioDevice.BLUETOOTH;
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTED) {
            HMSLogger.d(TAG, "Need BT audio: start=" + needBluetoothAudioStart + ", stop=" + needBluetoothAudioStop + ", BT state=" + (Object)((Object)this.bluetoothManager.getState()));
        }
        if (needBluetoothAudioStop) {
            this.bluetoothManager.stopScoAudio();
            this.bluetoothManager.updateDevice();
        }
        if (needBluetoothAudioStart && !needBluetoothAudioStop && !this.bluetoothManager.startScoAudio()) {
            if (this.audioManagerDeviceChangeListener != null) {
                this.audioManagerDeviceChangeListener.onError(ErrorFactory.AudioOutputErrors.INSTANCE.bluetoothScoInitFailure());
            }
            audioDeviceListUpdated = true;
        }
        if (this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTED) {
            newAudioDevice = HMSAudioManager.AudioDevice.BLUETOOTH;
        } else if (this.bluetoothManager.getState() == HMSBluetoothManager.State.SCO_CONNECTING) {
            newAudioDevice = this.selectedAudioDevice;
        } else if (this.hasWiredHeadset && this.userSelectedAudioDevice == HMSAudioManager.AudioDevice.WIRED_HEADSET) {
            newAudioDevice = HMSAudioManager.AudioDevice.WIRED_HEADSET;
        } else if (this.userSelectedAudioDevice == HMSAudioManager.AudioDevice.EARPIECE) {
            newAudioDevice = this.userSelectedAudioDevice;
        } else if (this.userSelectedAudioDevice == HMSAudioManager.AudioDevice.SPEAKER_PHONE) {
            newAudioDevice = this.userSelectedAudioDevice;
        } else {
            if (this.defaultAudioDevice == HMSAudioManager.AudioDevice.WIRED_HEADSET && !this.hasWiredHeadset) {
                this.defaultAudioDevice = HMSAudioManager.AudioDevice.SPEAKER_PHONE;
            }
            newAudioDevice = this.defaultAudioDevice;
        }
        if (newAudioDevice != this.selectedAudioDevice || audioDeviceListUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            HMSLogger.d(TAG, "New device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)newAudioDevice));
            if (this.audioManagerDeviceChangeListener != null) {
                this.audioManagerDeviceChangeListener.onAudioDeviceChanged(this.selectedAudioDevice, this.audioDevices);
            }
            this.analytics.queue(AnalyticsEventFactory.INSTANCE.selectedAudioDevice(newAudioDevice));
        }
        HMSLogger.d(TAG, "--- updateAudioDeviceState done");
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state2 = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            HMSLogger.d(HMSAudioManagerLegacy.TAG, "WiredHeadsetReceiver.onReceive" + ThreadUtils.getThreadInfo() + ": a=" + intent.getAction() + ", s=" + (state2 == 0 ? "unplugged" : "plugged") + ", m=" + (microphone == 1 ? "mic" : "no mic") + ", n=" + name + ", sb=" + this.isInitialStickyBroadcast());
            HMSAudioManagerLegacy.this.hasWiredHeadset = state2 == 1;
            HMSAudioManagerLegacy.this.updateAudioDeviceState();
        }
    }
}

