/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.stats;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.degredation.Track;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011RJ\u0010\u0003\u001a>\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0004j\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llive/hms/video/connection/stats/BitrateCalculator;", "", "()V", "prevTrackStatsReceivedTime", "Ljava/util/HashMap;", "", "Lkotlin/Pair;", "", "Ljava/math/BigInteger;", "Lkotlin/collections/HashMap;", "getBitrateFromTrackUpdatePrev", "trackId", "remoteTimeStamp", "bytesTransported", "rid", "(Ljava/lang/String;Ljava/lang/Double;Ljava/math/BigInteger;Ljava/lang/String;)D", "stat", "Llive/hms/video/connection/degredation/Track;", "lib_release"})
public final class BitrateCalculator {
    @NotNull
    private final HashMap<String, Pair<Double, BigInteger>> prevTrackStatsReceivedTime = new HashMap();

    public final double getBitrateFromTrackUpdatePrev(@NotNull Track stat) {
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        String string = stat.getTrackIdentifier();
        Double d = stat.getRemoteTimestamp();
        BigInteger bigInteger = stat.getBytesTransported();
        Object object = stat instanceof Track.LocalTrack.LocalVideo ? (Track.LocalTrack.LocalVideo)stat : null;
        if (object == null || (object = ((Track.LocalTrack.LocalVideo)object).getHmsLayer()) == null || (object = ((Enum)object).name()) == null) {
            object = "";
        }
        return this.getBitrateFromTrackUpdatePrev(string, d, bigInteger, (String)object);
    }

    public final double getBitrateFromTrackUpdatePrev(@Nullable String trackId, @Nullable Double remoteTimeStamp, @Nullable BigInteger bytesTransported, @NotNull String rid) {
        Intrinsics.checkNotNullParameter((Object)rid, (String)"rid");
        String trackIdentifier = trackId;
        double bitrate = 0.0;
        if (trackIdentifier != null && remoteTimeStamp != null) {
            double d;
            BigInteger prevBytesReceived;
            Pair<Double, BigInteger> prevInfo;
            String simulcastPostFix = rid;
            Pair<Double, BigInteger> pair = prevInfo = this.prevTrackStatsReceivedTime.get(trackIdentifier + '_' + simulcastPostFix);
            Double prevTime = pair != null ? (Double)pair.getFirst() : null;
            Pair<Double, BigInteger> pair2 = prevInfo;
            BigInteger bigInteger = prevBytesReceived = pair2 != null ? (BigInteger)pair2.getSecond() : null;
            if (prevBytesReceived != null && prevTime != null && bytesTransported != null) {
                double timeDelta = (remoteTimeStamp - prevTime) / (double)1000000;
                d = (double)(0.008f * (bytesTransported.floatValue() - prevBytesReceived.floatValue())) / timeDelta;
            } else {
                d = 0.0;
            }
            bitrate = d;
            ((Map)this.prevTrackStatsReceivedTime).put(trackIdentifier + '_' + simulcastPostFix, new Pair((Object)remoteTimeStamp, (Object)bytesTransported));
        }
        return bitrate;
    }
}

