/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.media.tracks.HMSLocalAudioTrack;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.webrtc.SessionDescription;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J[\u0010\u0013\u001a:\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000f0\fj\b\u0012\u0004\u0012\u00020\u000f`\r\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u0015j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0004`\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0011\u00a2\u0006\u0002\u0010!J;\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\r2\u0006\u0010\u001a\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0002\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Llive/hms/video/utils/SDPUtils;", "", "()V", "ATTRIBUTE_RTPMAP", "", "MEDIA_AUDIO", "MEDIA_VIDEO", "SDP_SEPARATOR", "SDP_SEPARATOR_REGEX", "Lkotlin/text/Regex;", "TAG", "getMediaLines", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "sdpStartIndex", "", "sdp", "", "(I[Ljava/lang/String;)Ljava/util/ArrayList;", "getPayloadTypeToCodecMap", "Lkotlin/Pair;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "startIndex", "(I[Ljava/lang/String;)Lkotlin/Pair;", "mungeAudioMedia", "settings", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "(Llive/hms/video/media/settings/HMSAudioTrackSettings;I[Ljava/lang/String;)Ljava/util/ArrayList;", "mungePublishSDP", "Lorg/webrtc/SessionDescription;", "tracks", "Llive/hms/video/media/tracks/HMSTrack;", "(Lorg/webrtc/SessionDescription;[Llive/hms/video/media/tracks/HMSTrack;)Lorg/webrtc/SessionDescription;", "mungeVideoMedia", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "(Llive/hms/video/media/settings/HMSVideoTrackSettings;I[Ljava/lang/String;)Ljava/util/ArrayList;", "lib_release"})
public final class SDPUtils {
    @NotNull
    public static final SDPUtils INSTANCE = new SDPUtils();
    @NotNull
    private static final String TAG = "SDPUtils";
    @NotNull
    private static final String ATTRIBUTE_RTPMAP = "a=rtpmap";
    @NotNull
    private static final String MEDIA_AUDIO = "m=audio";
    @NotNull
    private static final String MEDIA_VIDEO = "m=video";
    @NotNull
    private static final Regex SDP_SEPARATOR_REGEX = new Regex("(\r\n|\r|\n)");
    @NotNull
    private static final String SDP_SEPARATOR = "\r\n";

    private SDPUtils() {
    }

    private final Pair<ArrayList<Integer>, HashMap<Integer, String>> getPayloadTypeToCodecMap(int startIndex, String[] sdp) {
        String[] stringArray;
        if (!StringsKt.startsWith$default((String)sdp[startIndex], (String)MEDIA_AUDIO, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)sdp[startIndex], (String)MEDIA_VIDEO, (boolean)false, (int)2, null)) {
            throw new IllegalArgumentException("Expected `startIndex=" + startIndex + "` to be a audio/video media attribute in sdp");
        }
        String[] stringArray2 = new String[]{" "};
        List mediaItems = StringsKt.split$default((CharSequence)sdp[startIndex], (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        ArrayList<Integer> payloadPriority = new ArrayList<Integer>();
        int n = 3;
        int n2 = mediaItems.size();
        if (n < n2) {
            do {
                int i = n++;
                stringArray = (String[])mediaItems.get(i);
                payloadPriority.add(Integer.parseInt((String)stringArray));
            } while (n < n2);
        }
        HashMap payloadTypeToCodec = new HashMap();
        int pos = startIndex;
        do {
            List list;
            if (!StringsKt.startsWith$default((String)sdp[pos], (String)ATTRIBUTE_RTPMAP, (boolean)false, (int)2, null)) continue;
            stringArray = sdp[pos];
            int n3 = ATTRIBUTE_RTPMAP.length() + 1;
            Object object = stringArray.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
            stringArray = object;
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)((CharSequence)stringArray))).toString();
            stringArray = new String[]{" "};
            List list2 = list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String payloadType = (String)list2.get(0);
            object = list;
            String codec = (String)object.get(1);
            object = payloadTypeToCodec;
            Object object2 = payloadType;
            object2 = Integer.parseInt((String)object2);
            object.put(object2, codec);
        } while (++pos < sdp.length && sdp[pos].charAt(0) != 'm');
        HMSLogger.d(TAG, "getPayloadTypeToCodecMap: payloadPriority=" + payloadPriority + " payloadTypeToCodecMap=" + payloadTypeToCodec);
        return new Pair(payloadPriority, payloadTypeToCodec);
    }

    private final ArrayList<String> getMediaLines(int sdpStartIndex, String[] sdp) {
        ArrayList<String> res2 = new ArrayList<String>();
        int pos = sdpStartIndex;
        do {
            res2.add(sdp[pos]);
        } while (++pos < sdp.length && sdp[pos].charAt(0) != 'm');
        return res2;
    }

    private final ArrayList<String> mungeAudioMedia(HMSAudioTrackSettings settings, int sdpStartIndex, String[] sdp) {
        ArrayList<String> res2 = new ArrayList<String>();
        Pair<ArrayList<Integer>, HashMap<Integer, String>> pair = this.getPayloadTypeToCodecMap(sdpStartIndex, sdp);
        ArrayList originalPayloadPriorityList = (ArrayList)pair.component1();
        HashMap payloadTypeToCodec = (HashMap)pair.component2();
        Map $this$filterValues$iv = payloadTypeToCodec;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!StringsKt.startsWith((String)it, (String)settings.getCodec().name(), (boolean)true)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map requiredPayloads = result$iv;
        if (requiredPayloads.isEmpty()) {
            throw new IllegalStateException("Codec=" + (Object)((Object)settings.getCodec()) + " not supported in this device");
        }
        String payloadsPriority = CollectionsKt.joinToString$default((Iterable)requiredPayloads.keySet(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        int pos = sdpStartIndex;
        do {
            if (StringsKt.startsWith$default((String)sdp[pos], (String)MEDIA_AUDIO, (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{" "};
                List mediaItems = StringsKt.split$default((CharSequence)sdp[pos], (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                res2.add("m=audio " + (String)mediaItems.get(1) + ' ' + (String)mediaItems.get(2) + ' ' + payloadsPriority);
                continue;
            }
            res2.add(sdp[pos]);
        } while (++pos < sdp.length && sdp[pos].charAt(0) != 'm');
        return res2;
    }

    private final ArrayList<String> mungeVideoMedia(HMSVideoTrackSettings settings, int sdpStartIndex, String[] sdp) {
        ArrayList<String> res2 = new ArrayList<String>();
        Pair<ArrayList<Integer>, HashMap<Integer, String>> pair = this.getPayloadTypeToCodecMap(sdpStartIndex, sdp);
        ArrayList originalPayloadPriorityList = (ArrayList)pair.component1();
        HashMap payloadTypeToCodec = (HashMap)pair.component2();
        Map $this$filterValues$iv = payloadTypeToCodec;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!StringsKt.startsWith((String)it, (String)settings.getCodec().name(), (boolean)true)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map requiredPayloads = result$iv;
        if (requiredPayloads.isEmpty()) {
            throw new IllegalStateException("Codec=" + (Object)((Object)settings.getCodec()) + " not supported in this device");
        }
        String payloadsPriority = CollectionsKt.joinToString$default((Iterable)requiredPayloads.keySet(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        int pos = sdpStartIndex;
        do {
            if (StringsKt.startsWith$default((String)sdp[pos], (String)MEDIA_VIDEO, (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{" "};
                List mediaItems = StringsKt.split$default((CharSequence)sdp[pos], (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                res2.add("m=video " + (String)mediaItems.get(1) + ' ' + (String)mediaItems.get(2) + ' ' + payloadsPriority);
                continue;
            }
            res2.add(sdp[pos]);
        } while (++pos < sdp.length && sdp[pos].charAt(0) != 'm');
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SessionDescription mungePublishSDP(@NotNull SessionDescription sdp, @NotNull HMSTrack[] tracks) {
        int index;
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)sdp, (String)"sdp");
        Intrinsics.checkNotNullParameter((Object)tracks, (String)"tracks");
        ArrayList<String> description = new ArrayList<String>();
        Object object = sdp.description;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sdp.description");
        object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
        Regex regex = SDP_SEPARATOR_REGEX;
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray2 = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] lines = stringArray;
        for (index = 0; index < lines.length && lines[index].charAt(0) != 'm'; ++index) {
            description.add(lines[index]);
        }
        while (index < lines.length) {
            if (StringsKt.startsWith$default((String)lines[index], (String)MEDIA_AUDIO, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lines[index], (String)MEDIA_VIDEO, (boolean)false, (int)2, null)) {
                HMSTrack[] $i$f$toTypedArray2 = tracks;
                int n2 = 0;
                int n3 = $i$f$toTypedArray2.length;
                while (n2 < n3) {
                    ArrayList<String> arrayList;
                    String string;
                    HMSTrack track = $i$f$toTypedArray2[n2];
                    ++n2;
                    HMSTrackType hMSTrackType = track.getType();
                    int n4 = WhenMappings.$EnumSwitchMapping$0[hMSTrackType.ordinal()];
                    switch (n4) {
                        case 1: {
                            string = MEDIA_AUDIO;
                            break;
                        }
                        case 2: {
                            string = MEDIA_VIDEO;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    String mediaToMunge = string;
                    if (!StringsKt.startsWith$default((String)lines[index], (String)mediaToMunge, (boolean)false, (int)2, null)) continue;
                    HMSTrackType hMSTrackType2 = track.getType();
                    int n5 = WhenMappings.$EnumSwitchMapping$0[hMSTrackType2.ordinal()];
                    switch (n5) {
                        case 1: {
                            arrayList = this.mungeAudioMedia(((HMSLocalAudioTrack)track).getSettings(), index, lines);
                            break;
                        }
                        case 2: {
                            arrayList = this.mungeVideoMedia(((HMSLocalVideoTrack)track).getSettings(), index, lines);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    ArrayList<String> modifiedLines = arrayList;
                    description.addAll((Collection)modifiedLines);
                    break;
                }
            } else {
                description.addAll((Collection)this.getMediaLines(index, lines));
            }
            while (++index < lines.length && lines[index].charAt(0) != 'm') {
            }
        }
        String modifiedSdp = Intrinsics.stringPlus((String)CollectionsKt.joinToString$default((Iterable)description, (CharSequence)SDP_SEPARATOR, null, null, (int)0, null, null, (int)62, null), (Object)SDP_SEPARATOR);
        HMSLogger.d(TAG, "mungePublishSDP: modified sdp [size=" + modifiedSdp.length() + "] " + modifiedSdp);
        return new SessionDescription(sdp.type, modifiedSdp);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSTrackType.values().length];
            nArray[HMSTrackType.AUDIO.ordinal()] = 1;
            nArray[HMSTrackType.VIDEO.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

