/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.interactivity.HmsInteractivityCenter;
import live.hms.video.media.tracks.HMSRemoteAudioTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.sdk.featureflags.FeatureFlags;
import live.hms.video.sdk.models.HMSConfig;
import live.hms.video.sdk.models.HMSLocalPeer;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSPeerType;
import live.hms.video.sdk.models.HMSRemotePeer;
import live.hms.video.sdk.models.HMSRoom;
import live.hms.video.sdk.models.role.HMSRole;
import live.hms.video.sdk.models.role.HMSWhiteBoardPermission;
import live.hms.video.sdk.models.role.PermissionsParams;
import live.hms.video.sdk.models.role.PublishParams;
import live.hms.video.sdk.models.role.SubscribeParams;
import live.hms.video.sessionstore.HmsSessionStore;
import live.hms.video.utils.AuthTokenUtils;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0080\b\u0018\u0000 \u008d\u00012\u00020\u0001:\b\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001B1\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020N2\u0006\u0010K\u001a\u00020OJ\u000e\u0010P\u001a\u00020N2\u0006\u0010Q\u001a\u00020RJ\u0016\u0010S\u001a\u00020N2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u0004J\u0006\u0010W\u001a\u00020NJ\u0015\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u0015\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007H\u00c2\u0003J5\u0010Z\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010[\u001a\u00020\u001f2\b\u0010\\\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J/\u0010]\u001a\b\u0012\u0004\u0012\u00020J0^2!\u0010_\u001a\u001d\u0012\u0013\u0012\u00110J\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(K\u0012\u0004\u0012\u00020\u001f0`J>\u0010c\u001a\u00020N26\u0010d\u001a2\u0012\u0013\u0012\u00110O\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(K\u0012\u0013\u0012\u00110f\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(g\u0012\u0004\u0012\u00020N0eJ)\u0010h\u001a\u00020N2!\u0010d\u001a\u001d\u0012\u0013\u0012\u00110R\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(Q\u0012\u0004\u0012\u00020N0`JS\u0010i\u001a\u00020N2K\u0010d\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(V\u0012\u0013\u0012\u00110U\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(k\u0012\u0013\u0012\u00110f\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(g\u0012\u0004\u0012\u00020N0jJ>\u0010l\u001a\u00020N26\u0010d\u001a2\u0012\u0013\u0012\u00110R\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(Q\u0012\u0013\u0012\u00110f\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(g\u0012\u0004\u0012\u00020N0eJ\b\u0010m\u001a\u0004\u0018\u00010nJ\u0006\u0010o\u001a\u00020\u001fJ\u0010\u0010p\u001a\u0004\u0018\u00010R2\u0006\u0010q\u001a\u00020\u0004J\b\u0010r\u001a\u0004\u0018\u00010\u0004J\u0012\u0010s\u001a\u0004\u0018\u00010O2\b\u0010V\u001a\u0004\u0018\u00010\u0004J\u0010\u0010t\u001a\u0004\u0018\u00010O2\u0006\u0010q\u001a\u00020\u0004J\f\u0010u\u001a\b\u0012\u0004\u0012\u00020O0^J\f\u0010v\u001a\b\u0012\u0004\u0012\u00020J0^J\u0018\u0010w\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0x0^J\u0010\u0010y\u001a\u0004\u0018\u00010F2\u0006\u0010q\u001a\u00020\u0004J\u000e\u0010z\u001a\u00020\u001f2\u0006\u0010{\u001a\u00020\u0004J\t\u0010|\u001a\u00020\u0013H\u00d6\u0001J\u000e\u0010}\u001a\u00020N2\u0006\u0010~\u001a\u00020\u007fJ9\u0010\u0080\u0001\u001a\t\u0012\u0005\u0012\u0003H\u0081\u00010^\"\u0005\b\u0000\u0010\u0081\u00012\"\u0010d\u001a\u001e\u0012\u0013\u0012\u00110R\u00a2\u0006\f\ba\u0012\b\bb\u0012\u0004\b\b(Q\u0012\u0005\u0012\u0003H\u0081\u00010`J\u0010\u0010\u0082\u0001\u001a\u00020N2\u0007\u0010\u0083\u0001\u001a\u00020\u001fJ\u000f\u0010\u0084\u0001\u001a\u00020\u001f2\u0006\u0010Q\u001a\u00020RJ\u000f\u0010\u0084\u0001\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020OJ\u000f\u0010\u0085\u0001\u001a\u00020N2\u0006\u0010Q\u001a\u00020RJ\u000f\u0010\u0086\u0001\u001a\u00020\u001f2\u0006\u0010q\u001a\u00020\u0004J\u0018\u0010\u0087\u0001\u001a\u00020N2\u000f\u0010\u0088\u0001\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010^J\u0010\u0010\u0089\u0001\u001a\u00020N2\u0007\u0010\u0083\u0001\u001a\u00020\u001fJ\n\u0010\u008a\u0001\u001a\u00020\u0004H\u00d6\u0001J\u000f\u0010\u008b\u0001\u001a\u00020\u001f2\u0006\u0010T\u001a\u00020UJ\u0017\u0010\u008c\u0001\u001a\u00020\u001f2\u0006\u0010V\u001a\u00020\u00042\u0006\u0010T\u001a\u00020UR\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00048B@BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\n\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\"\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\n\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00103\u001a\u0004\u0018\u0001022\b\u0010\n\u001a\u0004\u0018\u0001028F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R*\u00109\u001a\u0004\u0018\u0001082\b\u0010\n\u001a\u0004\u0018\u0001088F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R>\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002080>2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002080>8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020F0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00040HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0091\u0001"}, d2={"Llive/hms/video/sdk/SDKStore;", "", "peers", "", "", "Llive/hms/video/sdk/SDKStore$PeerTimePair;", "tracks", "Ljava/util/concurrent/ConcurrentHashMap;", "Llive/hms/video/sdk/SDKStore$TrackTimePair;", "(Ljava/util/Map;Ljava/util/concurrent/ConcurrentHashMap;)V", "<set-?>", "_localPeerId", "Llive/hms/video/sdk/models/HMSRoom;", "_room", "get_room", "()Llive/hms/video/sdk/models/HMSRoom;", "set_room", "(Llive/hms/video/sdk/models/HMSRoom;)V", "countPeers", "", "getCountPeers", "()I", "countTracks", "getCountTracks", "countTracksMetadata", "getCountTracksMetadata", "Llive/hms/video/sdk/featureflags/FeatureFlags;", "featureFlags", "getFeatureFlags", "()Llive/hms/video/sdk/featureflags/FeatureFlags;", "hasLocalPeer", "", "getHasLocalPeer", "()Z", "hmsInteractivityCenter", "Llive/hms/video/interactivity/HmsInteractivityCenter;", "getHmsInteractivityCenter", "()Llive/hms/video/interactivity/HmsInteractivityCenter;", "setHmsInteractivityCenter", "(Llive/hms/video/interactivity/HmsInteractivityCenter;)V", "hmsSessionStore", "Llive/hms/video/sessionstore/HmsSessionStore;", "getHmsSessionStore", "()Llive/hms/video/sessionstore/HmsSessionStore;", "setHmsSessionStore", "(Llive/hms/video/sessionstore/HmsSessionStore;)V", "localMute", "localPeerId", "getLocalPeerId", "()Ljava/lang/String;", "Llive/hms/video/sdk/models/HMSNotifications$Plugins;", "plugins", "getPlugins", "()Llive/hms/video/sdk/models/HMSNotifications$Plugins;", "setPlugins", "(Llive/hms/video/sdk/models/HMSNotifications$Plugins;)V", "Llive/hms/video/sdk/models/role/HMSRole;", "role", "getRole", "()Llive/hms/video/sdk/models/role/HMSRole;", "setRole", "(Llive/hms/video/sdk/models/role/HMSRole;)V", "", "rolesMap", "getRolesMap", "()Ljava/util/Map;", "setRolesMap", "(Ljava/util/Map;)V", "trackIDToPeerIdMap", "trackMetadata", "Llive/hms/video/sdk/SDKStore$TrackMetadataPair;", "trackMetadataId", "", "add", "Llive/hms/video/sdk/models/HMSRemotePeer;", "peer", "Llive/hms/video/sdk/models/HMSNotifications$PeerJoin;", "addLocalPeer", "", "Llive/hms/video/sdk/models/HMSPeer;", "addNativeTrack", "track", "Llive/hms/video/media/tracks/HMSTrack;", "addTrackMetadata", "data", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "peerId", "clear", "component1", "component2", "copy", "equals", "other", "filterRemoterPeers", "", "checker", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "forEachPeerWithTime", "action", "Lkotlin/Function2;", "", "time", "forEachTrack", "forEachTrackDataWithTime", "Lkotlin/Function3;", "trackData", "forEachTrackWithTime", "getLocalPeer", "Llive/hms/video/sdk/models/HMSLocalPeer;", "getLocalTracksMute", "getNativeTrackById", "trackId", "getNullableLocalPeerId", "getPeerById", "getPeerByTrackId", "getPeers", "getRemotePeers", "getRemoteTrackCopy", "Lkotlin/Pair;", "getTrackMetadata", "hasTrackMetadataFor", "id", "hashCode", "initWithConfig", "config", "Llive/hms/video/sdk/models/HMSConfig;", "mapTracks", "R", "muteAllRemoteTracks", "mute", "remove", "removeNativeTrack", "removeTrackData", "setFeatureFlags", "flags", "setLocalTracksMute", "toString", "updateRTCTrack", "updateTrackMetaData", "Companion", "PeerTimePair", "TrackMetadataPair", "TrackTimePair", "lib_release"})
public final class SDKStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, PeerTimePair> peers;
    @NotNull
    private final ConcurrentHashMap<String, TrackTimePair> tracks;
    private boolean localMute;
    @NotNull
    private final Set<String> trackMetadataId;
    @Nullable
    private HMSRole role;
    @NotNull
    private Map<String, HMSRole> rolesMap;
    @Nullable
    private HMSNotifications.Plugins plugins;
    @Nullable
    private String _localPeerId;
    @NotNull
    private final Map<String, TrackMetadataPair> trackMetadata;
    @NotNull
    private final Map<String, String> trackIDToPeerIdMap;
    @Nullable
    private HMSRoom _room;
    @Nullable
    private FeatureFlags featureFlags;
    @Nullable
    private HmsSessionStore hmsSessionStore;
    @Nullable
    private HmsInteractivityCenter hmsInteractivityCenter;
    @NotNull
    private static final String TAG = "SDKStore";

    public SDKStore(@NotNull Map<String, PeerTimePair> peers, @NotNull ConcurrentHashMap<String, TrackTimePair> tracks) {
        Intrinsics.checkNotNullParameter(peers, (String)"peers");
        Intrinsics.checkNotNullParameter(tracks, (String)"tracks");
        this.peers = peers;
        this.tracks = tracks;
        Map map = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedSet(HashSet<String>())");
        this.trackMetadataId = map;
        this.rolesMap = MapsKt.emptyMap();
        map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"synchronizedMap(HashMap())");
        this.trackMetadata = map;
        map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(HashMap())");
        this.trackIDToPeerIdMap = map;
    }

    public /* synthetic */ SDKStore(Map map, ConcurrentHashMap concurrentHashMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Map map2 = Collections.synchronizedMap(new HashMap());
            Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(HashMap())");
            map = map2;
        }
        if ((n & 2) != 0) {
            concurrentHashMap = new ConcurrentHashMap<String, TrackTimePair>();
        }
        this(map, concurrentHashMap);
    }

    public final synchronized void setLocalTracksMute(boolean mute) {
        this.localMute = mute;
    }

    public final synchronized boolean getLocalTracksMute() {
        return this.localMute;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void muteAllRemoteTracks(boolean mute) {
        void $this$forEach$iv;
        double volume = mute ? 0.0 : 1.0;
        Map map = this.tracks;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            HMSTrack track = ((TrackTimePair)it.getValue()).getTrack();
            if (track.getType() != HMSTrackType.AUDIO || !(track instanceof HMSRemoteAudioTrack)) continue;
            ((HMSRemoteAudioTrack)track).setVolume(volume);
        }
    }

    @Nullable
    public final synchronized HMSRole getRole() {
        return this.role;
    }

    public final synchronized void setRole(@Nullable HMSRole hMSRole) {
        this.role = hMSRole;
    }

    @NotNull
    public final synchronized Map<String, HMSRole> getRolesMap() {
        return this.rolesMap;
    }

    public final synchronized void setRolesMap(@NotNull Map<String, HMSRole> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.rolesMap = map;
    }

    @Nullable
    public final synchronized HMSNotifications.Plugins getPlugins() {
        return this.plugins;
    }

    public final synchronized void setPlugins(@Nullable HMSNotifications.Plugins plugins) {
        this.plugins = plugins;
    }

    @NotNull
    public final synchronized String getLocalPeerId() {
        String string = this._localPeerId;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public final String getNullableLocalPeerId() {
        return this._localPeerId;
    }

    public final synchronized int getCountTracks() {
        return this.tracks.size();
    }

    public final synchronized int getCountTracksMetadata() {
        return this.trackMetadata.size();
    }

    public final synchronized int getCountPeers() {
        return this.peers.size();
    }

    @Nullable
    public final synchronized HMSRoom get_room() {
        return this._room;
    }

    public final synchronized void set_room(@Nullable HMSRoom hMSRoom) {
        this._room = hMSRoom;
    }

    public final synchronized void initWithConfig(@NotNull HMSConfig config) {
        AuthTokenUtils.AuthToken token;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!this.getHasLocalPeer()) {
            boolean bl;
            List<String> list;
            HMSNotifications.WhiteboardPermissions whiteboardPermissions;
            HMSNotifications.Whiteboard whiteboard;
            token = AuthTokenUtils.INSTANCE.getJWTPayload(config.getAuthtoken());
            HMSNotifications.Plugins plugins = this.plugins;
            boolean bl2 = plugins == null ? false : ((whiteboard = plugins.getWhiteboard()) == null ? false : ((whiteboardPermissions = whiteboard.getPermissions()) == null ? false : ((list = whiteboardPermissions.getAdmin()) == null ? false : (bl = list.contains(token.getRole())))));
            plugins = this.plugins;
            boolean bl3 = plugins == null ? false : ((whiteboard = plugins.getWhiteboard()) == null ? false : ((whiteboardPermissions = whiteboard.getPermissions()) == null ? false : ((list = whiteboardPermissions.getReader()) == null ? false : (bl = list.contains(token.getRole())))));
            plugins = this.plugins;
            HMSLocalPeer hmsLocalPeer = new HMSLocalPeer(token.getUserId(), config.getUserName(), new HMSRole(token.getRole(), null, null, new PermissionsParams(false, false, false, false, false, false, false, false, false, false, null, 2047, null), 1, 1L, new HMSWhiteBoardPermission(bl2, bl3, plugins == null ? false : ((whiteboard = plugins.getWhiteboard()) == null ? false : ((whiteboardPermissions = whiteboard.getPermissions()) == null ? false : ((list = whiteboardPermissions.getWriter()) == null ? false : (bl = list.contains(token.getRole()))))))), config.getMetadata());
            this.addLocalPeer(hmsLocalPeer);
            this._room = new HMSRoom(token.getRoomId(), hmsLocalPeer.getName(), this, null, 8, null);
        } else if (this._room == null) {
            String string;
            HMSLocalPeer hMSLocalPeer;
            token = AuthTokenUtils.INSTANCE.getJWTPayload(config.getAuthtoken());
            this._room = new HMSRoom(token.getRoomId(), (hMSLocalPeer = this.getLocalPeer()) == null ? "Unknown Name" : ((string = hMSLocalPeer.getName()) == null ? "Unknown Name" : string), this, null, 8, null);
        }
        HMSLocalPeer hMSLocalPeer = this.getLocalPeer();
        if (hMSLocalPeer != null) {
            hMSLocalPeer.setName$lib_release(config.getUserName());
        }
    }

    @NotNull
    public final synchronized HMSRemotePeer add(@NotNull HMSNotifications.PeerJoin peer) {
        boolean bl;
        List<String> list;
        Object object;
        int n;
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        HMSRole peerRole = this.rolesMap.get(peer.getRole());
        Object object2 = peer.getPeerId();
        String string = peer.getInfo().getCustomerUserId();
        Map<String, PeerTimePair> map = peerRole;
        PublishParams publishParams = map == null ? null : ((HMSRole)((Object)map)).getPublishParams();
        map = peerRole;
        SubscribeParams subscribeParams = map == null ? null : ((HMSRole)((Object)map)).getSubscribeParams();
        Object object3 = peerRole;
        map = object3 == null ? null : ((HMSRole)object3).getPermission();
        Object object4 = map == null ? new PermissionsParams(false, false, false, false, false, false, false, false, false, false, null, 2047, null) : map;
        map = peerRole;
        int n2 = map == null ? 1 : (n = ((HMSRole)((Object)map)).getPriority());
        map = this.plugins;
        boolean bl2 = map == null ? false : ((object3 = ((HMSNotifications.Plugins)((Object)map)).getWhiteboard()) == null ? false : ((object = ((HMSNotifications.Whiteboard)object3).getPermissions()) == null ? false : ((list = ((HMSNotifications.WhiteboardPermissions)object).getAdmin()) == null ? false : (bl = list.contains(peer.getRole())))));
        map = this.plugins;
        boolean bl3 = map == null ? false : ((object3 = ((HMSNotifications.Plugins)((Object)map)).getWhiteboard()) == null ? false : ((object = ((HMSNotifications.Whiteboard)object3).getPermissions()) == null ? false : ((list = ((HMSNotifications.WhiteboardPermissions)object).getReader()) == null ? false : (bl = list.contains(peer.getRole())))));
        map = this.plugins;
        HMSRole hMSRole = new HMSRole(peer.getRole(), publishParams, subscribeParams, (PermissionsParams)object4, n2, 1L, new HMSWhiteBoardPermission(bl2, bl3, map == null ? false : ((object3 = ((HMSNotifications.Plugins)((Object)map)).getWhiteboard()) == null ? false : ((object = ((HMSNotifications.Whiteboard)object3).getPermissions()) == null ? false : ((list = ((HMSNotifications.WhiteboardPermissions)object).getWriter()) == null ? false : (bl = list.contains(peer.getRole())))))));
        map = peer.getInfo().getUserName();
        object = peer.getInfo().getMetadata();
        object3 = object == null ? "" : object;
        long l = peer.getJoinedAt();
        HMSPeerType hMSPeerType = peer.getInfo().getTypeSipOrRegular();
        HMSPeerType hMSPeerType2 = hMSPeerType == null ? HMSPeerType.REGULAR : hMSPeerType;
        Object $this$add_u24lambda_u2d1 = object2 = new HMSRemotePeer((String)object2, string, (String)((Object)map), hMSRole, l, (String)object3, hMSPeerType2);
        boolean bl4 = false;
        ((HMSPeer)$this$add_u24lambda_u2d1).setGroups$lib_release(peer.getGroups());
        Object it = object2;
        boolean bl5 = false;
        map = this.peers;
        object3 = peer.getPeerId();
        PeerTimePair peerTimePair = new PeerTimePair((HMSPeer)it, 0L, 2, null);
        map.put((String)object3, peerTimePair);
        return object2;
    }

    public final synchronized boolean getHasLocalPeer() {
        return this._localPeerId != null;
    }

    @Nullable
    public final synchronized HMSLocalPeer getLocalPeer() {
        HMSLocalPeer hMSLocalPeer;
        String string = this._localPeerId;
        if (string == null) {
            hMSLocalPeer = null;
        } else {
            String string2;
            String localPeerIdNonNull = string2 = string;
            boolean bl = false;
            HMSPeer hMSPeer = this.getPeerById(localPeerIdNonNull);
            if (hMSPeer == null) {
                hMSLocalPeer = null;
            } else {
                HMSPeer hMSPeer2;
                HMSPeer it = hMSPeer2 = hMSPeer;
                boolean bl2 = false;
                hMSLocalPeer = (HMSLocalPeer)it;
            }
        }
        return hMSLocalPeer;
    }

    public final synchronized void addLocalPeer(@NotNull HMSPeer peer) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Map<String, PeerTimePair> map = this.peers;
        String string = peer.getPeerID();
        PeerTimePair peerTimePair = new PeerTimePair(peer, 0L, 2, null);
        map.put(string, peerTimePair);
        this._localPeerId = peer.getPeerID();
    }

    public final synchronized boolean remove(@NotNull HMSPeer peer) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        return this.peers.remove(peer.getPeerID()) != null;
    }

    public final synchronized void addTrackMetadata(@NotNull HMSNotifications.Track data, @NotNull String peerId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
        this.trackMetadataId.add(data.getTrackId());
        Map<String, Object> map = this.trackIDToPeerIdMap;
        String string = data.getTrackId();
        map.put(string, peerId);
        map = this.trackMetadata;
        string = data.getTrackId();
        TrackMetadataPair trackMetadataPair = new TrackMetadataPair(peerId, data, 0L, 4, null);
        map.put(string, (String)((Object)trackMetadataPair));
    }

    public final synchronized boolean removeTrackData(@NotNull String trackId) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        this.trackMetadataId.add(trackId);
        return this.trackMetadata.remove(trackId) != null;
    }

    public final synchronized void addNativeTrack(@NotNull HMSTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Map map = this.tracks;
        String string = track.getTrackId();
        TrackTimePair trackTimePair = new TrackTimePair(track, 0L, 2, null);
        map.put(string, trackTimePair);
    }

    public final synchronized boolean remove(@NotNull HMSTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.trackIDToPeerIdMap.remove(track.getTrackId());
        return this.tracks.remove(track.getTrackId()) != null;
    }

    public final synchronized void removeNativeTrack(@NotNull HMSTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.tracks.remove(track.getTrackId());
    }

    public final synchronized boolean updateRTCTrack(@NotNull HMSNotifications.Track data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean found = false;
        TrackTimePair trackTimePair = this.tracks.get(data.getTrackId());
        if (trackTimePair != null) {
            HMSTrack hMSTrack;
            HMSTrack hMSTrack2;
            HMSTrack track = hMSTrack2 = (hMSTrack = trackTimePair.getTrack());
            boolean bl = false;
            String string = track.getType().toString();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            boolean bl2 = Intrinsics.areEqual((Object)string2, (Object)data.getType());
            if (!bl2) {
                boolean bl3 = false;
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            track.setSource(data.getSource());
            track.setMute$lib_release(data.isMute());
            track.setDescription$lib_release(data.getDescription());
            found = true;
        }
        return found;
    }

    public final synchronized boolean updateTrackMetaData(@NotNull String peerId, @NotNull HMSNotifications.Track data) {
        Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.trackMetadata.containsKey(data.getTrackId())) {
            Map<String, TrackMetadataPair> map = this.trackMetadata;
            String string = data.getTrackId();
            TrackMetadataPair trackMetadataPair = new TrackMetadataPair(peerId, data, 0L, 4, null);
            map.put(string, trackMetadataPair);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<HMSPeer> getPeers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.peers.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PeerTimePair peerTimePair = (PeerTimePair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HMSPeer hMSPeer = it.getPeer();
            collection.add(hMSPeer);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<HMSRemotePeer> getRemotePeers() {
        void $this$mapTo$iv$iv;
        HMSPeer it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getPeers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (HMSPeer)element$iv$iv;
            boolean bl = false;
            if (!(!it.isLocal())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (HMSPeer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HMSRemotePeer hMSRemotePeer = (HMSRemotePeer)it;
            collection.add(hMSRemotePeer);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final synchronized HMSPeer getPeerById(@Nullable String peerId) {
        PeerTimePair peerTimePair;
        return peerId == null ? null : ((peerTimePair = this.peers.get(peerId)) == null ? null : peerTimePair.getPeer());
    }

    @Nullable
    public final synchronized HMSTrack getNativeTrackById(@NotNull String trackId) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        TrackTimePair trackTimePair = this.tracks.get(trackId);
        return trackTimePair == null ? null : trackTimePair.getTrack();
    }

    @Nullable
    public final synchronized TrackMetadataPair getTrackMetadata(@NotNull String trackId) {
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        return this.trackMetadata.get(trackId);
    }

    @Nullable
    public final synchronized HMSPeer getPeerByTrackId(@NotNull String trackId) {
        HMSPeer hMSPeer;
        String peerId;
        Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
        String string = peerId = this.trackIDToPeerIdMap.get(trackId);
        if (string == null) {
            hMSPeer = null;
        } else {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            hMSPeer = this.getPeerById(it);
        }
        return hMSPeer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<HMSRemotePeer> filterRemoterPeers(@NotNull Function1<? super HMSRemotePeer, Boolean> checker) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(checker, (String)"checker");
        Map<String, PeerTimePair> $this$filter$iv = this.peers;
        boolean $i$f$filter = false;
        Map<String, PeerTimePair> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!((PeerTimePair)it.getValue()).getPeer().isLocal() && (Boolean)checker.invoke((Object)((HMSRemotePeer)((PeerTimePair)it.getValue()).getPeer())) != false)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            HMSRemotePeer hMSRemotePeer = (HMSRemotePeer)((PeerTimePair)it.getValue()).getPeer();
            object.add(hMSRemotePeer);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void forEachPeerWithTime(@NotNull Function2<? super HMSPeer, ? super Long, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map<String, PeerTimePair> map = this.peers;
        synchronized (map) {
            boolean bl = false;
            Map<String, PeerTimePair> $this$forEach$iv = this.peers;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, PeerTimePair>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PeerTimePair> element$iv;
                Map.Entry<String, PeerTimePair> it = element$iv = iterator.next();
                boolean bl2 = false;
                action.invoke((Object)it.getValue().getPeer(), (Object)it.getValue().getTimestamp());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final synchronized void forEachTrack(@NotNull Function1<? super HMSTrack, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map $this$forEach$iv = this.tracks;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            action.invoke((Object)((TrackTimePair)it.getValue()).getTrack());
        }
    }

    public final synchronized void forEachTrackWithTime(@NotNull Function2<? super HMSTrack, ? super Long, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map $this$forEach$iv = this.tracks;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            action.invoke((Object)((TrackTimePair)it.getValue()).getTrack(), (Object)((TrackTimePair)it.getValue()).getTimestamp());
        }
    }

    public final synchronized void forEachTrackDataWithTime(@NotNull Function3<? super String, ? super HMSNotifications.Track, ? super Long, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map<String, TrackMetadataPair> $this$forEach$iv = this.trackMetadata;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, TrackMetadataPair>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TrackMetadataPair> element$iv;
            Map.Entry<String, TrackMetadataPair> it = element$iv = iterator.next();
            boolean bl = false;
            action.invoke((Object)it.getValue().getPeerId(), (Object)it.getValue().getTrackData(), (Object)it.getValue().getTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean hasTrackMetadataFor(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Set<String> set2 = this.trackMetadataId;
        synchronized (set2) {
            boolean bl = false;
            boolean bl2 = this.trackMetadataId.contains(id);
            return bl2;
        }
    }

    public final synchronized void clear() {
        HMSLogger.d(TAG, "clear: START \u23f0");
        this.role = null;
        this.rolesMap = MapsKt.emptyMap();
        this.plugins = null;
        this.trackIDToPeerIdMap.clear();
        this.trackMetadata.clear();
        this.tracks.clear();
        this.peers.clear();
        this.setLocalTracksMute(false);
        this._localPeerId = null;
        this._room = null;
        this.featureFlags = null;
        this.hmsSessionStore = null;
        this.hmsInteractivityCenter = null;
        HMSLogger.d(TAG, "clear: DONE \u2705");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized <R> List<R> mapTracks(@NotNull Function1<? super HMSTrack, ? extends R> action) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map $this$map$iv = this.tracks;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = action.invoke((Object)((TrackTimePair)it.getValue()).getTrack());
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final synchronized List<Pair<String, TrackTimePair>> getRemoteTrackCopy() {
        return MapsKt.toList((Map)this.tracks);
    }

    @Nullable
    public final FeatureFlags getFeatureFlags() {
        return this.featureFlags;
    }

    public final void setFeatureFlags(@Nullable List<String> flags) {
        List<String> list = flags;
        if (list != null) {
            List<String> list2;
            List<String> it = list2 = list;
            boolean bl = false;
            this.featureFlags = new FeatureFlags(CollectionsKt.toSet((Iterable)it));
        }
    }

    @Nullable
    public final HmsSessionStore getHmsSessionStore() {
        return this.hmsSessionStore;
    }

    public final void setHmsSessionStore(@Nullable HmsSessionStore hmsSessionStore) {
        this.hmsSessionStore = hmsSessionStore;
    }

    @Nullable
    public final HmsInteractivityCenter getHmsInteractivityCenter() {
        return this.hmsInteractivityCenter;
    }

    public final void setHmsInteractivityCenter(@Nullable HmsInteractivityCenter hmsInteractivityCenter) {
        this.hmsInteractivityCenter = hmsInteractivityCenter;
    }

    private final Map<String, PeerTimePair> component1() {
        return this.peers;
    }

    private final ConcurrentHashMap<String, TrackTimePair> component2() {
        return this.tracks;
    }

    @NotNull
    public final SDKStore copy(@NotNull Map<String, PeerTimePair> peers, @NotNull ConcurrentHashMap<String, TrackTimePair> tracks) {
        Intrinsics.checkNotNullParameter(peers, (String)"peers");
        Intrinsics.checkNotNullParameter(tracks, (String)"tracks");
        return new SDKStore(peers, tracks);
    }

    public static /* synthetic */ SDKStore copy$default(SDKStore sDKStore, Map map, ConcurrentHashMap concurrentHashMap, int n, Object object) {
        if ((n & 1) != 0) {
            map = sDKStore.peers;
        }
        if ((n & 2) != 0) {
            concurrentHashMap = sDKStore.tracks;
        }
        return sDKStore.copy(map, concurrentHashMap);
    }

    @NotNull
    public String toString() {
        return "SDKStore(peers=" + this.peers + ", tracks=" + this.tracks + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.peers).hashCode();
        result2 = result2 * 31 + this.tracks.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SDKStore)) {
            return false;
        }
        SDKStore sDKStore = (SDKStore)other;
        if (!Intrinsics.areEqual(this.peers, sDKStore.peers)) {
            return false;
        }
        return Intrinsics.areEqual(this.tracks, sDKStore.tracks);
    }

    public SDKStore() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/sdk/SDKStore$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Llive/hms/video/sdk/SDKStore$PeerTimePair;", "", "peer", "Llive/hms/video/sdk/models/HMSPeer;", "timestamp", "", "(Llive/hms/video/sdk/models/HMSPeer;J)V", "getPeer", "()Llive/hms/video/sdk/models/HMSPeer;", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lib_release"})
    public static final class PeerTimePair {
        @NotNull
        private final HMSPeer peer;
        private final long timestamp;

        public PeerTimePair(@NotNull HMSPeer peer, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            this.peer = peer;
            this.timestamp = timestamp;
        }

        public /* synthetic */ PeerTimePair(HMSPeer hMSPeer, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            this(hMSPeer, l);
        }

        @NotNull
        public final HMSPeer getPeer() {
            return this.peer;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final HMSPeer component1() {
            return this.peer;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final PeerTimePair copy(@NotNull HMSPeer peer, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            return new PeerTimePair(peer, timestamp);
        }

        public static /* synthetic */ PeerTimePair copy$default(PeerTimePair peerTimePair, HMSPeer hMSPeer, long l, int n, Object object) {
            if ((n & 1) != 0) {
                hMSPeer = peerTimePair.peer;
            }
            if ((n & 2) != 0) {
                l = peerTimePair.timestamp;
            }
            return peerTimePair.copy(hMSPeer, l);
        }

        @NotNull
        public String toString() {
            return "PeerTimePair(peer=" + this.peer + ", timestamp=" + this.timestamp + ')';
        }

        public int hashCode() {
            int result2 = this.peer.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PeerTimePair)) {
                return false;
            }
            PeerTimePair peerTimePair = (PeerTimePair)other;
            if (!Intrinsics.areEqual((Object)this.peer, (Object)peerTimePair.peer)) {
                return false;
            }
            return this.timestamp == peerTimePair.timestamp;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Llive/hms/video/sdk/SDKStore$TrackTimePair;", "", "track", "Llive/hms/video/media/tracks/HMSTrack;", "timestamp", "", "(Llive/hms/video/media/tracks/HMSTrack;J)V", "getTimestamp", "()J", "getTrack", "()Llive/hms/video/media/tracks/HMSTrack;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lib_release"})
    public static final class TrackTimePair {
        @NotNull
        private final HMSTrack track;
        private final long timestamp;

        public TrackTimePair(@NotNull HMSTrack track, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)track, (String)"track");
            this.track = track;
            this.timestamp = timestamp;
        }

        public /* synthetic */ TrackTimePair(HMSTrack hMSTrack, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            this(hMSTrack, l);
        }

        @NotNull
        public final HMSTrack getTrack() {
            return this.track;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final HMSTrack component1() {
            return this.track;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final TrackTimePair copy(@NotNull HMSTrack track, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)track, (String)"track");
            return new TrackTimePair(track, timestamp);
        }

        public static /* synthetic */ TrackTimePair copy$default(TrackTimePair trackTimePair, HMSTrack hMSTrack, long l, int n, Object object) {
            if ((n & 1) != 0) {
                hMSTrack = trackTimePair.track;
            }
            if ((n & 2) != 0) {
                l = trackTimePair.timestamp;
            }
            return trackTimePair.copy(hMSTrack, l);
        }

        @NotNull
        public String toString() {
            return "TrackTimePair(track=" + this.track + ", timestamp=" + this.timestamp + ')';
        }

        public int hashCode() {
            int result2 = this.track.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackTimePair)) {
                return false;
            }
            TrackTimePair trackTimePair = (TrackTimePair)other;
            if (!Intrinsics.areEqual((Object)this.track, (Object)trackTimePair.track)) {
                return false;
            }
            return this.timestamp == trackTimePair.timestamp;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Llive/hms/video/sdk/SDKStore$TrackMetadataPair;", "", "peerId", "", "trackData", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "timestamp", "", "(Ljava/lang/String;Llive/hms/video/sdk/models/HMSNotifications$Track;J)V", "getPeerId", "()Ljava/lang/String;", "getTimestamp", "()J", "getTrackData", "()Llive/hms/video/sdk/models/HMSNotifications$Track;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lib_release"})
    public static final class TrackMetadataPair {
        @NotNull
        private final String peerId;
        @NotNull
        private final HMSNotifications.Track trackData;
        private final long timestamp;

        public TrackMetadataPair(@NotNull String peerId, @NotNull HMSNotifications.Track trackData, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)trackData, (String)"trackData");
            this.peerId = peerId;
            this.trackData = trackData;
            this.timestamp = timestamp;
        }

        public /* synthetic */ TrackMetadataPair(String string, HMSNotifications.Track track, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = System.currentTimeMillis();
            }
            this(string, track, l);
        }

        @NotNull
        public final String getPeerId() {
            return this.peerId;
        }

        @NotNull
        public final HMSNotifications.Track getTrackData() {
            return this.trackData;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final String component1() {
            return this.peerId;
        }

        @NotNull
        public final HMSNotifications.Track component2() {
            return this.trackData;
        }

        public final long component3() {
            return this.timestamp;
        }

        @NotNull
        public final TrackMetadataPair copy(@NotNull String peerId, @NotNull HMSNotifications.Track trackData, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)trackData, (String)"trackData");
            return new TrackMetadataPair(peerId, trackData, timestamp);
        }

        public static /* synthetic */ TrackMetadataPair copy$default(TrackMetadataPair trackMetadataPair, String string, HMSNotifications.Track track, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = trackMetadataPair.peerId;
            }
            if ((n & 2) != 0) {
                track = trackMetadataPair.trackData;
            }
            if ((n & 4) != 0) {
                l = trackMetadataPair.timestamp;
            }
            return trackMetadataPair.copy(string, track, l);
        }

        @NotNull
        public String toString() {
            return "TrackMetadataPair(peerId=" + this.peerId + ", trackData=" + this.trackData + ", timestamp=" + this.timestamp + ')';
        }

        public int hashCode() {
            int result2 = this.peerId.hashCode();
            result2 = result2 * 31 + this.trackData.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackMetadataPair)) {
                return false;
            }
            TrackMetadataPair trackMetadataPair = (TrackMetadataPair)other;
            if (!Intrinsics.areEqual((Object)this.peerId, (Object)trackMetadataPair.peerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trackData, (Object)trackMetadataPair.trackData)) {
                return false;
            }
            return this.timestamp == trackMetadataPair.timestamp;
        }
    }
}

