/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.tracks;

import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import live.hms.video.error.ErrorFactory;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import live.hms.video.media.streams.HMSLocalStream;
import live.hms.video.media.streams.HMSMediaStream;
import live.hms.video.media.tracks.HMSAudioTrack;
import live.hms.video.media.tracks.HMSLocalTrack;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.signal.ISignal;
import live.hms.video.utils.HMSCoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioTrack;
import org.webrtc.RtpParameters;
import org.webrtc.RtpTransceiver;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B'\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\nH\u0016J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020-H\u0016J\u0019\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020\nH\u0016R(\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Llive/hms/video/media/tracks/HMSLocalAudioTrack;", "Llive/hms/video/media/tracks/HMSAudioTrack;", "Llive/hms/video/media/tracks/HMSLocalTrack;", "stream", "Llive/hms/video/media/streams/HMSLocalStream;", "nativeTrack", "Lorg/webrtc/AudioTrack;", "settings", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "source", "", "(Llive/hms/video/media/streams/HMSLocalStream;Lorg/webrtc/AudioTrack;Llive/hms/video/media/settings/HMSAudioTrackSettings;Ljava/lang/String;)V", "sendLocalUpdate", "Lkotlin/Function1;", "", "getSendLocalUpdate$lib_release", "()Lkotlin/jvm/functions/Function1;", "setSendLocalUpdate$lib_release", "(Lkotlin/jvm/functions/Function1;)V", "<set-?>", "getSettings", "()Llive/hms/video/media/settings/HMSAudioTrackSettings;", "signal", "Llive/hms/video/signal/ISignal;", "getSignal$lib_release", "()Llive/hms/video/signal/ISignal;", "setSignal$lib_release", "(Llive/hms/video/signal/ISignal;)V", "getStream$lib_release", "()Llive/hms/video/media/streams/HMSLocalStream;", "transceiver", "Lorg/webrtc/RtpTransceiver;", "getTransceiver$lib_release", "()Lorg/webrtc/RtpTransceiver;", "setTransceiver$lib_release", "(Lorg/webrtc/RtpTransceiver;)V", "value", "", "volume", "getVolume", "()D", "setVolume", "(D)V", "setDescription", "setMute", "", "setSettings", "newSettings", "(Llive/hms/video/media/settings/HMSAudioTrackSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "lib_release"})
public final class HMSLocalAudioTrack
extends HMSAudioTrack
implements HMSLocalTrack {
    @NotNull
    private final HMSLocalStream stream;
    @Nullable
    private ISignal signal;
    @Nullable
    private RtpTransceiver transceiver;
    @Nullable
    private Function1<? super HMSLocalTrack, Unit> sendLocalUpdate;
    @NotNull
    private HMSAudioTrackSettings settings;
    private double volume;

    public HMSLocalAudioTrack(@NotNull HMSLocalStream stream, @NotNull AudioTrack nativeTrack, @NotNull HMSAudioTrackSettings settings, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)nativeTrack, (String)"nativeTrack");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super((HMSMediaStream)stream, nativeTrack, source);
        this.stream = stream;
        this.settings = settings;
        this.getStream$lib_release().getTracks().add(this);
        nativeTrack.setVolume(settings.getVolume());
        if (settings.getInitialState() == HMSTrackSettings.InitState.MUTED) {
            this.setMute(true);
        }
        this.volume = settings.getVolume();
    }

    @Override
    @NotNull
    public HMSLocalStream getStream$lib_release() {
        return this.stream;
    }

    @Nullable
    public final ISignal getSignal$lib_release() {
        return this.signal;
    }

    public final void setSignal$lib_release(@Nullable ISignal iSignal) {
        this.signal = iSignal;
    }

    @Nullable
    public final RtpTransceiver getTransceiver$lib_release() {
        return this.transceiver;
    }

    public final void setTransceiver$lib_release(@Nullable RtpTransceiver rtpTransceiver) {
        this.transceiver = rtpTransceiver;
    }

    @Nullable
    public final Function1<HMSLocalTrack, Unit> getSendLocalUpdate$lib_release() {
        return this.sendLocalUpdate;
    }

    public final void setSendLocalUpdate$lib_release(@Nullable Function1<? super HMSLocalTrack, Unit> function1) {
        this.sendLocalUpdate = function1;
    }

    @NotNull
    public final HMSAudioTrackSettings getSettings() {
        return this.settings;
    }

    public final double getVolume() {
        return this.volume;
    }

    public final void setVolume(double value) {
        ((AudioTrack)this.getNativeTrack$lib_release()).setVolume(value);
        this.volume = value;
    }

    @Nullable
    public final Object setSettings(@NotNull HMSAudioTrackSettings newSettings, @NotNull Continuation<? super Unit> $completion) {
        if (this.getSettings().getCodec() != newSettings.getCodec()) {
            throw ErrorFactory.TracksErrors.CodecChangeNotPermitted$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "Cannot change from " + (Object)((Object)this.getSettings().getCodec()) + " to " + (Object)((Object)newSettings.getCodec()) + " for " + this, null, null, 12, null);
        }
        if (this.getTransceiver$lib_release() != null && newSettings.getMaxBitrate() != this.getSettings().getMaxBitrate()) {
            RtpParameters.Encoding audioEncoding = new RtpParameters.Encoding(null, true, null);
            audioEncoding.bitratePriority = 2.0;
            audioEncoding.maxBitrateBps = Boxing.boxInt((int)(newSettings.getMaxBitrate() * 1000));
            RtpTransceiver rtpTransceiver = this.getTransceiver$lib_release();
            Intrinsics.checkNotNull((Object)rtpTransceiver);
            RtpParameters params = rtpTransceiver.getSender().getParameters();
            params.encodings.clear();
            params.encodings.add(audioEncoding);
            RtpTransceiver rtpTransceiver2 = this.getTransceiver$lib_release();
            Intrinsics.checkNotNull((Object)rtpTransceiver2);
            rtpTransceiver2.getSender().setParameters(params);
        }
        this.setVolume(newSettings.getVolume());
        this.settings = newSettings;
        return Unit.INSTANCE;
    }

    @Override
    public void setDescription(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setDescription$lib_release(value);
        ISignal iSignal = this.signal;
        if (iSignal != null) {
            iSignal.trackUpdate(CollectionsKt.listOf((Object)HMSNotifications.Track.Companion.from(this)));
        }
    }

    @Override
    public void setMute(boolean value) {
        if (this.isMute() == value) {
            return;
        }
        this.setMute$lib_release(value);
        BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ HMSLocalAudioTrack this$0;
            final /* synthetic */ boolean $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.setEnabled$lib_release(this.$value == false, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((var2_3 = this.this$0.getSignal$lib_release()) != null) {
                            var2_3.trackUpdate((List<HMSNotifications.Track>)CollectionsKt.listOf((Object)HMSNotifications.Track.Companion.from(this.this$0)));
                        }
                        var2_3 = this.this$0.getSendLocalUpdate$lib_release();
                        if (var2_3 != null) {
                            var2_3.invoke((Object)this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    public String toString() {
        return "HMSLocalAudioTrack{trackId=" + this.getTrackId() + ", isEnabled=" + this.isEnabled$lib_release() + ", settings=" + this.settings + '}';
    }
}

