/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.media.tracks.HMSAudioTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.HMSRoom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Llive/hms/video/utils/HmsUtilities;", "", "()V", "Companion", "lib_release"})
public final class HmsUtilities {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES;

    static {
        String[] stringArray = new String[]{"OMX.google.", "OMX.SEC.", "c2.android"};
        SOFTWARE_IMPLEMENTATION_PREFIXES = stringArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00100\nj\b\u0012\u0004\u0012\u00020\u0010`\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0003R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Llive/hms/video/utils/HmsUtilities$Companion;", "", "()V", "SOFTWARE_IMPLEMENTATION_PREFIXES", "", "", "getSOFTWARE_IMPLEMENTATION_PREFIXES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getAllAudioTracks", "Ljava/util/ArrayList;", "Llive/hms/video/media/tracks/HMSAudioTrack;", "Lkotlin/collections/ArrayList;", "room", "Llive/hms/video/sdk/models/HMSRoom;", "getAllVideoTracks", "Llive/hms/video/media/tracks/HMSVideoTrack;", "getAudioTrack", "trackId", "getPeer", "Llive/hms/video/sdk/models/HMSPeer;", "peerId", "getSupportedVp8CodecsList", "", "Landroid/media/MediaCodecInfo;", "getTrack", "Llive/hms/video/media/tracks/HMSTrack;", "getVideoTrack", "isSoftwareOnly", "", "codecInfo", "isSoftwareOnlyQOrHigher", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getSOFTWARE_IMPLEMENTATION_PREFIXES() {
            return SOFTWARE_IMPLEMENTATION_PREFIXES;
        }

        @NotNull
        public final ArrayList<HMSVideoTrack> getAllVideoTracks(@NotNull HMSRoom room) {
            Intrinsics.checkNotNullParameter((Object)room, (String)"room");
            ArrayList<HMSVideoTrack> tracks = new ArrayList<HMSVideoTrack>();
            Iterable $this$forEach$iv = room.getPeerList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HMSPeer peer = (HMSPeer)element$iv;
                boolean bl = false;
                HMSVideoTrack hMSVideoTrack = peer.getVideoTrack();
                if (hMSVideoTrack != null) {
                    HMSVideoTrack hMSVideoTrack2;
                    HMSVideoTrack it = hMSVideoTrack2 = hMSVideoTrack;
                    boolean bl2 = false;
                    tracks.add(it);
                }
                Iterable $this$forEach$iv2 = peer.getAuxiliaryTracks();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    HMSTrack track = (HMSTrack)element$iv2;
                    boolean bl3 = false;
                    if (!(track instanceof HMSVideoTrack)) continue;
                    tracks.add((HMSVideoTrack)track);
                }
            }
            return tracks;
        }

        @NotNull
        public final ArrayList<HMSAudioTrack> getAllAudioTracks(@NotNull HMSRoom room) {
            Intrinsics.checkNotNullParameter((Object)room, (String)"room");
            ArrayList<HMSAudioTrack> tracks = new ArrayList<HMSAudioTrack>();
            Iterable $this$forEach$iv = room.getPeerList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HMSPeer peer = (HMSPeer)element$iv;
                boolean bl = false;
                HMSAudioTrack hMSAudioTrack = peer.getAudioTrack();
                if (hMSAudioTrack != null) {
                    HMSAudioTrack hMSAudioTrack2;
                    HMSAudioTrack it = hMSAudioTrack2 = hMSAudioTrack;
                    boolean bl2 = false;
                    tracks.add(it);
                }
                Iterable $this$forEach$iv2 = peer.getAuxiliaryTracks();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    HMSTrack track = (HMSTrack)element$iv2;
                    boolean bl3 = false;
                    if (!(track instanceof HMSAudioTrack)) continue;
                    tracks.add((HMSAudioTrack)track);
                }
            }
            return tracks;
        }

        @Nullable
        public final HMSPeer getPeer(@NotNull String peerId, @NotNull HMSRoom room) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
                Intrinsics.checkNotNullParameter((Object)room, (String)"room");
                Iterable $this$firstOrNull$iv = room.getPeerList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HMSPeer peer = (HMSPeer)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)peer.getPeerID(), (Object)peerId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final HMSTrack getTrack(@NotNull String trackId, @NotNull HMSRoom room) {
            Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
            Intrinsics.checkNotNullParameter((Object)room, (String)"room");
            HMSTrack hMSTrack = this.getAudioTrack(trackId, room);
            if (hMSTrack != null) {
                HMSAudioTrack hMSAudioTrack;
                HMSAudioTrack it = hMSAudioTrack = hMSTrack;
                boolean bl = false;
                return it;
            }
            hMSTrack = this.getVideoTrack(trackId, room);
            if (hMSTrack != null) {
                HMSTrack hMSTrack2;
                HMSTrack it = hMSTrack2 = hMSTrack;
                boolean bl = false;
                return it;
            }
            return null;
        }

        @Nullable
        public final HMSAudioTrack getAudioTrack(@NotNull String trackId, @NotNull HMSRoom room) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
                Intrinsics.checkNotNullParameter((Object)room, (String)"room");
                Iterable $this$firstOrNull$iv = this.getAllAudioTracks(room);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HMSAudioTrack it = (HMSAudioTrack)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTrackId(), (Object)trackId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final HMSVideoTrack getVideoTrack(@NotNull String trackId, @NotNull HMSRoom room) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
                Intrinsics.checkNotNullParameter((Object)room, (String)"room");
                Iterable $this$firstOrNull$iv = this.getAllVideoTracks(room);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HMSVideoTrack it = (HMSVideoTrack)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTrackId(), (Object)trackId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final List<MediaCodecInfo> getSupportedVp8CodecsList() {
            var2_1 = new MediaCodecList(1).getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)var2_1, (String)"MediaCodecList(MediaCodecList.ALL_CODECS).codecInfos");
            $this$filter$iv = var2_1;
            $i$f$filter = false;
            var4_3 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var7_6 = $this$filterTo$iv$iv;
            var8_7 = 0;
            var9_8 = ((void)var7_6).length;
            while (var8_7 < var9_8) {
                element$iv$iv = var7_6[var8_7];
                ++var8_7;
                it = (MediaCodecInfo)element$iv$iv;
                $i$a$-filter-HmsUtilities$Companion$getSupportedVp8CodecsList$supportedVideoCodecs$1 = false;
                if (!it.isEncoder()) ** GOTO lbl-1000
                var13_12 = it.getSupportedTypes()[0];
                Intrinsics.checkNotNullExpressionValue((Object)var13_12, (String)"it.supportedTypes[0]");
                if (!StringsKt.startsWith$default((String)var13_12, (String)"video", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                var13_12 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)var13_12, (String)"it.name");
                if (StringsKt.contains$default((CharSequence)var13_12, (CharSequence)"vp8", (boolean)false, (int)2, null)) {
                    v0 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            supportedVideoCodecs = (List)destination$iv$iv;
            return supportedVideoCodecs;
        }

        public final boolean isSoftwareOnly(@NotNull MediaCodecInfo codecInfo) {
            Intrinsics.checkNotNullParameter((Object)codecInfo, (String)"codecInfo");
            if (Build.VERSION.SDK_INT >= 29) {
                return this.isSoftwareOnlyQOrHigher(codecInfo);
            }
            String[] stringArray = codecInfo.getName();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"codecInfo.name");
            String[] name = stringArray;
            for (String prefix : this.getSOFTWARE_IMPLEMENTATION_PREFIXES()) {
                if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                return true;
            }
            return false;
        }

        @TargetApi(value=29)
        private final boolean isSoftwareOnlyQOrHigher(MediaCodecInfo codecInfo) {
            return codecInfo.isSoftwareOnly();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

