/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import androidx.annotation.NonNull;
import io.github.zncmn.libyuv.YuvConvert;
import io.github.zncmn.libyuv.YuvFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.webrtc.VideoFrame;

public class YuvFrame {
    public int width;
    public int height;
    public byte[] nv21Buffer;
    public int rotationDegree;
    public long timestamp;
    private final Object planeLock = new Object();
    public static final int PROCESSING_NONE = 0;
    public static final int PROCESSING_CROP_TO_SQUARE = 1;
    private static final YuvConvert yuvConverter = new YuvConvert();

    public YuvFrame(VideoFrame videoFrame) {
        this.fromVideoFrame(videoFrame, 0, System.nanoTime());
    }

    public YuvFrame(VideoFrame videoFrame, int processingFlags) {
        this.fromVideoFrame(videoFrame, processingFlags, System.nanoTime());
    }

    public YuvFrame(VideoFrame videoFrame, int processingFlags, long timestamp) {
        this.fromVideoFrame(videoFrame, processingFlags, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromVideoFrame(VideoFrame videoFrame, int processingFlags, long timestamp) {
        if (videoFrame == null) {
            return;
        }
        Object object = this.planeLock;
        synchronized (object) {
            try {
                this.timestamp = timestamp;
                this.rotationDegree = videoFrame.getRotation();
                if (1 == (processingFlags & 1)) {
                    this.copyPlanesCropped(videoFrame.getBuffer());
                } else {
                    this.copyPlanes(videoFrame.getBuffer());
                }
            }
            catch (Throwable t) {
                this.dispose();
            }
        }
    }

    public void dispose() {
        this.nv21Buffer = null;
    }

    public boolean hasData() {
        return this.nv21Buffer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPlanes(VideoFrame.Buffer videoFrameBuffer) {
        VideoFrame.I420Buffer i420Buffer = null;
        if (videoFrameBuffer != null) {
            i420Buffer = videoFrameBuffer.toI420();
        }
        if (i420Buffer == null) {
            return;
        }
        Object object = this.planeLock;
        synchronized (object) {
            int x;
            int y;
            this.width = i420Buffer.getWidth();
            this.height = i420Buffer.getHeight();
            int size = this.width * this.height;
            int chromaStride = this.width;
            int chromaWidth = (this.width + 1) / 2;
            int chromaHeight = (this.height + 1) / 2;
            int nv21Size = size + chromaStride * chromaHeight;
            if (this.nv21Buffer == null || this.nv21Buffer.length != nv21Size) {
                this.nv21Buffer = new byte[nv21Size];
            }
            ByteBuffer yPlane = i420Buffer.getDataY();
            byte[] yPlaneArr = this.getByteArrayFromByteBuffer(yPlane);
            ByteBuffer uPlane = i420Buffer.getDataU();
            byte[] uPlaneArr = this.getByteArrayFromByteBuffer(uPlane);
            ByteBuffer vPlane = i420Buffer.getDataV();
            byte[] vPlaneArr = this.getByteArrayFromByteBuffer(vPlane);
            int yStride = i420Buffer.getStrideY();
            int uStride = i420Buffer.getStrideU();
            int vStride = i420Buffer.getStrideV();
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    this.nv21Buffer[y * this.width + x] = yPlaneArr[y * yStride + x];
                }
            }
            for (y = 0; y < chromaHeight; ++y) {
                for (x = 0; x < chromaWidth; ++x) {
                    this.nv21Buffer[size + y * chromaStride + 2 * x + 1] = uPlaneArr[y * uStride + x];
                    this.nv21Buffer[size + y * chromaStride + 2 * x] = vPlaneArr[y * vStride + x];
                }
            }
        }
        i420Buffer.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPlanesCropped(VideoFrame.Buffer videoFrameBuffer) {
        if (videoFrameBuffer == null) {
            return;
        }
        Object object = this.planeLock;
        synchronized (object) {
            int width = videoFrameBuffer.getWidth();
            int height = videoFrameBuffer.getHeight();
            if (width > height) {
                VideoFrame.Buffer croppedVideoFrameBuffer = videoFrameBuffer.cropAndScale((width - height) / 2, 0, height, height, height, height);
                this.copyPlanes(croppedVideoFrameBuffer);
                croppedVideoFrameBuffer.release();
            } else {
                VideoFrame.Buffer croppedVideoFrameBuffer = videoFrameBuffer.cropAndScale(0, (height - width) / 2, width, width, width, width);
                this.copyPlanes(croppedVideoFrameBuffer);
                croppedVideoFrameBuffer.release();
            }
        }
    }

    public Bitmap getBitmap() {
        if (this.nv21Buffer == null) {
            return null;
        }
        int size = this.width * this.height;
        byte[] argbBytes = new byte[size * 4];
        yuvConverter.toARGB(this.nv21Buffer, argbBytes, this.width, this.height, YuvFormat.NV21);
        Bitmap bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(argbBytes));
        if (this.rotationDegree == 90 || this.rotationDegree == -270) {
            Matrix m = new Matrix();
            m.postRotate(90.0f);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        }
        if (this.rotationDegree == 180 || this.rotationDegree == -180) {
            Matrix m = new Matrix();
            m.postRotate(180.0f);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        }
        if (this.rotationDegree == 270 || this.rotationDegree == -90) {
            Matrix m = new Matrix();
            m.postRotate(270.0f);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        }
        return bitmap;
    }

    private byte[] getByteArrayFromByteBuffer(@NonNull ByteBuffer byteBuffer) {
        byte[] bytesArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytesArray, 0, bytesArray.length);
        return bytesArray;
    }
}

