/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.models;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.sdk.models.EVENT_TYPE;
import live.hms.video.sdk.models.IRetryAttemptTracking;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001fJT\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\"0!j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\"`#2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010$\u001a\u00020\fH\u0002J!\u0010%\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Llive/hms/video/sdk/models/PerformanceMeasurement;", "Ljava/io/Closeable;", "Llive/hms/video/sdk/models/IRetryAttemptTracking;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Llive/hms/video/events/AnalyticsEventsService;)V", "eventsThatWereEnded", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "eventsThatWereStarted", "isPreviewCalled", "", "numberEvents", "Ljava/util/concurrent/ConcurrentHashMap;", "", "previewStartTime", "startTimes", "Llive/hms/video/sdk/models/EVENT_TYPE;", "stopTimes", "clearValues", "", "close", "end", "eventType", "end$lib_release", "fireJoinPerformanceMeasurementEvent", "success", "fireJoinPerformanceMeasurementEvent$lib_release", "firePreviewPerformanceMeasurementEvent", "eventSuccessful", "firePreviewPerformanceMeasurementEvent$lib_release", "getPropertiesFromTimes", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "isJoin", "numberedValue", "times", "(Llive/hms/video/sdk/models/EVENT_TYPE;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "start$lib_release", "startPreview", "startPreview$lib_release", "lib_release"})
public final class PerformanceMeasurement
implements Closeable,
IRetryAttemptTracking {
    @NotNull
    private AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final ConcurrentHashMap<EVENT_TYPE, Long> startTimes;
    @NotNull
    private final ConcurrentHashMap<EVENT_TYPE, Long> stopTimes;
    @NotNull
    private final ConcurrentHashMap<String, Long> numberEvents;
    private long previewStartTime;
    private boolean isPreviewCalled;
    @NotNull
    private final HashSet<String> eventsThatWereEnded;
    @NotNull
    private final HashSet<String> eventsThatWereStarted;

    public PerformanceMeasurement(@NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        this.analyticsEventsService = analyticsEventsService2;
        this.startTimes = new ConcurrentHashMap();
        this.stopTimes = new ConcurrentHashMap();
        this.numberEvents = new ConcurrentHashMap();
        this.eventsThatWereEnded = new HashSet();
        this.eventsThatWereStarted = new HashSet();
    }

    public final void start$lib_release(@NotNull EVENT_TYPE eventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        Map map = this.startTimes;
        Long l = System.currentTimeMillis();
        map.put(eventType, l);
    }

    @NotNull
    public final PerformanceMeasurement end$lib_release(@NotNull EVENT_TYPE eventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        long endTime = System.currentTimeMillis();
        Map map = this.stopTimes;
        Long l = endTime;
        map.put(eventType, l);
        return this;
    }

    @Override
    @Nullable
    public Object numberedValue(@NotNull EVENT_TYPE eventType, long times, @NotNull Continuation<? super Unit> $completion) {
        Map map = this.numberEvents;
        String string = eventType.getValue();
        Long l = Boxing.boxLong((long)times);
        Long l2 = map.put(string, l);
        if (l2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return l2;
        }
        return Unit.INSTANCE;
    }

    public final void fireJoinPerformanceMeasurementEvent$lib_release(boolean success) {
        boolean hasJoined = this.startTimes.containsKey((Object)EVENT_TYPE.JOIN_CALL);
        if (hasJoined) {
            HashMap<String, Object> properties = this.getPropertiesFromTimes(this.startTimes, this.stopTimes, true);
            Map map = properties;
            String string = "is_preview_called";
            Boolean bl = this.isPreviewCalled;
            map.put(string, bl);
            HMSLogger.d("PerformanceJoinEvents", Intrinsics.stringPlus((String)"Sending event: ", properties));
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.joinStatusEvent(success, properties)).flush();
        } else {
            HMSLogger.e("PerformanceJoinEvents", "Throwing away a flush since the measurement was wrong by not having a time at all");
        }
        this.clearValues();
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, Object> getPropertiesFromTimes(ConcurrentHashMap<EVENT_TYPE, Long> startTimes, ConcurrentHashMap<EVENT_TYPE, Long> stopTimes, boolean isJoin) {
        void $this$mapTo$iv$iv;
        if (isJoin) {
            startTimes.remove((Object)EVENT_TYPE.PREVIEW_CALL);
            stopTimes.remove((Object)EVENT_TYPE.PREVIEW_CALL);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Map $this$map$iv = startTimes;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Long l;
            void startMap;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = stopTimes.get(startMap.getKey());
            if (object2 == null) {
                l = null;
            } else {
                object = object2;
                Long stop = object;
                boolean bl2 = false;
                l = stop - ((Number)startMap.getValue()).longValue();
            }
            Long time = l;
            if (time != null && time >= 0L) {
                object2 = properties;
                object = ((EVENT_TYPE)((Object)startMap.getKey())).getValue();
                object2.put(object, time);
            }
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        properties.putAll((Map)this.numberEvents);
        return properties;
    }

    public final void startPreview$lib_release() {
        this.previewStartTime = System.currentTimeMillis();
        this.isPreviewCalled = true;
    }

    public final void firePreviewPerformanceMeasurementEvent$lib_release(boolean eventSuccessful) {
        Map map = this.stopTimes;
        EVENT_TYPE eVENT_TYPE = EVENT_TYPE.PREVIEW_CALL;
        Long l = System.currentTimeMillis();
        map.put(eVENT_TYPE, l);
        map = this.startTimes;
        eVENT_TYPE = EVENT_TYPE.PREVIEW_CALL;
        l = this.previewStartTime;
        map.put(eVENT_TYPE, l);
        HashMap<String, Object> properties = this.getPropertiesFromTimes(this.startTimes, this.stopTimes, false);
        AnalyticsEvent event = AnalyticsEventFactory.INSTANCE.previewStatusEvent(eventSuccessful, properties);
        this.analyticsEventsService.queue(event).flush();
        HMSLogger.d("PerformanceJoinEvents", Intrinsics.stringPlus((String)"Fire preview measurement: ", (Object)event));
    }

    @Override
    public void close() {
        this.isPreviewCalled = false;
        this.clearValues();
    }

    private final void clearValues() {
        this.startTimes.clear();
        this.stopTimes.clear();
        this.numberEvents.clear();
    }
}

