/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers.camera;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.media.ExifInterface;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import androidx.core.math.MathUtils;
import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeoutException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.capturers.camera.CameraControl;
import live.hms.video.media.capturers.camera.CameraExtKt;
import live.hms.video.media.capturers.camera.utils.ImageCaptureModel;
import live.hms.video.utils.HMSUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera2Session;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.RendererCommon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J1\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@2!\u0010A\u001a\u001d\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020;0BJ\u0018\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u000e2\u0006\u0010J\u001a\u00020HH\u0002J\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000e0LJ\u0006\u0010M\u001a\u00020\u000eJ\u0012\u0010N\u001a\u00020\u000e2\b\u0010O\u001a\u0004\u0018\u00010PH\u0002J\u0006\u0010Q\u001a\u00020\u000eJ\u0006\u0010R\u001a\u00020CJ\u0006\u0010S\u001a\u00020CJ\u0006\u0010T\u001a\u00020CJ\u0006\u0010U\u001a\u00020CJ\b\u0010V\u001a\u00020CH\u0002J\u0006\u0010W\u001a\u00020CJ\u0015\u0010X\u001a\u00020;2\u0006\u0010Y\u001a\u00020ZH\u0000\u00a2\u0006\u0002\b[J\u0006\u0010\\\u001a\u00020;J\u000e\u0010]\u001a\u00020;2\u0006\u0010^\u001a\u00020CJ\u000e\u0010_\u001a\u00020;2\u0006\u0010`\u001a\u00020\u000eJ0\u0010a\u001a\u00020;2\u0006\u0010b\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020\u000e2\u0006\u0010d\u001a\u00020\n2\u0006\u0010e\u001a\u00020\n2\b\b\u0002\u0010f\u001a\u00020gJ\u000e\u0010h\u001a\u00020;2\u0006\u0010i\u001a\u00020\u000eJ\u001a\u0010j\u001a\u00020;2\u0006\u0010i\u001a\u00020\u000e2\b\u0010k\u001a\u0004\u0018\u00010lH\u0002J\u0011\u0010m\u001a\u00020nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010oR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001b\u0010/\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b0\u0010\u0014R\u001b\u00103\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00102\u001a\u0004\b5\u00106R\u000e\u00108\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006p"}, d2={"Llive/hms/video/media/capturers/camera/CameraControl;", "", "cameraHandler", "Landroid/os/Handler;", "context", "Landroid/content/Context;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Landroid/os/Handler;Landroid/content/Context;Llive/hms/video/events/AnalyticsEventsService;)V", "IMAGE_BUFFER_SIZE", "", "IMAGE_CAPTURE_TIMEOUT_MILLIS", "", "ZOOM_DEFAULT_VALUE", "", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "cameraCaptureMutex", "Lkotlinx/coroutines/sync/Mutex;", "getCameraHandler", "()Landroid/os/Handler;", "captureFormat", "Lorg/webrtc/CameraEnumerationAndroid$CaptureFormat;", "getCaptureFormat", "()Lorg/webrtc/CameraEnumerationAndroid$CaptureFormat;", "setCaptureFormat", "(Lorg/webrtc/CameraEnumerationAndroid$CaptureFormat;)V", "captureRequestBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "getCaptureRequestBuilder", "()Landroid/hardware/camera2/CaptureRequest$Builder;", "setCaptureRequestBuilder", "(Landroid/hardware/camera2/CaptureRequest$Builder;)V", "getContext", "()Landroid/content/Context;", "currentCameraSession", "Landroid/hardware/camera2/CameraCaptureSession;", "getCurrentCameraSession", "()Landroid/hardware/camera2/CameraCaptureSession;", "setCurrentCameraSession", "(Landroid/hardware/camera2/CameraCaptureSession;)V", "imageReader", "Landroid/media/ImageReader;", "getImageReader", "()Landroid/media/ImageReader;", "setImageReader", "(Landroid/media/ImageReader;)V", "imageReaderHandler", "getImageReaderHandler", "imageReaderHandler$delegate", "Lkotlin/Lazy;", "imageReaderThread", "Landroid/os/HandlerThread;", "getImageReaderThread", "()Landroid/os/HandlerThread;", "imageReaderThread$delegate", "lastLensDistance", "lastZoom", "autoFocusCallbackResult", "", "result", "Landroid/hardware/camera2/CaptureResult;", "captureImageAtMaxSupportedResolution", "savePath", "Ljava/io/File;", "callback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "isSuccess", "cropRegionForZoom", "Landroid/graphics/Rect;", "ratio", "zoomSensorRect", "getManualFocusRange", "Landroid/util/Range;", "getMaxZoom", "getMaxZoomInternal", "cameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "getMinZoom", "isFlashEnabled", "isFlashSupported", "isManualFocusSupported", "isTapToFocusSupported", "isValidSession", "isZoomSupported", "onCameraSessionUpdate", "session", "Lorg/webrtc/Camera2Session;", "onCameraSessionUpdate$lib_release", "resetZoom", "setFlash", "enable", "setManualFocus", "range", "setTapToFocusAt", "viewX", "viewY", "viewWidth", "viewHeight", "scalingType", "Lorg/webrtc/RendererCommon$ScalingType;", "setZoom", "zoomValue", "setZoomInternal", "currentCameraIndex", "", "takePictureInternal", "Llive/hms/video/media/capturers/camera/utils/ImageCaptureModel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
public final class CameraControl {
    @Nullable
    private final Handler cameraHandler;
    @NotNull
    private final Context context;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @Nullable
    private CameraCaptureSession currentCameraSession;
    @Nullable
    private CaptureRequest.Builder captureRequestBuilder;
    @Nullable
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    @NotNull
    private final Mutex cameraCaptureMutex;
    private final int IMAGE_BUFFER_SIZE;
    @NotNull
    private final Lazy imageReaderThread$delegate;
    @NotNull
    private final Lazy imageReaderHandler$delegate;
    private final long IMAGE_CAPTURE_TIMEOUT_MILLIS;
    @Nullable
    private ImageReader imageReader;
    private final float ZOOM_DEFAULT_VALUE;
    private float lastZoom;
    private float lastLensDistance;

    public CameraControl(@Nullable Handler cameraHandler, @NotNull Context context, @NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        this.cameraHandler = cameraHandler;
        this.context = context;
        this.analyticsEventsService = analyticsEventsService2;
        this.cameraCaptureMutex = MutexKt.Mutex((boolean)false);
        this.IMAGE_BUFFER_SIZE = 1;
        this.imageReaderThread$delegate = LazyKt.lazy((Function0)imageReaderThread.2.INSTANCE);
        this.imageReaderHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Handler>(this){
            final /* synthetic */ CameraControl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Handler invoke() {
                return new Handler(CameraControl.access$getImageReaderThread(this.this$0).getLooper());
            }
        }));
        this.IMAGE_CAPTURE_TIMEOUT_MILLIS = 5000L;
        this.ZOOM_DEFAULT_VALUE = 1.0f;
    }

    @Nullable
    public final Handler getCameraHandler() {
        return this.cameraHandler;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService() {
        return this.analyticsEventsService;
    }

    @Nullable
    public final CameraCaptureSession getCurrentCameraSession() {
        return this.currentCameraSession;
    }

    public final void setCurrentCameraSession(@Nullable CameraCaptureSession cameraCaptureSession) {
        this.currentCameraSession = cameraCaptureSession;
    }

    @Nullable
    public final CaptureRequest.Builder getCaptureRequestBuilder() {
        return this.captureRequestBuilder;
    }

    public final void setCaptureRequestBuilder(@Nullable CaptureRequest.Builder builder) {
        this.captureRequestBuilder = builder;
    }

    @Nullable
    public final CameraEnumerationAndroid.CaptureFormat getCaptureFormat() {
        return this.captureFormat;
    }

    public final void setCaptureFormat(@Nullable CameraEnumerationAndroid.CaptureFormat captureFormat) {
        this.captureFormat = captureFormat;
    }

    private final HandlerThread getImageReaderThread() {
        Lazy lazy = this.imageReaderThread$delegate;
        return (HandlerThread)lazy.getValue();
    }

    private final Handler getImageReaderHandler() {
        Lazy lazy = this.imageReaderHandler$delegate;
        return (Handler)lazy.getValue();
    }

    @Nullable
    public final ImageReader getImageReader() {
        return this.imageReader;
    }

    public final void setImageReader(@Nullable ImageReader imageReader) {
        this.imageReader = imageReader;
    }

    public final void onCameraSessionUpdate$lib_release(@NotNull Camera2Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.captureRequestBuilder = session.getCaptureRequestBuilder();
        this.currentCameraSession = session.getCamera2CaptureSession();
        this.captureFormat = session.getCameraCaptureFormat();
        this.imageReader = session.getImageReader();
    }

    private final boolean isValidSession() {
        return this.cameraHandler != null && this.captureRequestBuilder != null && this.currentCameraSession != null && this.captureFormat != null;
    }

    public final boolean isZoomSupported() {
        CameraDevice cameraDevice;
        Object object;
        if (!this.isValidSession()) {
            return false;
        }
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        Object object2 = cameraCaptureSession == null ? null : (object = (cameraDevice = cameraCaptureSession.getDevice()) == null ? null : cameraDevice.getId());
        if (object == null) {
            return false;
        }
        Object object3 = object;
        String currentCameraIndex = object3;
        CameraCharacteristics cameraCharacteristics = (object = StringsKt.toIntOrNull((String)currentCameraIndex)) == null ? null : CameraExtKt.getCameraCharacteristics((Integer)object, this.context);
        return this.getMaxZoomInternal(cameraCharacteristics) > this.ZOOM_DEFAULT_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isManualFocusSupported() {
        String string;
        Object object;
        if (!this.isValidSession()) {
            return false;
        }
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        if (cameraCaptureSession == null) {
            return false;
        }
        CameraDevice cameraDevice = cameraCaptureSession.getDevice();
        if (cameraDevice == null) {
            return false;
        }
        Object object2 = object = cameraDevice.getId();
        if (object == null) {
            return false;
        }
        String currentCameraIndex = string = object;
        object = currentCameraIndex;
        String it = object;
        boolean bl = false;
        Range<Float> manualFocusRange = CameraExtKt.getLensDistanceRange(this.getContext(), it);
        object = manualFocusRange.getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"manualFocusRange.upper");
        if (!(((Number)object).floatValue() > 0.0f)) return false;
        object = manualFocusRange.getLower();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"manualFocusRange.lower");
        if (!(((Number)object).floatValue() > 0.0f)) return false;
        return true;
    }

    @NotNull
    public final Range<Float> getManualFocusRange() {
        String string;
        CameraDevice cameraDevice;
        String string2;
        if (!this.isValidSession()) {
            return new Range((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(0.0f));
        }
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        String string3 = cameraCaptureSession == null ? null : (string2 = (cameraDevice = cameraCaptureSession.getDevice()) == null ? null : cameraDevice.getId());
        if (string2 == null) {
            return new Range((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(0.0f));
        }
        String currentCameraIndex = string = string2;
        return CameraExtKt.getLensDistanceRange(this.context, currentCameraIndex);
    }

    public final void setManualFocus(float range) {
        String string;
        CameraDevice cameraDevice;
        Object object;
        if (!this.isValidSession()) {
            return;
        }
        Object object2 = this.currentCameraSession;
        Object object3 = object2 == null ? null : (object = (cameraDevice = object2.getDevice()) == null ? null : cameraDevice.getId());
        if (object == null) {
            return;
        }
        String currentCameraIndex = string = object;
        Range<Float> lensRange = this.getManualFocusRange();
        object = lensRange.getLower();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lensRange.lower");
        float f = ((Number)object).floatValue();
        object = lensRange.getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lensRange.upper");
        this.lastLensDistance = RangesKt.coerceIn((float)range, (float)f, (float)((Number)object).floatValue());
        object = this.captureRequestBuilder;
        if (object != null) {
            object.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(this.lastLensDistance));
        }
        object = this;
        try {
            Integer n;
            object2 = Result.Companion;
            CameraControl $this$setManualFocus_u24lambda_u2d1 = (CameraControl)object;
            boolean bl = false;
            if (!$this$setManualFocus_u24lambda_u2d1.isValidSession()) {
                return;
            }
            CameraCaptureSession cameraCaptureSession = $this$setManualFocus_u24lambda_u2d1.getCurrentCameraSession();
            if (cameraCaptureSession == null) {
                n = null;
            } else {
                CaptureRequest.Builder builder = $this$setManualFocus_u24lambda_u2d1.getCaptureRequestBuilder();
                Intrinsics.checkNotNull((Object)builder);
                n = cameraCaptureSession.setRepeatingRequest(builder.build(), new CameraCaptureSession.CaptureCallback(){}, $this$setManualFocus_u24lambda_u2d1.getCameraHandler());
            }
            cameraDevice = n;
            object2 = Result.constructor-impl((Object)cameraDevice);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public final boolean isTapToFocusSupported() {
        Object object;
        String string;
        if (!this.isValidSession()) {
            return false;
        }
        Object object2 = this.currentCameraSession;
        String string2 = object2 == null ? null : (string = (object = object2.getDevice()) == null ? null : object.getId());
        if (string == null) {
            return false;
        }
        String string3 = string;
        String currentCameraIndex = string3;
        object2 = StringsKt.toIntOrNull((String)currentCameraIndex);
        Object object3 = string = object2 == null ? null : CameraExtKt.getCameraCharacteristics((Integer)object2, this.context);
        if (string == null) {
            return false;
        }
        String cameraCharacteristics = string;
        object = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (object == null) {
            return false;
        }
        object2 = object;
        Object availableAFModes = object2;
        object2 = availableAFModes;
        return !(((Object)object2).length == 0) && CameraExtKt.getFocusMaxMeteringRegionsSupported(this.context, currentCameraIndex) != 0;
    }

    public final float getMaxZoom() {
        CameraDevice cameraDevice;
        String string;
        if (!this.isValidSession()) {
            return this.ZOOM_DEFAULT_VALUE;
        }
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        String string2 = cameraCaptureSession == null ? null : (string = (cameraDevice = cameraCaptureSession.getDevice()) == null ? null : cameraDevice.getId());
        if (string == null) {
            return this.ZOOM_DEFAULT_VALUE;
        }
        Object object = string;
        Object currentCameraIndex = object;
        return this.getMaxZoomInternal((object = StringsKt.toIntOrNull((String)currentCameraIndex)) == null ? null : CameraExtKt.getCameraCharacteristics((Integer)object, this.context));
    }

    public final float getMinZoom() {
        return this.ZOOM_DEFAULT_VALUE;
    }

    public final void setZoom(float zoomValue) {
        String string;
        CameraDevice cameraDevice;
        String string2;
        if (!this.isValidSession()) {
            return;
        }
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        String string3 = cameraCaptureSession == null ? null : (string2 = (cameraDevice = cameraCaptureSession.getDevice()) == null ? null : cameraDevice.getId());
        if (string2 == null) {
            return;
        }
        String currentCameraIndex = string = string2;
        string = this.cameraHandler;
        if (string != null) {
            string.post(() -> CameraControl.setZoom$lambda-2(this, zoomValue, currentCameraIndex));
        }
    }

    public final void resetZoom() {
        String string;
        CameraDevice cameraDevice;
        String string2;
        Object imageView = null;
        if (!this.isValidSession()) {
            return;
        }
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        String string3 = cameraCaptureSession == null ? null : (string2 = (cameraDevice = cameraCaptureSession.getDevice()) == null ? null : cameraDevice.getId());
        if (string2 == null) {
            return;
        }
        String currentCameraIndex = string = string2;
        string = this.cameraHandler;
        if (string != null) {
            string.post(() -> CameraControl.resetZoom$lambda-3(this, currentCameraIndex));
        }
    }

    public final void setTapToFocusAt(float viewX, float viewY, int viewWidth, int viewHeight, @NotNull RendererCommon.ScalingType scalingType) {
        RectF rectF;
        String string;
        CameraDevice cameraDevice;
        Rect rect;
        Intrinsics.checkNotNullParameter((Object)scalingType, (String)"scalingType");
        if (!this.isValidSession()) {
            return;
        }
        if (viewX < 0.0f || viewX > (float)viewWidth || viewY < 0.0f || viewY > (float)viewHeight) {
            return;
        }
        CaptureRequest.Builder builder = this.captureRequestBuilder;
        Rect rect2 = rect = builder == null ? null : (Rect)builder.get(CaptureRequest.SCALER_CROP_REGION);
        if (rect == null) {
            return;
        }
        Rect cropRegion = rect;
        int cropWidth = cropRegion.width();
        int cropHeight = cropRegion.height();
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        String string2 = cameraCaptureSession == null ? "1" : ((cameraDevice = cameraCaptureSession.getDevice()) == null ? "1" : ((string = cameraDevice.getId()) == null ? "1" : string));
        int rotation = CameraExtKt.computeRelativeRotation(this.context, string2);
        cameraCaptureSession = this.currentCameraSession;
        boolean isMirror = Intrinsics.areEqual(cameraCaptureSession == null ? null : ((cameraDevice = cameraCaptureSession.getDevice()) == null ? null : cameraDevice.getId()), (Object)"1");
        int rotationValue = (isMirror ? 1 : -1) * rotation;
        CameraEnumerationAndroid.CaptureFormat captureFormat = this.captureFormat;
        string = HMSUtils.INSTANCE.viewToNormalized$lib_release(new RectF(viewX, viewY, viewX, viewY), viewWidth, viewHeight, captureFormat == null ? null : Integer.valueOf(captureFormat.width), (captureFormat = this.captureFormat) == null ? null : Integer.valueOf(captureFormat.height), isMirror, rotationValue, scalingType);
        if (string == null) {
            return;
        }
        String normalisedRect = string;
        float tempX = ((RectF)normalisedRect).left;
        float tempY = ((RectF)normalisedRect).top;
        RectF $this$setTapToFocusAt_u24lambda_u2d4 = rectF = new RectF();
        boolean bl = false;
        $this$setTapToFocusAt_u24lambda_u2d4.left = MathUtils.clamp((float)(tempX - 0.05f), (float)0.0f, (float)1.0f);
        $this$setTapToFocusAt_u24lambda_u2d4.right = MathUtils.clamp((float)(tempX + 0.05f), (float)0.0f, (float)1.0f);
        $this$setTapToFocusAt_u24lambda_u2d4.top = MathUtils.clamp((float)(tempY - 0.05f), (float)0.0f, (float)1.0f);
        $this$setTapToFocusAt_u24lambda_u2d4.bottom = MathUtils.clamp((float)(tempY + 0.05f), (float)0.0f, (float)1.0f);
        RectF clampedNormalisedRect = rectF;
        CameraEnumerationAndroid.CaptureFormat captureFormat2 = this.captureFormat;
        $this$setTapToFocusAt_u24lambda_u2d4 = HMSUtils.INSTANCE.normalizedToCameraSensor$lib_release(clampedNormalisedRect, captureFormat2 == null ? null : Integer.valueOf(captureFormat2.width), (captureFormat2 = this.captureFormat) == null ? null : Integer.valueOf(captureFormat2.height), cropWidth, cropHeight, true);
        if ($this$setTapToFocusAt_u24lambda_u2d4 == null) {
            return;
        }
        RectF sensorCoordinateRect = $this$setTapToFocusAt_u24lambda_u2d4;
        Rect sensorCoordinateRectRound = null;
        sensorCoordinateRectRound = new Rect();
        if (sensorCoordinateRect.width() == 0.0f || sensorCoordinateRect.height() == 0.0f) {
            sensorCoordinateRectRound = new Rect(0, 0, 0, 0);
        } else {
            sensorCoordinateRect.round(sensorCoordinateRectRound);
        }
        captureFormat2 = this.captureRequestBuilder;
        if (captureFormat2 != null) {
            CameraEnumerationAndroid.CaptureFormat captureFormat3;
            CameraEnumerationAndroid.CaptureFormat $this$setTapToFocusAt_u24lambda_u2d5 = captureFormat3 = captureFormat2;
            boolean bl2 = false;
            MeteringRectangle[] meteringRectangleArray = new MeteringRectangle[]{new MeteringRectangle(sensorCoordinateRectRound, 1000)};
            $this$setTapToFocusAt_u24lambda_u2d5.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)meteringRectangleArray);
            meteringRectangleArray = new MeteringRectangle[]{new MeteringRectangle(sensorCoordinateRectRound, 1000)};
            $this$setTapToFocusAt_u24lambda_u2d5.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)meteringRectangleArray);
            $this$setTapToFocusAt_u24lambda_u2d5.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            $this$setTapToFocusAt_u24lambda_u2d5.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            $this$setTapToFocusAt_u24lambda_u2d5.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        }
        captureFormat2 = this.cameraHandler;
        if (captureFormat2 != null) {
            captureFormat2.post(() -> CameraControl.setTapToFocusAt$lambda-7(this));
        }
    }

    public static /* synthetic */ void setTapToFocusAt$default(CameraControl cameraControl, float f, float f2, int n, int n2, RendererCommon.ScalingType scalingType, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FILL;
        }
        cameraControl.setTapToFocusAt(f, f2, n, n2, scalingType);
    }

    public final void captureImageAtMaxSupportedResolution(@NotNull File savePath, @NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)savePath, (String)"savePath");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback, savePath, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CameraControl this$0;
            final /* synthetic */ Function1<Boolean, Unit> $callback;
            final /* synthetic */ File $savePath;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                this.$savePath = $savePath;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var20_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        var3_4 = CameraControl.access$getCameraCaptureMutex$p(this.this$0);
                        var5_5 = this.$callback;
                        var6_6 = this.this$0;
                        var7_7 = this.$savePath;
                        owner$iv = null;
                        $i$f$withLock = false;
                        this.L$0 = $this$launch;
                        this.L$1 = $this$withLock_u24default$iv;
                        this.L$2 = var5_5;
                        this.L$3 = var6_6;
                        this.L$4 = var7_7;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var20_2) {
                            return var20_2;
                        }
                        ** GOTO lbl34
                    }
                    case 1: {
                        $i$f$withLock = false;
                        var7_7 = (File)this.L$4;
                        var6_6 = (CameraControl)this.L$3;
                        var5_5 = (Function1)this.L$2;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl34:
                        // 3 sources

                        $i$a$-withLock$default-CameraControl$captureImageAtMaxSupportedResolution$1$1 = false;
                        var11_16 /* !! */  = $this$launch;
                        var12_17 = Result.Companion;
                        var13_21 = var11_16 /* !! */ ;
                        $i$a$-runCatching-CameraControl$captureImageAtMaxSupportedResolution$1$1$imageCaptureResult$1 = false;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var5_5;
                        this.L$2 = var6_6;
                        this.L$3 = var7_7;
                        this.L$4 = null;
                        this.label = 2;
                        v1 = CameraControl.access$takePictureInternal(var6_6, (Continuation)this);
                        ** if (v1 != var20_2) goto lbl51
lbl50:
                        // 1 sources

                        return var20_2;
lbl51:
                        // 1 sources

                        ** GOTO lbl65
                    }
                    case 2: {
                        $i$f$withLock = false;
                        $i$a$-withLock$default-CameraControl$captureImageAtMaxSupportedResolution$1$1 = false;
                        $i$a$-runCatching-CameraControl$captureImageAtMaxSupportedResolution$1$1$imageCaptureResult$1 = false;
                        var7_7 = (File)this.L$3;
                        var6_6 = (CameraControl)this.L$2;
                        var5_5 = (Function1)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl65:
                        // 2 sources

                        imageModel = (ImageCaptureModel)v1;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var5_5;
                        this.L$2 = var6_6;
                        this.L$3 = var7_7;
                        this.L$4 = imageModel;
                        this.label = 3;
                        v2 = CameraExtKt.saveResult(var6_6.getContext(), imageModel, var7_7, (Continuation<? super Unit>)this);
                        ** if (v2 != var20_2) goto lbl75
lbl74:
                        // 1 sources

                        return var20_2;
lbl75:
                        // 1 sources

                        ** GOTO lbl91
                    }
                    case 3: {
                        $i$f$withLock = false;
                        $i$a$-withLock$default-CameraControl$captureImageAtMaxSupportedResolution$1$1 = false;
                        $i$a$-runCatching-CameraControl$captureImageAtMaxSupportedResolution$1$1$imageCaptureResult$1 = false;
                        imageModel = (ImageCaptureModel)this.L$4;
                        var7_7 = (File)this.L$3;
                        var6_6 = (CameraControl)this.L$2;
                        var5_5 = (Function1)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl91:
                            // 2 sources

                            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)var7_7), (Object)"jpg") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)var7_7), (Object)"jpeg")) {
                                $this$invokeSuspend_u24lambda_u2d3_u24lambda_u2d1_u24lambda_u2d0 = var16_28 = new ExifInterface(var7_7.getAbsolutePath());
                                $i$a$-apply-CameraControl$captureImageAtMaxSupportedResolution$1$1$imageCaptureResult$1$1 = false;
                                $this$invokeSuspend_u24lambda_u2d3_u24lambda_u2d1_u24lambda_u2d0.setAttribute("Orientation", String.valueOf(imageModel.getOrientation()));
                                $this$invokeSuspend_u24lambda_u2d3_u24lambda_u2d1_u24lambda_u2d0.saveAttributes();
                            }
                            var13_21 = Unit.INSTANCE;
                            var12_17 = Result.constructor-impl((Object)var13_21);
                            {
                                catch (Throwable var13_22) {
                                    var14_26 = Result.Companion;
                                    var12_17 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var13_22));
                                }
                            }
                            imageCaptureResult = var12_17;
                            if (Result.isFailure-impl((Object)imageCaptureResult) && Result.exceptionOrNull-impl((Object)imageCaptureResult) != null) {
                                try {
                                    var11_16 /* !! */  = Result.Companion;
                                    $i$a$-runCatching-CameraControl$captureImageAtMaxSupportedResolution$1$1$1 = false;
                                    v3 = var6_6.getAnalyticsEventsService();
                                    v4 = Result.exceptionOrNull-impl((Object)imageCaptureResult);
                                    Intrinsics.checkNotNull((Object)v4);
                                    v3.queue(AnalyticsEventFactory.INSTANCE.cameraCapturingException(v4)).flush();
                                    var12_19 = Unit.INSTANCE;
                                    var11_16 /* !! */  = Result.constructor-impl((Object)var12_19);
                                }
                                catch (Throwable var12_20) {
                                    var13_21 = Result.Companion;
                                    var11_16 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var12_20));
                                }
                            }
                            var5_5.invoke((Object)Boxing.boxBoolean((boolean)Result.isSuccess-impl((Object)imageCaptureResult)));
                            var9_32 = Unit.INSTANCE;
                        }
                        catch (Throwable var9_33) {
                            throw var9_33;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean isFlashSupported() {
        boolean bl;
        CameraCaptureSession cameraCaptureSession = this.currentCameraSession;
        if (cameraCaptureSession == null) {
            bl = false;
        } else {
            CameraDevice cameraDevice = cameraCaptureSession.getDevice();
            if (cameraDevice == null) {
                bl = false;
            } else {
                String string = cameraDevice.getId();
                if (string == null) {
                    bl = false;
                } else {
                    boolean bl2;
                    String string2;
                    String it = string2 = string;
                    boolean bl3 = false;
                    bl = bl2 = CameraExtKt.isFlashAvailable(this.getContext(), it);
                }
            }
        }
        return bl;
    }

    public final boolean isFlashEnabled() {
        CaptureRequest.Builder builder = this.captureRequestBuilder;
        return builder == null ? false : Intrinsics.areEqual((Object)builder.get(CaptureRequest.FLASH_MODE), (Object)2);
    }

    public final void setFlash(boolean enable) {
        if (!this.isValidSession()) {
            return;
        }
        int mode = enable ? 2 : 0;
        Handler handler = this.cameraHandler;
        if (handler != null) {
            handler.post(() -> CameraControl.setFlash$lambda-10(this, mode));
        }
    }

    private final void setZoomInternal(float zoomValue, String currentCameraIndex) {
        Integer n;
        CameraCharacteristics cameraCharacteristics;
        Object object = currentCameraIndex;
        CameraCharacteristics cameraCharacteristics2 = object == null ? null : (cameraCharacteristics = (n = StringsKt.toIntOrNull((String)object)) == null ? null : CameraExtKt.getCameraCharacteristics(n, this.context));
        if (cameraCharacteristics == null) {
            return;
        }
        CameraCharacteristics cameraCharacteristics3 = cameraCharacteristics;
        n = (Rect)cameraCharacteristics3.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        if (n == null) {
            return;
        }
        Object zoomSensorRect = object = n;
        float currentMaxZoomValue = this.getMaxZoomInternal(cameraCharacteristics3);
        float f = currentMaxZoomValue - this.ZOOM_DEFAULT_VALUE;
        if (Math.abs(f) < 0.001f) {
            return;
        }
        boolean isZoomRequired = zoomValue >= this.ZOOM_DEFAULT_VALUE && zoomValue <= currentMaxZoomValue && !(zoomValue == this.lastZoom);
        this.lastZoom = zoomValue;
        if (!isZoomRequired) {
            return;
        }
        Rect zoomRect = this.cropRegionForZoom(zoomValue, (Rect)zoomSensorRect);
        Object object2 = this.captureRequestBuilder;
        if (object2 != null) {
            object2.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoomRect);
        }
        this.lastZoom = zoomValue;
        object2 = this;
        try {
            Integer n2;
            Object object3 = Result.Companion;
            CameraControl $this$setZoomInternal_u24lambda_u2d11 = (CameraControl)object2;
            boolean bl = false;
            if (!$this$setZoomInternal_u24lambda_u2d11.isValidSession()) {
                return;
            }
            CameraCaptureSession cameraCaptureSession = $this$setZoomInternal_u24lambda_u2d11.getCurrentCameraSession();
            if (cameraCaptureSession == null) {
                n2 = null;
            } else {
                CaptureRequest.Builder builder = $this$setZoomInternal_u24lambda_u2d11.getCaptureRequestBuilder();
                Intrinsics.checkNotNull((Object)builder);
                n2 = cameraCaptureSession.setRepeatingRequest(builder.build(), new CameraCaptureSession.CaptureCallback(){}, $this$setZoomInternal_u24lambda_u2d11.getCameraHandler());
            }
            Integer n3 = n2;
            object3 = Result.constructor-impl(n3);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            Object object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final void autoFocusCallbackResult(CaptureResult result2) {
        Integer n = (Integer)result2.get(CaptureResult.CONTROL_AF_STATE);
        if (n == null) {
            return;
        }
        Object object = n;
        int afState = ((Number)object).intValue();
        if (4 == afState || 5 == afState) {
            Result.Companion companion;
            object = this.captureRequestBuilder;
            if (object != null) {
                Integer $this$autoFocusCallbackResult_u24lambda_u2d12 = n = object;
                boolean bl = false;
                $this$autoFocusCallbackResult_u24lambda_u2d12.set(CaptureRequest.CONTROL_AF_TRIGGER, 2);
                $this$autoFocusCallbackResult_u24lambda_u2d12.set(CaptureRequest.CONTROL_AF_MODE, 3);
                $this$autoFocusCallbackResult_u24lambda_u2d12.set(CaptureRequest.CONTROL_AE_MODE, 1);
            }
            try {
                Integer n2;
                object = Result.Companion;
                boolean bl = false;
                if (!this.isValidSession()) {
                    return;
                }
                companion = this.getCurrentCameraSession();
                if (companion == null) {
                    n2 = null;
                } else {
                    CaptureRequest.Builder builder = this.getCaptureRequestBuilder();
                    Intrinsics.checkNotNull((Object)builder);
                    n2 = companion.setRepeatingRequest(builder.build(), new CameraCaptureSession.CaptureCallback(){}, this.getCameraHandler());
                }
                Integer n3 = n2;
                object = Result.constructor-impl(n3);
            }
            catch (Throwable throwable) {
                companion = Result.Companion;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private final float getMaxZoomInternal(CameraCharacteristics cameraCharacteristics) {
        if (cameraCharacteristics == null) {
            return this.ZOOM_DEFAULT_VALUE;
        }
        Float zoomValue = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (zoomValue != null) {
            return zoomValue.floatValue();
        }
        return this.ZOOM_DEFAULT_VALUE;
    }

    private final Rect cropRegionForZoom(float ratio, Rect zoomSensorRect) {
        int xCenter = zoomSensorRect.width() / 2;
        int yCenter = zoomSensorRect.height() / 2;
        int xDelta = (int)(0.5f * (float)zoomSensorRect.width() / ratio);
        int yDelta = (int)(0.5f * (float)zoomSensorRect.height() / ratio);
        return new Rect(xCenter - xDelta, yCenter - yDelta, xCenter + xDelta, yCenter + yDelta);
    }

    private final Object takePictureInternal(Continuation<? super ImageCaptureModel> $completion) {
        CaptureRequest.Builder captureRequest;
        CaptureRequest.Builder builder;
        Object object;
        CaptureRequest.Builder builder2;
        ImageReader imageReader;
        Result.Companion companion;
        Continuation<? super ImageCaptureModel> continuation = $completion;
        boolean bl = false;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl2 = false;
        if (this.getImageReader() == null || !this.isValidSession()) {
            Continuation continuation2 = cont;
            Throwable throwable = new NullPointerException("imageReader null, should be initlaised");
            companion = Result.Companion;
            continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
        }
        do {
            imageReader = this.getImageReader();
            Intrinsics.checkNotNull((Object)imageReader);
        } while (imageReader.acquireNextImage() != null);
        ArrayBlockingQueue<Image> imageQueue = new ArrayBlockingQueue<Image>(this.IMAGE_BUFFER_SIZE);
        ImageReader imageReader2 = this.getImageReader();
        Intrinsics.checkNotNull((Object)imageReader2);
        imageReader2.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(imageQueue){
            final /* synthetic */ ArrayBlockingQueue<Image> $imageQueue;
            {
                this.$imageQueue = $imageQueue;
            }

            public final void onImageAvailable(ImageReader reader) {
                Image image = reader.acquireNextImage();
                this.$imageQueue.add(image);
            }
        }, this.getImageReaderHandler());
        companion = this.getCurrentCameraSession();
        if (companion == null) {
            builder2 = null;
        } else {
            object = companion.getDevice();
            if (object == null) {
                builder2 = null;
            } else {
                builder = object.createCaptureRequest(2);
                if (builder == null) {
                    builder2 = null;
                } else {
                    CaptureRequest.Builder builder3;
                    CaptureRequest.Builder $this$takePictureInternal_u24lambda_u2d16_u24lambda_u2d14 = builder3 = builder;
                    boolean bl3 = false;
                    ImageReader imageReader3 = this.getImageReader();
                    Intrinsics.checkNotNull((Object)imageReader3);
                    $this$takePictureInternal_u24lambda_u2d16_u24lambda_u2d14.addTarget(imageReader3.getSurface());
                    builder2 = captureRequest = builder3;
                }
            }
        }
        if (captureRequest == null) {
            companion = cont;
            object = new NullPointerException("current camera session not found");
            builder = Result.Companion;
            companion.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object)));
        }
        if ((companion = this.getCaptureRequestBuilder()) != null && (object = (Rect)companion.get(CaptureRequest.SCALER_CROP_REGION)) != null) {
            CaptureRequest.Builder it = builder = object;
            boolean bl4 = false;
            CaptureRequest.Builder builder4 = captureRequest;
            if (builder4 != null) {
                builder4.set(CaptureRequest.SCALER_CROP_REGION, (Object)it);
            }
        }
        if ((companion = this.getCurrentCameraSession()) != null) {
            CaptureRequest.Builder builder5 = captureRequest;
            Intrinsics.checkNotNull(builder5);
            Boxing.boxInt((int)companion.capture(builder5.build(), new CameraCaptureSession.CaptureCallback(this, (Continuation<? super ImageCaptureModel>)cont, imageQueue){
                final /* synthetic */ CameraControl this$0;
                final /* synthetic */ Continuation<ImageCaptureModel> $cont;
                final /* synthetic */ ArrayBlockingQueue<Image> $imageQueue;
                {
                    this.this$0 = $receiver;
                    this.$cont = $cont;
                    this.$imageQueue = $imageQueue;
                }

                public void onCaptureCompleted(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull TotalCaptureResult result2) {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    super.onCaptureCompleted(session, request, result2);
                    Long resultTimestamp = (Long)result2.get(CaptureResult.SENSOR_TIMESTAMP);
                    TimeoutException exc = new TimeoutException("Image dequeuing took too long");
                    Runnable timeoutRunnable2 = new Runnable(this.$cont, exc){
                        final /* synthetic */ Continuation<ImageCaptureModel> $cont;
                        final /* synthetic */ TimeoutException $exc;
                        {
                            this.$cont = $cont;
                            this.$exc = $exc;
                        }

                        public final void run() {
                            Continuation<ImageCaptureModel> continuation = this.$cont;
                            Throwable throwable = this.$exc;
                            Result.Companion companion = Result.Companion;
                            continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                        }
                    };
                    CameraControl.access$getImageReaderHandler(this.this$0).postDelayed(timeoutRunnable2, CameraControl.access$getIMAGE_CAPTURE_TIMEOUT_MILLIS$p(this.this$0));
                    BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.$cont.getContext()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$imageQueue, resultTimestamp, this.this$0, timeoutRunnable2, this.$cont, result2, null){
                        int label;
                        final /* synthetic */ ArrayBlockingQueue<Image> $imageQueue;
                        final /* synthetic */ Long $resultTimestamp;
                        final /* synthetic */ CameraControl this$0;
                        final /* synthetic */ Runnable $timeoutRunnable;
                        final /* synthetic */ Continuation<ImageCaptureModel> $cont;
                        final /* synthetic */ TotalCaptureResult $result;
                        {
                            this.$imageQueue = $imageQueue;
                            this.$resultTimestamp = $resultTimestamp;
                            this.this$0 = $receiver;
                            this.$timeoutRunnable = $timeoutRunnable;
                            this.$cont = $cont;
                            this.$result = $result;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    while (true) {
                                        Image image = this.$imageQueue.take();
                                        if (Build.VERSION.SDK_INT >= 29 && image.getFormat() != 1768253795) {
                                            Long l = this.$resultTimestamp;
                                            if (l == null || image.getTimestamp() != l.longValue()) continue;
                                        }
                                        CameraControl.access$getImageReaderHandler(this.this$0).removeCallbacks(this.$timeoutRunnable);
                                        ImageReader imageReader = this.this$0.getImageReader();
                                        Intrinsics.checkNotNull((Object)imageReader);
                                        imageReader.setOnImageAvailableListener(null, null);
                                        while (this.$imageQueue.size() > 0) {
                                            this.$imageQueue.take().close();
                                        }
                                        Context context = this.this$0.getContext();
                                        CameraCaptureSession cameraCaptureSession = this.this$0.getCurrentCameraSession();
                                        Intrinsics.checkNotNull((Object)cameraCaptureSession);
                                        String string = cameraCaptureSession.getDevice().getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentCameraSession!!.device.id");
                                        int rotation = CameraExtKt.computeRelativeRotation(context, string);
                                        Context context2 = this.this$0.getContext();
                                        CameraCaptureSession cameraCaptureSession2 = this.this$0.getCurrentCameraSession();
                                        Intrinsics.checkNotNull((Object)cameraCaptureSession2);
                                        String string2 = cameraCaptureSession2.getDevice().getId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentCameraSession!!.device.id");
                                        Integer n = (Integer)CameraExtKt.getCameraCharacteristics(context2, string2).get(CameraCharacteristics.LENS_FACING);
                                        boolean bl = false;
                                        boolean mirrored = n != null && n == 0;
                                        int exifOrientation = CameraExtKt.computeExifOrientation(rotation, mirrored);
                                        Continuation<ImageCaptureModel> continuation = this.$cont;
                                        Intrinsics.checkNotNullExpressionValue((Object)image, (String)"image");
                                        CaptureResult captureResult = (CaptureResult)this.$result;
                                        Integer n2 = Boxing.boxInt((int)exifOrientation);
                                        ImageReader imageReader2 = this.this$0.getImageReader();
                                        Intrinsics.checkNotNull((Object)imageReader2);
                                        ImageCaptureModel imageCaptureModel = new ImageCaptureModel(image, captureResult, n2, imageReader2.getImageFormat());
                                        Result.Companion companion = Result.Companion;
                                        continuation.resumeWith(Result.constructor-impl((Object)imageCaptureModel));
                                    }
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }, this.getCameraHandler()));
        }
        Object object2 = safeContinuation.getOrThrow();
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object2;
    }

    private static final void setZoom$lambda-2(CameraControl this$0, float $zoomValue, String $currentCameraIndex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentCameraIndex, (String)"$currentCameraIndex");
        this$0.setZoomInternal($zoomValue, $currentCameraIndex);
    }

    private static final void resetZoom$lambda-3(CameraControl this$0, String $currentCameraIndex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentCameraIndex, (String)"$currentCameraIndex");
        this$0.setZoomInternal(this$0.getMinZoom(), $currentCameraIndex);
    }

    private static final void setTapToFocusAt$lambda-7(CameraControl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.getCurrentCameraSession() != null) {
            CameraControl cameraControl = this$0;
            try {
                Integer n;
                Object object = Result.Companion;
                CameraControl $this$setTapToFocusAt_u24lambda_u2d7_u24lambda_u2d6 = cameraControl;
                boolean bl = false;
                CameraCaptureSession cameraCaptureSession = $this$setTapToFocusAt_u24lambda_u2d7_u24lambda_u2d6.getCurrentCameraSession();
                if (cameraCaptureSession == null) {
                    n = null;
                } else {
                    CaptureRequest.Builder builder = $this$setTapToFocusAt_u24lambda_u2d7_u24lambda_u2d6.getCaptureRequestBuilder();
                    Intrinsics.checkNotNull((Object)builder);
                    n = cameraCaptureSession.setRepeatingRequest(builder.build(), new CameraCaptureSession.CaptureCallback($this$setTapToFocusAt_u24lambda_u2d7_u24lambda_u2d6){
                        final /* synthetic */ CameraControl $this_runCatching;
                        {
                            this.$this_runCatching = $receiver;
                        }

                        public void onCaptureProgressed(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull CaptureResult partialResult) {
                            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                            Intrinsics.checkNotNullParameter((Object)partialResult, (String)"partialResult");
                            super.onCaptureProgressed(session, request, partialResult);
                            CameraControl.access$autoFocusCallbackResult(this.$this_runCatching, partialResult);
                        }

                        public void onCaptureCompleted(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull TotalCaptureResult result2) {
                            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                            super.onCaptureCompleted(session, request, result2);
                            CameraControl.access$autoFocusCallbackResult(this.$this_runCatching, (CaptureResult)result2);
                        }
                    }, $this$setTapToFocusAt_u24lambda_u2d7_u24lambda_u2d6.getCameraHandler());
                }
                Integer n2 = n;
                object = Result.constructor-impl(n2);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private static final void setFlash$lambda-10(CameraControl this$0, int $mode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Integer n;
            Object object = Result.Companion;
            boolean bl = false;
            CaptureRequest.Builder builder = this$0.getCaptureRequestBuilder();
            if (builder != null) {
                builder.set(CaptureRequest.FLASH_MODE, (Object)$mode);
            }
            builder = this$0.getCurrentCameraSession();
            if (builder == null) {
                n = null;
            } else {
                CaptureRequest.Builder builder2 = this$0.getCaptureRequestBuilder();
                Intrinsics.checkNotNull((Object)builder2);
                n = builder.setRepeatingRequest(builder2.build(), new CameraCaptureSession.CaptureCallback(){}, this$0.getCameraHandler());
            }
            Integer n2 = n;
            object = Result.constructor-impl(n2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public static final /* synthetic */ Mutex access$getCameraCaptureMutex$p(CameraControl $this) {
        return $this.cameraCaptureMutex;
    }

    public static final /* synthetic */ Object access$takePictureInternal(CameraControl $this, Continuation $completion) {
        return $this.takePictureInternal((Continuation<? super ImageCaptureModel>)$completion);
    }

    public static final /* synthetic */ void access$autoFocusCallbackResult(CameraControl $this, CaptureResult result2) {
        $this.autoFocusCallbackResult(result2);
    }

    public static final /* synthetic */ Handler access$getImageReaderHandler(CameraControl $this) {
        return $this.getImageReaderHandler();
    }

    public static final /* synthetic */ long access$getIMAGE_CAPTURE_TIMEOUT_MILLIS$p(CameraControl $this) {
        return $this.IMAGE_CAPTURE_TIMEOUT_MILLIS;
    }

    public static final /* synthetic */ HandlerThread access$getImageReaderThread(CameraControl $this) {
        return $this.getImageReaderThread();
    }
}

