/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories;

import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoEncoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoEncoderFallback;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Llive/hms/video/factories/HMSVideoEncoderFactory;", "Lorg/webrtc/DefaultVideoEncoderFactory;", "eglContext", "Lorg/webrtc/EglBase$Context;", "enableIntelVp8Encoder", "", "enableH264HighProfile", "(Lorg/webrtc/EglBase$Context;ZZ)V", "hardwareVideoEncoderFactory", "Lorg/webrtc/VideoEncoderFactory;", "softwareVideoEncoderFactory", "createEncoder", "Lorg/webrtc/VideoEncoder;", "info", "Lorg/webrtc/VideoCodecInfo;", "lib_release"})
public final class HMSVideoEncoderFactory
extends DefaultVideoEncoderFactory {
    @NotNull
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    @NotNull
    private final VideoEncoderFactory softwareVideoEncoderFactory;

    public HMSVideoEncoderFactory(@Nullable EglBase.Context eglContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        super(eglContext, enableIntelVp8Encoder, enableH264HighProfile);
        this.hardwareVideoEncoderFactory = (VideoEncoderFactory)new HardwareVideoEncoderFactory(eglContext, enableIntelVp8Encoder, enableH264HighProfile);
        this.softwareVideoEncoderFactory = (VideoEncoderFactory)new SoftwareVideoEncoderFactory();
    }

    @Nullable
    public VideoEncoder createEncoder(@Nullable VideoCodecInfo info) {
        VideoEncoder softwareEncoder = this.softwareVideoEncoderFactory.createEncoder(info);
        VideoEncoder hardwareEncoder = this.hardwareVideoEncoderFactory.createEncoder(info);
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        if (StringsKt.startsWith$default((String)string, (String)"Pixel", (boolean)false, (int)2, null)) {
            return softwareEncoder;
        }
        return hardwareEncoder != null && softwareEncoder != null ? (VideoEncoder)new VideoEncoderFallback(softwareEncoder, hardwareEncoder) : ((string = hardwareEncoder) == null ? softwareEncoder : string);
    }
}

