/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.events;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.database.entity.AnalyticsEntityModel;
import live.hms.video.factories.OkHttpFactory;
import live.hms.video.signal.init.ShortCodeInput;
import live.hms.video.signal.init.TokenRequest;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSAgentOs;
import live.hms.video.utils.HMSLogger;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J'\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0010J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Llive/hms/video/events/HMSApiClient;", "", "()V", "TAG", "", "makeEventRequest", "Lokhttp3/Request;", "analyticsEntityModel", "Llive/hms/video/database/entity/AnalyticsEntityModel;", "token", "hmsAgentOs", "Llive/hms/video/utils/HMSAgentOs;", "makeTokenRequest", "tokenRequest", "Llive/hms/video/signal/init/TokenRequest;", "baseUrl", "makeTokenRequest$lib_release", "reportAnalyticsEvent", "", "(Llive/hms/video/database/entity/AnalyticsEntityModel;Llive/hms/video/utils/HMSAgentOs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
public final class HMSApiClient {
    @NotNull
    public static final HMSApiClient INSTANCE = new HMSApiClient();
    @NotNull
    private static final String TAG = "EventsApi";

    private HMSApiClient() {
    }

    private final Request makeEventRequest(AnalyticsEntityModel analyticsEntityModel, String token, HMSAgentOs hmsAgentOs) {
        String agentUrlEncoded = hmsAgentOs.getUserAgent();
        String url = analyticsEntityModel.isQa() ? "https://event-nonprod.100ms.live/v2/client/report" : "https://event.100ms.live/v2/client/report";
        MediaType mediaType = MediaType.Companion.parse("application/json; charset=utf-8");
        String jsonPayload = GsonUtils.INSTANCE.getGson().toJson((Object)analyticsEntityModel);
        Intrinsics.checkNotNullExpressionValue((Object)jsonPayload, (String)"jsonPayload");
        RequestBody body = RequestBody.Companion.create(jsonPayload, mediaType);
        Request request = new Request.Builder().url(url).addHeader(hmsAgentOs.getUSER_AGENT_V2_NAME(), agentUrlEncoded).addHeader("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)token)).addHeader("Accept-Type", "application/json").post(body).build();
        HMSLogger.d(TAG, Intrinsics.stringPlus((String)"makeEventRequest: request=", (Object)request));
        return request;
    }

    @NotNull
    public final Request makeTokenRequest$lib_release(@NotNull TokenRequest tokenRequest, @Nullable String baseUrl, @NotNull HMSAgentOs hmsAgentOs) {
        Intrinsics.checkNotNullParameter((Object)tokenRequest, (String)"tokenRequest");
        Intrinsics.checkNotNullParameter((Object)hmsAgentOs, (String)"hmsAgentOs");
        String agentUrlEncoded = hmsAgentOs.getUserAgent();
        MediaType mediaType = MediaType.Companion.parse("application/json; charset=utf-8");
        String jsonPayload = GsonUtils.INSTANCE.getGson().toJson((Object)new ShortCodeInput(tokenRequest.getRoomCode(), tokenRequest.getUserId()));
        Intrinsics.checkNotNullExpressionValue((Object)jsonPayload, (String)"jsonPayload");
        RequestBody body = RequestBody.Companion.create(jsonPayload, mediaType);
        CharSequence charSequence = baseUrl;
        String tokenEndpoint = charSequence == null || charSequence.length() == 0 ? "https://auth.100ms.live" : baseUrl;
        return new Request.Builder().url(Intrinsics.stringPlus((String)tokenEndpoint, (Object)"/v2/token")).addHeader(hmsAgentOs.getUSER_AGENT_V2_NAME(), agentUrlEncoded).post(body).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object reportAnalyticsEvent(@NotNull AnalyticsEntityModel analyticsEntityModel, @NotNull HMSAgentOs hmsAgentOs, @NotNull Continuation<? super Boolean> $completion) {
        Request request = this.makeEventRequest(analyticsEntityModel, analyticsEntityModel.getToken(), hmsAgentOs);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        try {
            Closeable closeable = (Closeable)OkHttpFactory.INSTANCE.getClient().newCall(request).execute();
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl = false;
                Boolean bl2 = Boxing.boxBoolean((boolean)(response.isSuccessful() ? deferred.complete((Object)Boxing.boxBoolean((boolean)true)) : deferred.complete((Object)Boxing.boxBoolean((boolean)false))));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HMSLogger.e(TAG, Unit.INSTANCE.toString());
            deferred.complete((Object)Boxing.boxBoolean((boolean)false));
        }
        return deferred.await($completion);
    }
}

