/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import live.hms.video.sdk.SignatureChecker;
import live.hms.video.sdk.models.FrameworkInfo;
import live.hms.video.utils.HMSAgentOs;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RTCStats;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010\"\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010\u000eH\u0002J \u0010$\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0016\u0010'\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u0007J\u0018\u0010(\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Llive/hms/video/utils/LogUtils;", "", "()V", "DEFAULT_DIR_SIZE", "", "DEVICE_INFO", "", "", "getDEVICE_INFO", "()[Ljava/lang/String;", "[Ljava/lang/String;", "MAX_DIR_SIZE", "TAG", "currentSessionFile", "Ljava/io/File;", "getCurrentSessionFile", "()Ljava/io/File;", "setCurrentSessionFile", "(Ljava/io/File;)V", "currentSessionFileWriter", "Ljava/io/FileWriter;", "getCurrentSessionFileWriter", "()Ljava/io/FileWriter;", "setCurrentSessionFileWriter", "(Ljava/io/FileWriter;)V", "logDateFormatter", "Ljava/text/SimpleDateFormat;", "logFileNameDateFormatter", "checkDirSizeAndRemove", "", "context", "Landroid/content/Context;", "closeLogging", "getDirPath", "initiateLogging", "givenSessionFile", "makeLogFile", "dirName", "filename", "saveLogsToFile", "staticFileWriterStart", "frameworkInfo", "Llive/hms/video/sdk/models/FrameworkInfo;", "lib_release"})
public final class LogUtils {
    @NotNull
    public static final LogUtils INSTANCE = new LogUtils();
    @NotNull
    private static final String[] DEVICE_INFO;
    @NotNull
    public static final String MAX_DIR_SIZE = "max_dir_size";
    public static final long DEFAULT_DIR_SIZE = 1000000L;
    @NotNull
    private static final SimpleDateFormat logFileNameDateFormatter;
    @NotNull
    private static final SimpleDateFormat logDateFormatter;
    @Nullable
    private static File currentSessionFile;
    @Nullable
    private static FileWriter currentSessionFileWriter;
    @NotNull
    private static final String TAG = "LogUtils";

    private LogUtils() {
    }

    @NotNull
    public final String[] getDEVICE_INFO() {
        return DEVICE_INFO;
    }

    @Nullable
    public final File getCurrentSessionFile() {
        return currentSessionFile;
    }

    public final void setCurrentSessionFile(@Nullable File file) {
        currentSessionFile = file;
    }

    @Nullable
    public final FileWriter getCurrentSessionFileWriter() {
        return currentSessionFileWriter;
    }

    public final void setCurrentSessionFileWriter(@Nullable FileWriter fileWriter) {
        currentSessionFileWriter = fileWriter;
    }

    public final void closeLogging() {
        FileWriter fileWriter = currentSessionFileWriter;
        if (fileWriter != null) {
            FileWriter fileWriter2;
            FileWriter writer = fileWriter2 = fileWriter;
            boolean bl = false;
            HMSLogger.INSTANCE.removeInjectedLoggable();
            writer.close();
            INSTANCE.setCurrentSessionFile(null);
            INSTANCE.setCurrentSessionFileWriter(null);
        }
    }

    private final FileWriter initiateLogging(Context context, File givenSessionFile) {
        FileWriter fileWriter;
        File file = givenSessionFile;
        currentSessionFile = file == null ? this.makeLogFile(context, "logs", "session_log") : file;
        currentSessionFileWriter = fileWriter = new FileWriter(currentSessionFile);
        return fileWriter;
    }

    @Nullable
    public final String staticFileWriterStart(@NotNull Context context, @NotNull FrameworkInfo frameworkInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frameworkInfo, (String)"frameworkInfo");
        this.closeLogging();
        Ref.ObjectRef fileWriter = new Ref.ObjectRef();
        fileWriter.element = this.initiateLogging(context, null);
        ((FileWriter)fileWriter.element).write(Intrinsics.stringPlus((String)"Android Agent: ", (Object)new HMSAgentOs(frameworkInfo, new SignatureChecker(context)).getUserAgent()));
        ((FileWriter)fileWriter.element).write(Intrinsics.stringPlus((String)"Device Info: ", (Object)ArraysKt.joinToString$default((Object[])DEVICE_INFO, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
        HMSLogger.INSTANCE.injectLoggable(new HMSLogger.Loggable((Ref.ObjectRef<FileWriter>)fileWriter, context){
            final /* synthetic */ Ref.ObjectRef<FileWriter> $fileWriter;
            final /* synthetic */ Context $context;
            {
                this.$fileWriter = $fileWriter;
                this.$context = $context;
            }

            public void onLogMessage(@NotNull HMSLogger.LogLevel level, @NotNull String tag, @NotNull String message, boolean isWebRtCLog) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Date date = new Date();
                Object it = date;
                boolean bl = false;
                String time = LogUtils.access$getLogDateFormatter$p().format((Date)it);
                String prefix = '[' + (isWebRtCLog ? "RTC" : "HMS") + ':' + (Object)((Object)level) + ':' + tag + ':' + time + ']';
                try {
                    it = message;
                    ((FileWriter)this.$fileWriter.element).write(prefix + "\t\t" + ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)it))).toString() + '\n');
                }
                catch (IOException e) {
                    Log.e((String)"LogUtils", (String)Intrinsics.stringPlus((String)"ran into an exception closing the log file :", (Object)e));
                    ((FileWriter)this.$fileWriter.element).close();
                    this.$fileWriter.element = LogUtils.access$initiateLogging(LogUtils.INSTANCE, this.$context, LogUtils.INSTANCE.getCurrentSessionFile());
                }
            }

            public void onLogToFile(@NotNull HMSLogger.LogFiles fileName, @NotNull String tag, @NotNull Map<String, RTCStats> message) {
                HMSLogger.Loggable.DefaultImpls.onLogToFile(this, fileName, tag, message);
            }
        });
        File file = currentSessionFile;
        return file == null ? null : file.getAbsolutePath();
    }

    private final File makeLogFile(Context context, String dirName, String filename) {
        Date date;
        File logsDir = new File(context.getExternalFilesDir(dirName), "");
        Date it = date = new Date();
        boolean bl = false;
        String fileNameSuffix = logFileNameDateFormatter.format(it) + '-' + it.getTime();
        return new File(logsDir, filename + '-' + fileNameSuffix + ".log");
    }

    @NotNull
    public final File saveLogsToFile(@NotNull Context context, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        File logFile = this.makeLogFile(context, "crash", filename);
        try {
            Runtime.getRuntime().exec(Intrinsics.stringPlus((String)"logcat -f ", (Object)logFile.getAbsolutePath()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)Intrinsics.stringPlus((String)"Error occurred while saving logs in ", (Object)logFile.getAbsolutePath()), (Throwable)e);
        }
        Log.v((String)TAG, (String)Intrinsics.stringPlus((String)"Saved logs to file ", (Object)logFile.getAbsolutePath()));
        return logFile;
    }

    @NotNull
    public final File getDirPath(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getExternalFilesDir("logs"), "");
    }

    public final void checkDirSizeAndRemove(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        long maxDirSize = prefs.getLong(MAX_DIR_SIZE, 1000000L);
        File logsDir = new File(context.getExternalFilesDir("logs"), "");
        if (logsDir.exists()) {
            long result2 = 0L;
            File[] fileList = logsDir.listFiles();
            File[] fileArray = fileList;
            if (fileArray != null) {
                File[] fileArray2;
                File[] it = fileArray2 = fileArray;
                boolean bl = false;
                Arrays.sort(fileList, LogUtils::checkDirSizeAndRemove$lambda-4$lambda-2);
                File[] $this$forEach$iv = fileList;
                boolean $i$f$forEach = false;
                for (File element$iv : $this$forEach$iv) {
                    File it2 = element$iv;
                    boolean bl2 = false;
                    if ((result2 += it2.length()) <= maxDirSize) continue;
                    it2.delete();
                }
            }
        }
    }

    private static final int checkDirSizeAndRemove$lambda-4$lambda-2(File firstComparator, File secondComparator) {
        return Intrinsics.compare((long)secondComparator.lastModified(), (long)firstComparator.lastModified());
    }

    public static final /* synthetic */ FileWriter access$initiateLogging(LogUtils $this, Context context, File givenSessionFile) {
        return $this.initiateLogging(context, givenSessionFile);
    }

    public static final /* synthetic */ SimpleDateFormat access$getLogDateFormatter$p() {
        return logDateFormatter;
    }

    static {
        String[] stringArray = new String[]{Intrinsics.stringPlus((String)"Android SDK: ", (Object)Build.VERSION.SDK_INT), Intrinsics.stringPlus((String)"Release: ", (Object)Build.VERSION.RELEASE), Intrinsics.stringPlus((String)"Brand: ", (Object)Build.BRAND), Intrinsics.stringPlus((String)"Device: ", (Object)Build.DEVICE), Intrinsics.stringPlus((String)"Id: ", (Object)Build.ID), Intrinsics.stringPlus((String)"Hardware: ", (Object)Build.HARDWARE), Intrinsics.stringPlus((String)"Manufacturer: ", (Object)Build.MANUFACTURER), Intrinsics.stringPlus((String)"Model: ", (Object)Build.MODEL), Intrinsics.stringPlus((String)"Product: ", (Object)Build.PRODUCT)};
        DEVICE_INFO = stringArray;
        logFileNameDateFormatter = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss.SSS", Locale.ENGLISH);
        logDateFormatter = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
    }
}

