/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.view.WindowManager;
import androidx.core.math.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.error.HMSException;
import live.hms.video.media.settings.HMSLayer;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.sdk.models.role.HMSRole;
import live.hms.video.sdk.models.role.LayerParams;
import live.hms.video.sdk.models.role.PublishParams;
import live.hms.video.sdk.models.role.Simulcast;
import live.hms.video.sdk.models.role.VideoSimulcastLayersParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RendererCommon;
import org.webrtc.RtpParameters;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ!\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J%\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b#J\u0016\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002JG\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010+\u001a\u0004\u0018\u00010\u00042\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b0\u00101J\u0019\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b5J\u0012\u00106\u001a\u00020\u00122\n\u00107\u001a\u000608j\u0002`9JW\u0010:\u001a\u0004\u0018\u00010)2\b\u0010;\u001a\u0004\u0018\u00010)2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\b\u0010+\u001a\u0004\u0018\u00010\u00042\b\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0004\bB\u0010CJ\u000e\u0010D\u001a\u00020\u0012*\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Llive/hms/video/utils/HMSUtils;", "", "()V", "MAX_SCREENSHARE_SIZE", "", "TAG", "", "addAndConvertBuffers", "", "a1", "", "a1Limit", "a2", "a2Limit", "applySizeConstraint", "Landroid/graphics/Point;", "actualSize", "didSimulcastLayerChangeHappen", "", "prevRole", "Llive/hms/video/sdk/models/role/HMSRole;", "newRole", "didSimulcastLayerChangeHappen$lib_release", "getDeviceWidthAndHeight", "context", "Landroid/content/Context;", "getOrientation", "getSurfaceOrientation", "surfaceOrientation", "getVideoEncodingParameter", "", "Lorg/webrtc/RtpParameters$Encoding;", "hmsVideoTrackSettings", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "isScreenShare", "getVideoEncodingParameter$lib_release", "hasOrientationChange", "currentOrientation", "oldOrientation", "isSimulcastEnabledFromPolicy", "normalizedToCameraSensor", "Landroid/graphics/RectF;", "normalisedRect", "captureWidth", "captureHeight", "cropSensorWidth", "cropSensorHeight", "needCameraCrop", "normalizedToCameraSensor$lib_release", "(Landroid/graphics/RectF;Ljava/lang/Integer;Ljava/lang/Integer;IIZ)Landroid/graphics/RectF;", "ridToHMSLayerMapper", "Llive/hms/video/media/settings/HMSLayer;", "rid", "ridToHMSLayerMapper$lib_release", "shouldRetry", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "viewToNormalized", "transformRect", "viewWidth", "viewHeight", "mirrorMode", "rotationAngle", "scaleType", "Lorg/webrtc/RendererCommon$ScalingType;", "viewToNormalized$lib_release", "(Landroid/graphics/RectF;IILjava/lang/Integer;Ljava/lang/Integer;ZILorg/webrtc/RendererCommon$ScalingType;)Landroid/graphics/RectF;", "isRoleSimulcast", "lib_release"})
public final class HMSUtils {
    @NotNull
    public static final HMSUtils INSTANCE = new HMSUtils();
    @NotNull
    private static final String TAG = "HMSUtils";
    private static final int MAX_SCREENSHARE_SIZE = 1920;

    private HMSUtils() {
    }

    public final int getOrientation(@NotNull Context context) {
        int n;
        Integer n2;
        WindowManager windowManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        WindowManager windowManager2 = windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        Integer n3 = n2 = windowManager == null ? null : ((object = windowManager.getDefaultDisplay()) == null ? null : Integer.valueOf(object.getRotation()));
        int n4 = 1;
        if (n3 != null && n3 == n4) {
            n = 90;
        } else {
            Integer n5 = n2;
            n4 = 2;
            if (n5 != null && n5 == n4) {
                n = 180;
            } else {
                Integer n6 = n2;
                n4 = 3;
                n = n6 != null && n6 == n4 ? 270 : 0;
            }
        }
        return n;
    }

    public final boolean hasOrientationChange(int currentOrientation, int oldOrientation) {
        int n;
        return currentOrientation != oldOrientation && Math.abs(n = currentOrientation - oldOrientation) != 180;
    }

    public final boolean shouldRetry(@NotNull Exception ex) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return ex instanceof HMSException ? ArraysKt.contains((Object[])(objectArray = new Integer[]{2003, 1003}), (Object)((HMSException)ex).getCode()) || StringsKt.startsWith$default((String)String.valueOf(((HMSException)ex).getCode()), (String)"5", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(((HMSException)ex).getCode()), (String)"429", (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public final byte[] addAndConvertBuffers(@NotNull short[] a1, int a1Limit, @NotNull short[] a2, int a2Limit) {
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        int size = Math.max(a1Limit, a2Limit);
        if (size < 0) {
            return new byte[0];
        }
        byte[] buff = new byte[size * 2];
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                int sum = 0;
                int n2 = i >= a1Limit ? a2[i] : (sum = i >= a2Limit ? a1[i] : a1[i] + a2[i]);
                if (sum > Short.MAX_VALUE) {
                    sum = Short.MAX_VALUE;
                }
                if (sum < Short.MIN_VALUE) {
                    sum = Short.MIN_VALUE;
                }
                int byteIndex = i * 2;
                buff[byteIndex] = (byte)(sum & 0xFF);
                buff[byteIndex + 1] = (byte)(sum >> 8 & 0xFF);
            } while (n < size);
        }
        return buff;
    }

    @NotNull
    public final Point getDeviceWidthAndHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Point size = new Point();
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Object $this$getDeviceWidthAndHeight_u24lambda_u2d0 = object = wm.getDefaultDisplay();
        boolean bl = false;
        $this$getDeviceWidthAndHeight_u24lambda_u2d0.getRealSize(size);
        return size;
    }

    private final boolean isSimulcastEnabledFromPolicy(boolean isScreenShare, HMSVideoTrackSettings hmsVideoTrackSettings) {
        Object object;
        return isScreenShare && ((object = (Collection)((object = hmsVideoTrackSettings.getScreenShareSimulcastLayersParams$lib_release()) == null ? null : ((VideoSimulcastLayersParams)object).getLayers())) == null || object.isEmpty()) || !isScreenShare && ((object = (Collection)((object = hmsVideoTrackSettings.getVideoSimulcastLayersParams$lib_release()) == null ? null : ((VideoSimulcastLayersParams)object).getLayers())) == null || object.isEmpty());
    }

    @NotNull
    public final List<RtpParameters.Encoding> getVideoEncodingParameter$lib_release(@NotNull HMSVideoTrackSettings hmsVideoTrackSettings, boolean isScreenShare) {
        Intrinsics.checkNotNullParameter((Object)hmsVideoTrackSettings, (String)"hmsVideoTrackSettings");
        List encodingParams = new ArrayList();
        if (!hmsVideoTrackSettings.isSimulcastFeatureFlagEnabled$lib_release() || this.isSimulcastEnabledFromPolicy(isScreenShare, hmsVideoTrackSettings)) {
            RtpParameters.Encoding encoding;
            Collection collection = encodingParams;
            RtpParameters.Encoding $this$getVideoEncodingParameter_u24lambda_u2d1 = encoding = new RtpParameters.Encoding(null, true, null);
            boolean bl = false;
            $this$getVideoEncodingParameter_u24lambda_u2d1.maxBitrateBps = hmsVideoTrackSettings.getMaxBitRate() * 1000;
            $this$getVideoEncodingParameter_u24lambda_u2d1.maxFramerate = hmsVideoTrackSettings.getMaxFrameRate();
            collection.add(encoding);
        } else {
            Object object;
            ArrayList<LayerParams> simulcastLayers = isScreenShare ? ((object = hmsVideoTrackSettings.getScreenShareSimulcastLayersParams$lib_release()) == null ? null : ((VideoSimulcastLayersParams)object).getLayers()) : ((object = hmsVideoTrackSettings.getVideoSimulcastLayersParams$lib_release()) == null ? null : ((VideoSimulcastLayersParams)object).getLayers());
            object = simulcastLayers;
            if (object != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Float f;
                    LayerParams layer = (LayerParams)element$iv;
                    boolean bl = false;
                    Collection collection = encodingParams;
                    Float $this$getVideoEncodingParameter_u24lambda_u2d3_u24lambda_u2d2 = f = new RtpParameters.Encoding(layer.getRid(), true, (f = layer.getScaleResolutionDownBy()) == null ? null : Double.valueOf(f.floatValue()));
                    boolean bl2 = false;
                    Integer n = layer.getMaxBitrate();
                    ((RtpParameters.Encoding)$this$getVideoEncodingParameter_u24lambda_u2d3_u24lambda_u2d2).maxBitrateBps = (n == null ? hmsVideoTrackSettings.getMaxBitRate() : n.intValue()) * 1000;
                    n = layer.getMaxFramerate();
                    ((RtpParameters.Encoding)$this$getVideoEncodingParameter_u24lambda_u2d3_u24lambda_u2d2).maxFramerate = n == null ? Integer.valueOf(hmsVideoTrackSettings.getMaxFrameRate()) : n;
                    collection.add(f);
                }
            }
        }
        return encodingParams;
    }

    public static /* synthetic */ List getVideoEncodingParameter$lib_release$default(HMSUtils hMSUtils, HMSVideoTrackSettings hMSVideoTrackSettings, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return hMSUtils.getVideoEncodingParameter$lib_release(hMSVideoTrackSettings, bl);
    }

    @NotNull
    public final Point applySizeConstraint(@NotNull Point actualSize) {
        Intrinsics.checkNotNullParameter((Object)actualSize, (String)"actualSize");
        int width = actualSize.x;
        int height = actualSize.y;
        int maxSize = Math.max(width, height);
        if (maxSize > 1920) {
            float ratio = (float)width / (float)height;
            if (width == maxSize) {
                width = 1920;
                height = (int)(1.0f / ratio * (float)1920);
            } else {
                height = 1920;
                width = (int)((float)1920 * ratio);
            }
            return new Point(width, height);
        }
        return actualSize;
    }

    public final boolean didSimulcastLayerChangeHappen$lib_release(@Nullable HMSRole prevRole, @Nullable HMSRole newRole) {
        if (this.isRoleSimulcast(prevRole) && !this.isRoleSimulcast(newRole)) {
            return true;
        }
        return !this.isRoleSimulcast(prevRole) && this.isRoleSimulcast(newRole);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final HMSLayer ridToHMSLayerMapper$lib_release(@Nullable String rid) {
        String string = rid;
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 113: {
                if (string.equals("q")) {
                    n = 1;
                }
                break;
            }
            case 102: {
                if (string.equals("f")) {
                    n = 2;
                }
                break;
            }
            case 104: {
                if (string.equals("h")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                HMSLayer hMSLayer = HMSLayer.MEDIUM;
                return hMSLayer;
            }
            case 1: {
                HMSLayer hMSLayer = HMSLayer.LOW;
                return hMSLayer;
            }
            case 2: {
                HMSLayer hMSLayer = HMSLayer.HIGH;
                return hMSLayer;
            }
            default: {
                return null;
            }
        }
    }

    private final boolean isRoleSimulcast(HMSRole $this$isRoleSimulcast) {
        VideoSimulcastLayersParams videoSimulcastLayersParams;
        Simulcast simulcast;
        PublishParams publishParams;
        Object object = $this$isRoleSimulcast;
        object = object == null ? null : ((publishParams = ((HMSRole)object).getPublishParams()) == null ? null : ((simulcast = publishParams.getSimulcast()) == null ? null : ((videoSimulcastLayersParams = simulcast.getVideo()) == null ? null : videoSimulcastLayersParams.getLayers())));
        return !(object == null || object.isEmpty());
    }

    @Nullable
    public final RectF viewToNormalized$lib_release(@Nullable RectF transformRect, int viewWidth, int viewHeight, @Nullable Integer captureWidth, @Nullable Integer captureHeight, boolean mirrorMode, int rotationAngle, @NotNull RendererCommon.ScalingType scaleType) {
        float f;
        float f2;
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        if (transformRect == null || captureWidth == null || captureHeight == null || viewWidth <= 0 || viewHeight <= 0 || transformRect.left < 0.0f || transformRect.top < 0.0f || transformRect.right > (float)viewWidth || transformRect.bottom > (float)viewHeight || rotationAngle % 90 != 0) {
            return null;
        }
        int appliedRotation = rotationAngle > 0 ? rotationAngle % 360 : 360 + rotationAngle % 360;
        RectF normalisedRect = new RectF(transformRect);
        Matrix matrix = new Matrix();
        matrix.postRotate((float)appliedRotation);
        switch (appliedRotation) {
            case 90: 
            case 270: {
                f2 = viewHeight;
                break;
            }
            default: {
                f2 = viewWidth;
            }
        }
        float viewWidthPostRotate = f2;
        switch (appliedRotation) {
            case 90: 
            case 270: {
                f = viewWidth;
                break;
            }
            default: {
                f = viewHeight;
            }
        }
        float viewHeightPostRotate = f;
        float ratioW = viewWidthPostRotate / (float)captureWidth.intValue();
        float ratioH = viewHeightPostRotate / (float)captureHeight.intValue();
        matrix.postScale(1.0f / viewWidthPostRotate, 1.0f / viewHeightPostRotate);
        int n = appliedRotation;
        switch (n) {
            case 90: {
                matrix.postTranslate(1.0f, 0.0f);
                break;
            }
            case 180: {
                matrix.postTranslate(1.0f, 1.0f);
                break;
            }
            case 270: {
                matrix.postTranslate(0.0f, 1.0f);
            }
        }
        RendererCommon.ScalingType scalingType = scaleType;
        int n2 = WhenMappings.$EnumSwitchMapping$0[scalingType.ordinal()];
        switch (n2) {
            case 1: {
                if (ratioW <= ratioH) {
                    matrix.postScale(ratioW / ratioH, 1.0f, 0.5f, 0.0f);
                    matrix.mapRect(normalisedRect);
                    normalisedRect.right = MathUtils.clamp((float)normalisedRect.right, (float)0.0f, (float)1.0f);
                    normalisedRect.left = MathUtils.clamp((float)normalisedRect.left, (float)0.0f, (float)1.0f);
                    break;
                }
                matrix.postScale(1.0f, ratioH / ratioW, 0.0f, 0.5f);
                matrix.mapRect(normalisedRect);
                normalisedRect.top = MathUtils.clamp((float)normalisedRect.top, (float)0.0f, (float)1.0f);
                normalisedRect.bottom = MathUtils.clamp((float)normalisedRect.bottom, (float)0.0f, (float)1.0f);
                break;
            }
            case 2: {
                if (ratioW <= ratioH) {
                    matrix.postScale(1.0f, ratioH / ratioW);
                    matrix.mapRect(normalisedRect);
                    normalisedRect.top = MathUtils.clamp((float)normalisedRect.top, (float)0.0f, (float)1.0f);
                    normalisedRect.bottom = MathUtils.clamp((float)normalisedRect.bottom, (float)0.0f, (float)1.0f);
                    break;
                }
                matrix.postScale(ratioW / ratioH, 1.0f, 0.5f, 0.0f);
                matrix.mapRect(normalisedRect);
                normalisedRect.right = MathUtils.clamp((float)normalisedRect.right, (float)0.0f, (float)1.0f);
                normalisedRect.left = MathUtils.clamp((float)normalisedRect.left, (float)0.0f, (float)1.0f);
            }
        }
        if (mirrorMode) {
            float tempLeft = normalisedRect.left;
            normalisedRect.left = 1.0f - normalisedRect.right;
            normalisedRect.right = 1.0f - tempLeft;
        }
        return normalisedRect;
    }

    @Nullable
    public final RectF normalizedToCameraSensor$lib_release(@Nullable RectF normalisedRect, @Nullable Integer captureWidth, @Nullable Integer captureHeight, int cropSensorWidth, int cropSensorHeight, boolean needCameraCrop) {
        if (normalisedRect == null || captureWidth == null || captureHeight == null || normalisedRect.left < 0.0f || normalisedRect.top < 0.0f || normalisedRect.width() > 1.0f || normalisedRect.height() > 1.0f) {
            return null;
        }
        RectF sensorRect = new RectF(normalisedRect);
        Matrix matrix = new Matrix();
        int cropWidth = cropSensorWidth;
        int cropHeight = cropSensorHeight;
        if (needCameraCrop) {
            float ratioH;
            float ratioW = cropWidth / captureWidth;
            if (ratioW / (ratioH = (float)(cropHeight / captureHeight)) > 1.0f) {
                matrix.postTranslate((ratioW / ratioH - 1.0f) / 2.0f, 0.0f);
                cropWidth = (int)((float)cropWidth * ratioH / ratioW);
            } else if (ratioW / ratioH < 1.0f) {
                matrix.postTranslate(0.0f, (ratioH / ratioW - 1.0f) / 2.0f);
                cropHeight = (int)((float)cropHeight * ratioW / ratioH);
            }
            matrix.mapRect(sensorRect);
        }
        matrix.setScale((float)cropWidth, (float)cropHeight);
        matrix.mapRect(sensorRect);
        return sensorRect;
    }

    public final int getSurfaceOrientation(int surfaceOrientation) {
        int n;
        int n2 = surfaceOrientation;
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RendererCommon.ScalingType.values().length];
            nArray[RendererCommon.ScalingType.SCALE_ASPECT_FILL.ordinal()] = 1;
            nArray[RendererCommon.ScalingType.SCALE_ASPECT_FIT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

