/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import androidx.annotation.Nullable;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.ThreadUtils;
import org.webrtc.ThreadUtils;

class HMSProximitySensor
implements SensorEventListener {
    private static final String TAG = "HMSProximitySensor";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final Runnable onSensorStateListener;
    private final SensorManager sensorManager;
    @Nullable
    private Sensor proximitySensor;
    private boolean lastStateReportIsNear;

    static HMSProximitySensor create(Context context, Runnable sensorStateListener) {
        return new HMSProximitySensor(context, sensorStateListener);
    }

    private HMSProximitySensor(Context context, Runnable sensorStateListener) {
        HMSLogger.d(TAG, TAG + ThreadUtils.getThreadInfo());
        this.onSensorStateListener = sensorStateListener;
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
    }

    public boolean start() {
        this.threadChecker.checkIsOnValidThread();
        HMSLogger.d(TAG, "start" + ThreadUtils.getThreadInfo());
        if (!this.initDefaultSensor()) {
            return false;
        }
        this.sensorManager.registerListener((SensorEventListener)this, this.proximitySensor, 3);
        return true;
    }

    public void stop() {
        this.threadChecker.checkIsOnValidThread();
        HMSLogger.d(TAG, "stop" + ThreadUtils.getThreadInfo());
        if (this.proximitySensor == null) {
            return;
        }
        this.sensorManager.unregisterListener((SensorEventListener)this, this.proximitySensor);
    }

    public boolean sensorReportsNearState() {
        this.threadChecker.checkIsOnValidThread();
        return this.lastStateReportIsNear;
    }

    public final void onAccuracyChanged(Sensor sensor, int accuracy) {
        this.threadChecker.checkIsOnValidThread();
        this.assertIsTrue(sensor.getType() == 8);
        if (accuracy == 0) {
            HMSLogger.e(TAG, "The values returned by this sensor cannot be trusted");
        }
    }

    private void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    public final void onSensorChanged(SensorEvent event) {
        this.threadChecker.checkIsOnValidThread();
        this.assertIsTrue(event.sensor.getType() == 8);
        float distanceInCentimeters = event.values[0];
        if (distanceInCentimeters < this.proximitySensor.getMaximumRange()) {
            HMSLogger.d(TAG, "Proximity sensor => NEAR state");
            this.lastStateReportIsNear = true;
        } else {
            HMSLogger.d(TAG, "Proximity sensor => FAR state");
            this.lastStateReportIsNear = false;
        }
        if (this.onSensorStateListener != null) {
            this.onSensorStateListener.run();
        }
        HMSLogger.d(TAG, "onSensorChanged" + ThreadUtils.getThreadInfo() + ": accuracy=" + event.accuracy + ", timestamp=" + event.timestamp + ", distance=" + event.values[0]);
    }

    private boolean initDefaultSensor() {
        if (this.proximitySensor != null) {
            return true;
        }
        this.proximitySensor = this.sensorManager.getDefaultSensor(8);
        if (this.proximitySensor == null) {
            return false;
        }
        this.HMSLoggerProximitySensorInfo();
        return true;
    }

    private void HMSLoggerProximitySensorInfo() {
        if (this.proximitySensor == null) {
            return;
        }
        StringBuilder info = new StringBuilder("Proximity sensor: ");
        info.append("name=").append(this.proximitySensor.getName());
        info.append(", vendor: ").append(this.proximitySensor.getVendor());
        info.append(", power: ").append(this.proximitySensor.getPower());
        info.append(", resolution: ").append(this.proximitySensor.getResolution());
        info.append(", max range: ").append(this.proximitySensor.getMaximumRange());
        info.append(", min delay: ").append(this.proximitySensor.getMinDelay());
        if (Build.VERSION.SDK_INT >= 20) {
            info.append(", type: ").append(this.proximitySensor.getStringType());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            info.append(", max delay: ").append(this.proximitySensor.getMaxDelay());
            info.append(", reporting mode: ").append(this.proximitySensor.getReportingMode());
            info.append(", isWakeUpSensor: ").append(this.proximitySensor.isWakeUpSensor());
        }
        HMSLogger.d(TAG, info.toString());
    }
}

