/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.tracks.HMSRemoteAudioTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.sdk.SDKStore;
import live.hms.video.sdk.managers.IManager;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSPeer;
import live.hms.video.sdk.models.SDKUpdate;
import live.hms.video.sdk.models.enums.HMSTrackUpdate;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Llive/hms/video/sdk/managers/OnTrackUpdateManager;", "Llive/hms/video/sdk/managers/IManager;", "Llive/hms/video/sdk/models/HMSNotifications$TrackMetadata;", "store", "Llive/hms/video/sdk/SDKStore;", "(Llive/hms/video/sdk/SDKStore;)V", "getStore", "()Llive/hms/video/sdk/SDKStore;", "manage", "", "Llive/hms/video/sdk/models/SDKUpdate;", "data", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "peerId", "", "params", "Companion", "lib_release"})
public final class OnTrackUpdateManager
implements IManager<HMSNotifications.TrackMetadata> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SDKStore store;
    @NotNull
    private static final String TAG = "OnTrackUpdateManager";

    public OnTrackUpdateManager(@NotNull SDKStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @Override
    @NotNull
    public SDKStore getStore() {
        return this.store;
    }

    @Override
    @NotNull
    public List<SDKUpdate> manage(@NotNull HMSNotifications.TrackMetadata params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        List updates2 = new ArrayList();
        for (HMSNotifications.Track data : params.getTracks()) {
            updates2.addAll((Collection)this.manage(data, params.getPeer().getPeerId()));
        }
        return updates2;
    }

    @NotNull
    public final List<SDKUpdate> manage(@NotNull HMSNotifications.Track data, @NotNull String peerId) {
        List updates2;
        block14: {
            HMSTrack hMSTrack;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            updates2 = new ArrayList();
            HMSPeer hMSPeer = this.getStore().getPeerById(peerId);
            if (hMSPeer == null) {
                hMSTrack = null;
            } else {
                Object object;
                Object object2;
                boolean bl;
                HMSPeer hMSPeer2;
                HMSPeer peer = hMSPeer2 = hMSPeer;
                boolean bl2 = false;
                boolean bl3 = bl = !peer.isLocal();
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                HMSTrack hMSTrack2 = this.getStore().getTrackById(data.getTrackId());
                if (hMSTrack2 == null) {
                    object2 = null;
                } else {
                    boolean bl5;
                    object = hMSTrack2;
                    HMSTrack track = object;
                    boolean bl6 = false;
                    boolean bl7 = bl5 = track instanceof HMSRemoteAudioTrack || track instanceof HMSRemoteVideoTrack;
                    if (!bl5) {
                        boolean bl8 = false;
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (track.isMute() != data.isMute()) {
                        HMSTrackUpdate type = data.isMute() ? HMSTrackUpdate.TRACK_MUTED : HMSTrackUpdate.TRACK_UNMUTED;
                        updates2.add(new SDKUpdate.Track(type, track, peer));
                    }
                    if (!Intrinsics.areEqual((Object)track.getDescription(), (Object)data.getDescription())) {
                        updates2.add(new SDKUpdate.Track(HMSTrackUpdate.TRACK_DESCRIPTION_CHANGED, track, peer));
                    }
                    object2 = this.getStore().updateRTCTrack(data);
                }
                HMSTrack hMSTrack3 = object2;
                if (hMSTrack3 == null) {
                    Boolean bl9;
                    object = this.getStore().getTrackDataById(data.getTrackId());
                    if (object == null) {
                        bl9 = null;
                    } else {
                        Object object3;
                        Object it = object3 = object;
                        boolean bl10 = false;
                        bl9 = this.getStore().updateTrackMetaData(peerId, data);
                    }
                    hMSTrack2 = bl9;
                    if (hMSTrack2 == null) {
                        HMSLogger.e(TAG, "onTrackUpdateNotification: Cannot find track for " + data + ", peer=" + peer);
                        hMSTrack = Unit.INSTANCE;
                    } else {
                        hMSTrack = hMSTrack2;
                    }
                } else {
                    hMSTrack = hMSTrack3;
                }
            }
            HMSTrack hMSTrack4 = hMSTrack;
            if (hMSTrack4 != null) break block14;
            HMSLogger.e(TAG, "onTrackUpdateNotification: Cannot find respective peer for track=" + data + " , store=" + this.getStore());
        }
        return updates2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/sdk/managers/OnTrackUpdateManager$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

